/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.IReportGenerator;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Strings;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;

public final class ReportProcessor
extends Processor
implements IAppErrorCodes {
    private File[] m_dataPath = IConstants.EMPTY_FILE_ARRAY;
    private File[] m_sourcePath;
    private IReportGenerator[] m_reportGenerators;
    private int m_dataFileCount;
    private static final Class[] EXPECTED_FAILURES = new Class[]{EMMARuntimeException.class, IllegalArgumentException.class, IllegalStateException.class};

    public static ReportProcessor create() {
        return new ReportProcessor();
    }

    public final synchronized void setDataPath(String[] stringArray) {
        this.m_dataPath = stringArray == null || stringArray.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(stringArray, true);
    }

    public synchronized void setSourcePath(String[] stringArray) {
        this.m_sourcePath = stringArray == null ? null : Files.pathToFiles(stringArray, true);
    }

    public synchronized void setReportTypes(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("null input: types");
        }
        String[] stringArray2 = Strings.removeDuplicates(stringArray, true);
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("empty input: types");
        }
        IReportGenerator[] iReportGeneratorArray = new IReportGenerator[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            iReportGeneratorArray[i] = AbstractReportGenerator.create(stringArray2[i]);
        }
        this.m_reportGenerators = iReportGeneratorArray;
    }

    protected void validateState() {
        super.validateState();
        if (this.m_dataPath == null) {
            throw new IllegalStateException("data path not set");
        }
        if (this.m_reportGenerators == null || this.m_reportGenerators.length == 0) {
            throw new IllegalStateException("report types not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _run(IProperties iProperties) {
        RuntimeException runtimeException;
        block44: {
            Logger logger = this.m_log;
            boolean bl = this.m_log.atVERBOSE();
            if (bl) {
                String string;
                File file;
                int n;
                logger.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
                logger.verbose("input data path:");
                logger.verbose("{");
                for (n = 0; n < this.m_dataPath.length; ++n) {
                    file = this.m_dataPath[n];
                    string = file.exists() ? "" : "{nonexistent} ";
                    logger.verbose("  " + string + file.getAbsolutePath());
                }
                logger.verbose("}");
                if (this.m_sourcePath == null || this.m_sourcePath.length == 0) {
                    logger.verbose("source path not set");
                } else {
                    logger.verbose("source path:");
                    logger.verbose("{");
                    for (n = 0; n < this.m_sourcePath.length; ++n) {
                        file = this.m_sourcePath[n];
                        string = file.exists() ? "" : "{nonexistent} ";
                        logger.verbose("  " + string + file.getAbsolutePath());
                    }
                    logger.verbose("}");
                }
            } else {
                logger.info("processing input files ...");
            }
            runtimeException = null;
            try {
                Object object;
                long l = logger.atINFO() ? System.currentTimeMillis() : 0L;
                IMergeable iMergeable2 = null;
                IMergeable iMergeable = null;
                try {
                    for (int i = 0; i < this.m_dataPath.length; ++this.m_dataFileCount, ++i) {
                        ICoverageData iCoverageData;
                        IMetaData iMetaData;
                        File file = this.m_dataPath[i];
                        if (bl) {
                            logger.verbose("processing input file [" + file.getAbsolutePath() + "] ...");
                        }
                        if ((iMetaData = (IMetaData)(object = DataFactory.load(file))[0]) != null) {
                            if (bl) {
                                logger.verbose("  loaded " + iMetaData.size() + " metadata entries");
                            }
                            iMergeable2 = iMergeable2 == null ? iMetaData : (IMetaData)iMergeable2.merge(iMetaData);
                        }
                        if ((iCoverageData = (ICoverageData)object[1]) == null) continue;
                        if (bl) {
                            logger.verbose("  loaded " + iCoverageData.size() + " coverage data entries");
                        }
                        iMergeable = iMergeable == null ? iCoverageData : (ICoverageData)iMergeable.merge(iCoverageData);
                    }
                    if (logger.atINFO()) {
                        long l2 = System.currentTimeMillis();
                        logger.info(this.m_dataFileCount + " file(s) read and merged in " + (l2 - l) + " ms");
                    }
                    if (iMergeable2 == null || iMergeable2.isEmpty()) {
                        logger.warning("nothing to do: no metadata found in any of the data files");
                        return;
                    }
                    if (iMergeable == null) {
                        logger.warning("nothing to do: no runtime coverage data found in any of the data files");
                        return;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.out);
                    break block44;
                }
                {
                    if (iMergeable.isEmpty()) {
                        logger.warning("no collected coverage data found in any of the data files [all reports will be empty]");
                    }
                    if (bl) {
                        if (iMergeable2 != null) {
                            logger.verbose("  merged metadata contains " + iMergeable2.size() + " entries");
                        }
                        if (iMergeable != null) {
                            logger.verbose("  merged coverage data contains " + iMergeable.size() + " entries");
                        }
                    }
                    SourcePathCache sourcePathCache = null;
                    if (this.m_sourcePath != null) {
                        sourcePathCache = new SourcePathCache(this.m_sourcePath, true);
                    }
                    for (int i = 0; i < this.m_reportGenerators.length; ++i) {
                        object = this.m_reportGenerators[i];
                        try {
                            object.process((IMetaData)iMergeable2, (ICoverageData)iMergeable, sourcePathCache, iProperties);
                        }
                        catch (Throwable throwable) {
                            try {
                                throwable.printStackTrace(System.out);
                                break;
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                            finally {
                                try {
                                    object.cleanup();
                                }
                                catch (Throwable throwable3) {}
                            }
                        }
                        try {
                            object.cleanup();
                            continue;
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (SecurityException securityException) {
                runtimeException = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, securityException);
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
            finally {
                this.reset();
            }
        }
        if (runtimeException == null) return;
        if (!Exceptions.unexpectedFailure(runtimeException, EXPECTED_FAILURES)) throw runtimeException;
        throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{runtimeException.toString(), "this private build is unsupported"}, runtimeException);
    }

    private ReportProcessor() {
    }

    private void reset() {
        this.m_dataFileCount = 0;
    }
}

