/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;

class Warning
implements Comparable<Warning> {
    public final Issue issue;
    public final String message;
    public final Severity severity;
    public final Object data;
    public final Project project;
    public Location location;
    public File file;
    public String path;
    public int line = -1;
    public int offset = -1;
    public String errorLine;
    public String fileContents;

    public Warning(Issue issue, String message, Severity severity, Project project, Object data) {
        this.issue = issue;
        this.message = message;
        this.severity = severity;
        this.project = project;
        this.data = data;
    }

    @Override
    public int compareTo(Warning other) {
        int fileDelta;
        int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
        if (categoryDelta != 0) {
            return categoryDelta;
        }
        int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
        if (priorityDelta != 0) {
            return priorityDelta;
        }
        String id1 = this.issue.getId();
        String id2 = other.issue.getId();
        if (id1 == null || id2 == null) {
            return this.file.getName().compareTo(other.file.getName());
        }
        int idDelta = id1.compareTo(id2);
        if (idDelta != 0) {
            return idDelta;
        }
        if (this.file != null && other.file != null && (fileDelta = this.file.getName().compareTo(other.file.getName())) != 0) {
            return fileDelta;
        }
        if (this.line != other.line) {
            return this.line - other.line;
        }
        return this.message.compareTo(other.message);
    }
}

