/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.StatePrettyPrinter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class GLListProperty
implements IGLProperty {
    private final List<IGLProperty> mList;
    private final GLStateType mType;
    private IGLProperty mParent;
    private IGLProperty mTemplate;

    public GLListProperty(GLStateType gLStateType, IGLProperty iGLProperty, int n) {
        this.mType = gLStateType;
        this.mTemplate = iGLProperty;
        this.mList = new ArrayList<IGLProperty>(n);
        int n2 = 0;
        while (n2 < n) {
            IGLProperty iGLProperty2 = iGLProperty.clone();
            this.mList.add(iGLProperty2);
            iGLProperty2.setParent(this);
            ++n2;
        }
    }

    private GLListProperty(GLStateType gLStateType, List<IGLProperty> list) {
        this.mList = list;
        this.mType = gLStateType;
        for (IGLProperty iGLProperty : this.mList) {
            iGLProperty.setParent(this);
        }
    }

    public List<IGLProperty> getList() {
        return this.mList;
    }

    public IGLProperty get(int n) {
        return this.mList.get(n);
    }

    public boolean add(IGLProperty iGLProperty) {
        iGLProperty.setParent(this);
        return this.mList.add(iGLProperty);
    }

    public boolean remove(IGLProperty iGLProperty) {
        return this.mList.remove(iGLProperty);
    }

    public void set(int n, IGLProperty iGLProperty) {
        this.ensureCapacity(n + 1);
        this.mList.set(n, iGLProperty);
        iGLProperty.setParent(this);
    }

    private void ensureCapacity(int n) {
        int n2 = this.mList.size();
        while (n2 < n) {
            this.mList.add(this.mTemplate);
            ++n2;
        }
    }

    @Override
    public GLListProperty clone() {
        ArrayList<IGLProperty> arrayList = new ArrayList<IGLProperty>(this.mList.size());
        for (IGLProperty iGLProperty : this.mList) {
            arrayList.add(iGLProperty.clone());
        }
        return new GLListProperty(this.getType(), arrayList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GLListProperty [");
        int n = 0;
        for (IGLProperty iGLProperty : this.mList) {
            stringBuffer.append(n);
            stringBuffer.append(':');
            stringBuffer.append(iGLProperty.toString());
            stringBuffer.append(", ");
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public String getStringValue() {
        return "";
    }

    @Override
    public GLStateType getType() {
        return this.mType;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public IGLProperty getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IGLProperty iGLProperty) {
        this.mParent = iGLProperty;
    }

    public int indexOf(IGLProperty iGLProperty) {
        return this.mList.indexOf(iGLProperty);
    }

    @Override
    public void setValue(Object object) {
        throw new UnsupportedOperationException("Values cannot be set for composite properties.");
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Values cannot be obtained for composite properties.");
    }

    public int size() {
        return this.mList.size();
    }

    @Override
    public void prettyPrint(StatePrettyPrinter statePrettyPrinter) {
        statePrettyPrinter.prettyPrint(this.mType, null);
        statePrettyPrinter.incrementIndentLevel();
        int n = 0;
        while (n < this.mList.size()) {
            statePrettyPrinter.prettyPrint(String.format(Locale.US, "Index %d:", n));
            IGLProperty iGLProperty = this.mList.get(n);
            iGLProperty.prettyPrint(statePrettyPrinter);
            ++n;
        }
        statePrettyPrinter.decrementIndentLevel();
    }
}

