/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor.ddms;

import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.IDevice;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

public class DebugPortProvider
implements DebugPortManager.IDebugPortProvider {
    private static DebugPortProvider sThis = new DebugPortProvider();
    public static final String PREFS_STATIC_PORT_LIST = "android.staticPortList";
    private Map<String, Map<String, Integer>> mMap;

    public static DebugPortProvider getInstance() {
        return sThis;
    }

    private DebugPortProvider() {
        this.computePortList();
    }

    public int getPort(IDevice iDevice, String string) {
        Integer n;
        Map<String, Integer> map;
        if (this.mMap != null && (map = this.mMap.get(iDevice.getSerialNumber())) != null && (n = map.get(string)) != null) {
            return n;
        }
        return -1;
    }

    public Map<String, Map<String, Integer>> getPortList() {
        return this.mMap;
    }

    private void computePortList() {
        this.mMap = new HashMap<String, Map<String, Integer>>();
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(PREFS_STATIC_PORT_LIST);
        if (string != null && string.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                String[] stringArray3 = string2.split(":");
                String string3 = null;
                string3 = stringArray3.length == 3 ? stringArray3[2] : "emulator-5554";
                Map<String, Integer> map = this.mMap.get(string3);
                if (map == null) {
                    map = new HashMap<String, Integer>();
                    this.mMap.put(string3, map);
                }
                map.put(stringArray3[0], Integer.valueOf(stringArray3[1]));
                ++n2;
            }
        }
    }

    public void setPortList(Map<String, Map<String, Integer>> map) {
        String string2;
        this.mMap.clear();
        this.mMap.putAll(map);
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = map.keySet();
        for (String string2 : set) {
            Map<String, Integer> map2 = map.get(string2);
            if (map2 == null) continue;
            Set<String> set2 = map2.keySet();
            for (String string3 : set2) {
                Integer n = map2.get(string3);
                if (n == null) continue;
                stringBuilder.append(string3).append(':').append(n).append(':').append(string2).append('|');
            }
        }
        string2 = stringBuilder.toString();
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PREFS_STATIC_PORT_LIST, string2);
    }
}

