/*
 * Decompiled with CFR 0.152.
 */
package com.android.menubar;

import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import java.lang.reflect.Method;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuBarEnhancer37
implements IMenuBarEnhancer {
    private static final int kAboutMenuItem = -1;
    private static final int kPreferencesMenuItem = -2;
    private static final int kQuitMenuItem = -6;

    @Override
    public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
        return IMenuBarEnhancer.MenuBarMode.MAC_OS;
    }

    @Override
    public void setupMenu(String appName, Display display, IMenuBarCallback callbacks) {
        try {
            this.initialize(display, appName, callbacks);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public static boolean isSupported(Display display) {
        try {
            Object sysMenu = MenuBarEnhancer37.call0(display, "getSystemMenu");
            if (sysMenu instanceof Menu) {
                return MenuBarEnhancer37.findMenuById((Menu)sysMenu, -2) != null && MenuBarEnhancer37.findMenuById((Menu)sysMenu, -1) != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void initialize(Display display, String appName, final IMenuBarCallback callbacks) throws Exception {
        Object sysMenu = MenuBarEnhancer37.call0(display, "getSystemMenu");
        if (sysMenu instanceof Menu) {
            MenuItem menu = MenuBarEnhancer37.findMenuById((Menu)sysMenu, -2);
            if (menu != null) {
                menu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        callbacks.onPreferencesMenuSelected();
                    }
                });
            }
            if ((menu = MenuBarEnhancer37.findMenuById((Menu)sysMenu, -1)) != null) {
                menu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        callbacks.onAboutMenuSelected();
                    }
                });
                menu.setText("About " + appName);
            }
            if ((menu = MenuBarEnhancer37.findMenuById((Menu)sysMenu, -6)) != null) {
                menu.setText("Quit " + appName);
            }
        }
    }

    private static Object call0(Object obj, String method) {
        try {
            Method m = obj.getClass().getMethod(method, null);
            if (m != null) {
                return m.invoke(obj, (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static MenuItem findMenuById(Menu menu, int id) {
        MenuItem[] items = menu.getItems();
        for (int i = items.length - 1; i >= 0; --i) {
            MenuItem item = items[i];
            Object menuId = MenuBarEnhancer37.call0(item, "getID");
            if (!(menuId instanceof Integer) || (Integer)menuId != id) continue;
            return item;
        }
        return null;
    }
}

