/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class BasicInvocationUnit
extends SimplifiedVisitor
implements InvocationUnit,
ConstantVisitor,
MemberVisitor {
    protected final ValueFactory valueFactory;
    private boolean isStatic;
    private boolean isLoad;
    private Stack stack;
    private Clazz returnTypeClass;

    public BasicInvocationUnit(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public void enterMethod(Clazz clazz, Method method, Variables variables) {
        Object object;
        String string = method.getDescriptor(clazz);
        boolean bl = (method.getAccessFlags() & 8) != 0;
        int n = ClassUtil.internalMethodParameterSize(string, bl);
        variables.reset(n);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        int n2 = 0;
        int n3 = 0;
        if (!bl) {
            object = this.getMethodParameterValue(clazz, method, n2++, ClassUtil.internalTypeFromClassName(clazz.getName()), clazz);
            variables.store(n3++, (Value)object);
        }
        object = ((ProgramMethod)method).referencedClasses;
        int n4 = 0;
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            Clazz clazz2 = object != null && ClassUtil.isInternalClassType(string2) ? object[n4++] : null;
            Value value = this.getMethodParameterValue(clazz, method, n2++, string2, clazz2);
            variables.store(n3++, value);
            if (!value.isCategory2()) continue;
            ++n3;
        }
    }

    public void exitMethod(Clazz clazz, Method method, Value value) {
        this.setMethodReturnValue(clazz, method, value);
    }

    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction, Stack stack) {
        int n2 = constantInstruction.constantIndex;
        switch (constantInstruction.opcode) {
            case -78: {
                this.isStatic = true;
                this.isLoad = true;
                break;
            }
            case -77: {
                this.isStatic = true;
                this.isLoad = false;
                break;
            }
            case -76: {
                this.isStatic = false;
                this.isLoad = true;
                break;
            }
            case -75: {
                this.isStatic = false;
                this.isLoad = false;
                break;
            }
            case -72: 
            case -70: {
                this.isStatic = true;
                break;
            }
            case -74: 
            case -73: 
            case -71: {
                this.isStatic = false;
            }
        }
        this.stack = stack;
        clazz.constantPoolEntryAccept(n2, this);
        this.stack = null;
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (!this.isLoad) {
            this.setFieldValue(clazz, fieldrefConstant, this.stack.pop());
        }
        if (!this.isStatic) {
            this.setFieldClassValue(clazz, fieldrefConstant, this.stack.apop());
        }
        if (this.isLoad) {
            String string = fieldrefConstant.getType(clazz);
            this.stack.push(this.getFieldValue(clazz, fieldrefConstant, string));
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        String string = refConstant.getType(clazz);
        int n = ClassUtil.internalMethodParameterCount(string);
        if (!this.isStatic) {
            ++n;
        }
        for (int i = n - 1; i >= 0; --i) {
            this.setMethodParameterValue(clazz, refConstant, i, this.stack.pop());
        }
        String string2 = ClassUtil.internalMethodReturnType(string);
        if (string2.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, refConstant, string2));
        }
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String string = invokeDynamicConstant.getType(clazz);
        int n = ClassUtil.internalMethodParameterCount(string);
        if (!this.isStatic) {
            ++n;
        }
        for (int i = n - 1; i >= 0; --i) {
            this.stack.pop();
        }
        String string2 = ClassUtil.internalMethodReturnType(string);
        if (string2.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, invokeDynamicConstant, string2));
        }
    }

    protected void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue referenceValue) {
    }

    protected Value getFieldClassValue(Clazz clazz, RefConstant refConstant, String string) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(string, this.returnTypeClass, true);
    }

    protected void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
    }

    protected Value getFieldValue(Clazz clazz, RefConstant refConstant, String string) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(string, this.returnTypeClass, true);
    }

    protected void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int n, Value value) {
    }

    protected Value getMethodParameterValue(Clazz clazz, Method method, int n, String string, Clazz clazz2) {
        return this.valueFactory.createValue(string, clazz2, true);
    }

    protected void setMethodReturnValue(Clazz clazz, Method method, Value value) {
    }

    protected Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String string) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(string, this.returnTypeClass, true);
    }

    protected Value getMethodReturnValue(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant, String string) {
        Clazz[] clazzArray = invokeDynamicConstant.referencedClasses;
        Clazz clazz2 = clazzArray == null ? null : clazzArray[clazzArray.length - 1];
        return this.valueFactory.createValue(string, clazz2, true);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.returnTypeClass = programField.referencedClass;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz[] clazzArray = programMethod.referencedClasses;
        if (clazzArray != null) {
            this.returnTypeClass = clazzArray[clazzArray.length - 1];
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.returnTypeClass = libraryField.referencedClass;
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        Clazz[] clazzArray = libraryMethod.referencedClasses;
        if (clazzArray != null) {
            this.returnTypeClass = clazzArray[clazzArray.length - 1];
        }
    }
}

