/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.JumpInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.LabelNode;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import org.jetbrains.annotations.NotNull;

class ReturnInstructionUnifier
implements Opcodes,
RuleMethodProcessor {
    ReturnInstructionUnifier() {
    }

    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ReturnInstructionUnifier.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.ReturnInstructionUnifier.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return true;
    }

    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) throws Exception {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ReturnInstructionUnifier.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.ReturnInstructionUnifier.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method.getNumberOfReturns() == 1) {
            return;
        }
        Preconditions.checkState(method.getNumberOfReturns() > 1);
        AbstractInsnNode current = method.instructions.getLast();
        while (current.getOpcode() != 176) {
            current = current.getPrevious();
        }
        LabelNode lastReturnLabel = new LabelNode();
        method.instructions.insertBefore(current, lastReturnLabel);
        while ((current = current.getPrevious()) != null) {
            if (current.getOpcode() != 176) continue;
            JumpInsnNode gotoInstruction = new JumpInsnNode(167, lastReturnLabel);
            method.instructions.set(current, gotoInstruction);
            current = gotoInstruction;
        }
    }
}

