/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Beta
public class XmlContext
extends Context {
    public IDomParser parser;
    public Document document;
    private final ResourceFolderType mFolderType;

    public XmlContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file, @Nullable ResourceFolderType folderType) {
        super(driver, project, main, file);
        this.mFolderType = folderType;
    }

    @NonNull
    public Location getLocation(@NonNull Node node) {
        if (this.parser != null) {
            return this.parser.getLocation(this, node);
        }
        return Location.create(this.file);
    }

    @NonNull
    public Location getLocation(@NonNull Node textNode, int begin, int end) {
        assert (textNode.getNodeType() == 3);
        if (this.parser != null) {
            return this.parser.getLocation(this, textNode, begin, end);
        }
        return Location.create(this.file);
    }

    public void report(@NonNull Issue issue, @Nullable Node scope, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (scope != null && this.mDriver.isSuppressed(issue, scope)) {
            return;
        }
        super.report(issue, location, message, data);
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (this.document != null && this.mDriver.isSuppressed(issue, this.document)) {
            return;
        }
        super.report(issue, location, message, data);
    }

    @Nullable
    public ResourceFolderType getResourceFolderType() {
        return this.mFolderType;
    }
}

