/*****************************************************************************
*
* ALPS Project Applications
*
* Copyright (C) 1999-2003 by Matthias Troyer <troyer@comp-phys.org>
*
* This software is part of the ALPS Applications, published under the ALPS
* Application License; you can use, redistribute it and/or modify it under
* the terms of the license, either version 1 or (at your option) any later
* version.
* 
* You should have received a copy of the ALPS Application License along with
* the ALPS Applications; see the file LICENSE.txt. If not, the license is also
* available from http://alps.comp-phys.org/.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: faststack.h 692 2004-03-16 15:37:52Z wistaria $ */

#ifndef ALPS_APPLICATIONS_MC_SPIN_FASTSTACK_H_
#define ALPS_APPLICATIONS_MC_SPIN_FASTSTACK_H_

template <class T> class fast_stack {
public:
  fast_stack(std::size_t max_size) 
    : stack_(new T[max_size]), ptr_(stack_-1), start_(stack_-1) 
    {}
  ~fast_stack() { delete[] stack_;}
  T& top() { return *ptr_;}
  void pop() { --ptr_;}
  void push(T x) {*(++ptr_) = x;}
  bool empty() { return ptr_==start_;}
private:
  T *stack_, *ptr_, *start_;
};

#endif
