//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_HGEQZ_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_HGEQZ_HPP

#include <boost/assert.hpp>
#include <boost/numeric/bindings/begin.hpp>
#include <boost/numeric/bindings/detail/array.hpp>
#include <boost/numeric/bindings/is_column_major.hpp>
#include <boost/numeric/bindings/is_complex.hpp>
#include <boost/numeric/bindings/is_mutable.hpp>
#include <boost/numeric/bindings/is_real.hpp>
#include <boost/numeric/bindings/lapack/workspace.hpp>
#include <boost/numeric/bindings/remove_imaginary.hpp>
#include <boost/numeric/bindings/size.hpp>
#include <boost/numeric/bindings/stride.hpp>
#include <boost/numeric/bindings/traits/detail/utils.hpp>
#include <boost/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>
#include <boost/utility/enable_if.hpp>

//
// The LAPACK-backend for hgeqz is the netlib-compatible backend.
//
#include <boost/numeric/bindings/lapack/detail/lapack.h>
#include <boost/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost {
namespace numeric {
namespace bindings {
namespace lapack {

//
// The detail namespace contains value-type-overloaded functions that
// dispatch to the appropriate back-end LAPACK-routine.
//
namespace detail {

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * float value-type.
//
inline std::ptrdiff_t hgeqz( const char job, const char compq,
        const char compz, const fortran_int_t n, const fortran_int_t ilo,
        const fortran_int_t ihi, float* h, const fortran_int_t ldh, float* t,
        const fortran_int_t ldt, float* alphar, float* alphai, float* beta,
        float* q, const fortran_int_t ldq, float* z, const fortran_int_t ldz,
        float* work, const fortran_int_t lwork ) {
    fortran_int_t info(0);
    LAPACK_SHGEQZ( &job, &compq, &compz, &n, &ilo, &ihi, h, &ldh, t, &ldt,
            alphar, alphai, beta, q, &ldq, z, &ldz, work, &lwork, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * double value-type.
//
inline std::ptrdiff_t hgeqz( const char job, const char compq,
        const char compz, const fortran_int_t n, const fortran_int_t ilo,
        const fortran_int_t ihi, double* h, const fortran_int_t ldh,
        double* t, const fortran_int_t ldt, double* alphar, double* alphai,
        double* beta, double* q, const fortran_int_t ldq, double* z,
        const fortran_int_t ldz, double* work, const fortran_int_t lwork ) {
    fortran_int_t info(0);
    LAPACK_DHGEQZ( &job, &compq, &compz, &n, &ilo, &ihi, h, &ldh, t, &ldt,
            alphar, alphai, beta, q, &ldq, z, &ldz, work, &lwork, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<float> value-type.
//
inline std::ptrdiff_t hgeqz( const char job, const char compq,
        const char compz, const fortran_int_t n, const fortran_int_t ilo,
        const fortran_int_t ihi, std::complex<float>* h,
        const fortran_int_t ldh, std::complex<float>* t,
        const fortran_int_t ldt, std::complex<float>* alpha,
        std::complex<float>* beta, std::complex<float>* q,
        const fortran_int_t ldq, std::complex<float>* z,
        const fortran_int_t ldz, std::complex<float>* work,
        const fortran_int_t lwork, float* rwork ) {
    fortran_int_t info(0);
    LAPACK_CHGEQZ( &job, &compq, &compz, &n, &ilo, &ihi, h, &ldh, t, &ldt,
            alpha, beta, q, &ldq, z, &ldz, work, &lwork, rwork, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<double> value-type.
//
inline std::ptrdiff_t hgeqz( const char job, const char compq,
        const char compz, const fortran_int_t n, const fortran_int_t ilo,
        const fortran_int_t ihi, std::complex<double>* h,
        const fortran_int_t ldh, std::complex<double>* t,
        const fortran_int_t ldt, std::complex<double>* alpha,
        std::complex<double>* beta, std::complex<double>* q,
        const fortran_int_t ldq, std::complex<double>* z,
        const fortran_int_t ldz, std::complex<double>* work,
        const fortran_int_t lwork, double* rwork ) {
    fortran_int_t info(0);
    LAPACK_ZHGEQZ( &job, &compq, &compz, &n, &ilo, &ihi, h, &ldh, t, &ldt,
            alpha, beta, q, &ldq, z, &ldz, work, &lwork, rwork, &info );
    return info;
}

} // namespace detail

//
// Value-type based template class. Use this class if you need a type
// for dispatching to hgeqz.
//
template< typename Value, typename Enable = void >
struct hgeqz_impl {};

//
// This implementation is enabled if Value is a real type.
//
template< typename Value >
struct hgeqz_impl< Value, typename boost::enable_if< is_real< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename MatrixH, typename MatrixT, typename VectorALPHAR,
            typename VectorALPHAI, typename VectorBETA, typename MatrixQ,
            typename MatrixZ, typename WORK >
    static std::ptrdiff_t invoke( const char job, const char compq,
            const char compz, const fortran_int_t ilo, MatrixH& h,
            MatrixT& t, VectorALPHAR& alphar, VectorALPHAI& alphai,
            VectorBETA& beta, MatrixQ& q, MatrixZ& z, detail::workspace1<
            WORK > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixH >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixZ >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixT >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorALPHAR >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorALPHAI >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorBETA >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixQ >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixZ >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixH >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorALPHAR >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorALPHAI >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorBETA >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixZ >::value) );
        BOOST_ASSERT( bindings::size(alphar) >= bindings::size_column(h) );
        BOOST_ASSERT( bindings::size(beta) >= bindings::size_column(h) );
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_work( bindings::size_column(h) ));
        BOOST_ASSERT( bindings::size_column(h) >= 0 );
        BOOST_ASSERT( bindings::size_minor(h) == 1 ||
                bindings::stride_minor(h) == 1 );
        BOOST_ASSERT( bindings::size_minor(q) == 1 ||
                bindings::stride_minor(q) == 1 );
        BOOST_ASSERT( bindings::size_minor(t) == 1 ||
                bindings::stride_minor(t) == 1 );
        BOOST_ASSERT( bindings::size_minor(z) == 1 ||
                bindings::stride_minor(z) == 1 );
        BOOST_ASSERT( bindings::stride_major(h) >= std::max< std::ptrdiff_t >(1,
                bindings::size_column(h)) );
        BOOST_ASSERT( bindings::stride_major(t) >= std::max< std::ptrdiff_t >(1,
                bindings::size_column(h)) );
        BOOST_ASSERT( compq == 'N' || compq == 'I' || compq == 'V' );
        BOOST_ASSERT( compz == 'N' || compz == 'I' || compz == 'V' );
        BOOST_ASSERT( job == 'E' || job == 'S' );
        return detail::hgeqz( job, compq, compz, bindings::size_column(h),
                ilo, bindings::size_column(h), bindings::begin_value(h),
                bindings::stride_major(h), bindings::begin_value(t),
                bindings::stride_major(t), bindings::begin_value(alphar),
                bindings::begin_value(alphai), bindings::begin_value(beta),
                bindings::begin_value(q), bindings::stride_major(q),
                bindings::begin_value(z), bindings::stride_major(z),
                bindings::begin_value(work.select(real_type())),
                bindings::size(work.select(real_type())) );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename MatrixH, typename MatrixT, typename VectorALPHAR,
            typename VectorALPHAI, typename VectorBETA, typename MatrixQ,
            typename MatrixZ >
    static std::ptrdiff_t invoke( const char job, const char compq,
            const char compz, const fortran_int_t ilo, MatrixH& h,
            MatrixT& t, VectorALPHAR& alphar, VectorALPHAI& alphai,
            VectorBETA& beta, MatrixQ& q, MatrixZ& z, minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< real_type > tmp_work( min_size_work(
                bindings::size_column(h) ) );
        return invoke( job, compq, compz, ilo, h, t, alphar, alphai, beta, q,
                z, workspace( tmp_work ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename MatrixH, typename MatrixT, typename VectorALPHAR,
            typename VectorALPHAI, typename VectorBETA, typename MatrixQ,
            typename MatrixZ >
    static std::ptrdiff_t invoke( const char job, const char compq,
            const char compz, const fortran_int_t ilo, MatrixH& h,
            MatrixT& t, VectorALPHAR& alphar, VectorALPHAI& alphai,
            VectorBETA& beta, MatrixQ& q, MatrixZ& z, optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        real_type opt_size_work;
        detail::hgeqz( job, compq, compz, bindings::size_column(h), ilo,
                bindings::size_column(h), bindings::begin_value(h),
                bindings::stride_major(h), bindings::begin_value(t),
                bindings::stride_major(t), bindings::begin_value(alphar),
                bindings::begin_value(alphai), bindings::begin_value(beta),
                bindings::begin_value(q), bindings::stride_major(q),
                bindings::begin_value(z), bindings::stride_major(z),
                &opt_size_work, -1 );
        bindings::detail::array< real_type > tmp_work(
                traits::detail::to_int( opt_size_work ) );
        return invoke( job, compq, compz, ilo, h, t, alphar, alphai, beta, q,
                z, workspace( tmp_work ) );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array work.
    //
    static std::ptrdiff_t min_size_work( const std::ptrdiff_t n ) {
        return std::max< std::ptrdiff_t >(1,n);
    }
};

//
// This implementation is enabled if Value is a complex type.
//
template< typename Value >
struct hgeqz_impl< Value, typename boost::enable_if< is_complex< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename MatrixH, typename MatrixT, typename VectorALPHA,
            typename VectorBETA, typename MatrixQ, typename MatrixZ,
            typename WORK, typename RWORK >
    static std::ptrdiff_t invoke( const char job, const char compq,
            const char compz, const fortran_int_t ilo, MatrixH& h,
            MatrixT& t, VectorALPHA& alpha, VectorBETA& beta, MatrixQ& q,
            MatrixZ& z, detail::workspace2< WORK, RWORK > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixH >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixZ >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixT >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorALPHA >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorBETA >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixQ >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixH >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixZ >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixH >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorALPHA >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorBETA >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixQ >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixZ >::value) );
        BOOST_ASSERT( bindings::size(alpha) >= bindings::size_column(h) );
        BOOST_ASSERT( bindings::size(beta) >= bindings::size_column(h) );
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_rwork( bindings::size_column(h) ));
        BOOST_ASSERT( bindings::size(work.select(value_type())) >=
                min_size_work( bindings::size_column(h) ));
        BOOST_ASSERT( bindings::size_column(h) >= 0 );
        BOOST_ASSERT( bindings::size_minor(h) == 1 ||
                bindings::stride_minor(h) == 1 );
        BOOST_ASSERT( bindings::size_minor(q) == 1 ||
                bindings::stride_minor(q) == 1 );
        BOOST_ASSERT( bindings::size_minor(t) == 1 ||
                bindings::stride_minor(t) == 1 );
        BOOST_ASSERT( bindings::size_minor(z) == 1 ||
                bindings::stride_minor(z) == 1 );
        BOOST_ASSERT( bindings::stride_major(h) >= std::max< std::ptrdiff_t >(1,
                bindings::size_column(h)) );
        BOOST_ASSERT( bindings::stride_major(t) >= std::max< std::ptrdiff_t >(1,
                bindings::size_column(h)) );
        BOOST_ASSERT( compq == 'N' || compq == 'I' || compq == 'V' );
        BOOST_ASSERT( compz == 'N' || compz == 'I' || compz == 'V' );
        BOOST_ASSERT( job == 'E' || job == 'S' );
        return detail::hgeqz( job, compq, compz, bindings::size_column(h),
                ilo, bindings::size_column(h), bindings::begin_value(h),
                bindings::stride_major(h), bindings::begin_value(t),
                bindings::stride_major(t), bindings::begin_value(alpha),
                bindings::begin_value(beta), bindings::begin_value(q),
                bindings::stride_major(q), bindings::begin_value(z),
                bindings::stride_major(z),
                bindings::begin_value(work.select(value_type())),
                bindings::size(work.select(value_type())),
                bindings::begin_value(work.select(real_type())) );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename MatrixH, typename MatrixT, typename VectorALPHA,
            typename VectorBETA, typename MatrixQ, typename MatrixZ >
    static std::ptrdiff_t invoke( const char job, const char compq,
            const char compz, const fortran_int_t ilo, MatrixH& h,
            MatrixT& t, VectorALPHA& alpha, VectorBETA& beta, MatrixQ& q,
            MatrixZ& z, minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< value_type > tmp_work( min_size_work(
                bindings::size_column(h) ) );
        bindings::detail::array< real_type > tmp_rwork( min_size_rwork(
                bindings::size_column(h) ) );
        return invoke( job, compq, compz, ilo, h, t, alpha, beta, q, z,
                workspace( tmp_work, tmp_rwork ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename MatrixH, typename MatrixT, typename VectorALPHA,
            typename VectorBETA, typename MatrixQ, typename MatrixZ >
    static std::ptrdiff_t invoke( const char job, const char compq,
            const char compz, const fortran_int_t ilo, MatrixH& h,
            MatrixT& t, VectorALPHA& alpha, VectorBETA& beta, MatrixQ& q,
            MatrixZ& z, optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        value_type opt_size_work;
        bindings::detail::array< real_type > tmp_rwork( min_size_rwork(
                bindings::size_column(h) ) );
        detail::hgeqz( job, compq, compz, bindings::size_column(h), ilo,
                bindings::size_column(h), bindings::begin_value(h),
                bindings::stride_major(h), bindings::begin_value(t),
                bindings::stride_major(t), bindings::begin_value(alpha),
                bindings::begin_value(beta), bindings::begin_value(q),
                bindings::stride_major(q), bindings::begin_value(z),
                bindings::stride_major(z), &opt_size_work, -1,
                bindings::begin_value(tmp_rwork) );
        bindings::detail::array< value_type > tmp_work(
                traits::detail::to_int( opt_size_work ) );
        return invoke( job, compq, compz, ilo, h, t, alpha, beta, q, z,
                workspace( tmp_work, tmp_rwork ) );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array work.
    //
    static std::ptrdiff_t min_size_work( const std::ptrdiff_t n ) {
        return std::max< std::ptrdiff_t >(1,n);
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array rwork.
    //
    static std::ptrdiff_t min_size_rwork( const std::ptrdiff_t n ) {
        return n;
    }
};


//
// Functions for direct use. These functions are overloaded for temporaries,
// so that wrapped types can still be passed and used for write-access. In
// addition, if applicable, they are overloaded for user-defined workspaces.
// Calls to these functions are passed to the hgeqz_impl classes. In the 
// documentation, most overloads are collapsed to avoid a large number of
// prototypes which are very similar.
//

//
// Overloaded function for hgeqz. Its overload differs for
// * User-defined workspace
//
template< typename MatrixH, typename MatrixT, typename VectorALPHAR,
        typename VectorALPHAI, typename VectorBETA, typename MatrixQ,
        typename MatrixZ, typename Workspace >
inline typename boost::enable_if< detail::is_workspace< Workspace >,
        std::ptrdiff_t >::type
hgeqz( const char job, const char compq, const char compz,
        const fortran_int_t ilo, MatrixH& h, MatrixT& t,
        VectorALPHAR& alphar, VectorALPHAI& alphai, VectorBETA& beta,
        MatrixQ& q, MatrixZ& z, Workspace work ) {
    return hgeqz_impl< typename bindings::value_type<
            MatrixH >::type >::invoke( job, compq, compz, ilo, h, t, alphar,
            alphai, beta, q, z, work );
}

//
// Overloaded function for hgeqz. Its overload differs for
// * Default workspace-type (optimal)
//
template< typename MatrixH, typename MatrixT, typename VectorALPHAR,
        typename VectorALPHAI, typename VectorBETA, typename MatrixQ,
        typename MatrixZ >
inline typename boost::disable_if< detail::is_workspace< MatrixZ >,
        std::ptrdiff_t >::type
hgeqz( const char job, const char compq, const char compz,
        const fortran_int_t ilo, MatrixH& h, MatrixT& t,
        VectorALPHAR& alphar, VectorALPHAI& alphai, VectorBETA& beta,
        MatrixQ& q, MatrixZ& z ) {
    return hgeqz_impl< typename bindings::value_type<
            MatrixH >::type >::invoke( job, compq, compz, ilo, h, t, alphar,
            alphai, beta, q, z, optimal_workspace() );
}
//
// Overloaded function for hgeqz. Its overload differs for
// * User-defined workspace
//
template< typename MatrixH, typename MatrixT, typename VectorALPHA,
        typename VectorBETA, typename MatrixQ, typename MatrixZ,
        typename Workspace >
inline typename boost::enable_if< detail::is_workspace< Workspace >,
        std::ptrdiff_t >::type
hgeqz( const char job, const char compq, const char compz,
        const fortran_int_t ilo, MatrixH& h, MatrixT& t,
        VectorALPHA& alpha, VectorBETA& beta, MatrixQ& q, MatrixZ& z,
        Workspace work ) {
    return hgeqz_impl< typename bindings::value_type<
            MatrixH >::type >::invoke( job, compq, compz, ilo, h, t, alpha,
            beta, q, z, work );
}

//
// Overloaded function for hgeqz. Its overload differs for
// * Default workspace-type (optimal)
//
template< typename MatrixH, typename MatrixT, typename VectorALPHA,
        typename VectorBETA, typename MatrixQ, typename MatrixZ >
inline typename boost::disable_if< detail::is_workspace< MatrixZ >,
        std::ptrdiff_t >::type
hgeqz( const char job, const char compq, const char compz,
        const fortran_int_t ilo, MatrixH& h, MatrixT& t,
        VectorALPHA& alpha, VectorBETA& beta, MatrixQ& q, MatrixZ& z ) {
    return hgeqz_impl< typename bindings::value_type<
            MatrixH >::type >::invoke( job, compq, compz, ilo, h, t, alpha,
            beta, q, z, optimal_workspace() );
}

} // namespace lapack
} // namespace bindings
} // namespace numeric
} // namespace boost

#endif
