/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Libraries
*
* Copyright (C) 1994-2010 by Ping Nang Ma <pingnang@itp.phys.ethz.ch>,
*                            Lukas Gamper <gamperl@gmail.com>,
*                            Matthias Troyer <troyer@itp.phys.ethz.ch>
*
* This software is part of the ALPS libraries, published under the ALPS
* Library License; you can use, redistribute it and/or modify it under
* the terms of the license, either version 1 or (at your option) any later
* version.
* 
* You should have received a copy of the ALPS Library License along with
* the ALPS Libraries; see the file LICENSE.txt. If not, the license is also
* available from http://alps.comp-phys.org/.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: nobinning.h 3520 2009-12-11 16:49:53Z gamperl $ */


#ifndef ALPS_NUMERIC_SPECIAL_FUNCTIONS_HPP
#define ALPS_NUMERIC_SPECIAL_FUNCTIONS_HPP

#include <boost/accumulators/numeric/functional/vector.hpp>
#include <boost/math/special_functions.hpp>


namespace alps {
  namespace numeric {
    
    // define special powers
    template<class T> 
    inline T sq(T value) {
        using boost::numeric::operators::operator*;
        return value * value; 
    }

    template<class T>
    inline T cb(T value) { 
        using boost::numeric::operators::operator*;
        return value * value * value; 
    }

    template<class T>
    inline T cbrt(T value) { 
        return std::pow(value,1./3); 
    }

    // define norm and r
    template <class T>
    inline T norm(T x, T y=T(), T z=T()) {
        using boost::numeric::operators::operator+;
        return (sq(x) + sq(y) + sq(z));
    }
    
    template <class T>
    inline T r(T x, T y=T(), T z=T()) {
        return std::sqrt(norm(x,y,z)); 
    }
  }
}


#endif
