/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                                 *
 * ALPS Project: Algorithms and Libraries for Physics Simulations                  *
 *                                                                                 *
 * ALPS Libraries                                                                  *
 *                                                                                 *
 * Copyright (C) 2010 - 2011 by Lukas Gamper <gamperl@gmail.com>                   *
 *                                                                                 *
 * This software is part of the ALPS libraries, published under the ALPS           *
 * Library License; you can use, redistribute it and/or modify it under            *
 * the terms of the license, either version 1 or (at your option) any later        *
 * version.                                                                        *
 *                                                                                 *
 * You should have received a copy of the ALPS Library License along with          *
 * the ALPS Libraries; see the file LICENSE.txt. If not, the license is also       *
 * available from http://alps.comp-phys.org/.                                      *
 *                                                                                 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,        *
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT       *
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE       *
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,     *
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER     *
 * DEALINGS IN THE SOFTWARE.                                                       *
 *                                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <alps/ngs/mcdeprecated.hpp>

namespace alps {

    Parameters make_alps_parameters(params const & arg) {
        Parameters params;
        std::vector<std::string> keys = arg.keys();
        for (std::vector<std::string>::const_iterator it = keys.begin(); it != keys.end(); ++it)
            params.push_back(*it, arg[*it].str());
        return params;
    }


    mcdeprecated::mcdeprecated(parameters_type const & p, std::size_t seed_offset)
        : mcbase(p, seed_offset)
        , parms(make_alps_parameters(p))
        // TODO: implement!
//        , measurements(results)
        , random_01(random)
    {}

    double mcdeprecated::fraction_completed() const { 
        return work_done(); 
    }

    double mcdeprecated::random_real(double a, double b) { 
        return a + b * random(); 
    }

    void mcdeprecated::do_update() {
        dostep();
    }

    void mcdeprecated::do_measurements() {}

}
