#Intel compilers 7.x
IF($ENV{CXX} MATCHES icc)
  SET(INTEL_COMPILER 1)
  ADD_DEFINITIONS(-DADD_)
  SET(CMAKE_CXX_FLAGS "-restrict -unroll -fno-alias -O3 -xW")
  SET(FORTRAN_LIBS "-lPEPCF90 -lCEPCF90 -lF90 -lintrins")
  SET(F77 ifc)
  SET(F77OPTFLAGS  -fpp2 -O3)
  SET(F77FLAGS ${F77OPTFLAGS})
ENDIF($ENV{CXX} MATCHES icc)

IF($ENV{CXX} MATCHES ecc)
  SET(INTEL_COMPILER 1)
  ADD_DEFINITIONS(-DADD_)
  SET(CMAKE_CXX_FLAGS "-restrict -unroll -fno-alias -O3 -ftz")
  SET(FORTRAN_LIBS "-lPEPCF90 -lCEPCF90 -lF90 -lintrins")
  SET(F77 efc)
  SET(F77OPTFLAGS  -fpp2 -O3 -unrol -fno-alias -ftz)
  SET(F77FLAGS ${F77OPTFLAGS})
ENDIF($ENV{CXX} MATCHES ecc)

IF(INTEL_COMPILER)
  MESSAGE(STATUS "Using intel compiler")
  IF(OHMMS_OMP)
    SET(ENABLE_OPENMP 1)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -openmp")
    SET(ENABLE_OMP 1 CACHE BOOL "OpenMP is enabled")
  ENDIF(OHMMS_OMP)
ENDIF(INTEL_COMPILER)
