

/* from linux hermes.h */

#define HERMES_INQ_TALLIES				0xF100

/* Missing in linux_hermes_rid.h */

#define HERMES_RID_CNFTXRATECONTROL0			0xFC9E
#define HERMES_RID_CNFTXRATECONTROL1			0xFC9F
#define HERMES_RID_CNFTXRATECONTROL2			0xFCA0
#define HERMES_RID_CNFTXRATECONTROL3			0xFCA1
#define HERMES_RID_CNFTXRATECONTROL4			0xFCA2
#define HERMES_RID_CNFTXRATECONTROL5			0xFCA3
#define HERMES_RID_CNFTXRATECONTROL6			0xFCA4

#define HERMES_RID_PROFILE				0xFD14
#define HERMES_RID_CURRENTREMOTERATES			0xFD50
#define HERMES_RID_CURRENTUSEDRATES			0xFD51
#define HERMES_RID_POINTCOORDFUNC			0xFD87
#define HERMES_RID_CCATIME				0xFDC4
#define HERMES_RID_MACPROCESSINGDELAY			0xFDC5


/* Badly defined in linux hermes.h */

struct hermes_tallies_frame_fixed {
	uint32_t TxUnicastFrames;
	uint32_t TxMulticastFrames;
	uint32_t TxFragments;
	uint32_t TxUnicastOctets;
	uint32_t TxMulticastOctets;
	uint32_t TxDeferredTransmissions;
	uint32_t TxSingleRetryFrames;
	uint32_t TxMultipleRetryFrames;
	uint32_t TxRetryLimitExceeded;
	uint32_t TxDiscards;
	uint32_t RxUnicastFrames;
	uint32_t RxMulticastFrames;
	uint32_t RxFragments;
	uint32_t RxUnicastOctets;
	uint32_t RxMulticastOctets;
	uint32_t RxFCSErrors;
	uint32_t RxDiscards_NoBuffer;
	uint32_t TxDiscardsWrongSA;
	uint32_t RxWEPUndecryptable;
	uint32_t RxMsgInMsgFragments;
	uint32_t RxMsgInBadMsgFragments;
	/* Those last are probably not available in very old firmwares */
	uint32_t RxDiscards_WEPICVError;
	uint32_t RxDiscards_WEPExcluded;
} __attribute__ ((packed));


/* missing */

struct hermes_regulatory_domains {
  uint16_t count;
  uint8_t d[10];
} __attribute__ ((packed));


struct hermes_profile {
  uint16_t code;
  uint16_t capabilities;
  uint16_t allowed_data_rates;
} __attribute__ ((packed));


struct hermes_comms_quality {
  uint16_t comms_qual;
  uint16_t signal_lvl;
  uint16_t noise_lvl;
} __attribute__ ((packed));


struct hermes_scale_thresholds {
  uint16_t energy_detect_thrh;     //Receiver H/W Energy Detect Threshold
  uint16_t carrier_detect_thrh;    //Receiver H/W Carrier Detect Threshold
  uint16_t defer_thrh;             //Receiver H/W Defer Threshold
  uint16_t cell_search_thrh;       //Firmware Roaming Cell Search Threshold [STA]
  uint16_t out_of_range_thrh;      //Firmware Roaming Out of Range Threshold [STA]
  uint16_t delta_snr;              //Firmware Roaming Delta SNR value [STA]
} __attribute__ ((packed));


struct hermes_supported_data_rates {
  uint16_t rates[5];
} __attribute__ ((packed));
