/* ==========================================================================
 * AnonNet - Anonymous Network Project
 * --------------------------------------------------------------------------
 * Copyright (C) 2002  William Ahern
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 * ==========================================================================
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>	/* fileno() */
#include <sys/types.h>	/* write() */
#include <unistd.h>	/* "     " */
#include <limits.h>	/* PIPE_BUF */


#ifndef _SNPRINTX_H
#define _SNPRINTX_H

#ifndef MIN
#define MIN(a,b)	(((a) < (b))? (a) : (b))
#endif

#ifndef MAX
#define MAX(a,b)	(((a) > (b))? (a) : (b))
#endif

#define SNPRINTX_WITH_GRAPH 1

#if SNPRINTX_WITH_GRAPH
#define SNPRINTX_LINE_SIZE(len)	((len != 0)?(5 + (16 * 3) + 4 + MIN((len),16) + 1):0)
#define SNPRINTX_LINE_SIZE_MAX	SNPRINTX_LINE_SIZE(16)	/* should be 74 */
#else
#define SNPRINTX_LINE_SIZE(len)	((len != 0)?(5 + (MIN((len),16) * 3) + 1):0)
#define SNPRINTX_LINE_SIZE_MAX	SNPRINTX_LINE_SIZE(16)	/* should be 54 */
#endif

#define SNPRINTX_STRING_SIZE(len)						\
				((SNPRINTX_LINE_SIZE_MAX-1) * ((len) / 16))	\
				+ MAX(SNPRINTX_LINE_SIZE(((len) % 16)),1)	/* need final '\0' */

#define DPRINTX_STATIC(fd,bytes,len) do {			\
	char hex[SNPRINTX_STRING_SIZE((len))]	= {0};		\
	int r;							\
								\
	r = snprintx(hex,sizeof(hex),bytes,len,0);		\
								\
	write((fd),hex,SNPRINTX_STRING_SIZE(r));		\
} while(0)

#define FPRINTX_STATIC(fp,bytes,len)	DPRINTX_STATIC(fileno((fp)),(bytes),(len))
#define PRINTX_STATIC(bytes,len)	FPRINTX_STATIC(stdout,(bytes),(len))

#define DPRINTX(fd,bytes,len) do {					\
	char hex[PIPE_BUF]	= {0};					\
	int off			= 0;					\
	int r;								\
									\
	while ((r = snprintx(hex,sizeof(hex),(bytes),(len),off)) > 0) {	\
		write((fd),hex,SNPRINTX_STRING_SIZE(r));		\
		off += r;						\
	}								\
} while(0)

#define FPRINTX(fp,bytes,len)	DPRINTX(fileno((fp)),(bytes),(len))
#define PRINTX(bytes,len)	FPRINTX(stdout,(bytes),(len))

#define _SNPRINTX_ROW(len,off)	\
	MIN((((len)/16)-(((len)-(off))/16)),99) /* sizes calculated on 2 digits row #'s */


int snprintx(char *, int, void *, int, int);

#endif /* _SNPRINTX_H */
