/* ==========================================================================
 * AnonNet - Anonymous Network Project
 * --------------------------------------------------------------------------
 * Copyright (C) 2002  William Ahern
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * ==========================================================================
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "snprintx.h"


static const char *snprintx_format[16] = {
	#if SNPRINTX_WITH_GRAPH
	"%.2i - %.2X                                                 %c\n",
	"%.2i - %.2X %.2X                                              %c%c\n",
	"%.2i - %.2X %.2X %.2X                                           %c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X                                        %c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X                                     %c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X                                  %c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X                               %c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X                            %c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X                         %c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X                      %c%c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X                   %c%c%c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X                %c%c%c%c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X             %c%c%c%c%c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X          %c%c%c%c%c%c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X       %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X    %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c\n"
	#else
	"%.2i - %.2X\n",
	"%.2i - %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n",
	"%.2i - %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X\n"
	#endif
};


int snprintx(char *line, int size, void *data, int len, int off) {
	unsigned char *bytes;
	int n,r = 0;

	bytes	= ((unsigned char *)data) + off;

	if (size < SNPRINTX_LINE_SIZE(MIN(16,(len-off))))
		return -1;

	while (((n = MIN((len-off),16)) > 0) && (size >= SNPRINTX_LINE_SIZE(n))) {
		switch(n) {
			case 0:
				break;
			#if SNPRINTX_WITH_GRAPH
			case 1:
				snprintf(line,size,snprintx_format[0],_SNPRINTX_ROW(len,off),bytes[0],((isgraph(bytes[0]))?bytes[0]:'.'),'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.');
				break;
			case 2:
				snprintf(line,size,snprintx_format[1],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),'.','.','.','.','.','.','.','.','.','.','.','.','.','.');
				break;
			case 3:
				snprintf(line,size,snprintx_format[2],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),'.','.','.','.','.','.','.','.','.','.','.','.','.');
				break;
			case 4:
				snprintf(line,size,snprintx_format[3],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),'.','.','.','.','.','.','.','.','.','.','.','.');
				break;
			case 5:
				snprintf(line,size,snprintx_format[4],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),'.','.','.','.','.','.','.','.','.','.','.');
				break;
			case 6:
				snprintf(line,size,snprintx_format[5],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),'.','.','.','.','.','.','.','.','.','.');
				break;
			case 7:
				snprintf(line,size,snprintx_format[6],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),'.','.','.','.','.','.','.','.','.');
				break;
			case 8:
				snprintf(line,size,snprintx_format[7],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),'.','.','.','.','.','.','.','.');
				break;
			case 9:
				snprintf(line,size,snprintx_format[8],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),'.','.','.','.','.','.','.');
				break;
			case 10:
				snprintf(line,size,snprintx_format[9],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),'.','.','.','.','.','.');
				break;
			case 11:
				snprintf(line,size,snprintx_format[10],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),((isgraph(bytes[10]))?bytes[10]:'.'),'.','.','.','.','.');
				break;
			case 12:
				snprintf(line,size,snprintx_format[11],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),((isgraph(bytes[10]))?bytes[10]:'.'),((isgraph(bytes[11]))?bytes[11]:'.'),'.','.','.','.');
				break;
			case 13:
				snprintf(line,size,snprintx_format[12],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),((isgraph(bytes[10]))?bytes[10]:'.'),((isgraph(bytes[11]))?bytes[11]:'.'),((isgraph(bytes[12]))?bytes[12]:'.'),'.','.','.');
				break;
			case 14:
				snprintf(line,size,snprintx_format[13],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],bytes[13],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),((isgraph(bytes[10]))?bytes[10]:'.'),((isgraph(bytes[11]))?bytes[11]:'.'),((isgraph(bytes[12]))?bytes[12]:'.'),((isgraph(bytes[13]))?bytes[13]:'.'),'.','.');
				break;
			case 15:
				snprintf(line,size,snprintx_format[14],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],bytes[13],bytes[14],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),((isgraph(bytes[10]))?bytes[10]:'.'),((isgraph(bytes[11]))?bytes[11]:'.'),((isgraph(bytes[12]))?bytes[12]:'.'),((isgraph(bytes[13]))?bytes[13]:'.'),((isgraph(bytes[14]))?bytes[14]:'.'),'.');
				break;
			case 16:
				snprintf(line,size,snprintx_format[15],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],bytes[13],bytes[14],bytes[15],((isgraph(bytes[0]))?bytes[0]:'.'),((isgraph(bytes[1]))?bytes[1]:'.'),((isgraph(bytes[2]))?bytes[2]:'.'),((isgraph(bytes[3]))?bytes[3]:'.'),((isgraph(bytes[4]))?bytes[4]:'.'),((isgraph(bytes[5]))?bytes[5]:'.'),((isgraph(bytes[6]))?bytes[6]:'.'),((isgraph(bytes[7]))?bytes[7]:'.'),((isgraph(bytes[8]))?bytes[8]:'.'),((isgraph(bytes[9]))?bytes[9]:'.'),((isgraph(bytes[10]))?bytes[10]:'.'),((isgraph(bytes[11]))?bytes[11]:'.'),((isgraph(bytes[12]))?bytes[12]:'.'),((isgraph(bytes[13]))?bytes[13]:'.'),((isgraph(bytes[14]))?bytes[14]:'.'),((isgraph(bytes[15]))?bytes[15]:'.'));
				break;
			#else
			case 1:
				snprintf(line,size,snprintx_format[0],_SNPRINTX_ROW(len,off),bytes[0]);
				break;
			case 2:
				snprintf(line,size,snprintx_format[1],_SNPRINTX_ROW(len,off),bytes[0],bytes[1]);
				break;
			case 3:
				snprintf(line,size,snprintx_format[2],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2]);
				break;
			case 4:
				snprintf(line,size,snprintx_format[3],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3]);
				break;
			case 5:
				snprintf(line,size,snprintx_format[4],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4]);
				break;
			case 6:
				snprintf(line,size,snprintx_format[5],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5]);
				break;
			case 7:
				snprintf(line,size,snprintx_format[6],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6]);
				break;
			case 8:
				snprintf(line,size,snprintx_format[7],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7]);
				break;
			case 9:
				snprintf(line,size,snprintx_format[8],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8]);
				break;
			case 10:
				snprintf(line,size,snprintx_format[9],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9]);
				break;
			case 11:
				snprintf(line,size,snprintx_format[10],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10]);
				break;
			case 12:
				snprintf(line,size,snprintx_format[11],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11]);
				break;
			case 13:
				snprintf(line,size,snprintx_format[12],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12]);
				break;
			case 14:
				snprintf(line,size,snprintx_format[13],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],bytes[13]);
				break;
			case 15:
				snprintf(line,size,snprintx_format[14],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],bytes[13],bytes[14]);
				break;
			case 16:
				snprintf(line,size,snprintx_format[15],_SNPRINTX_ROW(len,off),bytes[0],bytes[1],bytes[2],bytes[3],bytes[4],bytes[5],bytes[6],bytes[7],bytes[8],bytes[9],bytes[10],bytes[11],bytes[12],bytes[13],bytes[14],bytes[15]);
				break;
			#endif
		}
		bytes	+= n;
		off	+= n;
		line	+= SNPRINTX_LINE_SIZE(n)-1;
		size	-= SNPRINTX_LINE_SIZE(n);
		r	+= n;
	}

	return r;
}

