// ===========================================================================
// File: "aidaMain.h"
//                        Created: 2010-08-09 21:56:18
//              Last modification: 2014-01-11 13:21:23
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// (c) Copyright: Bernard Desgraupes 2010-2014
// All rights reserved.
// ===========================================================================

#ifndef AIDA_MAIN_H
#define AIDA_MAIN_H

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <limits.h>
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

// #include <Tcl/tcl.h>
#include <tcl.h>

#include "aidaDefinitions.h"
#include "aidaConstants.h"
#include "aida.tab.h"


// Prototypes
// ----------

// aidaMain.c
void	aida_exit(int inCode);
void	aida_abort(char * inMsg,...);
void	aida_terminate(void);
void	aida_free_fragments();
int		aida_global_options(int * ioArgc, char ** ioArgv[]);
#ifdef HAVE_SIGNAL_H
void	aida_signal_handler(int inNum);
void	aida_install_sigaction();
#endif

// aidaCommands.c
int		aidaCmd_info(int argc, char *argv[]);
int		aidaCmd_help(int argc, char *argv[]);
int		aidaCmd_convert(int argc, char *argv[]);
int		aidaCmd_split(int argc, char *argv[]);
int		aida_process(int argc, char *argv[], int index);
int		aida_checkRequired();
int		aida_doConvert();
int		aida_doSplit();
int		aida_reconstructOutput();
int		aida_preScanData();
int		aida_openInclude(Tcl_DString * inDst, aida_incl_t ** outIncl);
void	aida_closeInclude(aida_incl_t * inData);
aida_incl_t *	aida_newInclude();

// aidaDebug.c
void	aida_dbg_ifconds();
void	aida_dbg_context(aida_parse_t * inScanParam);
void	aida_dbg_fragments();
void	aida_dbg_printf(const char * frmt,...);
void	aida_dbg_loc(int inNum, char * inStr, YYLTYPE * inLoc);
void	aida_dbg_tcl_callstack(int inNum);

// aidaEncoding.c
int			aida_init_encodings();
int			aida_install_encodings();
int			aida_encoding_name(const char * inEnc, bool isInput);
int			aida_set_encoding(const char * inEnc, bool isInput);
int			aida_transcodeInput(char * inFile, bool * outTemp, char ** outFile);
void		aida_free_encodings();
bool		aida_single_encoding(const char * inEnc);
char *		aida_TclObjToExternalDString(Tcl_Obj * inObj, Tcl_Encoding inExtEnc, Tcl_DString *outDStr);
Tcl_Obj *	aida_externalToTclObj(char * inStr);
Tcl_Obj *	aida_externalCharsToTclObj(char * inStr, int inLen, int *outErr);
bool		aida_has_BOM(Tcl_Obj * inObj);

// aidaInterp.c
int			aida_initTcl(const char * inName);
int			aida_createTclCommands();
int			aida_createTclVars();
int			aida_adjustTclVars();
int			aida_installCoreLib();
int			aida_installTclCode(char * inTarget);
int			aida_sourceRcFiles(char * inName);
int			aida_installCharsMap();
int			aida_evalFile(Tcl_Obj * inFile, bool * openError);
int			aida_sourceLibFile(char * inName, char * inTarget);
int			aida_setHeaderValue(char * inKey, char * inValue);
int			aida_executeHook(char * inHook, int inArgc, ...);
int			aida_executeProc(char * inProc, aida_parse_t * inScanParam, int inArgc, ...);
int			aida_executeTextProc(char * inProc, aida_parse_t * inScanParam, Tcl_DString * inDst);
int			aida_procToFile(Tcl_Obj * inProc, FILE * inDest, int inArgc, ...);
int			aida_evalIfCondition(Tcl_DString * inDst);
Tcl_Obj *	aida_substString(char * inStr, int inFlags);

// aidaLib.c 
void	aida_initLibDir();

// aidaPrint.c 
void	aida_assert_result(int inCode);
void	aida_result_to_console(int inCode);
void	aida_print_err(const char * frmt,...);
void	aida_print_out(const char * frmt,...);
void	aida_print_array(FILE * stream, const char * inTable[], bool inLF);
void	aida_verbose(int inLevel, const char * frmt,...);
void	aida_warn(const char * frmt,...);
void	aida_result_to_std(FILE * stream, Tcl_Encoding inEncoding);

void	aida_writeResult(int inCode, aida_parse_t * inScanParam);
void	aida_writeString(char * inStr, aida_parse_t * inScanParam);
void	aida_writeDString(Tcl_DString * inDStr, aida_parse_t * inScanParam);
void	aida_writeTclObj(Tcl_Obj * inObj, aida_parse_t * inScanParam);

void	aida_writeByte(char inChar, aida_parse_t * inScanParam);

// aidaProcs.c 
int		aida_anchorProc(Tcl_DString * inDst, aida_parse_t * inScanParam);
int		aida_commentProc(Tcl_DString * inDst, aida_parse_t * inScanParam);
int		aida_horizRuleProc(aida_parse_t * inScanParam);
int		aida_imageProc(Tcl_DString * inDst, Tcl_DString * inAttrDst, aida_parse_t * inScanParam);
int		aida_linkProc(Tcl_DString * inUrl, Tcl_DString * inTxt, bool isRef, aida_parse_t * inScanParam);
int		aida_navBarProc(int inNum, int inLastNum, FILE * inDest);
int		aida_newLineProc(aida_parse_t * inScanParam);
int		aida_printIndexProc(aida_parse_t * inScanParam);
int		aida_quoteProc(Tcl_DString * inDst, aida_parse_t * inScanParam);
int		aida_sectionProc(Tcl_DString * inDst, int inLevel, aida_parse_t * inScanParam);
int		aida_setIndexProc(Tcl_DString * inDst, aida_parse_t * inScanParam);
int		aida_styleTagProc(char inType, bool inBegin, aida_parse_t * inScanParam);
int		aida_tocProc(aida_parse_t * inScanParam);
int		aida_verbProc(Tcl_DString * inDst, aida_parse_t * inScanParam);
int		aida_verbatimBlockProc(Tcl_DString * inDst, aida_parse_t * inScanParam);

// aidaTclCommands.c
int aidaTcl_getDepth(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv);
int aidaTcl_getDirname(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv);
int aidaTcl_splitting(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv);
int aidaTcl_encoding(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv);

// aidaUsage.c
int		aida_convert_usage();
int		aida_help_usage();
int		aida_help_header();
int		aida_info_attributes(char * inTarget);
int		aida_info_configuration();
int		aida_info_encodings();
int		aida_info_extensions(char * inTarget);
int		aida_info_license();
int		aida_info_mapping(char * inTarget);
int		aida_info_parameters(char * inTarget);
int		aida_info_path();
int		aida_info_sysenc();
int		aida_info_targets();
int		aida_info_usage();
int		aida_split_usage();
void	aida_global_options_usage();
void	aida_print_help();
void	aida_usage(const char * fname);

// aidaUtils.c
void			aida_wrongNumArgs(const char * inCmd);
int				aida_open(const char *inName, const char *inMode, FILE ** outFile);
Tcl_DString *	aida_makeDString(char *inStr, int inlen);
Tcl_DString *	aida_appendDString(Tcl_DString * inDst, char *inStr, int inlen);
Tcl_Obj *		aida_makeTclList(Tcl_Obj * inObj);
Tcl_Obj *		aida_appendTclList(Tcl_Obj * inList, Tcl_Obj * inObj);
Tcl_Obj *		aida_makeTclDict(Tcl_Obj * inObj);
Tcl_Obj *		aida_appendTclDict(Tcl_Obj * inDict, Tcl_Obj * inPair);
Tcl_Obj *		aida_splitFileName(int inNum);
Tcl_Obj *		aida_buildOutNameObj();
Tcl_Obj *		aida_setIncludeBase(char * inFile);
aida_frag_t *	aida_newFragment(int inKind, void * inData);
void			aida_closeFragmentFile(aida_frag_t * inFrag);
FILE *			aida_newTempFile(aida_file_t * outFile, const char * inDir);
FILE *			aida_switchOutput();
FILE *			aida_nextSplitFile(int inNum, aida_file_t * ioFileData);
int				aida_closeSplitFile(int inNum, aida_file_t * ioFileData);
int				aida_transferContents(FILE * inSrc, FILE * inDest);
int				aida_renameFile(char * inOldName, char * inNewName);
int				aida_renameWithNum(char * inOldName, int inNum);
void			aida_forceSplit(aida_parse_t * inScanParam);
void			aida_addListDepth(char * inType, int inDelta);
char *			aida_buildSplitFormat();
char *			aida_buildOutFileName();
void			aida_checkSplitFormat();


// aida.y
int				aida_parse(FILE * inStream);
Tcl_DString *	aida_parseDString(Tcl_DString * inDst, int inStart);
Tcl_Obj *		aida_parseAttrString(Tcl_DString * inDst);


// aida.l
void	aida_init_contexts(aida_parse_t * inScanParam);



#endif  // AIDA_MAIN_H
