// ===========================================================================
// File: "aidaDebug.c"
//                        Created: 2010-08-09 21:56:18
//              Last modification: 2011-04-26 15:13:10
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// (c) Copyright: Bernard Desgraupes 2010-2011
// All rights reserved.
// ===========================================================================

#include "aidaMain.h"


// ------------------------------------------------------------------------
// 
// "aida_dbg_context" --
// 
// ------------------------------------------------------------------------
void aida_dbg_context(aida_parse_t * inScanParam) 
{
	int i;
	
	printf("scanner(%d) context stack: ", inScanParam->num);
	for (i = 0; i <= inScanParam->ctxCount; i++) {
		printf("%d ", inScanParam->contexts[i]);
	}
	printf("\n");
}


// ------------------------------------------------------------------------
// 
// "aida_dbg_ifconds" --
// 
// ------------------------------------------------------------------------
void aida_dbg_ifconds()
{
#ifdef AIDA_DEBUG_IFELSE
	int i;
	
	printf("gIfDepth: %d - gIfLevel: %d - ", gIfDepth, gIfLevel);
	printf("if-conds stack: ");
	for (i = 0; i <= gIfDepth; i++) {
		printf("%d ", gIfConds[i]);
	}
	printf("\n");
#endif
}


// ------------------------------------------------------------------------
// 
// "aida_dbg_fragments" --
// 
// ------------------------------------------------------------------------
void aida_dbg_fragments()
{
	if (gFragmentHead != NULL) {
		aida_frag_t		*curr = gFragmentHead, *next;
		do {
			next = curr->next;
			printf("Fragment #%d\n", curr->num);			
			switch (curr->kind) {
				case kind_file:
				printf("\ttype: file\n");
				if (curr->u.file.name != NULL) {
					printf("\tname: %s\n", curr->u.file.name);
				} 
				printf("\tclosed: %d\n", curr->u.file.closed);
				break;
				
				case kind_proc:
				printf("\ttype: proc\n");
				printf("\tname: %s\n", Tcl_GetString(curr->u.proc));
				break;
				
				case kind_split:
				printf("\ttype: split\n");
				printf("\tindex: %d\n", curr->u.split.index);
				break;
				
			}
			curr = next;
		} while (curr != NULL);
	} 
}


// ------------------------------------------------------------------------
// 
// "aida_dbg_printf" --
// 
// Print debugging formatted strings if the AIDA_DEBUG_PRINTF macro is
// defined (e-g in aidaDefinitions.h).
// 
// ------------------------------------------------------------------------
void aida_dbg_printf(const char * frmt,...)
{
#ifdef AIDA_DEBUG_PRINTF
	int			result = TCL_OK;
	va_list		ap;

	va_start(ap, frmt);
	vprintf(frmt, ap);
	va_end(ap);
#endif
}


// ------------------------------------------------------------------------
// 
// "aida_dbg_loc" --
// 
// Print tokens met by the lexer with the number of the matching rule and
// the position in the source file.
// 
// ------------------------------------------------------------------------
void aida_dbg_loc(int inNum, char * inStr, YYLTYPE * inLoc)
{
	if (gTraceLexer) {
		printf("-->> (rule %d) seen '%s'\n", inNum, inStr);
		printf("     at pos %d.%d-%d.%d\n", inLoc->first_line, inLoc->first_column, 
			   inLoc->last_line, inLoc->last_column);
	} 
}


// ------------------------------------------------------------------------
// 
// "aida_dbg_tcl_callstack" --
// 
// ------------------------------------------------------------------------
void aida_dbg_tcl_callstack(int inNum) 
{
	int			result = TCL_OK;
	char 		cmd[64];
	
	sprintf(cmd, "info level %d%c", inNum, 0);
	result = Tcl_EvalEx(gInterp, cmd, -1, TCL_EVAL_GLOBAL);	
	aida_result_to_console(result);
}


