# ===========================================================================
# File: "aidaEditing.tcl"
#                        Created: 2010-09-25 12:05:28
#              Last modification: 2011-02-08 08:36:08
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# Description: this file is part of the Aida package.
# It contains procs related to the edition of aida source files.
# 
# (c) Copyright: Bernard Desgraupes, 2010-2011
#         All rights reserved.
# This software is free software. 
# See licensing terms in the Aida Help file.
# ===========================================================================

namespace eval Aida {}

proc Aida::displayPalettes {} {
	global tileLeft tileTop tileWidth
	variable menuToken
	variable floatToken
	
	array set pos {
		"aidaSections"		"-top $tileTop -left [expr $tileWidth -320]"
		"aidaStructures"	"-top [expr $tileTop + 300] -left [expr $tileWidth -320]"
		"aidaStyles"		"-top $tileTop -left [expr $tileWidth -100]"
		"aidaLinks"			"-top [expr $tileTop + 210] -left [expr $tileWidth -100]"
		
	}
	foreach sub [array names pos] {
		set token $menuToken($sub)
		if {[catch {floatMenu find $token} floatToken($sub)]} {
			set floatToken($sub) [eval [list floatMenu create -menu $token -height 25 -width 130] $pos($sub)]
		} else {
			floatMenu hide $floatToken($sub)
			floatMenu set $floatToken($sub) -menu $token
			floatMenu show $floatToken($sub)
		}
	} 
}


proc Aida::environment {which} {
	set txt [string trimright [getSelect] "\r\n"]
	deleteSelection
	switch -- $which {
		"ifBlock" {
			set pos [getPos]
			insertText "((if \r$txt\rif))"
			goto [pos::math $pos + 5]
		}
		"ifElseBlock" {
			set pos [getPos]
			insertText "((if \r$txt\r((else\r\t\rif))"
			goto [pos::math $pos + 5]
		}
	}
}


proc Aida::buildList {tag bitm eitm} {
	set txt [getSelect]
	set result [list]
	if {$txt == ""} {
		if {[catch {prompt "How many list items ?" 3} numli]} {
			return
		} 
		for {set i 0} {$i < $numli} {incr i} {
			lappend result "${bitm}${eitm}"
		}
	} else {
		deleteSelection
		set txt [string trimright $txt "\r"]
		regsub -all {\r\r+} $txt "" txt
		set blocks [split $txt ""]
		foreach bl $blocks {
			set bl [string trimright $bl "\r"]
			lappend result "${bitm}$bl${eitm}"
		} 
	}
	insertText "(($tag\r[join $result "\r"]\r$tag))\r"
}


proc Aida::makeTable {{border 0}} {
	set txt [getSelect]
	if {$txt == ""} {
		if {[catch {prompt "How many table rows ?" 3} numr]} {
			return
		}  
		set txt [string repeat "((tr  tr))\r" $numr]
	} else {
		deleteSelection
		regsub -all {[\r\n]{2,}} $txt "\r" txt
		set txt [doPrefixText insert "((tr " $txt]
		set txt [doSuffixText insert " tr))" $txt]
	}
	insertText "((table border=$border\n${txt}table))\n"
}


proc Aida::verbatimize {} {
	set txt [getSelect]
	deleteSelection
	insertText "((|\r[doPrefixText insert "    " $txt]|))\r"
}


proc Aida::unverbatimize {} {
	set txt [getSelect]
	deleteSelection
	regsub {\(\(\|} $txt "" txt
	regsub {\|\)\)} $txt "" txt
	insertText [doPrefixText remove "(| " $txt]
}


proc Aida::tagStartOfLine {which} {
	switch -- $which {
		"newLine" {set tag "((nl))"}
		"horizontalRule" {set tag "((hr))"}
	}
	goto [lineStart [getPos]]
	insertText "$tag "
}


proc Aida::tagSection {which} {
	Aida::tagEnclosing "s$which"
}


proc Aida::tagEnclosing {symb} {
	set txt [getSelect]
	deleteSelection
	if {[regexp "\\\(\\\(${symb} (.*) ${symb}\\\)\\\)" $txt dum txt]} {
		insertText $txt	
	} else {
		insertText "((${symb} $txt ${symb}))"	
	}
}


proc Aida::makeLink {symb} {
	set txt [getSelect]
	set txt [string trimleft $txt " "]
	set idx [string first " " $txt]
	if {$idx == "-1"} {
		set res "((${symb} \[$txt\] ${symb}))"
	} else {
		set res "((${symb} \[[string range $txt 0 [expr {$idx-1}]]\][string range $txt $idx end] ${symb}))"
	}
	deleteSelection
	insertText $res
}


proc Aida::newTemplate {} {
	set defaulttext [Aida::defaultHeader]
	append defaulttext "\r\r((hr))\r((toc))\r((hr))\r\r"
	new -n "untitled.aida" -text $defaulttext
}


proc Aida::insertHeader {} {
	goto [minPos]
	set title [file root [file tail [win::Current]]]
	insertText [Aida::defaultHeader $title]
}


proc Aida::defaultHeader { {title "untitled"} } {
	global identity
	
	set defaulttext ""
	set date [ISOTime::ISODateAndTimeRelaxed]
	append defaulttext ":Title:             $title\n"
	append defaulttext ":DestDir:           \n"
	append defaulttext ":Project:           \n"
	append defaulttext ":Author:            [userInfo::getInfo author]\n"
	append defaulttext ":Email:             [userInfo::getInfo email]\n"
	append defaulttext ":Homepage:          [userInfo::getInfo www]\n"
	append defaulttext ":Created:           $date\n"
	append defaulttext ":Modified"
	append defaulttext ":          $date\n"
	append defaulttext ":Keywords:          \n"
	return $defaulttext
}

