// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a Tuple.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface ITuple {

    /**
     * Get the title of this ITuple.
     * @return The ITuple's title.
     *
     */
    public String title();

    /**
     * Set the title of the ITuple.
     * @param title The new ITuple's title.
     * @throws      IllegalArgumentEception If title cannot be changed.
     *
     */
    public void setTitle(String title) throws IllegalArgumentException;

    /**
     * Get the IAnnotation corresponding to this ITuple.
     * @return The ITuple's IAnnotation.
     *
     */
    public IAnnotation annotation();

    /**
     * Fill a given column with a double.
     * @param column The column's index within the ITuple.
     * @param value  The double.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, double value) throws IllegalArgumentException;

    /**
     * Fill a given column with a float.
     * @param column The column's index within the ITuple.
     * @param value  The float.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, float value) throws IllegalArgumentException;

    /**
     * Fill a given column with an integer.
     * @param column The column's index within the ITuple.
     * @param value  The integer.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, int value) throws IllegalArgumentException;

    /**
     * Fill a given column with a short.
     * @param column The column's index within the ITuple.
     * @param value  The short.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, short value) throws IllegalArgumentException;

    /**
     * Fill a given column with a long.
     * @param column The column's index within the ITuple.
     * @param value  The long.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, long value) throws IllegalArgumentException;

    /**
     * Fill a given column with a char.
     * @param column The column's index within the ITuple.
     * @param value  The char.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, char value) throws IllegalArgumentException;



    /**
     * Fill a given column with a byte.
     * @param column The column's index within the ITuple.
     * @param value  The byte.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    void fill(int column, byte value) throws IllegalArgumentException;
    /**
     * Fill a given column with a boolean.
     * @param column The column's index within the ITuple.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, boolean value) throws IllegalArgumentException;

    /**
     * Fill a given column with a string.
     * @param column The column's index within the ITuple.
     * @param value  The string.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, String value) throws IllegalArgumentException;

    /**
     * Fill a given column with an object.
     * @param column The column's index within the ITuple.
     * @param value  The object.
     * @throws       IllegalArgumentException If the column is of the wrong type.
     *
     */
    public void fill(int column, Object value) throws IllegalArgumentException;

    /**
     * Fill all the columns at once with doubles.
     * @param values The array of doubles.
     * @throws       IllegalArgumentException If any column is not of type double or if
     *               the array has the wrong dimension.
     *
     */
    public void fill(double[] values) throws IllegalArgumentException;

    /**
     * Fill all the columns at once with floats.
     * @param values The array of floats.
     * @throws       IllegalArgumentException If any column is not of type float or if
     *               the array has the wrong dimension.
     *
     */
    public void fill(float[] values) throws IllegalArgumentException;

    /**
     * Add the current row to the ITuple. This method should be called after 
     * fill has been called for the columns; unfilled columns will be filled 
     * with their default value.
     * @throws OutOfStorageException When the ITuple runs out of storage space.
     *
     */
    public void addRow() throws OutOfStorageException;

    /**
     * Clear the current(not yet added) row.
     *
     */
    public void resetRow();

    /**
     * Reset the ITuple. All the rows are reset.
     * The ITuple is as just created.
     *
     */
    public void reset();

    /**
     * Get the number of rows currently filled in the ITuple.
     * @return The number of rows. -1 if empty or if it cannot be determined.
     *
     */
    public int rows();

    /**
     * Positions the read cursor immediately before the first row.
     *
     */
    public void start();

    /**
     * Skips a given number of rows.
     * @param rows The number of rows to skip.
     * @throws     IllegalArgumentException If rows is less than zero or
     *             if it is not possible to perform the jump.
     *
     */
    public void skip(int rows) throws IllegalArgumentException;

    /**
     * Positions the cursor at the next row.
     * @return false if there is no next row.
     *
     */
    public boolean next();

    /**
     * Position the cursor at a give row.
     * @param rowIndex The row where the cursor has to be positioned.
     * @throws         IllegalArgumentException If the cursor cannot be positioned
     *                 at the give row.
     *
     */
    public void setRow(int rowIndex) throws IllegalArgumentException;

    /**
     * Get the index within the ITuple of a given column.
     * @param name The colum's name.
     * @throws IllegalArgumentExcepion If the column does not exist.
     * @return The corresponding column's index. Note: in C++ -1 may
     *         be returned if the column does not exist.
     */
    public int findColumn(String name) throws IllegalArgumentException;

    /**
     * Get the double stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The double.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */
    public double getDouble(int column) throws ClassCastException;

    /**
     * Get the float stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The float.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public float getFloat(int column) throws ClassCastException;

    /**
     * Get the integer stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The integer.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public int getInt(int column) throws ClassCastException;

    /**
     * Get the short stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The short.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public short getShort(int column) throws ClassCastException;

    /**
     * Get the long stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The long.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public long getLong(int column) throws ClassCastException;

    /**
     * Get the character stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The character.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public char getChar(int column) throws ClassCastException;



    /**
     * Get the byte stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The byte.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    byte getByte(int column) throws ClassCastException;
    /**
     * Get the boolean stored in a given column at the current cursor's position.
     * @return       The boolean.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public boolean getBoolean(int column) throws ClassCastException;

    /**
     * Get the string stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The string.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public String getString(int column) throws ClassCastException;

    /**
     * Get the object stored in a given column at the current cursor's position.
     * @param column The column's index within the ITuple.
     * @return       The object.
     * @throws       ClassCastException If there is a mismatch of types.
     *
     */    
    public Object getObject(int column) throws ClassCastException;

    /**
     * Return method for tuple variables of type ITuple for a given column.
     * This method can be used in order to fill a tuple variable in the master tuple.
     * @param column The column's index.
     * @return       The ITuple representing the structure of this column.
     *
     */
    public ITuple getTuple(int column);

   /** 
    * Get the number of columns in the ITuple
    * @return The number of columns.
    *
    */
    public int columns();

   /** 
    * Get the name of a column from its index.
    * @param column The column's index.
    * @return       The column's name.
    * @throws       IllegalArgumentException For a wrong column's index.
    *
    */
    public String columnName(int column) throws IllegalArgumentException;

   /** 
    * Get the names of all the columns.
    * @return  The column names.
    *
    */
    public String[] columnNames();

   /** 
    * Get the type of a give column.
    * @param column The column's type.
    * @return       The column's Class.
    * @throws       IllegalArgumentException For a wrong column's index.
    *
    */
    public Class columnType(int column) throws IllegalArgumentException;

   /** 
    * Get the types of all the columns.
    * @return  The column Classes.
    *
    */
    public Class[] columnTypes();

   /**
    * Get the minimum value of a given column (if it can be converted to a double).
    * @param column The column's index.
    * @return       The column's minimum value. In Java Double.NaN might be returned.
    * @throws       IllegalArgumentException For a wrong column's index.
    *
    */
    public double columnMin(int column) throws IllegalArgumentException;

   /**
    * Get the maximum value of a given column (if it can be converted to a double).
    * @param column The column's index.
    * @return       The column's maximum value. In Java Double.NaN might be returned.
    * @throws       IllegalArgumentException For a wrong column's index.
    *
    */
    public double columnMax(int column) throws IllegalArgumentException;

   /**
    * Get the mean value of a given column (if it can be converted to a double).
    * @param column The column's index.
    * @return       The column's mean value. In Java Double.NaN might be returned.
    * @throws       IllegalArgumentException For a wrong column's index.
    *
    */
    public double columnMean(int column) throws IllegalArgumentException;

   /**
    * Get the RMS of a given column (if it can be converted to a double).
    * @param column The column's index.
    * @return       The column's RMS. In Java Double.NaN might be returned.
    * @throws       IllegalArgumentException For a wrong column's index.
    *
    */
    public double columnRms(int column) throws IllegalArgumentException;

    /**
     * Fill an IHistogram1D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram. The value is computed
     *                   from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram1D histogram, IEvaluator evaluatorX) throws IllegalArgumentException;

    /**
     * Fill an IHistogram1D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram. The value is computed
     *                   from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the histogram is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */    
    public void project(IHistogram1D histogram, IEvaluator evaluatorX, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an IHistogram1D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram. The value is computed
     *                   from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */    
    public void project(IHistogram1D histogram, IEvaluator evaluatorX, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IHistogram1D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram. The value is computed
     *                   from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the histogram is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */    
    public void project(IHistogram1D histogram, IEvaluator evaluatorX, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IHistogram2D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY) throws IllegalArgumentException;

    /**
     * Fill an IHistogram2D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the histogram is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an IHistogram2D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IHistogram2D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the histogram is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IHistogram3D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the histogram along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ) throws IllegalArgumentException;

    /**
     * Fill an IHistogram3D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the histogram along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the histogram is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an IHistogram3D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the histogram along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IHistogram3D from the tuple.
     * @param histogram  The histogram to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the histogram along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the histogram along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the histogram along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the histogram is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an ICloud1D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud. The value is computed
     *                   from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud1D cloud, IEvaluator evaluatorX) throws IllegalArgumentException;

    /**
     * Fill an ICloud1D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud. The value is computed
     *                   from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the cloud is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */    
    public void project(ICloud1D cloud, IEvaluator evaluatorX, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an ICloud1D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud. The value is computed
     *                   from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */    
    public void project(ICloud1D cloud, IEvaluator evaluatorX, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an ICloud1D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud. The value is computed
     *                   from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the cloud is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */    
    public void project(ICloud1D cloud, IEvaluator evaluatorX, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an ICloud2D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY) throws IllegalArgumentException;

    /**
     * Fill an ICloud2D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the cloud is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an ICloud2D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an ICloud2D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the cloud is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an ICloud3D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the cloud along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ) throws IllegalArgumentException;

    /**
     * Fill an ICloud3D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the cloud along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the cloud is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an ICloud3D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the cloud along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an ICloud3D from the tuple.
     * @param cloud      The cloud to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the cloud along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the cloud along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the cloud along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the cloud is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IProfile1D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY) throws IllegalArgumentException;

    /**
     * Fill an IProfile1D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the profile is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an IProfile1D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IProfile1D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the profile is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IProfile2D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the profile along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ) throws IllegalArgumentException;

    /**
     * Fill an IProfile2D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the profile along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the profile is not filled.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter) throws IllegalArgumentException;

    /**
     * Fill an IProfile2D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the profile along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IEvaluator weight) throws IllegalArgumentException;

    /**
     * Fill an IProfile2D from the tuple.
     * @param profile    The profile to fill.
     * @param evaluatorX The evaluator used to compute the value
     *                   to be filled in the profile along the x axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorY The evaluator used to compute the value
     *                   to be filled in the profile along the y axis. 
     *                   The value is computed from the current row of the tuple.
     * @param evaluatorZ The evaluator used to compute the value
     *                   to be filled in the profile along the z axis. 
     *                   The value is computed from the current row of the tuple.
     * @param filter     The filter object used to accept or not the current row.
     *                   If rejected, the profile is not filled.
     * @param weight     The evaluator which determines the weight which is used during the filling.
     * @throws           IllegalArgumentException If something goes wrong.
     *
     */
    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter, IEvaluator weight) throws IllegalArgumentException;
} // class or interface

