// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_ICLOUD_H
#define AIDA_ICLOUD_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include "AIDA/IBaseHistogram.h"

namespace AIDA {

/**
 * User level interface to a Cloud.
 * A Cloud is an unbinned collection of points. It can be used to
 * represent scatter plots or dynamically rebinnable histograms.
 * If they number of entries in the cloud exceeds some threshold 
 * they may be automatically converted to a binned histogram.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class ICloud : virtual public IBaseHistogram {

public: 
    /// Destructor.
    virtual ~ICloud() { /* nop */; }

    /**
     * Get the sum of weights of all the entries.
     * @return The sum of the weights of all the entries.
     *
     */
    virtual double sumOfWeights() const = 0;

    /**
     * Convert the ICloud to an IHistogram using the default number of bins.
     * @return false If the ICloud has already been converted.
     *
     */
    virtual bool convertToHistogram() = 0;

    /**
     * Check if the ICloud has been converted to an IHistogram.
     * @return <code>true</code> if it has been converted.
     *
     */
    virtual bool isConverted() const = 0;

    /**
     * Get the number of entries after which the cloud will be converted to an IHistogram.
     * @return The number of entries.
     *
     */
    virtual int maxEntries() const = 0;

    /**
     * Scale the weights by a given factor.
     * @param scaleFactor The scale factor.
     * @return false If a non-positive scale factor is provided.
     *
     */
    virtual bool scale(double scaleFactor) = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_ICLOUD_H */
