/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.BitInputStream;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import com.webcodepro.shrinkit.io.LzwInputStream;
import com.webcodepro.shrinkit.io.RleInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NufxLzw1InputStream
extends InputStream {
    private LittleEndianByteInputStream dataStream;
    private LzwInputStream lzwStream;
    private RleInputStream rleStream;
    private InputStream lzwRleStream;
    private InputStream decompressionStream;
    private int bytesLeftInChunk;
    private int givenCrc = -1;
    private int volumeNumber;
    private int rleCharacter;
    private CRC16 dataCrc = new CRC16();

    public NufxLzw1InputStream(LittleEndianByteInputStream littleEndianByteInputStream) {
        this.dataStream = littleEndianByteInputStream;
    }

    public int read() throws IOException {
        int n;
        if (this.givenCrc == -1) {
            this.givenCrc = this.dataStream.readWord();
            this.volumeNumber = this.dataStream.readByte();
            this.rleCharacter = this.dataStream.readByte();
            this.lzwStream = new LzwInputStream(new BitInputStream(this.dataStream, 9));
            this.rleStream = new RleInputStream(this.dataStream, this.rleCharacter);
            this.lzwRleStream = new RleInputStream(this.lzwStream);
        }
        if (this.bytesLeftInChunk == 0) {
            this.bytesLeftInChunk = 4096;
            this.lzwStream.clearDictionary();
            n = this.dataStream.readWord();
            int n2 = this.dataStream.readByte();
            int n3 = n2 + (n == 4096 ? 0 : 2);
            switch (n3) {
                case 0: {
                    this.decompressionStream = this.dataStream;
                    break;
                }
                case 1: {
                    this.decompressionStream = this.lzwStream;
                    break;
                }
                case 2: {
                    this.decompressionStream = this.rleStream;
                    break;
                }
                case 3: {
                    this.decompressionStream = this.lzwRleStream;
                    break;
                }
                default: {
                    throw new IOException("Unknown type of decompression, flag = " + n3);
                }
            }
        }
        n = this.decompressionStream.read();
        --this.bytesLeftInChunk;
        this.dataCrc.update(n);
        return n;
    }

    public boolean isCrcValid() {
        return (long)this.givenCrc == this.dataCrc.getValue();
    }

    public int getGivenCrc() {
        return this.givenCrc;
    }

    public void setGivenCrc(int n) {
        this.givenCrc = n;
    }

    public int getVolumeNumber() {
        return this.volumeNumber;
    }

    public void setVolumeNumber(int n) {
        this.volumeNumber = n;
    }

    public int getRleCharacter() {
        return this.rleCharacter;
    }

    public void setRleCharacter(int n) {
        this.rleCharacter = n;
    }

    public long getDataCrc() {
        return this.dataCrc.getValue();
    }
}

