/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.BitOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class LzwOutputStream
extends OutputStream {
    private BitOutputStream os;
    private Map<ByteArray, Integer> dictionary = new HashMap<ByteArray, Integer>();
    private int[] w = new int[0];
    private int nextCode = 257;

    public LzwOutputStream(BitOutputStream bitOutputStream) {
        this.os = bitOutputStream;
    }

    public void write(int n) throws IOException {
        if (this.dictionary.isEmpty()) {
            for (int i = 0; i < 256; ++i) {
                this.dictionary.put(new ByteArray(i), i);
            }
            this.dictionary.put(new ByteArray(256), null);
        }
        n &= 0xFF;
        int[] nArray = new int[this.w.length + 1];
        if (this.w.length > 0) {
            System.arraycopy(this.w, 0, nArray, 0, this.w.length);
        }
        nArray[nArray.length - 1] = n;
        if (this.dictionary.containsKey(new ByteArray(nArray))) {
            this.w = nArray;
        } else {
            this.dictionary.put(new ByteArray(nArray), this.nextCode++);
            this.os.write(this.dictionary.get(new ByteArray(this.w)));
            this.w = new int[]{n};
        }
        if ((this.dictionary.size() ^ this.os.getBitMask()) == 0) {
            this.os.increaseRequestedNumberOfBits();
        }
    }

    public void flush() throws IOException {
        this.os.write(this.dictionary.get(new ByteArray(this.w)));
    }

    public void close() throws IOException {
        this.flush();
        this.os.flush();
        this.os.close();
    }

    private class ByteArray {
        private int[] data;
        private int hashCode;

        public ByteArray(int n) {
            this(new int[]{n});
        }

        public ByteArray(int[] nArray) {
            this.data = nArray;
            CRC16 cRC16 = new CRC16();
            for (int n : nArray) {
                cRC16.update(n);
            }
            this.hashCode = (int)cRC16.getValue();
        }

        public boolean equals(Object object) {
            ByteArray byteArray = (ByteArray)object;
            if (this.data.length != byteArray.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == byteArray.data[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

