/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.ByteConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class LittleEndianByteOutputStream
extends OutputStream
implements ByteConstants {
    private OutputStream outputStream;
    private long bytesWritten = 0L;
    private CRC16 crc = new CRC16();

    public LittleEndianByteOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void write(int n) throws IOException {
        this.outputStream.write(n);
        this.crc.update(n);
    }

    public void writeNuFileId() throws IOException {
        this.write(NUFILE_ID);
    }

    public void writeNuFxId() throws IOException {
        this.write(NUFX_ID);
    }

    public void writeWord(int n) throws IOException {
        this.write(n & 0xFF);
        this.write(n >> 8);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l & 0xFFL));
        this.write((int)(l >> 8 & 0xFFL));
        this.write((int)(l >> 16 & 0xFFL));
        this.write((int)(l >> 24 & 0xFFL));
    }

    public void writeDate(Date date) throws IOException {
        byte[] byArray = null;
        if (date == null) {
            byArray = TIMEREC_NULL;
        } else {
            byArray = new byte[8];
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            int n = gregorianCalendar.get(1);
            byArray[3] = (byte)((n -= n < 2000 ? 1900 : 2000) & 0xFF);
            byArray[5] = (byte)(gregorianCalendar.get(2) + 1);
            byArray[4] = (byte)gregorianCalendar.get(5);
            byArray[2] = (byte)gregorianCalendar.get(11);
            byArray[1] = (byte)gregorianCalendar.get(12);
            byArray[0] = (byte)gregorianCalendar.get(13);
            byArray[7] = (byte)gregorianCalendar.get(7);
        }
        this.write(byArray);
    }

    public void resetCrc() {
        this.crc.reset();
    }

    public long getCrcValue() {
        return this.crc.getValue();
    }

    public long getTotalBytesWritten() {
        return this.bytesWritten;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
    }
}

