/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.io.BitConstants;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream
implements BitConstants {
    private InputStream is;
    private int requestedNumberOfBits;
    private int bitMask;
    private int data = 0;
    private int bitsOfData = 0;

    public BitInputStream(InputStream inputStream, int n) {
        this.is = inputStream;
        this.setRequestedNumberOfBits(n);
    }

    public void setRequestedNumberOfBits(int n) {
        this.requestedNumberOfBits = n;
        this.bitMask = BIT_MASKS[n];
    }

    public void increaseRequestedNumberOfBits() {
        this.setRequestedNumberOfBits(this.requestedNumberOfBits + 1);
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public int read() throws IOException {
        int n;
        while (this.bitsOfData < this.requestedNumberOfBits) {
            n = this.is.read();
            if (n == -1) {
                return n;
            }
            if (this.bitsOfData > 0) {
                n <<= this.bitsOfData;
            }
            this.data |= n;
            this.bitsOfData += 8;
        }
        n = this.data & this.bitMask;
        this.data >>= this.requestedNumberOfBits;
        this.bitsOfData -= this.requestedNumberOfBits;
        return n;
    }

    public void clearRemainingBitsOfData() {
        this.bitsOfData = 0;
        this.data = 0;
    }
}

