/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.MasterHeaderBlock;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NuFileArchive {
    private MasterHeaderBlock master;
    private List<HeaderBlock> headers;
    private long totalSize = 0L;
    public static final int NUFILE_ARCHIVE = 1;
    public static final int NUFX_ARCHIVE = 2;
    public static final int BXY_ARCHIVE = 3;

    public NuFileArchive(InputStream inputStream) throws IOException {
        LittleEndianByteInputStream littleEndianByteInputStream = new LittleEndianByteInputStream(inputStream);
        this.master = new MasterHeaderBlock(littleEndianByteInputStream);
        this.headers = new ArrayList<HeaderBlock>();
        int n = 0;
        while ((long)n < this.master.getTotalRecords()) {
            HeaderBlock headerBlock = new HeaderBlock(littleEndianByteInputStream);
            headerBlock.readThreads(littleEndianByteInputStream);
            this.headers.add(headerBlock);
            this.totalSize += headerBlock.getHeaderSize();
            ++n;
        }
    }

    public long getArchiveSize() {
        return this.totalSize;
    }

    public MasterHeaderBlock getMasterHeaderBlock() {
        return this.master;
    }

    public List<HeaderBlock> getHeaderBlocks() {
        return this.headers;
    }
}

