/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.io.ByteConstants;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.IOException;
import java.util.Date;

public class MasterHeaderBlock {
    private static final int MASTER_HEADER_LENGTH = 48;
    private int masterCrc;
    private boolean validCrc;
    private long totalRecords;
    private Date archiveCreateWhen;
    private Date archiveModWhen;
    private int masterVersion;
    private long masterEof;

    public MasterHeaderBlock(LittleEndianByteInputStream littleEndianByteInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        n = littleEndianByteInputStream.seekFileType();
        if (n == 3) {
            littleEndianByteInputStream.readBytes(127 - ByteConstants.NUFILE_ID.length);
            n2 = 128;
            int n3 = littleEndianByteInputStream.read();
            if (n3 != 0) {
                throw new IOException("This is actually a Binary II archive with multiple files in it.");
            }
            n = littleEndianByteInputStream.seekFileType();
        }
        if (n != 1) {
            throw new IOException("Unable to decode this archive.");
        }
        this.masterCrc = littleEndianByteInputStream.readWord();
        littleEndianByteInputStream.resetCrc();
        this.totalRecords = littleEndianByteInputStream.readLong();
        this.archiveCreateWhen = littleEndianByteInputStream.readDate();
        this.archiveModWhen = littleEndianByteInputStream.readDate();
        this.masterVersion = littleEndianByteInputStream.readWord();
        if (this.masterVersion > 0) {
            littleEndianByteInputStream.readBytes(8);
            this.masterEof = littleEndianByteInputStream.readLong();
        } else {
            this.masterEof = -1L;
        }
        while (littleEndianByteInputStream.getTotalBytesRead() < (long)(48 + n2)) {
            littleEndianByteInputStream.readByte();
        }
        this.validCrc = (long)this.masterCrc == littleEndianByteInputStream.getCrcValue();
    }

    public int getMasterCrc() {
        return this.masterCrc;
    }

    public void setMasterCrc(int n) {
        this.masterCrc = n;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long l) {
        this.totalRecords = l;
    }

    public Date getArchiveCreateWhen() {
        return this.archiveCreateWhen;
    }

    public void setArchiveCreateWhen(Date date) {
        this.archiveCreateWhen = date;
    }

    public Date getArchiveModWhen() {
        return this.archiveModWhen;
    }

    public void setArchiveModWhen(Date date) {
        this.archiveModWhen = date;
    }

    public int getMasterVersion() {
        return this.masterVersion;
    }

    public void setMasterVersion(int n) {
        this.masterVersion = n;
    }

    public long getMasterEof() {
        return this.masterEof;
    }

    public void setMasterEof(long l) {
        this.masterEof = l;
    }

    public boolean isValidCrc() {
        return this.validCrc;
    }
}

