/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.utilities;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import org.adtpro.resources.Messages;

public class Log {
    private static Log _theSingleton = null;
    private static String _traceFileName = Messages.getString("TraceFileName");
    private static boolean _trace = false;
    private static PrintStream _out = null;

    private Log() {
        _out = System.out;
    }

    public static void printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
        if (_trace) {
            throwable.printStackTrace(_out);
        }
    }

    public static void println(boolean bl, String string) {
        if (bl) {
            System.out.println(string);
        }
        if (_trace) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            if (string != null && string.length() > 0) {
                _out.print(dateFormat.format(new Date()) + " ");
                _out.println(string);
            } else {
                _out.println();
            }
        }
    }

    public static void print(boolean bl, String string) {
        if (bl) {
            System.out.print(string);
        }
        if (_trace) {
            _out.print(string);
        }
    }

    public static Log getSingleton() {
        if (null == _theSingleton) {
            Log.allocateSingleton();
        }
        return _theSingleton;
    }

    public void setTrace(boolean bl) {
        _trace = bl;
        if (bl) {
            if (_traceFileName != null) {
                try {
                    _out.flush();
                    _out = new PrintStream(new FileOutputStream(_traceFileName));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    _out = System.out;
                }
            }
        } else if (_out.getClass() == PrintStream.class) {
            _out.flush();
            _out.close();
            _out = System.out;
        }
    }

    public void setTraceFile(String string) {
        _traceFileName = string;
    }

    private static synchronized void allocateSingleton() {
        if (null == _theSingleton) {
            _theSingleton = new Log();
        }
    }

    public boolean isLogging() {
        return _trace;
    }
}

