/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.adtpro.gui.Gui;
import org.adtpro.resources.Messages;
import org.adtpro.utilities.Log;

public class PlaybackThread
extends Thread {
    byte[] _audioData;
    Gui _parent = null;
    boolean _shouldRun = true;

    public PlaybackThread(byte[] byArray, Gui gui) {
        this._audioData = byArray;
        this._parent = gui;
    }

    public PlaybackThread(byte[] byArray) {
        this._audioData = byArray;
    }

    @Override
    public void run() {
        this.play();
    }

    public void requestStop() {
        this._shouldRun = false;
    }

    public void play() {
        long l = 0L;
        Log.println(false, "PlaybackThread.play() entry.");
        long l2 = System.currentTimeMillis();
        AudioFormat audioFormat = new AudioFormat(44100.0f, 8, 1, false, true);
        SourceDataLine sourceDataLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(audioFormat);
            sourceDataLine.start();
        }
        catch (Exception exception) {
            Log.printStackTrace(exception);
        }
        Log.println(false, "PlaybackThread.play() payload size: " + this._audioData.length);
        if (this._parent != null) {
            this._parent.setProgressMaximum(this._audioData.length);
        }
        int n = 0;
        int n2 = this._audioData.length / 100;
        Log.print(false, "PlaybackThread.play() Bytes written:");
        for (int i = 0; i < 100; ++i) {
            if (!this._shouldRun) continue;
            n += sourceDataLine.write(this._audioData, i * n2, n2);
            if (i % 25 == 0) {
                Log.print(false, " " + n);
            }
            if (this._parent == null || !this._shouldRun) continue;
            this._parent.setProgressValue(n);
        }
        Log.println(false, "");
        if (this._shouldRun) {
            sourceDataLine.drain();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                Log.printStackTrace(interruptedException);
            }
            while (sourceDataLine.getFramePosition() < n) {
                Log.println(false, "PlaybackThread.play() Line still active... pausing a bit.  Position:" + sourceDataLine.getFramePosition());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Log.printStackTrace(interruptedException);
                }
            }
            Log.println(false, "PlaybackThread.play() Done playing.");
            sourceDataLine.close();
            if (this._parent != null && this._shouldRun) {
                long l3 = System.currentTimeMillis();
                l = (l3 - l2) / 1000L;
                this._parent.setSecondaryText(Messages.getString("CommsThread.22") + " in " + l + " seconds.");
                Log.println(true, "Text file sent in " + (l3 - l2) / 1000L + " seconds.");
                Log.println(false, "PlaybackThread.play() exit.");
            }
        }
    }
}

