/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport.audio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.adtpro.resources.Messages;
import org.adtpro.utilities.Log;

public class CaptureThread
extends Thread {
    byte[] buffer = new byte[8192];
    ByteArrayOutputStream outputStream;
    AudioFormat audioFormat;
    TargetDataLine targetDataLine;
    boolean stopCapture = false;
    int byteRegisterData = 0;
    int byteRegisterBits = 0;
    boolean isTraining = true;
    int transitionHysteresis = 3;
    int transitionValue = 0;
    int transitionPeriod = 0;
    int transitionState = 0;
    int lastBit = -1;
    int _hardwareMixerIndex = 0;

    public CaptureThread(int n) {
        this._hardwareMixerIndex = n;
    }

    @Override
    public void run() {
        Log.println(true, "CaptureThread.run() entry with hardware mixer index " + this._hardwareMixerIndex);
        try {
            this.audioFormat = CaptureThread.getAudioFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            if (this._hardwareMixerIndex == 0) {
                this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                Log.println(true, "CaptureThread.run() using audio mixer " + Messages.getString("Gui.DefaultAudioMixer") + ".");
            } else {
                Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
                if (this._hardwareMixerIndex < infoArray.length) {
                    Mixer mixer = AudioSystem.getMixer(infoArray[this._hardwareMixerIndex]);
                    try {
                        this.targetDataLine = (TargetDataLine)mixer.getLine(info);
                        Log.println(true, "CaptureThread.run() using audio mixer " + infoArray[this._hardwareMixerIndex].getName() + ".");
                    }
                    catch (Exception exception) {
                        this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                        Log.println(true, "CaptureThread.run() reverting to audio mixer " + Messages.getString("Gui.DefaultAudioMixer") + ".");
                    }
                }
            }
            this.targetDataLine.open(this.audioFormat);
            this.targetDataLine.start();
        }
        catch (Exception exception) {
            Log.printStackTrace(exception);
        }
        this.outputStream = new ByteArrayOutputStream();
        try {
            while (!this.stopCapture) {
                int n = this.targetDataLine.read(this.buffer, 0, this.buffer.length);
                if (n <= 0) continue;
                this.interpretStream(this.buffer);
            }
            this.outputStream.close();
        }
        catch (IOException iOException) {
            Log.printStackTrace(iOException);
        }
        this.targetDataLine.stop();
        this.targetDataLine.close();
        Log.println(true, "CaptureThread.run() exit.");
    }

    void interpretStream(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            if (this.transitionValue >= 0 && byArray[i] >= this.transitionValue) {
                this.transitionValue = -this.transitionHysteresis;
                bl = true;
            } else if (this.transitionValue < 0 && byArray[i] <= this.transitionValue) {
                this.transitionValue = this.transitionHysteresis;
                bl = true;
            } else {
                bl = false;
            }
            ++this.transitionPeriod;
            if (!bl) continue;
            switch (this.transitionPeriod) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (this.transitionState == 1 && this.lastBit == 0) {
                        if (this.isTraining) {
                            this.isTraining = false;
                            break;
                        }
                        this.pushBit(0);
                        this.transitionState = 0;
                    } else {
                        this.transitionState = 1;
                    }
                    this.lastBit = 0;
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    if (this.isTraining) break;
                    if (this.transitionState == 1 && this.lastBit == 1) {
                        this.pushBit(1);
                        this.transitionState = 0;
                    } else {
                        this.transitionState = 1;
                    }
                    this.lastBit = 1;
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    this.isTraining = true;
                    this.transitionState = 0;
                    this.byteRegisterBits = 0;
                    break;
                }
            }
            this.transitionPeriod = 0;
        }
    }

    public int receiveBufferSize() {
        int n = 0;
        if (this.outputStream != null) {
            n = this.outputStream.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveReceiveBuffer() {
        byte[] byArray = null;
        if (this.outputStream != null && this.outputStream.size() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = this.outputStream;
            synchronized (byteArrayOutputStream) {
                byArray = this.outputStream.toByteArray();
                String string = "";
                for (int i = 0; i < byArray.length; ++i) {
                    if ((byArray[i] & 0xFF) < 16) {
                        string = string + "0";
                    }
                    string = string + Integer.toHexString(byArray[i] & 0xFF);
                }
                this.outputStream.reset();
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void pushBit(int n) {
        this.byteRegisterData = (this.byteRegisterData << 1 | n) & 0xFF;
        ++this.byteRegisterBits;
        if (this.byteRegisterBits == 8) {
            this.outputStream.write(this.byteRegisterData);
            this.byteRegisterBits = 0;
            String string = "";
            if (this.byteRegisterData < 16) {
                string = string + "0";
            }
            string = Integer.toHexString(this.byteRegisterData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushReceiveBuffer() {
        if (this.receiveBufferSize() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = this.outputStream;
            synchronized (byteArrayOutputStream) {
                this.outputStream.reset();
            }
        }
    }

    public void requestStop() {
        this.stopCapture = true;
    }

    public static AudioFormat getAudioFormat() {
        float f = 44100.0f;
        int n = 8;
        int n2 = 1;
        boolean bl = true;
        boolean bl2 = false;
        return new AudioFormat(f, n, n2, bl, bl2);
    }
}

