/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import org.adtpro.resources.Messages;
import org.adtpro.transport.ATransport;
import org.adtpro.transport.TransportTimeoutException;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.UnsignedByte;

public class UDPTransport
extends ATransport {
    protected boolean _connected;
    String _serverIP;
    int _port;
    int _inPacketPtr = 0;
    int _inPacketLen = 0;
    int _outPacketPtr = 0;
    DatagramSocket _socket;
    DatagramPacket _packet;
    byte[] _receiveBuffer = null;
    byte[] _sendBuffer = null;
    static byte _packetNum = 1;

    public UDPTransport(String string) throws Exception {
        try {
            this._port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._port = 6502;
        }
        this._connected = false;
        this._packet = new DatagramPacket(new byte[1500], 1500);
        this._sendBuffer = new byte[1500];
    }

    @Override
    public int transportType() {
        return 2;
    }

    @Override
    public byte readByte(int n) throws TransportTimeoutException {
        if (this._receiveBuffer == null) {
            Log.println(false, "UDPTransport.readByte() needs to pull a buffer; buffer is null.");
            try {
                this.pullBuffer(n);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new TransportTimeoutException();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._inPacketPtr + 1 > this._inPacketLen) {
            try {
                this.pullBuffer(n);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new TransportTimeoutException();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._receiveBuffer[this._inPacketPtr++];
    }

    @Override
    public synchronized void close() throws Exception {
        Log.println(false, "UDPTransport.close() entry.");
        if (this._connected) {
            this._connected = false;
            this._socket.close();
            Log.println(true, "UDPTransport closed UDP port " + this._port + ".");
        }
        Log.println(false, "UDPTransport.close() exit.");
    }

    @Override
    public void open() throws Exception {
        if (this._connected) {
            return;
        }
        this._socket = new DatagramSocket(this._port);
        this._connected = true;
        Log.println(true, "UDPTransport opened UDP port " + this._port + " at address " + InetAddress.getLocalHost().getHostAddress());
    }

    @Override
    public void writeBytes(byte[] byArray) {
        if (1500 - this._outPacketPtr >= byArray.length) {
            if (this._outPacketPtr == 0) {
                _packetNum = (byte)(_packetNum + 1);
                this._sendBuffer[this._outPacketPtr++] = _packetNum;
            }
            for (int i = 0; i < byArray.length; ++i) {
                this._sendBuffer[this._outPacketPtr++] = byArray[i];
            }
        } else {
            Log.println(false, "UDPTransport.writeBytes() didn't have room!");
        }
    }

    @Override
    public void writeBytes(char[] cArray) {
        if (1499 - this._outPacketPtr >= cArray.length) {
            if (this._outPacketPtr == 0) {
                _packetNum = (byte)(_packetNum + 1);
                this._sendBuffer[this._outPacketPtr++] = _packetNum;
            }
            for (int i = 0; i < cArray.length; ++i) {
                this._sendBuffer[this._outPacketPtr++] = (byte)cArray[i];
            }
        }
    }

    @Override
    public void writeBytes(String string) {
        this.writeBytes(string.getBytes());
    }

    @Override
    public void writeByte(char c) {
        byte[] byArray = new byte[]{(byte)c};
        this.writeBytes(byArray);
    }

    @Override
    public void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    @Override
    public void writeByte(byte by) {
        byte[] byArray = new byte[]{by};
        this.writeBytes(byArray);
    }

    @Override
    public void pushBuffer() {
        Log.println(false, "UDPTransport.pushBuffer() entry.");
        Log.println(false, "UDPTransport.pushBuffer() pushing " + this._outPacketPtr + " bytes of data:");
        for (int i = 0; i < this._outPacketPtr; ++i) {
            if (i % 32 == 0 && i != 0) {
                Log.println(false, "");
            }
            Log.print(false, UnsignedByte.toString(this._sendBuffer[i]) + " ");
        }
        Log.println(false, "");
        this._packet.setData(this._sendBuffer, 0, this._outPacketPtr);
        try {
            this._socket.send(this._packet);
        }
        catch (Exception exception) {
            Log.printStackTrace(exception);
        }
        this._outPacketPtr = 0;
        Log.println(false, "UDPTransport.pushBuffer() exit.");
    }

    public void pullBuffer(int n) throws Exception {
        this._receiveBuffer = new byte[1500];
        this._packet.setData(this._receiveBuffer);
        this._socket.setSoTimeout(n * 1000);
        this._socket.receive(this._packet);
        Log.println(false, "UDPTransport.pullBuffer() received a packet.");
        this._receiveBuffer = this._packet.getData();
        this._inPacketLen = this._packet.getLength();
        this._inPacketPtr = 0;
        Log.println(false, "UDPTransport.pullBuffer() pulled data:");
        for (int i = 0; i < this._inPacketLen; ++i) {
            if (i % 32 == 0 && i != 0) {
                Log.println(false, "");
            }
            Log.print(false, UnsignedByte.toString(this._receiveBuffer[i]) + " ");
        }
        Log.println(false, "");
    }

    @Override
    public void flushReceiveBuffer() {
        this._receiveBuffer = null;
    }

    @Override
    public void flushSendBuffer() {
        this._outPacketPtr = 0;
    }

    @Override
    public void setSpeed(int n) {
    }

    @Override
    public void setFullSpeed() {
    }

    @Override
    public void setFullSpeed(int n) {
    }

    @Override
    public void setSlowSpeed(int n) {
    }

    @Override
    public boolean supportsBootstrap() {
        return false;
    }

    @Override
    public void pauseIncorrectCRC() {
    }

    @Override
    public String getInstructions(String string, int n, int n2) {
        String string2 = "UDPTransport.getInstructions() - returned null!";
        if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            Messages.getString("Gui.BS.DumpDOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADT"))) {
            Messages.getString("Gui.BS.DumpADTInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTPro"))) {
            Messages.getString("Gui.BS.DumpProInstructions");
        }
        return string2;
    }

    @Override
    public String getInstructionsDone(String string) {
        return "";
    }
}

