!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_cppopts_dumper
!! NAME
!!  m_cppopts_dumper
!!
!! FUNCTION
!!  Displays preprocessing options activated at compile-time.
!!
!! COPYRIGHT
!!  Copyright (C) 2010-2020 ABINIT group (Yann Pouillon)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt.
!!
!! NOTES
!!  This file was generated by make-cppopts-dumper,
!!  on 2020/11/10 13:05:06 +0000.
!!  Any modification will be lost.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module m_cppopts_dumper

  implicit none

  public :: dump_cpp_options

contains
!!***

!!****f* ABINIT/m_cppopts_dumper/dump_cpp_options
!! NAME
!!  dump_cpp_options
!!
!! FUNCTION
!!  Reports a printout of the CPP options used at compile-time,
!!  useful for error messages and debugging.
!!
!! INPUTS
!!  my_unit= Fortran unit number (optional, default is std_out)
!!
!! OUTPUT
!!  Only printing.
!!
!! PARENTS
!!      abinit,m_argparse
!!
!! CHILDREN
!!
!! SOURCE

subroutine dump_cpp_options(my_unit)

  use defs_basis

  implicit none

!Arguments -------------------------------------
  integer,intent(in) :: my_unit

!Local variables -------------------------------
  character(len=26) :: tmp
  character(len=80) :: msg
  integer :: msg_index

! **********************************************************************

  write(my_unit,"(a,1x,a)") ch10,repeat("+",78)
  write(my_unit,"(1x,a,a)") "CPP options activated during the build:",ch10

  msg_index = 0
  msg = ""

#if defined CC_ARM
  write(tmp,"(1x,a25)") "CC_ARM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CC_GNU
  write(tmp,"(1x,a25)") "CC_GNU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CC_IBM
  write(tmp,"(1x,a25)") "CC_IBM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CC_INTEL
  write(tmp,"(1x,a25)") "CC_INTEL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CC_LLVM
  write(tmp,"(1x,a25)") "CC_LLVM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CC_PGI
  write(tmp,"(1x,a25)") "CC_PGI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CXX_ARM
  write(tmp,"(1x,a25)") "CXX_ARM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CXX_GNU
  write(tmp,"(1x,a25)") "CXX_GNU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CXX_IBM
  write(tmp,"(1x,a25)") "CXX_IBM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CXX_INTEL
  write(tmp,"(1x,a25)") "CXX_INTEL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CXX_LLVM
  write(tmp,"(1x,a25)") "CXX_LLVM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined CXX_PGI
  write(tmp,"(1x,a25)") "CXX_PGI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined DEBUG_CONTRACT
  write(tmp,"(1x,a25)") "DEB*G_CONTRACT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined DEBUG_MODE
  write(tmp,"(1x,a25)") "DEB*G_MODE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined DEBUG_VERBOSE
  write(tmp,"(1x,a25)") "DEB*G_VERBOSE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_ABSOFT
  write(tmp,"(1x,a25)") "FC_ABSOFT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_ARM
  write(tmp,"(1x,a25)") "FC_ARM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_GNU
  write(tmp,"(1x,a25)") "FC_GNU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_IBM
  write(tmp,"(1x,a25)") "FC_IBM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_INTEL
  write(tmp,"(1x,a25)") "FC_INTEL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_LLVM
  write(tmp,"(1x,a25)") "FC_LLVM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_NAG
  write(tmp,"(1x,a25)") "FC_NAG"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined FC_PGI
  write(tmp,"(1x,a25)") "FC_PGI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_ABINIT_COMMON
  write(tmp,"(1x,a25)") "HAVE_ABINIT_COMMON"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_ATOMPAW
  write(tmp,"(1x,a25)") "HAVE_ATOMPAW"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_AVX_SAFE_MODE
  write(tmp,"(1x,a25)") "HAVE_AVX_SAFE_MODE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_BIGDFT
  write(tmp,"(1x,a25)") "HAVE_BIGDFT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_BSE_UNPACKED
  write(tmp,"(1x,a25)") "HAVE_BSE_UNPACKED"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_CCLOCK
  write(tmp,"(1x,a25)") "HAVE_CCLOCK"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_CRPA_OPTIM
  write(tmp,"(1x,a25)") "HAVE_CRPA_OPTIM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_DFTI
  write(tmp,"(1x,a25)") "HAVE_DFTI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_ETSF_IO
  write(tmp,"(1x,a25)") "HAVE_ETSF_IO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_ALLOCATABLE_DTARRAYS
  write(tmp,"(1x,a25)") "HAVE_FC_ALLOCATABLE_DT..."
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_ASYNC
  write(tmp,"(1x,a25)") "HAVE_FC_ASYNC"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_BACKTRACE
  write(tmp,"(1x,a25)") "HAVE_FC_BACKTRACE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_COMMAND_ARGUMENT
  write(tmp,"(1x,a25)") "HAVE_FC_COMMAND_ARGUMENT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_COMMAND_LINE
  write(tmp,"(1x,a25)") "HAVE_FC_COMMAND_LINE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_CONTIGUOUS
  write(tmp,"(1x,a25)") "HAVE_FC_CONTIGUOUS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_CPUTIME
  write(tmp,"(1x,a25)") "HAVE_FC_CPUTIME"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_ETIME
  write(tmp,"(1x,a25)") "HAVE_FC_ETIME"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_EXIT
  write(tmp,"(1x,a25)") "HAVE_FC_EXIT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_FLUSH
  write(tmp,"(1x,a25)") "HAVE_FC_FLUSH"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_FLUSH_
  write(tmp,"(1x,a25)") "HAVE_FC_FLUSH_"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_GAMMA
  write(tmp,"(1x,a25)") "HAVE_FC_GAMMA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_GETENV
  write(tmp,"(1x,a25)") "HAVE_FC_GETENV"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_GETPID
  write(tmp,"(1x,a25)") "HAVE_FC_GETPID"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_IEEE_ARITHMETIC
  write(tmp,"(1x,a25)") "HAVE_FC_IEEE_ARITHMETIC"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_IEEE_EXCEPTIONS
  write(tmp,"(1x,a25)") "HAVE_FC_IEEE_EXCEPTIONS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_INT_QUAD
  write(tmp,"(1x,a25)") "HAVE_FC_INT_QUAD"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_IOMSG
  write(tmp,"(1x,a25)") "HAVE_FC_IOMSG"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_ISO_C_BINDING
  write(tmp,"(1x,a25)") "HAVE_FC_ISO_C_BINDING"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_ISO_FORTRAN_2008
  write(tmp,"(1x,a25)") "HAVE_FC_ISO_FORTRAN_2008"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_LONG_LINES
  write(tmp,"(1x,a25)") "HAVE_FC_LONG_LINES"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_MACRO_NEWLINE
  write(tmp,"(1x,a25)") "HAVE_FC_MACRO_NEWLINE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_MOVE_ALLOC
  write(tmp,"(1x,a25)") "HAVE_FC_MOVE_ALLOC"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_ON_THE_FLY_SHAPE
  write(tmp,"(1x,a25)") "HAVE_FC_ON_THE_FLY_SHAPE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_PRIVATE
  write(tmp,"(1x,a25)") "HAVE_FC_PRIVATE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_PROTECTED
  write(tmp,"(1x,a25)") "HAVE_FC_PROTECTED"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_SHIFTLR
  write(tmp,"(1x,a25)") "HAVE_FC_SHIFTLR"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_STREAM_IO
  write(tmp,"(1x,a25)") "HAVE_FC_STREAM_IO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FC_SYSTEM
  write(tmp,"(1x,a25)") "HAVE_FC_SYSTEM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FFTW3
  write(tmp,"(1x,a25)") "HAVE_FFTW3"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FFTW3_MPI
  write(tmp,"(1x,a25)") "HAVE_FFTW3_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FFTW3_THREADS
  write(tmp,"(1x,a25)") "HAVE_FFTW3_THREADS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_FORTRAN2003
  write(tmp,"(1x,a25)") "HAVE_FORTRAN2003"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU
  write(tmp,"(1x,a25)") "HAVE_GPU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA3
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA3"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA_DP
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA_DP"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA_SP
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA_SP"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU_MPI
  write(tmp,"(1x,a25)") "HAVE_GPU_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GPU_SERIAL
  write(tmp,"(1x,a25)") "HAVE_GPU_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_GW_DPC
  write(tmp,"(1x,a25)") "HAVE_GW_DPC"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_HDF5
  write(tmp,"(1x,a25)") "HAVE_HDF5"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_HDF5_MPI
  write(tmp,"(1x,a25)") "HAVE_HDF5_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LEVMAR
  write(tmp,"(1x,a25)") "HAVE_LEVMAR"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LIBPAW
  write(tmp,"(1x,a25)") "HAVE_LIBPAW"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LIBPAW_ABINIT
  write(tmp,"(1x,a25)") "HAVE_LIBPAW_ABINIT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LIBPSML
  write(tmp,"(1x,a25)") "HAVE_LIBPSML"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LIBTETRA_ABINIT
  write(tmp,"(1x,a25)") "HAVE_LIBTETRA_ABINIT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LIBXC
  write(tmp,"(1x,a25)") "HAVE_LIBXC"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ASL
  write(tmp,"(1x,a25)") "HAVE_LINALG_ASL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_AXPBY
  write(tmp,"(1x,a25)") "HAVE_LINALG_AXPBY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_2013
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_2013"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_2014
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_2014"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_2015_02
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_2015_02"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_2015_11
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_2015_11"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_2016
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_2016"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_2017
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_2017"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ELPA_FORTRAN2008
  write(tmp,"(1x,a25)") "HAVE_LINALG_ELPA_FORTR..."
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ESSL
  write(tmp,"(1x,a25)") "HAVE_LINALG_ESSL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_GEMM3M
  write(tmp,"(1x,a25)") "HAVE_LINALG_GEMM3M"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MAGMA
  write(tmp,"(1x,a25)") "HAVE_LINALG_MAGMA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MAGMA_15
  write(tmp,"(1x,a25)") "HAVE_LINALG_MAGMA_15"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_IMATCOPY
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_IMATCOPY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_OMATADD
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_OMATADD"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_OMATCOPY
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_OMATCOPY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_THREADS
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_THREADS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_PLASMA
  write(tmp,"(1x,a25)") "HAVE_LINALG_PLASMA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_SCALAPACK
  write(tmp,"(1x,a25)") "HAVE_LINALG_SCALAPACK"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ZDOTC_BUG
  write(tmp,"(1x,a25)") "HAVE_LINALG_ZDOTC_B*G"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ZDOTU_BUG
  write(tmp,"(1x,a25)") "HAVE_LINALG_ZDOTU_B*G"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_LOTF
  write(tmp,"(1x,a25)") "HAVE_LOTF"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MEM_PROFILING
  write(tmp,"(1x,a25)") "HAVE_MEM_PROFILING"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI
  write(tmp,"(1x,a25)") "HAVE_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI1
  write(tmp,"(1x,a25)") "HAVE_MPI1"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI2
  write(tmp,"(1x,a25)") "HAVE_MPI2"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI2_INPLACE
  write(tmp,"(1x,a25)") "HAVE_MPI2_INPLACE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI3
  write(tmp,"(1x,a25)") "HAVE_MPI3"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_GET_LIBRARY_VERSION
  write(tmp,"(1x,a25)") "HAVE_MPI_GET_LIBRARY_V..."
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IALLGATHER
  write(tmp,"(1x,a25)") "HAVE_MPI_IALLGATHER"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IALLREDUCE
  write(tmp,"(1x,a25)") "HAVE_MPI_IALLREDUCE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IALLTOALL
  write(tmp,"(1x,a25)") "HAVE_MPI_IALLTOALL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IALLTOALLV
  write(tmp,"(1x,a25)") "HAVE_MPI_IALLTOALLV"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IBCAST
  write(tmp,"(1x,a25)") "HAVE_MPI_IBCAST"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IGATHERV
  write(tmp,"(1x,a25)") "HAVE_MPI_IGATHERV"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_INCLUDED_ONCE
  write(tmp,"(1x,a25)") "HAVE_MPI_INCLUDED_ONCE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_INTEGER16
  write(tmp,"(1x,a25)") "HAVE_MPI_INTEGER16"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IO
  write(tmp,"(1x,a25)") "HAVE_MPI_IO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IO_DEFAULT
  write(tmp,"(1x,a25)") "HAVE_MPI_IO_DEFAULT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_MPI_TYPE_CREATE_STRUCT
  write(tmp,"(1x,a25)") "HAVE_MPI_TYPE_CREATE_S..."
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF
  write(tmp,"(1x,a25)") "HAVE_NETCDF"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF_CXX
  write(tmp,"(1x,a25)") "HAVE_NETCDF_CXX"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF_CXX_MPI
  write(tmp,"(1x,a25)") "HAVE_NETCDF_CXX_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF_DEFAULT
  write(tmp,"(1x,a25)") "HAVE_NETCDF_DEFAULT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF_FORTRAN
  write(tmp,"(1x,a25)") "HAVE_NETCDF_FORTRAN"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF_FORTRAN_MPI
  write(tmp,"(1x,a25)") "HAVE_NETCDF_FORTRAN_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NETCDF_MPI
  write(tmp,"(1x,a25)") "HAVE_NETCDF_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_NUMPY
  write(tmp,"(1x,a25)") "HAVE_NUMPY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_OMP_COLLAPSE
  write(tmp,"(1x,a25)") "HAVE_OMP_COLLAPSE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_OPENMP
  write(tmp,"(1x,a25)") "HAVE_OPENMP"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_OS_LINUX
  write(tmp,"(1x,a25)") "HAVE_OS_LINUX"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_OS_MACOSX
  write(tmp,"(1x,a25)") "HAVE_OS_MACOSX"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_OS_WINDOWS
  write(tmp,"(1x,a25)") "HAVE_OS_WINDOWS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_PAPI
  write(tmp,"(1x,a25)") "HAVE_PAPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_PFFT
  write(tmp,"(1x,a25)") "HAVE_PFFT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_PYTHON_INVOCATION
  write(tmp,"(1x,a25)") "HAVE_PYTHON_INVOCATION"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_TIMER_ABINIT
  write(tmp,"(1x,a25)") "HAVE_TIMER_ABINIT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_TRIQS
  write(tmp,"(1x,a25)") "HAVE_TRIQS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_TRIQS_v1_4
  write(tmp,"(1x,a25)") "HAVE_TRIQS_v1_4"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_TRIQS_v2_0
  write(tmp,"(1x,a25)") "HAVE_TRIQS_v2_0"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_WANNIER90
  write(tmp,"(1x,a25)") "HAVE_WANNIER90"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_WANNIER90_V1
  write(tmp,"(1x,a25)") "HAVE_WANNIER90_V1"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_XML
  write(tmp,"(1x,a25)") "HAVE_XML"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined HAVE_XMLF90
  write(tmp,"(1x,a25)") "HAVE_XMLF90"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif
#if defined READ_FROM_FILE
  write(tmp,"(1x,a25)") "READ_FROM_FILE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    write(my_unit,'(a)') msg
    msg = ""
  end if
#endif

  if ( mod(msg_index,3) /= 0 ) write(my_unit,'(a)') msg

  write(my_unit,"(1x,a,a)") repeat("+",78),ch10

end subroutine dump_cpp_options

end module m_cppopts_dumper
!!***
