# -*- Autoconf -*-
#
# Copyright (C) 2005-2020 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-dirflags on 2020/05/17 03:54:46 +0000

#
# Per-directory optimization support
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-dirflags
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTFLAGS_DIRS(FCFLAGS_OPTIM)
# --------------------------------
#
# Initializes optimization flags on a per-directory basis. Currently
# limited to Fortran.
#
AC_DEFUN([ABI_OPTFLAGS_DIRS],[
  dnl Check arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

  AC_MSG_CHECKING([whether to apply per-directory optimizations])
  if test "${enable_optim}" = "no" -o "${FCFLAGS}" != ""; then
    AC_MSG_RESULT([no])
  else
    AC_MSG_RESULT([yes])
  fi

  dnl Init config.optim
  echo "optim_dumper_template='${abinit_srcdir}/shared/common/src/14_hidewrite/m_optim_dumper.F90.in'" > config.optim
  echo "optim_dumper_output='${abinit_builddir}/shared/common/src/14_hidewrite/m_optim_dumper.F90'" >> config.optim

  dnl Set default
  fcflags_opt_default="$1"
  echo "fcflags_opt_default='${fcflags_opt_default}'" >>config.optim
  fcflags_opt_dirlist=""
  AC_SUBST(fcflags_opt_default)

  dnl bigdft library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_bigdft}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_bigdft="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for bigdft is ${fcflags_opt_bigdft}])
      echo "fcflags_opt_bigdft='${fcflags_opt_bigdft}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} bigdft"
    fi
  else
    if test "${fcflags_opt_bigdft}" != ""; then
      fcflags_opt_bigdft=""
      AC_MSG_NOTICE([fcflags_opt_bigdft overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_bigdft)

  dnl hdf5 library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_hdf5}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_hdf5="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for hdf5 is ${fcflags_opt_hdf5}])
      echo "fcflags_opt_hdf5='${fcflags_opt_hdf5}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} hdf5"
    fi
  else
    if test "${fcflags_opt_hdf5}" != ""; then
      fcflags_opt_hdf5=""
      AC_MSG_NOTICE([fcflags_opt_hdf5 overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_hdf5)

  dnl levmar library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_levmar}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_levmar="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for levmar is ${fcflags_opt_levmar}])
      echo "fcflags_opt_levmar='${fcflags_opt_levmar}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} levmar"
    fi
  else
    if test "${fcflags_opt_levmar}" != ""; then
      fcflags_opt_levmar=""
      AC_MSG_NOTICE([fcflags_opt_levmar overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_levmar)

  dnl libpsml library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_libpsml}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_libpsml="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for libpsml is ${fcflags_opt_libpsml}])
      echo "fcflags_opt_libpsml='${fcflags_opt_libpsml}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} libpsml"
    fi
  else
    if test "${fcflags_opt_libpsml}" != ""; then
      fcflags_opt_libpsml=""
      AC_MSG_NOTICE([fcflags_opt_libpsml overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_libpsml)

  dnl libxc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_libxc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_libxc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for libxc is ${fcflags_opt_libxc}])
      echo "fcflags_opt_libxc='${fcflags_opt_libxc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} libxc"
    fi
  else
    if test "${fcflags_opt_libxc}" != ""; then
      fcflags_opt_libxc=""
      AC_MSG_NOTICE([fcflags_opt_libxc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_libxc)

  dnl libxml2 library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_libxml2}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_libxml2="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for libxml2 is ${fcflags_opt_libxml2}])
      echo "fcflags_opt_libxml2='${fcflags_opt_libxml2}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} libxml2"
    fi
  else
    if test "${fcflags_opt_libxml2}" != ""; then
      fcflags_opt_libxml2=""
      AC_MSG_NOTICE([fcflags_opt_libxml2 overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_libxml2)

  dnl linalg library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_linalg}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_linalg="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for linalg is ${fcflags_opt_linalg}])
      echo "fcflags_opt_linalg='${fcflags_opt_linalg}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} linalg"
    fi
  else
    if test "${fcflags_opt_linalg}" != ""; then
      fcflags_opt_linalg=""
      AC_MSG_NOTICE([fcflags_opt_linalg overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_linalg)

  dnl netcdf library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_netcdf}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_netcdf="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for netcdf is ${fcflags_opt_netcdf}])
      echo "fcflags_opt_netcdf='${fcflags_opt_netcdf}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} netcdf"
    fi
  else
    if test "${fcflags_opt_netcdf}" != ""; then
      fcflags_opt_netcdf=""
      AC_MSG_NOTICE([fcflags_opt_netcdf overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_netcdf)

  dnl netcdf_fortran library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_netcdf_fortran}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_netcdf_fortran="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for netcdf_fortran is ${fcflags_opt_netcdf_fortran}])
      echo "fcflags_opt_netcdf_fortran='${fcflags_opt_netcdf_fortran}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} netcdf_fortran"
    fi
  else
    if test "${fcflags_opt_netcdf_fortran}" != ""; then
      fcflags_opt_netcdf_fortran=""
      AC_MSG_NOTICE([fcflags_opt_netcdf_fortran overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_netcdf_fortran)

  dnl papi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_papi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_papi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for papi is ${fcflags_opt_papi}])
      echo "fcflags_opt_papi='${fcflags_opt_papi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} papi"
    fi
  else
    if test "${fcflags_opt_papi}" != ""; then
      fcflags_opt_papi=""
      AC_MSG_NOTICE([fcflags_opt_papi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_papi)

  dnl triqs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_triqs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_triqs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for triqs is ${fcflags_opt_triqs}])
      echo "fcflags_opt_triqs='${fcflags_opt_triqs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} triqs"
    fi
  else
    if test "${fcflags_opt_triqs}" != ""; then
      fcflags_opt_triqs=""
      AC_MSG_NOTICE([fcflags_opt_triqs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_triqs)

  dnl wannier90 library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_wannier90}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_wannier90="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for wannier90 is ${fcflags_opt_wannier90}])
      echo "fcflags_opt_wannier90='${fcflags_opt_wannier90}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} wannier90"
    fi
  else
    if test "${fcflags_opt_wannier90}" != ""; then
      fcflags_opt_wannier90=""
      AC_MSG_NOTICE([fcflags_opt_wannier90 overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_wannier90)

  dnl xmlf90 library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_xmlf90}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_xmlf90="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for xmlf90 is ${fcflags_opt_xmlf90}])
      echo "fcflags_opt_xmlf90='${fcflags_opt_xmlf90}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} xmlf90"
    fi
  else
    if test "${fcflags_opt_xmlf90}" != ""; then
      fcflags_opt_xmlf90=""
      AC_MSG_NOTICE([fcflags_opt_xmlf90 overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_xmlf90)

  dnl 02_clib library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_02_clib}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_02_clib="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 02_clib is ${fcflags_opt_02_clib}])
      echo "fcflags_opt_02_clib='${fcflags_opt_02_clib}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 02_clib"
    fi
  else
    if test "${fcflags_opt_02_clib}" != ""; then
      fcflags_opt_02_clib=""
      AC_MSG_NOTICE([fcflags_opt_02_clib overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_02_clib)

  dnl 10_defs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_10_defs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_10_defs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 10_defs is ${fcflags_opt_10_defs}])
      echo "fcflags_opt_10_defs='${fcflags_opt_10_defs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 10_defs"
    fi
  else
    if test "${fcflags_opt_10_defs}" != ""; then
      fcflags_opt_10_defs=""
      AC_MSG_NOTICE([fcflags_opt_10_defs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_10_defs)

  dnl 11_memory_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_11_memory_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_11_memory_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 11_memory_mpi is ${fcflags_opt_11_memory_mpi}])
      echo "fcflags_opt_11_memory_mpi='${fcflags_opt_11_memory_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 11_memory_mpi"
    fi
  else
    if test "${fcflags_opt_11_memory_mpi}" != ""; then
      fcflags_opt_11_memory_mpi=""
      AC_MSG_NOTICE([fcflags_opt_11_memory_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_11_memory_mpi)

  dnl 12_hide_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_12_hide_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_12_hide_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 12_hide_mpi is ${fcflags_opt_12_hide_mpi}])
      echo "fcflags_opt_12_hide_mpi='${fcflags_opt_12_hide_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 12_hide_mpi"
    fi
  else
    if test "${fcflags_opt_12_hide_mpi}" != ""; then
      fcflags_opt_12_hide_mpi=""
      AC_MSG_NOTICE([fcflags_opt_12_hide_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_12_hide_mpi)

  dnl 14_hidewrite library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_14_hidewrite}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_14_hidewrite="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 14_hidewrite is ${fcflags_opt_14_hidewrite}])
      echo "fcflags_opt_14_hidewrite='${fcflags_opt_14_hidewrite}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 14_hidewrite"
    fi
  else
    if test "${fcflags_opt_14_hidewrite}" != ""; then
      fcflags_opt_14_hidewrite=""
      AC_MSG_NOTICE([fcflags_opt_14_hidewrite overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_14_hidewrite)

  dnl 16_hideleave library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_16_hideleave}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_16_hideleave="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 16_hideleave is ${fcflags_opt_16_hideleave}])
      echo "fcflags_opt_16_hideleave='${fcflags_opt_16_hideleave}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 16_hideleave"
    fi
  else
    if test "${fcflags_opt_16_hideleave}" != ""; then
      fcflags_opt_16_hideleave=""
      AC_MSG_NOTICE([fcflags_opt_16_hideleave overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_16_hideleave)

  dnl 17_gpu_toolbox library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_17_gpu_toolbox}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_17_gpu_toolbox="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 17_gpu_toolbox is ${fcflags_opt_17_gpu_toolbox}])
      echo "fcflags_opt_17_gpu_toolbox='${fcflags_opt_17_gpu_toolbox}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 17_gpu_toolbox"
    fi
  else
    if test "${fcflags_opt_17_gpu_toolbox}" != ""; then
      fcflags_opt_17_gpu_toolbox=""
      AC_MSG_NOTICE([fcflags_opt_17_gpu_toolbox overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_17_gpu_toolbox)

  dnl 17_libtetra_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_17_libtetra_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_17_libtetra_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 17_libtetra_ext is ${fcflags_opt_17_libtetra_ext}])
      echo "fcflags_opt_17_libtetra_ext='${fcflags_opt_17_libtetra_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 17_libtetra_ext"
    fi
  else
    if test "${fcflags_opt_17_libtetra_ext}" != ""; then
      fcflags_opt_17_libtetra_ext=""
      AC_MSG_NOTICE([fcflags_opt_17_libtetra_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_17_libtetra_ext)

  dnl 17_yaml_out library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_17_yaml_out}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_17_yaml_out="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 17_yaml_out is ${fcflags_opt_17_yaml_out}])
      echo "fcflags_opt_17_yaml_out='${fcflags_opt_17_yaml_out}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 17_yaml_out"
    fi
  else
    if test "${fcflags_opt_17_yaml_out}" != ""; then
      fcflags_opt_17_yaml_out=""
      AC_MSG_NOTICE([fcflags_opt_17_yaml_out overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_17_yaml_out)

  dnl 18_timing library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_18_timing}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_18_timing="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 18_timing is ${fcflags_opt_18_timing}])
      echo "fcflags_opt_18_timing='${fcflags_opt_18_timing}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 18_timing"
    fi
  else
    if test "${fcflags_opt_18_timing}" != ""; then
      fcflags_opt_18_timing=""
      AC_MSG_NOTICE([fcflags_opt_18_timing overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_18_timing)

  dnl 21_hashfuncs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_21_hashfuncs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_21_hashfuncs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 21_hashfuncs is ${fcflags_opt_21_hashfuncs}])
      echo "fcflags_opt_21_hashfuncs='${fcflags_opt_21_hashfuncs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 21_hashfuncs"
    fi
  else
    if test "${fcflags_opt_21_hashfuncs}" != ""; then
      fcflags_opt_21_hashfuncs=""
      AC_MSG_NOTICE([fcflags_opt_21_hashfuncs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_21_hashfuncs)

  dnl 27_toolbox_oop library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_27_toolbox_oop}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_27_toolbox_oop="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 27_toolbox_oop is ${fcflags_opt_27_toolbox_oop}])
      echo "fcflags_opt_27_toolbox_oop='${fcflags_opt_27_toolbox_oop}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 27_toolbox_oop"
    fi
  else
    if test "${fcflags_opt_27_toolbox_oop}" != ""; then
      fcflags_opt_27_toolbox_oop=""
      AC_MSG_NOTICE([fcflags_opt_27_toolbox_oop overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_27_toolbox_oop)

  dnl 28_numeric_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_28_numeric_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_28_numeric_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 28_numeric_noabirule is ${fcflags_opt_28_numeric_noabirule}])
      echo "fcflags_opt_28_numeric_noabirule='${fcflags_opt_28_numeric_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 28_numeric_noabirule"
    fi
  else
    if test "${fcflags_opt_28_numeric_noabirule}" != ""; then
      fcflags_opt_28_numeric_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_28_numeric_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_28_numeric_noabirule)

  dnl 29_kpoints library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_29_kpoints}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_29_kpoints="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 29_kpoints is ${fcflags_opt_29_kpoints}])
      echo "fcflags_opt_29_kpoints='${fcflags_opt_29_kpoints}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 29_kpoints"
    fi
  else
    if test "${fcflags_opt_29_kpoints}" != ""; then
      fcflags_opt_29_kpoints=""
      AC_MSG_NOTICE([fcflags_opt_29_kpoints overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_29_kpoints)

  dnl 32_util library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_32_util}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_32_util="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 32_util is ${fcflags_opt_32_util}])
      echo "fcflags_opt_32_util='${fcflags_opt_32_util}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 32_util"
    fi
  else
    if test "${fcflags_opt_32_util}" != ""; then
      fcflags_opt_32_util=""
      AC_MSG_NOTICE([fcflags_opt_32_util overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_32_util)

  dnl 33_xc_lowlevel library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_33_xc_lowlevel}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_33_xc_lowlevel="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 33_xc_lowlevel is ${fcflags_opt_33_xc_lowlevel}])
      echo "fcflags_opt_33_xc_lowlevel='${fcflags_opt_33_xc_lowlevel}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 33_xc_lowlevel"
    fi
  else
    if test "${fcflags_opt_33_xc_lowlevel}" != ""; then
      fcflags_opt_33_xc_lowlevel=""
      AC_MSG_NOTICE([fcflags_opt_33_xc_lowlevel overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_33_xc_lowlevel)

  dnl 39_libpaw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_39_libpaw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_39_libpaw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 39_libpaw is ${fcflags_opt_39_libpaw}])
      echo "fcflags_opt_39_libpaw='${fcflags_opt_39_libpaw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 39_libpaw"
    fi
  else
    if test "${fcflags_opt_39_libpaw}" != ""; then
      fcflags_opt_39_libpaw=""
      AC_MSG_NOTICE([fcflags_opt_39_libpaw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_39_libpaw)

  dnl 41_geometry library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_41_geometry}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_41_geometry="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 41_geometry is ${fcflags_opt_41_geometry}])
      echo "fcflags_opt_41_geometry='${fcflags_opt_41_geometry}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 41_geometry"
    fi
  else
    if test "${fcflags_opt_41_geometry}" != ""; then
      fcflags_opt_41_geometry=""
      AC_MSG_NOTICE([fcflags_opt_41_geometry overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_41_geometry)

  dnl 42_nlstrain library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_42_nlstrain}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_42_nlstrain="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 42_nlstrain is ${fcflags_opt_42_nlstrain}])
      echo "fcflags_opt_42_nlstrain='${fcflags_opt_42_nlstrain}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 42_nlstrain"
    fi
  else
    if test "${fcflags_opt_42_nlstrain}" != ""; then
      fcflags_opt_42_nlstrain=""
      AC_MSG_NOTICE([fcflags_opt_42_nlstrain overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_42_nlstrain)

  dnl 42_parser library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_42_parser}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_42_parser="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 42_parser is ${fcflags_opt_42_parser}])
      echo "fcflags_opt_42_parser='${fcflags_opt_42_parser}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 42_parser"
    fi
  else
    if test "${fcflags_opt_42_parser}" != ""; then
      fcflags_opt_42_parser=""
      AC_MSG_NOTICE([fcflags_opt_42_parser overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_42_parser)

  dnl 43_ptgroups library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_43_ptgroups}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_43_ptgroups="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 43_ptgroups is ${fcflags_opt_43_ptgroups}])
      echo "fcflags_opt_43_ptgroups='${fcflags_opt_43_ptgroups}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 43_ptgroups"
    fi
  else
    if test "${fcflags_opt_43_ptgroups}" != ""; then
      fcflags_opt_43_ptgroups=""
      AC_MSG_NOTICE([fcflags_opt_43_ptgroups overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_43_ptgroups)

  dnl 43_wvl_wrappers library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_43_wvl_wrappers}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_43_wvl_wrappers="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 43_wvl_wrappers is ${fcflags_opt_43_wvl_wrappers}])
      echo "fcflags_opt_43_wvl_wrappers='${fcflags_opt_43_wvl_wrappers}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 43_wvl_wrappers"
    fi
  else
    if test "${fcflags_opt_43_wvl_wrappers}" != ""; then
      fcflags_opt_43_wvl_wrappers=""
      AC_MSG_NOTICE([fcflags_opt_43_wvl_wrappers overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_43_wvl_wrappers)

  dnl 44_abitools library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_44_abitools}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_44_abitools="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 44_abitools is ${fcflags_opt_44_abitools}])
      echo "fcflags_opt_44_abitools='${fcflags_opt_44_abitools}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 44_abitools"
    fi
  else
    if test "${fcflags_opt_44_abitools}" != ""; then
      fcflags_opt_44_abitools=""
      AC_MSG_NOTICE([fcflags_opt_44_abitools overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_44_abitools)

  dnl 44_abitypes_defs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_44_abitypes_defs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_44_abitypes_defs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 44_abitypes_defs is ${fcflags_opt_44_abitypes_defs}])
      echo "fcflags_opt_44_abitypes_defs='${fcflags_opt_44_abitypes_defs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 44_abitypes_defs"
    fi
  else
    if test "${fcflags_opt_44_abitypes_defs}" != ""; then
      fcflags_opt_44_abitypes_defs=""
      AC_MSG_NOTICE([fcflags_opt_44_abitypes_defs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_44_abitypes_defs)

  dnl 45_geomoptim library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_45_geomoptim}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_45_geomoptim="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 45_geomoptim is ${fcflags_opt_45_geomoptim}])
      echo "fcflags_opt_45_geomoptim='${fcflags_opt_45_geomoptim}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 45_geomoptim"
    fi
  else
    if test "${fcflags_opt_45_geomoptim}" != ""; then
      fcflags_opt_45_geomoptim=""
      AC_MSG_NOTICE([fcflags_opt_45_geomoptim overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_45_geomoptim)

  dnl 45_xgTools library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_45_xgTools}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_45_xgTools="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 45_xgTools is ${fcflags_opt_45_xgTools}])
      echo "fcflags_opt_45_xgTools='${fcflags_opt_45_xgTools}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 45_xgTools"
    fi
  else
    if test "${fcflags_opt_45_xgTools}" != ""; then
      fcflags_opt_45_xgTools=""
      AC_MSG_NOTICE([fcflags_opt_45_xgTools overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_45_xgTools)

  dnl 46_diago library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_46_diago}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_46_diago="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 46_diago is ${fcflags_opt_46_diago}])
      echo "fcflags_opt_46_diago='${fcflags_opt_46_diago}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 46_diago"
    fi
  else
    if test "${fcflags_opt_46_diago}" != ""; then
      fcflags_opt_46_diago=""
      AC_MSG_NOTICE([fcflags_opt_46_diago overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_46_diago)

  dnl 49_gw_toolbox_oop library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_49_gw_toolbox_oop}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_49_gw_toolbox_oop="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 49_gw_toolbox_oop is ${fcflags_opt_49_gw_toolbox_oop}])
      echo "fcflags_opt_49_gw_toolbox_oop='${fcflags_opt_49_gw_toolbox_oop}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 49_gw_toolbox_oop"
    fi
  else
    if test "${fcflags_opt_49_gw_toolbox_oop}" != ""; then
      fcflags_opt_49_gw_toolbox_oop=""
      AC_MSG_NOTICE([fcflags_opt_49_gw_toolbox_oop overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_49_gw_toolbox_oop)

  dnl 51_manage_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_51_manage_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_51_manage_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 51_manage_mpi is ${fcflags_opt_51_manage_mpi}])
      echo "fcflags_opt_51_manage_mpi='${fcflags_opt_51_manage_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 51_manage_mpi"
    fi
  else
    if test "${fcflags_opt_51_manage_mpi}" != ""; then
      fcflags_opt_51_manage_mpi=""
      AC_MSG_NOTICE([fcflags_opt_51_manage_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_51_manage_mpi)

  dnl 52_fft_mpi_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_52_fft_mpi_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_52_fft_mpi_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 52_fft_mpi_noabirule is ${fcflags_opt_52_fft_mpi_noabirule}])
      echo "fcflags_opt_52_fft_mpi_noabirule='${fcflags_opt_52_fft_mpi_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 52_fft_mpi_noabirule"
    fi
  else
    if test "${fcflags_opt_52_fft_mpi_noabirule}" != ""; then
      fcflags_opt_52_fft_mpi_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_52_fft_mpi_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_52_fft_mpi_noabirule)

  dnl 52_manage_cuda library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_52_manage_cuda}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_52_manage_cuda="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 52_manage_cuda is ${fcflags_opt_52_manage_cuda}])
      echo "fcflags_opt_52_manage_cuda='${fcflags_opt_52_manage_cuda}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 52_manage_cuda"
    fi
  else
    if test "${fcflags_opt_52_manage_cuda}" != ""; then
      fcflags_opt_52_manage_cuda=""
      AC_MSG_NOTICE([fcflags_opt_52_manage_cuda overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_52_manage_cuda)

  dnl 53_ffts library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_53_ffts}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_53_ffts="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 53_ffts is ${fcflags_opt_53_ffts}])
      echo "fcflags_opt_53_ffts='${fcflags_opt_53_ffts}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 53_ffts"
    fi
  else
    if test "${fcflags_opt_53_ffts}" != ""; then
      fcflags_opt_53_ffts=""
      AC_MSG_NOTICE([fcflags_opt_53_ffts overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_53_ffts)

  dnl 54_spacepar library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_54_spacepar}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_54_spacepar="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 54_spacepar is ${fcflags_opt_54_spacepar}])
      echo "fcflags_opt_54_spacepar='${fcflags_opt_54_spacepar}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 54_spacepar"
    fi
  else
    if test "${fcflags_opt_54_spacepar}" != ""; then
      fcflags_opt_54_spacepar=""
      AC_MSG_NOTICE([fcflags_opt_54_spacepar overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_54_spacepar)

  dnl 55_abiutil library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_55_abiutil}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_55_abiutil="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 55_abiutil is ${fcflags_opt_55_abiutil}])
      echo "fcflags_opt_55_abiutil='${fcflags_opt_55_abiutil}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 55_abiutil"
    fi
  else
    if test "${fcflags_opt_55_abiutil}" != ""; then
      fcflags_opt_55_abiutil=""
      AC_MSG_NOTICE([fcflags_opt_55_abiutil overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_55_abiutil)

  dnl 56_io_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_io_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_io_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_io_mpi is ${fcflags_opt_56_io_mpi}])
      echo "fcflags_opt_56_io_mpi='${fcflags_opt_56_io_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_io_mpi"
    fi
  else
    if test "${fcflags_opt_56_io_mpi}" != ""; then
      fcflags_opt_56_io_mpi=""
      AC_MSG_NOTICE([fcflags_opt_56_io_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_io_mpi)

  dnl 56_mixing library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_mixing}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_mixing="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_mixing is ${fcflags_opt_56_mixing}])
      echo "fcflags_opt_56_mixing='${fcflags_opt_56_mixing}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_mixing"
    fi
  else
    if test "${fcflags_opt_56_mixing}" != ""; then
      fcflags_opt_56_mixing=""
      AC_MSG_NOTICE([fcflags_opt_56_mixing overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_mixing)

  dnl 56_recipspace library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_recipspace}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_recipspace="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_recipspace is ${fcflags_opt_56_recipspace}])
      echo "fcflags_opt_56_recipspace='${fcflags_opt_56_recipspace}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_recipspace"
    fi
  else
    if test "${fcflags_opt_56_recipspace}" != ""; then
      fcflags_opt_56_recipspace=""
      AC_MSG_NOTICE([fcflags_opt_56_recipspace overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_recipspace)

  dnl 56_xc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_xc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_xc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_xc is ${fcflags_opt_56_xc}])
      echo "fcflags_opt_56_xc='${fcflags_opt_56_xc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_xc"
    fi
  else
    if test "${fcflags_opt_56_xc}" != ""; then
      fcflags_opt_56_xc=""
      AC_MSG_NOTICE([fcflags_opt_56_xc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_xc)

  dnl 57_iopsp_parser library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_57_iopsp_parser}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_57_iopsp_parser="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 57_iopsp_parser is ${fcflags_opt_57_iopsp_parser}])
      echo "fcflags_opt_57_iopsp_parser='${fcflags_opt_57_iopsp_parser}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 57_iopsp_parser"
    fi
  else
    if test "${fcflags_opt_57_iopsp_parser}" != ""; then
      fcflags_opt_57_iopsp_parser=""
      AC_MSG_NOTICE([fcflags_opt_57_iopsp_parser overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_57_iopsp_parser)

  dnl 57_iovars library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_57_iovars}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_57_iovars="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 57_iovars is ${fcflags_opt_57_iovars}])
      echo "fcflags_opt_57_iovars='${fcflags_opt_57_iovars}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 57_iovars"
    fi
  else
    if test "${fcflags_opt_57_iovars}" != ""; then
      fcflags_opt_57_iovars=""
      AC_MSG_NOTICE([fcflags_opt_57_iovars overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_57_iovars)

  dnl 61_occeig library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_61_occeig}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_61_occeig="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 61_occeig is ${fcflags_opt_61_occeig}])
      echo "fcflags_opt_61_occeig='${fcflags_opt_61_occeig}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 61_occeig"
    fi
  else
    if test "${fcflags_opt_61_occeig}" != ""; then
      fcflags_opt_61_occeig=""
      AC_MSG_NOTICE([fcflags_opt_61_occeig overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_61_occeig)

  dnl 62_cg_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_cg_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_cg_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_cg_noabirule is ${fcflags_opt_62_cg_noabirule}])
      echo "fcflags_opt_62_cg_noabirule='${fcflags_opt_62_cg_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_cg_noabirule"
    fi
  else
    if test "${fcflags_opt_62_cg_noabirule}" != ""; then
      fcflags_opt_62_cg_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_62_cg_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_cg_noabirule)

  dnl 62_ctqmc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_ctqmc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_ctqmc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_ctqmc is ${fcflags_opt_62_ctqmc}])
      echo "fcflags_opt_62_ctqmc='${fcflags_opt_62_ctqmc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_ctqmc"
    fi
  else
    if test "${fcflags_opt_62_ctqmc}" != ""; then
      fcflags_opt_62_ctqmc=""
      AC_MSG_NOTICE([fcflags_opt_62_ctqmc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_ctqmc)

  dnl 62_iowfdenpot library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_iowfdenpot}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_iowfdenpot="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_iowfdenpot is ${fcflags_opt_62_iowfdenpot}])
      echo "fcflags_opt_62_iowfdenpot='${fcflags_opt_62_iowfdenpot}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_iowfdenpot"
    fi
  else
    if test "${fcflags_opt_62_iowfdenpot}" != ""; then
      fcflags_opt_62_iowfdenpot=""
      AC_MSG_NOTICE([fcflags_opt_62_iowfdenpot overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_iowfdenpot)

  dnl 62_poisson library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_poisson}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_poisson="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_poisson is ${fcflags_opt_62_poisson}])
      echo "fcflags_opt_62_poisson='${fcflags_opt_62_poisson}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_poisson"
    fi
  else
    if test "${fcflags_opt_62_poisson}" != ""; then
      fcflags_opt_62_poisson=""
      AC_MSG_NOTICE([fcflags_opt_62_poisson overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_poisson)

  dnl 62_wvl_wfs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_wvl_wfs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_wvl_wfs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_wvl_wfs is ${fcflags_opt_62_wvl_wfs}])
      echo "fcflags_opt_62_wvl_wfs='${fcflags_opt_62_wvl_wfs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_wvl_wfs"
    fi
  else
    if test "${fcflags_opt_62_wvl_wfs}" != ""; then
      fcflags_opt_62_wvl_wfs=""
      AC_MSG_NOTICE([fcflags_opt_62_wvl_wfs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_wvl_wfs)

  dnl 64_psp library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_64_psp}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_64_psp="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 64_psp is ${fcflags_opt_64_psp}])
      echo "fcflags_opt_64_psp='${fcflags_opt_64_psp}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 64_psp"
    fi
  else
    if test "${fcflags_opt_64_psp}" != ""; then
      fcflags_opt_64_psp=""
      AC_MSG_NOTICE([fcflags_opt_64_psp overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_64_psp)

  dnl 65_lotf_base library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_65_lotf_base}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_65_lotf_base="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 65_lotf_base is ${fcflags_opt_65_lotf_base}])
      echo "fcflags_opt_65_lotf_base='${fcflags_opt_65_lotf_base}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 65_lotf_base"
    fi
  else
    if test "${fcflags_opt_65_lotf_base}" != ""; then
      fcflags_opt_65_lotf_base=""
      AC_MSG_NOTICE([fcflags_opt_65_lotf_base overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_65_lotf_base)

  dnl 65_paw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_65_paw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_65_paw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 65_paw is ${fcflags_opt_65_paw}])
      echo "fcflags_opt_65_paw='${fcflags_opt_65_paw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 65_paw"
    fi
  else
    if test "${fcflags_opt_65_paw}" != ""; then
      fcflags_opt_65_paw=""
      AC_MSG_NOTICE([fcflags_opt_65_paw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_65_paw)

  dnl 66_nonlocal library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_66_nonlocal}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_66_nonlocal="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 66_nonlocal is ${fcflags_opt_66_nonlocal}])
      echo "fcflags_opt_66_nonlocal='${fcflags_opt_66_nonlocal}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 66_nonlocal"
    fi
  else
    if test "${fcflags_opt_66_nonlocal}" != ""; then
      fcflags_opt_66_nonlocal=""
      AC_MSG_NOTICE([fcflags_opt_66_nonlocal overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_66_nonlocal)

  dnl 66_vdwxc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_66_vdwxc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_66_vdwxc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 66_vdwxc is ${fcflags_opt_66_vdwxc}])
      echo "fcflags_opt_66_vdwxc='${fcflags_opt_66_vdwxc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 66_vdwxc"
    fi
  else
    if test "${fcflags_opt_66_vdwxc}" != ""; then
      fcflags_opt_66_vdwxc=""
      AC_MSG_NOTICE([fcflags_opt_66_vdwxc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_66_vdwxc)

  dnl 66_wfs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_66_wfs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_66_wfs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 66_wfs is ${fcflags_opt_66_wfs}])
      echo "fcflags_opt_66_wfs='${fcflags_opt_66_wfs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 66_wfs"
    fi
  else
    if test "${fcflags_opt_66_wfs}" != ""; then
      fcflags_opt_66_wfs=""
      AC_MSG_NOTICE([fcflags_opt_66_wfs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_66_wfs)

  dnl 67_common library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_67_common}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_67_common="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 67_common is ${fcflags_opt_67_common}])
      echo "fcflags_opt_67_common='${fcflags_opt_67_common}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 67_common"
    fi
  else
    if test "${fcflags_opt_67_common}" != ""; then
      fcflags_opt_67_common=""
      AC_MSG_NOTICE([fcflags_opt_67_common overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_67_common)

  dnl 67_python_invocation_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_67_python_invocation_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_67_python_invocation_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 67_python_invocation_ext is ${fcflags_opt_67_python_invocation_ext}])
      echo "fcflags_opt_67_python_invocation_ext='${fcflags_opt_67_python_invocation_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 67_python_invocation_ext"
    fi
  else
    if test "${fcflags_opt_67_python_invocation_ext}" != ""; then
      fcflags_opt_67_python_invocation_ext=""
      AC_MSG_NOTICE([fcflags_opt_67_python_invocation_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_67_python_invocation_ext)

  dnl 67_triqs_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_67_triqs_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_67_triqs_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 67_triqs_ext is ${fcflags_opt_67_triqs_ext}])
      echo "fcflags_opt_67_triqs_ext='${fcflags_opt_67_triqs_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 67_triqs_ext"
    fi
  else
    if test "${fcflags_opt_67_triqs_ext}" != ""; then
      fcflags_opt_67_triqs_ext=""
      AC_MSG_NOTICE([fcflags_opt_67_triqs_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_67_triqs_ext)

  dnl 68_dmft library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_dmft}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_dmft="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_dmft is ${fcflags_opt_68_dmft}])
      echo "fcflags_opt_68_dmft='${fcflags_opt_68_dmft}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_dmft"
    fi
  else
    if test "${fcflags_opt_68_dmft}" != ""; then
      fcflags_opt_68_dmft=""
      AC_MSG_NOTICE([fcflags_opt_68_dmft overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_dmft)

  dnl 68_lotf library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_lotf}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_lotf="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_lotf is ${fcflags_opt_68_lotf}])
      echo "fcflags_opt_68_lotf='${fcflags_opt_68_lotf}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_lotf"
    fi
  else
    if test "${fcflags_opt_68_lotf}" != ""; then
      fcflags_opt_68_lotf=""
      AC_MSG_NOTICE([fcflags_opt_68_lotf overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_lotf)

  dnl 68_recursion library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_recursion}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_recursion="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_recursion is ${fcflags_opt_68_recursion}])
      echo "fcflags_opt_68_recursion='${fcflags_opt_68_recursion}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_recursion"
    fi
  else
    if test "${fcflags_opt_68_recursion}" != ""; then
      fcflags_opt_68_recursion=""
      AC_MSG_NOTICE([fcflags_opt_68_recursion overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_recursion)

  dnl 68_rsprc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_rsprc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_rsprc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_rsprc is ${fcflags_opt_68_rsprc}])
      echo "fcflags_opt_68_rsprc='${fcflags_opt_68_rsprc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_rsprc"
    fi
  else
    if test "${fcflags_opt_68_rsprc}" != ""; then
      fcflags_opt_68_rsprc=""
      AC_MSG_NOTICE([fcflags_opt_68_rsprc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_rsprc)

  dnl 69_wfdesc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_69_wfdesc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_69_wfdesc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 69_wfdesc is ${fcflags_opt_69_wfdesc}])
      echo "fcflags_opt_69_wfdesc='${fcflags_opt_69_wfdesc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 69_wfdesc"
    fi
  else
    if test "${fcflags_opt_69_wfdesc}" != ""; then
      fcflags_opt_69_wfdesc=""
      AC_MSG_NOTICE([fcflags_opt_69_wfdesc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_69_wfdesc)

  dnl 70_gw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_70_gw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_70_gw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 70_gw is ${fcflags_opt_70_gw}])
      echo "fcflags_opt_70_gw='${fcflags_opt_70_gw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 70_gw"
    fi
  else
    if test "${fcflags_opt_70_gw}" != ""; then
      fcflags_opt_70_gw=""
      AC_MSG_NOTICE([fcflags_opt_70_gw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_70_gw)

  dnl 71_bse library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_71_bse}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_71_bse="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 71_bse is ${fcflags_opt_71_bse}])
      echo "fcflags_opt_71_bse='${fcflags_opt_71_bse}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 71_bse"
    fi
  else
    if test "${fcflags_opt_71_bse}" != ""; then
      fcflags_opt_71_bse=""
      AC_MSG_NOTICE([fcflags_opt_71_bse overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_71_bse)

  dnl 71_wannier library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_71_wannier}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_71_wannier="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 71_wannier is ${fcflags_opt_71_wannier}])
      echo "fcflags_opt_71_wannier='${fcflags_opt_71_wannier}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 71_wannier"
    fi
  else
    if test "${fcflags_opt_71_wannier}" != ""; then
      fcflags_opt_71_wannier=""
      AC_MSG_NOTICE([fcflags_opt_71_wannier overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_71_wannier)

  dnl 72_response library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_72_response}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_72_response="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 72_response is ${fcflags_opt_72_response}])
      echo "fcflags_opt_72_response='${fcflags_opt_72_response}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 72_response"
    fi
  else
    if test "${fcflags_opt_72_response}" != ""; then
      fcflags_opt_72_response=""
      AC_MSG_NOTICE([fcflags_opt_72_response overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_72_response)

  dnl 77_ddb library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_77_ddb}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_77_ddb="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 77_ddb is ${fcflags_opt_77_ddb}])
      echo "fcflags_opt_77_ddb='${fcflags_opt_77_ddb}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 77_ddb"
    fi
  else
    if test "${fcflags_opt_77_ddb}" != ""; then
      fcflags_opt_77_ddb=""
      AC_MSG_NOTICE([fcflags_opt_77_ddb overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_77_ddb)

  dnl 77_suscep library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_77_suscep}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_77_suscep="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 77_suscep is ${fcflags_opt_77_suscep}])
      echo "fcflags_opt_77_suscep='${fcflags_opt_77_suscep}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 77_suscep"
    fi
  else
    if test "${fcflags_opt_77_suscep}" != ""; then
      fcflags_opt_77_suscep=""
      AC_MSG_NOTICE([fcflags_opt_77_suscep overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_77_suscep)

  dnl 78_effpot library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_78_effpot}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_78_effpot="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 78_effpot is ${fcflags_opt_78_effpot}])
      echo "fcflags_opt_78_effpot='${fcflags_opt_78_effpot}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 78_effpot"
    fi
  else
    if test "${fcflags_opt_78_effpot}" != ""; then
      fcflags_opt_78_effpot=""
      AC_MSG_NOTICE([fcflags_opt_78_effpot overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_78_effpot)

  dnl 78_eph library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_78_eph}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_78_eph="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 78_eph is ${fcflags_opt_78_eph}])
      echo "fcflags_opt_78_eph='${fcflags_opt_78_eph}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 78_eph"
    fi
  else
    if test "${fcflags_opt_78_eph}" != ""; then
      fcflags_opt_78_eph=""
      AC_MSG_NOTICE([fcflags_opt_78_eph overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_78_eph)

  dnl 79_seqpar_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_79_seqpar_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_79_seqpar_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 79_seqpar_mpi is ${fcflags_opt_79_seqpar_mpi}])
      echo "fcflags_opt_79_seqpar_mpi='${fcflags_opt_79_seqpar_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 79_seqpar_mpi"
    fi
  else
    if test "${fcflags_opt_79_seqpar_mpi}" != ""; then
      fcflags_opt_79_seqpar_mpi=""
      AC_MSG_NOTICE([fcflags_opt_79_seqpar_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_79_seqpar_mpi)

  dnl 80_tdep library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_80_tdep}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_80_tdep="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 80_tdep is ${fcflags_opt_80_tdep}])
      echo "fcflags_opt_80_tdep='${fcflags_opt_80_tdep}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 80_tdep"
    fi
  else
    if test "${fcflags_opt_80_tdep}" != ""; then
      fcflags_opt_80_tdep=""
      AC_MSG_NOTICE([fcflags_opt_80_tdep overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_80_tdep)

  dnl 94_scfcv library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_94_scfcv}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_94_scfcv="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 94_scfcv is ${fcflags_opt_94_scfcv}])
      echo "fcflags_opt_94_scfcv='${fcflags_opt_94_scfcv}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 94_scfcv"
    fi
  else
    if test "${fcflags_opt_94_scfcv}" != ""; then
      fcflags_opt_94_scfcv=""
      AC_MSG_NOTICE([fcflags_opt_94_scfcv overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_94_scfcv)

  dnl 95_drive library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_95_drive}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_95_drive="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 95_drive is ${fcflags_opt_95_drive}])
      echo "fcflags_opt_95_drive='${fcflags_opt_95_drive}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 95_drive"
    fi
  else
    if test "${fcflags_opt_95_drive}" != ""; then
      fcflags_opt_95_drive=""
      AC_MSG_NOTICE([fcflags_opt_95_drive overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_95_drive)

  dnl 98_main library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_98_main}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_98_main="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 98_main is ${fcflags_opt_98_main}])
      echo "fcflags_opt_98_main='${fcflags_opt_98_main}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 98_main"
    fi
  else
    if test "${fcflags_opt_98_main}" != ""; then
      fcflags_opt_98_main=""
      AC_MSG_NOTICE([fcflags_opt_98_main overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_98_main)

  echo "fcflags_opt_dirlist='${fcflags_opt_dirlist}'" >>config.optim
]) # ABI_OPTFLAGS_DIRS
"
