

AC_DEFUN([ABI_CC_DBGFLAGS],[
  dnl Init
  abi_cc_vendor_dbg="none"
  abi_cc_version_dbg="none"
  abi_cpu_spec_dbg="none"

  dnl Look for debug flags
  AC_MSG_CHECKING([which cc debug flags to apply])

  dnl Case built from config/debug/cc_*.conf
  if test "${abi_cc_vendor}" = "gnu"; then
    abi_cc_vendor_dbg="gnu"
    abi_cc_version_dbg="default"
    abi_cpu_spec_dbg="default"
    case "${abi_debug_flavor}" in
      naughty)
        abi_debug_flavor_dbg="naughty"
        CFLAGS_DEBUG="${CFLAGS_DEBUG} -g3 -ggdb -Wall -Wextra"
        ;;
      verbose)
        abi_debug_flavor_dbg="verbose"
        
        ;;
      paranoid)
        abi_debug_flavor_dbg="paranoid"
        CFLAGS_DEBUG="${CFLAGS_DEBUG} -g3 -ggdb -Wall -Wextra"
        ;;
      enhanced)
        abi_debug_flavor_dbg="enhanced"
        CFLAGS_DEBUG="${CFLAGS_DEBUG} -g3 -ggdb"
        ;;
      basic)
        abi_debug_flavor_dbg="basic"
        
        ;;
    esac   # [case: abi_debug_flavor, indent: 1, item: False]
  fi

  dnl Display settings
  AC_MSG_RESULT([${abi_cc_vendor_dbg}/${abi_cc_version_dbg}/${abi_cpu_spec_dbg}])

]) #ABI_CC_DBGFLAGS


AC_DEFUN([ABI_CXX_DBGFLAGS],[
  dnl Init
  abi_cxx_vendor_dbg="none"
  abi_cxx_version_dbg="none"
  abi_cpu_spec_dbg="none"

  dnl Look for debug flags
  AC_MSG_CHECKING([which cxx debug flags to apply])

  dnl WARNING: no config files were found for language

  dnl Display settings
  AC_MSG_RESULT([${abi_cxx_vendor_dbg}/${abi_cxx_version_dbg}/${abi_cpu_spec_dbg}])

]) #ABI_CXX_DBGFLAGS


AC_DEFUN([ABI_FC_DBGFLAGS],[
  dnl Init
  abi_fc_vendor_dbg="none"
  abi_fc_version_dbg="none"
  abi_cpu_spec_dbg="none"

  dnl Look for debug flags
  AC_MSG_CHECKING([which fc debug flags to apply])

  dnl Case built from config/debug/fc_*.conf
  case "${abi_fc_vendor}" in
    llvm)
      abi_fc_vendor_dbg="llvm"
      abi_fc_version_dbg="default"
      abi_cpu_spec_dbg="default"
      case "${abi_debug_flavor}" in
        naughty)
          abi_debug_flavor_dbg="naughty"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit -fbacktrace -finit-real=nan -Wimplicit -Wall -Wextra -fbacktrace -finit-real=nan -Wimplicit -Wall -Wextra"
          ;;
        verbose)
          abi_debug_flavor_dbg="verbose"
          
          ;;
        paranoid)
          abi_debug_flavor_dbg="paranoid"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit -fbacktrace -finit-real=nan -Wimplicit -Wall -Wextra"
          ;;
        enhanced)
          abi_debug_flavor_dbg="enhanced"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit"
          ;;
        basic)
          abi_debug_flavor_dbg="basic"
          
          ;;
      esac   # [case: abi_debug_flavor, indent: 2, item: True]
      ;;
    ibm)
      abi_fc_vendor_dbg="ibm"
      abi_fc_version_dbg="default"
      abi_cpu_spec_dbg="default"
      case "${abi_debug_flavor}" in
        naughty)
          abi_debug_flavor_dbg="naughty"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -qnooptimize -qextcheck -qflag=i:i -qfloat=nans -qinitauto=7FBFFFFF -qflttrap=overflow:underflow:zerodivide:invalid:enable -qsigtrap -C -qcheck"
          ;;
        verbose)
          abi_debug_flavor_dbg="verbose"
          
          ;;
        paranoid)
          abi_debug_flavor_dbg="paranoid"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -qnooptimize -qextcheck -qflag=i:i -qfloat=nans -qinitauto=7FBFFFFF -qflttrap=overflow:underflow:zerodivide:invalid:enable -qsigtrap"
          ;;
        enhanced)
          abi_debug_flavor_dbg="enhanced"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -qnooptimize -qextcheck -qflag=i:i -qfloat=nans -qinitauto=7FBFFFFF"
          ;;
        basic)
          abi_debug_flavor_dbg="basic"
          
          ;;
      esac   # [case: abi_debug_flavor, indent: 2, item: True]
      ;;
    gnu)
      abi_fc_vendor_dbg="gnu"
      abi_fc_version_dbg="default"
      abi_cpu_spec_dbg="default"
      case "${abi_debug_flavor}" in
        naughty)
          abi_debug_flavor_dbg="naughty"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit-interface -Wno-maybe-uninitialized -Wtabs -ffpe-trap=invalid,zero,overflow -Wall -Wextra -fcheck=all -pedantic"
          ;;
        verbose)
          abi_debug_flavor_dbg="verbose"
          
          ;;
        paranoid)
          abi_debug_flavor_dbg="paranoid"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit-interface -Wno-maybe-uninitialized -Wtabs -ffpe-trap=invalid,zero,overflow -Wall -Wextra"
          ;;
        enhanced)
          abi_debug_flavor_dbg="enhanced"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit-interface -Wno-maybe-uninitialized -Wtabs"
          ;;
        basic)
          abi_debug_flavor_dbg="basic"
          
          ;;
      esac   # [case: abi_debug_flavor, indent: 2, item: True]
      ;;
    nag)
      abi_fc_vendor_dbg="nag"
      abi_fc_version_dbg="default"
      abi_cpu_spec_dbg="default"
      case "${abi_debug_flavor}" in
        naughty)
          abi_debug_flavor_dbg="naughty"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -gline -mtrace=verbose -nan -info -C"
          FC_LDFLAGS_DEBUG="${FC_LDFLAGS_DEBUG} -mtrace=verbose"
          ;;
        verbose)
          abi_debug_flavor_dbg="verbose"
          
          ;;
        paranoid)
          abi_debug_flavor_dbg="paranoid"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -gline -mtrace=verbose -nan -info"
          FC_LDFLAGS_DEBUG="${FC_LDFLAGS_DEBUG} -mtrace=verbose"
          ;;
        enhanced)
          abi_debug_flavor_dbg="enhanced"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -gline -mtrace=verbose -nan"
          FC_LDFLAGS_DEBUG="${FC_LDFLAGS_DEBUG} -mtrace=verbose"
          ;;
        basic)
          abi_debug_flavor_dbg="basic"
          
          ;;
      esac   # [case: abi_debug_flavor, indent: 2, item: True]
      ;;
    arm)
      abi_fc_vendor_dbg="arm"
      abi_fc_version_dbg="default"
      abi_cpu_spec_dbg="default"
      case "${abi_debug_flavor}" in
        naughty)
          abi_debug_flavor_dbg="naughty"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit -fbacktrace -finit-real=nan -Wimplicit -Wall -Wextra -fbacktrace -finit-real=nan -Wimplicit -Wall -Wextra"
          ;;
        verbose)
          abi_debug_flavor_dbg="verbose"
          
          ;;
        paranoid)
          abi_debug_flavor_dbg="paranoid"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit -fbacktrace -finit-real=nan -Wimplicit -Wall -Wextra"
          ;;
        enhanced)
          abi_debug_flavor_dbg="enhanced"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -fbacktrace -finit-real=nan -Wimplicit"
          ;;
        basic)
          abi_debug_flavor_dbg="basic"
          
          ;;
      esac   # [case: abi_debug_flavor, indent: 2, item: True]
      ;;
    intel)
      abi_fc_vendor_dbg="intel"
      abi_fc_version_dbg="default"
      abi_cpu_spec_dbg="default"
      case "${abi_debug_flavor}" in
        naughty)
          abi_debug_flavor_dbg="naughty"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -check uninit -debug all -fp-model source -ftrapuv -traceback -fp-stack-check -implicitnone -init=snan -warn all -check all -WB"
          ;;
        verbose)
          abi_debug_flavor_dbg="verbose"
          
          ;;
        paranoid)
          abi_debug_flavor_dbg="paranoid"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -check uninit -debug all -fp-model source -ftrapuv -traceback -fp-stack-check -implicitnone -init=snan -warn all"
          ;;
        enhanced)
          abi_debug_flavor_dbg="enhanced"
          FCFLAGS_DEBUG="${FCFLAGS_DEBUG} -check uninit -debug all -fp-model source -ftrapuv -traceback"
          ;;
        basic)
          abi_debug_flavor_dbg="basic"
          
          ;;
      esac   # [case: abi_debug_flavor, indent: 2, item: True]
      ;;
  esac   # [case: abi_fc_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_fc_vendor_dbg}/${abi_fc_version_dbg}/${abi_cpu_spec_dbg}])

]) #ABI_FC_DBGFLAGS
