/*
 * package_error_package.java
 *
 * Copyright (C) 2003-2004 Peter Graves
 * $Id: package_error_package.java 12826 2010-07-25 19:09:13Z vvoutilainen $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * As a special exception, the copyright holders of this library give you
 * permission to link this library with independent modules to produce an
 * executable, regardless of the license terms of these independent
 * modules, and to copy and distribute the resulting executable under
 * terms of your choice, provided that you also meet, for each linked
 * independent module, the terms and conditions of the license of that
 * module.  An independent module is a module which is not derived from
 * or based on this library.  If you modify this library, you may extend
 * this exception to your version of the library, but you are not
 * obligated to do so.  If you do not wish to do so, delete this
 * exception statement from your version.
 */

package org.armedbear.lisp;

import static org.armedbear.lisp.Lisp.*;

@DocString(name="package-error-package")
public final class package_error_package extends Primitive
{
    private package_error_package()
    {
        super("package-error-package");
    }

    @Override
    public LispObject execute(LispObject arg)
    {
        if (arg instanceof PackageError)
            return ((PackageError)arg).getPackage();
        return type_error(arg, Symbol.PACKAGE_ERROR);
    }

    private static final Primitive PACKAGE_ERROR_PACKAGE =
        new package_error_package();
}
