<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Search_Lucene
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id$
 */

/**
 * Zend_Search_Lucene_Storage_Directory_Filesystem
 */
require_once 'Zend/Search/Lucene/Storage/Directory/Filesystem.php';

/**
 * Zend_Search_Lucene_Index_SegmentInfo
 */
require_once 'Zend/Search/Lucene/Index/SegmentInfo.php';

/**
 * Zend_Search_Lucene_Index_TermsPriorityQueue
 */
require_once 'Zend/Search/Lucene/Index/TermsPriorityQueue.php';

/**
 * @category   Zend
 * @package    Zend_Search_Lucene
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @group      Zend_Search_Lucene
 */
class Zend_Search_Lucene_Index_TermsPriorityQueueTest extends PHPUnit_Framework_TestCase
{
    public function testQueue()
    {
        $directory = new Zend_Search_Lucene_Storage_Directory_Filesystem(dirname(__FILE__) . '/_source/_files');
        $segmentsList = array('_0', '_1', '_2', '_3', '_4');

        $segmentInfoQueue = new Zend_Search_Lucene_Index_TermsPriorityQueue();

        foreach ($segmentsList as $segmentName) {
            $segmentInfo = new Zend_Search_Lucene_Index_SegmentInfo($directory, $segmentName, 2);
            $segmentInfo->resetTermsStream();

            // Skip "empty" segments
            if ($segmentInfo->currentTerm() !== null) {
                $segmentInfoQueue->put($segmentInfo);
            }
        }

        $result = array();
        while (($segmentInfo = $segmentInfoQueue->pop()) !== null) {
            if ($segmentInfoQueue->top() === null ||
                $segmentInfoQueue->top()->currentTerm()->key() !=
                            $segmentInfo->currentTerm()->key()) {
                // We got new term
                $result[] = $segmentInfo->currentTerm();
            }

            $segmentInfo->nextTerm();
            // check, if segment dictionary is finished
            if ($segmentInfo->currentTerm() !== null) {
                // Put segment back into the priority queue
                $segmentInfoQueue->put($segmentInfo);
            }
        }

        $this->assertTrue($result ==
                          array(new Zend_Search_Lucene_Index_Term('a', 'contents'),
                                new Zend_Search_Lucene_Index_Term('about', 'contents'),
                                new Zend_Search_Lucene_Index_Term('above', 'contents'),
                                new Zend_Search_Lucene_Index_Term('absolutely', 'contents'),
                                new Zend_Search_Lucene_Index_Term('accept', 'contents'),
                                new Zend_Search_Lucene_Index_Term('accesskey', 'contents'),
                                new Zend_Search_Lucene_Index_Term('account', 'contents'),
                                new Zend_Search_Lucene_Index_Term('accounts', 'contents'),
                                new Zend_Search_Lucene_Index_Term('adding', 'contents'),
                                new Zend_Search_Lucene_Index_Term('additional', 'contents'),
                                new Zend_Search_Lucene_Index_Term('adresses', 'contents'),
                                new Zend_Search_Lucene_Index_Term('advised', 'contents'),
                                new Zend_Search_Lucene_Index_Term('after', 'contents'),
                                new Zend_Search_Lucene_Index_Term('alan', 'contents'),
                                new Zend_Search_Lucene_Index_Term('alberton', 'contents'),
                                new Zend_Search_Lucene_Index_Term('alexander', 'contents'),
                                new Zend_Search_Lucene_Index_Term('align', 'contents'),
                                new Zend_Search_Lucene_Index_Term('alink', 'contents'),
                                new Zend_Search_Lucene_Index_Term('all', 'contents'),
                                new Zend_Search_Lucene_Index_Term('alphabetic', 'contents'),
                                new Zend_Search_Lucene_Index_Term('already', 'contents'),
                                new Zend_Search_Lucene_Index_Term('also', 'contents'),
                                new Zend_Search_Lucene_Index_Term('always', 'contents'),
                                new Zend_Search_Lucene_Index_Term('amazon', 'contents'),
                                new Zend_Search_Lucene_Index_Term('an', 'contents'),
                                new Zend_Search_Lucene_Index_Term('and', 'contents'),
                                new Zend_Search_Lucene_Index_Term('annoying', 'contents'),
                                new Zend_Search_Lucene_Index_Term('another', 'contents'),
                                new Zend_Search_Lucene_Index_Term('any', 'contents'),
                                new Zend_Search_Lucene_Index_Term('apart', 'contents'),
                                new Zend_Search_Lucene_Index_Term('api', 'contents'),
                                new Zend_Search_Lucene_Index_Term('appreciate', 'contents'),
                                new Zend_Search_Lucene_Index_Term('are', 'contents'),
                                new Zend_Search_Lucene_Index_Term('arising', 'contents'),
                                new Zend_Search_Lucene_Index_Term('as', 'contents'),
                                new Zend_Search_Lucene_Index_Term('asked', 'contents'),
                                new Zend_Search_Lucene_Index_Term('at', 'contents'),
                                new Zend_Search_Lucene_Index_Term('attach', 'contents'),
                                new Zend_Search_Lucene_Index_Term('attachments', 'contents'),
                                new Zend_Search_Lucene_Index_Term('authors', 'contents'),
                                new Zend_Search_Lucene_Index_Term('available', 'contents'),
                                new Zend_Search_Lucene_Index_Term('b', 'contents'),
                                new Zend_Search_Lucene_Index_Term('back', 'contents'),
                                new Zend_Search_Lucene_Index_Term('backwards', 'contents'),
                                new Zend_Search_Lucene_Index_Term('bar', 'contents'),
                                new Zend_Search_Lucene_Index_Term('base', 'contents'),
                                new Zend_Search_Lucene_Index_Term('be', 'contents'),
                                new Zend_Search_Lucene_Index_Term('beaver', 'contents'),
                                new Zend_Search_Lucene_Index_Term('because', 'contents'),
                                new Zend_Search_Lucene_Index_Term('been', 'contents'),
                                new Zend_Search_Lucene_Index_Term('before', 'contents'),
                                new Zend_Search_Lucene_Index_Term('bgcolor', 'contents'),
                                new Zend_Search_Lucene_Index_Term('binary', 'contents'),
                                new Zend_Search_Lucene_Index_Term('blockquote', 'contents'),
                                new Zend_Search_Lucene_Index_Term('body', 'contents'),
                                new Zend_Search_Lucene_Index_Term('book', 'contents'),
                                new Zend_Search_Lucene_Index_Term('border', 'contents'),
                                new Zend_Search_Lucene_Index_Term('bottom', 'contents'),
                                new Zend_Search_Lucene_Index_Term('break', 'contents'),
                                new Zend_Search_Lucene_Index_Term('brought', 'contents'),
                                new Zend_Search_Lucene_Index_Term('browser', 'contents'),
                                new Zend_Search_Lucene_Index_Term('bug', 'contents'),
                                new Zend_Search_Lucene_Index_Term('bugs', 'contents'),
                                new Zend_Search_Lucene_Index_Term('business', 'contents'),
                                new Zend_Search_Lucene_Index_Term('but', 'contents'),
                                new Zend_Search_Lucene_Index_Term('buy', 'contents'),
                                new Zend_Search_Lucene_Index_Term('buying', 'contents'),
                                new Zend_Search_Lucene_Index_Term('by', 'contents'),
                                new Zend_Search_Lucene_Index_Term('c', 'contents'),
                                new Zend_Search_Lucene_Index_Term('can', 'contents'),
                                new Zend_Search_Lucene_Index_Term('care', 'contents'),
                                new Zend_Search_Lucene_Index_Term('carefully', 'contents'),
                                new Zend_Search_Lucene_Index_Term('case', 'contents'),
                                new Zend_Search_Lucene_Index_Term('caused', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cc', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cd', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cellpadding', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cellspacing', 'contents'),
                                new Zend_Search_Lucene_Index_Term('center', 'contents'),
                                new Zend_Search_Lucene_Index_Term('certain', 'contents'),
                                new Zend_Search_Lucene_Index_Term('chances', 'contents'),
                                new Zend_Search_Lucene_Index_Term('change', 'contents'),
                                new Zend_Search_Lucene_Index_Term('changed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('changes', 'contents'),
                                new Zend_Search_Lucene_Index_Term('changing', 'contents'),
                                new Zend_Search_Lucene_Index_Term('chapter', 'contents'),
                                new Zend_Search_Lucene_Index_Term('charset', 'contents'),
                                new Zend_Search_Lucene_Index_Term('check', 'contents'),
                                new Zend_Search_Lucene_Index_Term('class', 'contents'),
                                new Zend_Search_Lucene_Index_Term('classes', 'contents'),
                                new Zend_Search_Lucene_Index_Term('clay', 'contents'),
                                new Zend_Search_Lucene_Index_Term('clear', 'contents'),
                                new Zend_Search_Lucene_Index_Term('click', 'contents'),
                                new Zend_Search_Lucene_Index_Term('co', 'contents'),
                                new Zend_Search_Lucene_Index_Term('code', 'contents'),
                                new Zend_Search_Lucene_Index_Term('coding', 'contents'),
                                new Zend_Search_Lucene_Index_Term('colspan', 'contents'),
                                new Zend_Search_Lucene_Index_Term('com', 'contents'),
                                new Zend_Search_Lucene_Index_Term('commands', 'contents'),
                                new Zend_Search_Lucene_Index_Term('comment', 'contents'),
                                new Zend_Search_Lucene_Index_Term('community', 'contents'),
                                new Zend_Search_Lucene_Index_Term('company', 'contents'),
                                new Zend_Search_Lucene_Index_Term('compatibility', 'contents'),
                                new Zend_Search_Lucene_Index_Term('compatible', 'contents'),
                                new Zend_Search_Lucene_Index_Term('components', 'contents'),
                                new Zend_Search_Lucene_Index_Term('conditions', 'contents'),
                                new Zend_Search_Lucene_Index_Term('consequential', 'contents'),
                                new Zend_Search_Lucene_Index_Term('considered', 'contents'),
                                new Zend_Search_Lucene_Index_Term('consists', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contact', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contains', 'contents'),
                                new Zend_Search_Lucene_Index_Term('content', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contents', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contract', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contribute', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contributed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contributing', 'contents'),
                                new Zend_Search_Lucene_Index_Term('contributors', 'contents'),
                                new Zend_Search_Lucene_Index_Term('convissor', 'contents'),
                                new Zend_Search_Lucene_Index_Term('copyright', 'contents'),
                                new Zend_Search_Lucene_Index_Term('core', 'contents'),
                                new Zend_Search_Lucene_Index_Term('costa', 'contents'),
                                new Zend_Search_Lucene_Index_Term('could', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cox', 'contents'),
                                new Zend_Search_Lucene_Index_Term('create', 'contents'),
                                new Zend_Search_Lucene_Index_Term('creating', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cvs', 'contents'),
                                new Zend_Search_Lucene_Index_Term('cvsread', 'contents'),
                                new Zend_Search_Lucene_Index_Term('d', 'contents'),
                                new Zend_Search_Lucene_Index_Term('damage', 'contents'),
                                new Zend_Search_Lucene_Index_Term('damages', 'contents'),
                                new Zend_Search_Lucene_Index_Term('daniel', 'contents'),
                                new Zend_Search_Lucene_Index_Term('data', 'contents'),
                                new Zend_Search_Lucene_Index_Term('date', 'contents'),
                                new Zend_Search_Lucene_Index_Term('david', 'contents'),
                                new Zend_Search_Lucene_Index_Term('depends', 'contents'),
                                new Zend_Search_Lucene_Index_Term('derivative', 'contents'),
                                new Zend_Search_Lucene_Index_Term('derived', 'contents'),
                                new Zend_Search_Lucene_Index_Term('describes', 'contents'),
                                new Zend_Search_Lucene_Index_Term('details', 'contents'),
                                new Zend_Search_Lucene_Index_Term('detection', 'contents'),
                                new Zend_Search_Lucene_Index_Term('dev', 'contents'),
                                new Zend_Search_Lucene_Index_Term('developer', 'contents'),
                                new Zend_Search_Lucene_Index_Term('developers', 'contents'),
                                new Zend_Search_Lucene_Index_Term('diff', 'contents'),
                                new Zend_Search_Lucene_Index_Term('different', 'contents'),
                                new Zend_Search_Lucene_Index_Term('direct', 'contents'),
                                new Zend_Search_Lucene_Index_Term('disclaimed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('disclaimer', 'contents'),
                                new Zend_Search_Lucene_Index_Term('distributed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('distribution', 'contents'),
                                new Zend_Search_Lucene_Index_Term('div', 'contents'),
                                new Zend_Search_Lucene_Index_Term('dl', 'contents'),
                                new Zend_Search_Lucene_Index_Term('do', 'contents'),
                                new Zend_Search_Lucene_Index_Term('doc', 'contents'),
                                new Zend_Search_Lucene_Index_Term('docblock', 'contents'),
                                new Zend_Search_Lucene_Index_Term('docbook', 'contents'),
                                new Zend_Search_Lucene_Index_Term('docs', 'contents'),
                                new Zend_Search_Lucene_Index_Term('document', 'contents'),
                                new Zend_Search_Lucene_Index_Term('documentation', 'contents'),
                                new Zend_Search_Lucene_Index_Term('does', 'contents'),
                                new Zend_Search_Lucene_Index_Term('doesn', 'contents'),
                                new Zend_Search_Lucene_Index_Term('don', 'contents'),
                                new Zend_Search_Lucene_Index_Term('double', 'contents'),
                                new Zend_Search_Lucene_Index_Term('dt', 'contents'),
                                new Zend_Search_Lucene_Index_Term('dumbill', 'contents'),
                                new Zend_Search_Lucene_Index_Term('each', 'contents'),
                                new Zend_Search_Lucene_Index_Term('easiest', 'contents'),
                                new Zend_Search_Lucene_Index_Term('easy', 'contents'),
                                new Zend_Search_Lucene_Index_Term('edd', 'contents'),
                                new Zend_Search_Lucene_Index_Term('edit', 'contents'),
                                new Zend_Search_Lucene_Index_Term('eeeeee', 'contents'),
                                new Zend_Search_Lucene_Index_Term('email', 'contents'),
                                new Zend_Search_Lucene_Index_Term('endorse', 'contents'),
                                new Zend_Search_Lucene_Index_Term('english', 'contents'),
                                new Zend_Search_Lucene_Index_Term('equal', 'contents'),
                                new Zend_Search_Lucene_Index_Term('equiv', 'contents'),
                                new Zend_Search_Lucene_Index_Term('essential', 'contents'),
                                new Zend_Search_Lucene_Index_Term('even', 'contents'),
                                new Zend_Search_Lucene_Index_Term('event', 'contents'),
                                new Zend_Search_Lucene_Index_Term('everyone', 'contents'),
                                new Zend_Search_Lucene_Index_Term('example', 'contents'),
                                new Zend_Search_Lucene_Index_Term('exemplary', 'contents'),
                                new Zend_Search_Lucene_Index_Term('existing', 'contents'),
                                new Zend_Search_Lucene_Index_Term('expand', 'contents'),
                                new Zend_Search_Lucene_Index_Term('explanation', 'contents'),
                                new Zend_Search_Lucene_Index_Term('explanations', 'contents'),
                                new Zend_Search_Lucene_Index_Term('explicit', 'contents'),
                                new Zend_Search_Lucene_Index_Term('express', 'contents'),
                                new Zend_Search_Lucene_Index_Term('extension', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fairly', 'contents'),
                                new Zend_Search_Lucene_Index_Term('faq', 'contents'),
                                new Zend_Search_Lucene_Index_Term('feature', 'contents'),
                                new Zend_Search_Lucene_Index_Term('feedback', 'contents'),
                                new Zend_Search_Lucene_Index_Term('feel', 'contents'),
                                new Zend_Search_Lucene_Index_Term('ff', 'contents'),
                                new Zend_Search_Lucene_Index_Term('ffffff', 'contents'),
                                new Zend_Search_Lucene_Index_Term('file', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fill', 'contents'),
                                new Zend_Search_Lucene_Index_Term('financial', 'contents'),
                                new Zend_Search_Lucene_Index_Term('find', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fine', 'contents'),
                                new Zend_Search_Lucene_Index_Term('finished', 'contents'),
                                new Zend_Search_Lucene_Index_Term('first', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fitness', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fix', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fixed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('following', 'contents'),
                                new Zend_Search_Lucene_Index_Term('foo', 'contents'),
                                new Zend_Search_Lucene_Index_Term('footer', 'contents'),
                                new Zend_Search_Lucene_Index_Term('for', 'contents'),
                                new Zend_Search_Lucene_Index_Term('force', 'contents'),
                                new Zend_Search_Lucene_Index_Term('forget', 'contents'),
                                new Zend_Search_Lucene_Index_Term('form', 'contents'),
                                new Zend_Search_Lucene_Index_Term('forms', 'contents'),
                                new Zend_Search_Lucene_Index_Term('forth', 'contents'),
                                new Zend_Search_Lucene_Index_Term('found', 'contents'),
                                new Zend_Search_Lucene_Index_Term('free', 'contents'),
                                new Zend_Search_Lucene_Index_Term('frequently', 'contents'),
                                new Zend_Search_Lucene_Index_Term('from', 'contents'),
                                new Zend_Search_Lucene_Index_Term('front', 'contents'),
                                new Zend_Search_Lucene_Index_Term('fully', 'contents'),
                                new Zend_Search_Lucene_Index_Term('functionality', 'contents'),
                                new Zend_Search_Lucene_Index_Term('generally', 'contents'),
                                new Zend_Search_Lucene_Index_Term('generator', 'contents'),
                                new Zend_Search_Lucene_Index_Term('giving', 'contents'),
                                new Zend_Search_Lucene_Index_Term('go', 'contents'),
                                new Zend_Search_Lucene_Index_Term('good', 'contents'),
                                new Zend_Search_Lucene_Index_Term('goods', 'contents'),
                                new Zend_Search_Lucene_Index_Term('gregory', 'contents'),
                                new Zend_Search_Lucene_Index_Term('groundbraking', 'contents'),
                                new Zend_Search_Lucene_Index_Term('group', 'contents'),
                                new Zend_Search_Lucene_Index_Term('guide', 'contents'),
                                new Zend_Search_Lucene_Index_Term('h', 'contents'),
                                new Zend_Search_Lucene_Index_Term('happy', 'contents'),
                                new Zend_Search_Lucene_Index_Term('has', 'contents'),
                                new Zend_Search_Lucene_Index_Term('hasn', 'contents'),
                                new Zend_Search_Lucene_Index_Term('have', 'contents'),
                                new Zend_Search_Lucene_Index_Term('head', 'contents'),
                                new Zend_Search_Lucene_Index_Term('header', 'contents'),
                                new Zend_Search_Lucene_Index_Term('help', 'contents'),
                                new Zend_Search_Lucene_Index_Term('helping', 'contents'),
                                new Zend_Search_Lucene_Index_Term('her', 'contents'),
                                new Zend_Search_Lucene_Index_Term('hesitate', 'contents'),
                                new Zend_Search_Lucene_Index_Term('his', 'contents'),
                                new Zend_Search_Lucene_Index_Term('holder', 'contents'),
                                new Zend_Search_Lucene_Index_Term('holders', 'contents'),
                                new Zend_Search_Lucene_Index_Term('home', 'contents'),
                                new Zend_Search_Lucene_Index_Term('homepage', 'contents'),
                                new Zend_Search_Lucene_Index_Term('how', 'contents'),
                                new Zend_Search_Lucene_Index_Term('however', 'contents'),
                                new Zend_Search_Lucene_Index_Term('hr', 'contents'),
                                new Zend_Search_Lucene_Index_Term('href', 'contents'),
                                new Zend_Search_Lucene_Index_Term('html', 'contents'),
                                new Zend_Search_Lucene_Index_Term('http', 'contents'),
                                new Zend_Search_Lucene_Index_Term('i', 'contents'),
                                new Zend_Search_Lucene_Index_Term('if', 'contents'),
                                new Zend_Search_Lucene_Index_Term('immoral', 'contents'),
                                new Zend_Search_Lucene_Index_Term('implied', 'contents'),
                                new Zend_Search_Lucene_Index_Term('important', 'contents'),
                                new Zend_Search_Lucene_Index_Term('improvement', 'contents'),
                                new Zend_Search_Lucene_Index_Term('improving', 'contents'),
                                new Zend_Search_Lucene_Index_Term('in', 'contents'),
                                new Zend_Search_Lucene_Index_Term('incidental', 'contents'),
                                new Zend_Search_Lucene_Index_Term('include', 'contents'),
                                new Zend_Search_Lucene_Index_Term('including', 'contents'),
                                new Zend_Search_Lucene_Index_Term('independent', 'contents'),
                                new Zend_Search_Lucene_Index_Term('index', 'contents'),
                                new Zend_Search_Lucene_Index_Term('indirect', 'contents'),
                                new Zend_Search_Lucene_Index_Term('information', 'contents'),
                                new Zend_Search_Lucene_Index_Term('install', 'contents'),
                                new Zend_Search_Lucene_Index_Term('installation', 'contents'),
                                new Zend_Search_Lucene_Index_Term('installer', 'contents'),
                                new Zend_Search_Lucene_Index_Term('interruption', 'contents'),
                                new Zend_Search_Lucene_Index_Term('into', 'contents'),
                                new Zend_Search_Lucene_Index_Term('introduce', 'contents'),
                                new Zend_Search_Lucene_Index_Term('introduction', 'contents'),
                                new Zend_Search_Lucene_Index_Term('is', 'contents'),
                                new Zend_Search_Lucene_Index_Term('iso', 'contents'),
                                new Zend_Search_Lucene_Index_Term('it', 'contents'),
                                new Zend_Search_Lucene_Index_Term('its', 'contents'),
                                new Zend_Search_Lucene_Index_Term('jansen', 'contents'),
                                new Zend_Search_Lucene_Index_Term('jon', 'contents'),
                                new Zend_Search_Lucene_Index_Term('keep', 'contents'),
                                new Zend_Search_Lucene_Index_Term('knowles', 'contents'),
                                new Zend_Search_Lucene_Index_Term('lack', 'contents'),
                                new Zend_Search_Lucene_Index_Term('languages', 'contents'),
                                new Zend_Search_Lucene_Index_Term('later', 'contents'),
                                new Zend_Search_Lucene_Index_Term('latest', 'contents'),
                                new Zend_Search_Lucene_Index_Term('left', 'contents'),
                                new Zend_Search_Lucene_Index_Term('legalnotice', 'contents'),
                                new Zend_Search_Lucene_Index_Term('li', 'contents'),
                                new Zend_Search_Lucene_Index_Term('liability', 'contents'),
                                new Zend_Search_Lucene_Index_Term('liable', 'contents'),
                                new Zend_Search_Lucene_Index_Term('license', 'contents'),
                                new Zend_Search_Lucene_Index_Term('licenses', 'contents'),
                                new Zend_Search_Lucene_Index_Term('like', 'contents'),
                                new Zend_Search_Lucene_Index_Term('limited', 'contents'),
                                new Zend_Search_Lucene_Index_Term('link', 'contents'),
                                new Zend_Search_Lucene_Index_Term('list', 'contents'),
                                new Zend_Search_Lucene_Index_Term('listed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('lists', 'contents'),
                                new Zend_Search_Lucene_Index_Term('literal', 'contents'),
                                new Zend_Search_Lucene_Index_Term('ll', 'contents'),
                                new Zend_Search_Lucene_Index_Term('login', 'contents'),
                                new Zend_Search_Lucene_Index_Term('look', 'contents'),
                                new Zend_Search_Lucene_Index_Term('lorenzo', 'contents'),
                                new Zend_Search_Lucene_Index_Term('loss', 'contents'),
                                new Zend_Search_Lucene_Index_Term('loveless', 'contents'),
                                new Zend_Search_Lucene_Index_Term('mail', 'contents'),
                                new Zend_Search_Lucene_Index_Term('mailinglist', 'contents'),
                                new Zend_Search_Lucene_Index_Term('mailto', 'contents'),
                                new Zend_Search_Lucene_Index_Term('maintain', 'contents'),
                                new Zend_Search_Lucene_Index_Term('maintainer', 'contents'),
                                new Zend_Search_Lucene_Index_Term('maintainers', 'contents'),
                                new Zend_Search_Lucene_Index_Term('make', 'contents'),
                                new Zend_Search_Lucene_Index_Term('makes', 'contents'),
                                new Zend_Search_Lucene_Index_Term('manual', 'contents'),
                                new Zend_Search_Lucene_Index_Term('martin', 'contents'),
                                new Zend_Search_Lucene_Index_Term('material', 'contents'),
                                new Zend_Search_Lucene_Index_Term('materials', 'contents'),
                                new Zend_Search_Lucene_Index_Term('may', 'contents'),
                                new Zend_Search_Lucene_Index_Term('mean', 'contents'),
                                new Zend_Search_Lucene_Index_Term('means', 'contents'),
                                new Zend_Search_Lucene_Index_Term('meet', 'contents'),
                                new Zend_Search_Lucene_Index_Term('merchantability', 'contents'),
                                new Zend_Search_Lucene_Index_Term('merz', 'contents'),
                                new Zend_Search_Lucene_Index_Term('met', 'contents'),
                                new Zend_Search_Lucene_Index_Term('meta', 'contents'),
                                new Zend_Search_Lucene_Index_Term('michael', 'contents'),
                                new Zend_Search_Lucene_Index_Term('migrating', 'contents'),
                                new Zend_Search_Lucene_Index_Term('mika', 'contents'),
                                new Zend_Search_Lucene_Index_Term('mime', 'contents'),
                                new Zend_Search_Lucene_Index_Term('modification', 'contents'),
                                new Zend_Search_Lucene_Index_Term('modified', 'contents'),
                                new Zend_Search_Lucene_Index_Term('modular', 'contents'),
                                new Zend_Search_Lucene_Index_Term('more', 'contents'),
                                new Zend_Search_Lucene_Index_Term('must', 'contents'),
                                new Zend_Search_Lucene_Index_Term('n', 'contents'),
                                new Zend_Search_Lucene_Index_Term('name', 'contents'),
                                new Zend_Search_Lucene_Index_Term('names', 'contents'),
                                new Zend_Search_Lucene_Index_Term('navfooter', 'contents'),
                                new Zend_Search_Lucene_Index_Term('navheader', 'contents'),
                                new Zend_Search_Lucene_Index_Term('navigation', 'contents'),
                                new Zend_Search_Lucene_Index_Term('nbsp', 'contents'),
                                new Zend_Search_Lucene_Index_Term('need', 'contents'),
                                new Zend_Search_Lucene_Index_Term('negligence', 'contents'),
                                new Zend_Search_Lucene_Index_Term('neither', 'contents'),
                                new Zend_Search_Lucene_Index_Term('net', 'contents'),
                                new Zend_Search_Lucene_Index_Term('neufeind', 'contents'),
                                new Zend_Search_Lucene_Index_Term('new', 'contents'),
                                new Zend_Search_Lucene_Index_Term('newpackage', 'contents'),
                                new Zend_Search_Lucene_Index_Term('next', 'contents'),
                                new Zend_Search_Lucene_Index_Term('no', 'contents'),
                                new Zend_Search_Lucene_Index_Term('nor', 'contents'),
                                new Zend_Search_Lucene_Index_Term('not', 'contents'),
                                new Zend_Search_Lucene_Index_Term('note', 'contents'),
                                new Zend_Search_Lucene_Index_Term('notice', 'contents'),
                                new Zend_Search_Lucene_Index_Term('now', 'contents'),
                                new Zend_Search_Lucene_Index_Term('obtain', 'contents'),
                                new Zend_Search_Lucene_Index_Term('obtained', 'contents'),
                                new Zend_Search_Lucene_Index_Term('of', 'contents'),
                                new Zend_Search_Lucene_Index_Term('on', 'contents'),
                                new Zend_Search_Lucene_Index_Term('one', 'contents'),
                                new Zend_Search_Lucene_Index_Term('only', 'contents'),
                                new Zend_Search_Lucene_Index_Term('open', 'contents'),
                                new Zend_Search_Lucene_Index_Term('opencontent', 'contents'),
                                new Zend_Search_Lucene_Index_Term('openpub', 'contents'),
                                new Zend_Search_Lucene_Index_Term('or', 'contents'),
                                new Zend_Search_Lucene_Index_Term('order', 'contents'),
                                new Zend_Search_Lucene_Index_Term('org', 'contents'),
                                new Zend_Search_Lucene_Index_Term('originally', 'contents'),
                                new Zend_Search_Lucene_Index_Term('other', 'contents'),
                                new Zend_Search_Lucene_Index_Term('otherwise', 'contents'),
                                new Zend_Search_Lucene_Index_Term('our', 'contents'),
                                new Zend_Search_Lucene_Index_Term('out', 'contents'),
                                new Zend_Search_Lucene_Index_Term('outlook', 'contents'),
                                new Zend_Search_Lucene_Index_Term('p', 'contents'),
                                new Zend_Search_Lucene_Index_Term('package', 'contents'),
                                new Zend_Search_Lucene_Index_Term('packages', 'contents'),
                                new Zend_Search_Lucene_Index_Term('page', 'contents'),
                                new Zend_Search_Lucene_Index_Term('paper', 'contents'),
                                new Zend_Search_Lucene_Index_Term('parise', 'contents'),
                                new Zend_Search_Lucene_Index_Term('part', 'contents'),
                                new Zend_Search_Lucene_Index_Term('particular', 'contents'),
                                new Zend_Search_Lucene_Index_Term('password', 'contents'),
                                new Zend_Search_Lucene_Index_Term('patch', 'contents'),
                                new Zend_Search_Lucene_Index_Term('patches', 'contents'),
                                new Zend_Search_Lucene_Index_Term('pear', 'contents'),
                                new Zend_Search_Lucene_Index_Term('people', 'contents'),
                                new Zend_Search_Lucene_Index_Term('perform', 'contents'),
                                new Zend_Search_Lucene_Index_Term('permission', 'contents'),
                                new Zend_Search_Lucene_Index_Term('permitted', 'contents'),
                                new Zend_Search_Lucene_Index_Term('persists', 'contents'),
                                new Zend_Search_Lucene_Index_Term('php', 'contents'),
                                new Zend_Search_Lucene_Index_Term('phpfi', 'contents'),
                                new Zend_Search_Lucene_Index_Term('plain', 'contents'),
                                new Zend_Search_Lucene_Index_Term('please', 'contents'),
                                new Zend_Search_Lucene_Index_Term('possibility', 'contents'),
                                new Zend_Search_Lucene_Index_Term('post', 'contents'),
                                new Zend_Search_Lucene_Index_Term('postinstall', 'contents'),
                                new Zend_Search_Lucene_Index_Term('ppm', 'contents'),
                                new Zend_Search_Lucene_Index_Term('pre', 'contents'),
                                new Zend_Search_Lucene_Index_Term('preface', 'contents'),
                                new Zend_Search_Lucene_Index_Term('prefixed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('presently', 'contents'),
                                new Zend_Search_Lucene_Index_Term('prev', 'contents'),
                                new Zend_Search_Lucene_Index_Term('previous', 'contents'),
                                new Zend_Search_Lucene_Index_Term('prior', 'contents'),
                                new Zend_Search_Lucene_Index_Term('process', 'contents'),
                                new Zend_Search_Lucene_Index_Term('procurement', 'contents'),
                                new Zend_Search_Lucene_Index_Term('products', 'contents'),
                                new Zend_Search_Lucene_Index_Term('profits', 'contents'),
                                new Zend_Search_Lucene_Index_Term('prohibited', 'contents'),
                                new Zend_Search_Lucene_Index_Term('project', 'contents'),
                                new Zend_Search_Lucene_Index_Term('promote', 'contents'),
                                new Zend_Search_Lucene_Index_Term('proper', 'contents'),
                                new Zend_Search_Lucene_Index_Term('provided', 'contents'),
                                new Zend_Search_Lucene_Index_Term('provides', 'contents'),
                                new Zend_Search_Lucene_Index_Term('pserver', 'contents'),
                                new Zend_Search_Lucene_Index_Term('public', 'contents'),
                                new Zend_Search_Lucene_Index_Term('publication', 'contents'),
                                new Zend_Search_Lucene_Index_Term('published', 'contents'),
                                new Zend_Search_Lucene_Index_Term('purpose', 'contents'),
                                new Zend_Search_Lucene_Index_Term('questions', 'contents'),
                                new Zend_Search_Lucene_Index_Term('quote', 'contents'),
                                new Zend_Search_Lucene_Index_Term('read', 'contents'),
                                new Zend_Search_Lucene_Index_Term('redistribution', 'contents'),
                                new Zend_Search_Lucene_Index_Term('redistributions', 'contents'),
                                new Zend_Search_Lucene_Index_Term('regents', 'contents'),
                                new Zend_Search_Lucene_Index_Term('rejected', 'contents'),
                                new Zend_Search_Lucene_Index_Term('rel', 'contents'),
                                new Zend_Search_Lucene_Index_Term('relevant', 'contents'),
                                new Zend_Search_Lucene_Index_Term('report', 'contents'),
                                new Zend_Search_Lucene_Index_Term('reported', 'contents'),
                                new Zend_Search_Lucene_Index_Term('reporting', 'contents'),
                                new Zend_Search_Lucene_Index_Term('repository', 'contents'),
                                new Zend_Search_Lucene_Index_Term('representatives', 'contents'),
                                new Zend_Search_Lucene_Index_Term('reproduce', 'contents'),
                                new Zend_Search_Lucene_Index_Term('requests', 'contents'),
                                new Zend_Search_Lucene_Index_Term('requirements', 'contents'),
                                new Zend_Search_Lucene_Index_Term('reserved', 'contents'),
                                new Zend_Search_Lucene_Index_Term('restrictions', 'contents'),
                                new Zend_Search_Lucene_Index_Term('resulting', 'contents'),
                                new Zend_Search_Lucene_Index_Term('retain', 'contents'),
                                new Zend_Search_Lucene_Index_Term('revision', 'contents'),
                                new Zend_Search_Lucene_Index_Term('right', 'contents'),
                                new Zend_Search_Lucene_Index_Term('rights', 'contents'),
                                new Zend_Search_Lucene_Index_Term('rpc', 'contents'),
                                new Zend_Search_Lucene_Index_Term('running', 'contents'),
                                new Zend_Search_Lucene_Index_Term('s', 'contents'),
                                new Zend_Search_Lucene_Index_Term('sample', 'contents'),
                                new Zend_Search_Lucene_Index_Term('schlitt', 'contents'),
                                new Zend_Search_Lucene_Index_Term('schmidt', 'contents'),
                                new Zend_Search_Lucene_Index_Term('screen', 'contents'),
                                new Zend_Search_Lucene_Index_Term('script', 'contents'),
                                new Zend_Search_Lucene_Index_Term('sect', 'contents'),
                                new Zend_Search_Lucene_Index_Term('section', 'contents'),
                                new Zend_Search_Lucene_Index_Term('see', 'contents'),
                                new Zend_Search_Lucene_Index_Term('send', 'contents'),
                                new Zend_Search_Lucene_Index_Term('seriously', 'contents'),
                                new Zend_Search_Lucene_Index_Term('service', 'contents'),
                                new Zend_Search_Lucene_Index_Term('services', 'contents'),
                                new Zend_Search_Lucene_Index_Term('set', 'contents'),
                                new Zend_Search_Lucene_Index_Term('several', 'contents'),
                                new Zend_Search_Lucene_Index_Term('shall', 'contents'),
                                new Zend_Search_Lucene_Index_Term('she', 'contents'),
                                new Zend_Search_Lucene_Index_Term('should', 'contents'),
                                new Zend_Search_Lucene_Index_Term('similar', 'contents'),
                                new Zend_Search_Lucene_Index_Term('so', 'contents'),
                                new Zend_Search_Lucene_Index_Term('software', 'contents'),
                                new Zend_Search_Lucene_Index_Term('some', 'contents'),
                                new Zend_Search_Lucene_Index_Term('something', 'contents'),
                                new Zend_Search_Lucene_Index_Term('source', 'contents'),
                                new Zend_Search_Lucene_Index_Term('sources', 'contents'),
                                new Zend_Search_Lucene_Index_Term('span', 'contents'),
                                new Zend_Search_Lucene_Index_Term('special', 'contents'),
                                new Zend_Search_Lucene_Index_Term('specific', 'contents'),
                                new Zend_Search_Lucene_Index_Term('speed', 'contents'),
                                new Zend_Search_Lucene_Index_Term('standard', 'contents'),
                                new Zend_Search_Lucene_Index_Term('standards', 'contents'),
                                new Zend_Search_Lucene_Index_Term('stefan', 'contents'),
                                new Zend_Search_Lucene_Index_Term('step', 'contents'),
                                new Zend_Search_Lucene_Index_Term('stephan', 'contents'),
                                new Zend_Search_Lucene_Index_Term('still', 'contents'),
                                new Zend_Search_Lucene_Index_Term('strict', 'contents'),
                                new Zend_Search_Lucene_Index_Term('structure', 'contents'),
                                new Zend_Search_Lucene_Index_Term('stylesheet', 'contents'),
                                new Zend_Search_Lucene_Index_Term('subject', 'contents'),
                                new Zend_Search_Lucene_Index_Term('submit', 'contents'),
                                new Zend_Search_Lucene_Index_Term('submitting', 'contents'),
                                new Zend_Search_Lucene_Index_Term('substantively', 'contents'),
                                new Zend_Search_Lucene_Index_Term('substitute', 'contents'),
                                new Zend_Search_Lucene_Index_Term('such', 'contents'),
                                new Zend_Search_Lucene_Index_Term('summary', 'contents'),
                                new Zend_Search_Lucene_Index_Term('support', 'contents'),
                                new Zend_Search_Lucene_Index_Term('sure', 'contents'),
                                new Zend_Search_Lucene_Index_Term('system', 'contents'),
                                new Zend_Search_Lucene_Index_Term('t', 'contents'),
                                new Zend_Search_Lucene_Index_Term('table', 'contents'),
                                new Zend_Search_Lucene_Index_Term('take', 'contents'),
                                new Zend_Search_Lucene_Index_Term('target', 'contents'),
                                new Zend_Search_Lucene_Index_Term('task', 'contents'),
                                new Zend_Search_Lucene_Index_Term('td', 'contents'),
                                new Zend_Search_Lucene_Index_Term('terms', 'contents'),
                                new Zend_Search_Lucene_Index_Term('test', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tested', 'contents'),
                                new Zend_Search_Lucene_Index_Term('text', 'contents'),
                                new Zend_Search_Lucene_Index_Term('th', 'contents'),
                                new Zend_Search_Lucene_Index_Term('that', 'contents'),
                                new Zend_Search_Lucene_Index_Term('the', 'contents'),
                                new Zend_Search_Lucene_Index_Term('their', 'contents'),
                                new Zend_Search_Lucene_Index_Term('them', 'contents'),
                                new Zend_Search_Lucene_Index_Term('theory', 'contents'),
                                new Zend_Search_Lucene_Index_Term('there', 'contents'),
                                new Zend_Search_Lucene_Index_Term('think', 'contents'),
                                new Zend_Search_Lucene_Index_Term('this', 'contents'),
                                new Zend_Search_Lucene_Index_Term('thomas', 'contents'),
                                new Zend_Search_Lucene_Index_Term('those', 'contents'),
                                new Zend_Search_Lucene_Index_Term('thus', 'contents'),
                                new Zend_Search_Lucene_Index_Term('time', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tips', 'contents'),
                                new Zend_Search_Lucene_Index_Term('title', 'contents'),
                                new Zend_Search_Lucene_Index_Term('titlepage', 'contents'),
                                new Zend_Search_Lucene_Index_Term('to', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tobias', 'contents'),
                                new Zend_Search_Lucene_Index_Term('toc', 'contents'),
                                new Zend_Search_Lucene_Index_Term('top', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tort', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tr', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tracking', 'contents'),
                                new Zend_Search_Lucene_Index_Term('translated', 'contents'),
                                new Zend_Search_Lucene_Index_Term('translating', 'contents'),
                                new Zend_Search_Lucene_Index_Term('translation', 'contents'),
                                new Zend_Search_Lucene_Index_Term('translations', 'contents'),
                                new Zend_Search_Lucene_Index_Term('translators', 'contents'),
                                new Zend_Search_Lucene_Index_Term('try', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tt', 'contents'),
                                new Zend_Search_Lucene_Index_Term('tuupola', 'contents'),
                                new Zend_Search_Lucene_Index_Term('txt', 'contents'),
                                new Zend_Search_Lucene_Index_Term('type', 'contents'),
                                new Zend_Search_Lucene_Index_Term('u', 'contents'),
                                new Zend_Search_Lucene_Index_Term('ul', 'contents'),
                                new Zend_Search_Lucene_Index_Term('unable', 'contents'),
                                new Zend_Search_Lucene_Index_Term('under', 'contents'),
                                new Zend_Search_Lucene_Index_Term('understand', 'contents'),
                                new Zend_Search_Lucene_Index_Term('unified', 'contents'),
                                new Zend_Search_Lucene_Index_Term('unless', 'contents'),
                                new Zend_Search_Lucene_Index_Term('up', 'contents'),
                                new Zend_Search_Lucene_Index_Term('us', 'contents'),
                                new Zend_Search_Lucene_Index_Term('use', 'contents'),
                                new Zend_Search_Lucene_Index_Term('used', 'contents'),
                                new Zend_Search_Lucene_Index_Term('useful', 'contents'),
                                new Zend_Search_Lucene_Index_Term('usefulinc', 'contents'),
                                new Zend_Search_Lucene_Index_Term('userinput', 'contents'),
                                new Zend_Search_Lucene_Index_Term('users', 'contents'),
                                new Zend_Search_Lucene_Index_Term('using', 'contents'),
                                new Zend_Search_Lucene_Index_Term('usually', 'contents'),
                                new Zend_Search_Lucene_Index_Term('v', 'contents'),
                                new Zend_Search_Lucene_Index_Term('valign', 'contents'),
                                new Zend_Search_Lucene_Index_Term('verbose', 'contents'),
                                new Zend_Search_Lucene_Index_Term('version', 'contents'),
                                new Zend_Search_Lucene_Index_Term('versions', 'contents'),
                                new Zend_Search_Lucene_Index_Term('vlink', 'contents'),
                                new Zend_Search_Lucene_Index_Term('wallner', 'contents'),
                                new Zend_Search_Lucene_Index_Term('warranties', 'contents'),
                                new Zend_Search_Lucene_Index_Term('way', 'contents'),
                                new Zend_Search_Lucene_Index_Term('ways', 'contents'),
                                new Zend_Search_Lucene_Index_Term('we', 'contents'),
                                new Zend_Search_Lucene_Index_Term('webservices', 'contents'),
                                new Zend_Search_Lucene_Index_Term('welcome', 'contents'),
                                new Zend_Search_Lucene_Index_Term('what', 'contents'),
                                new Zend_Search_Lucene_Index_Term('when', 'contents'),
                                new Zend_Search_Lucene_Index_Term('whether', 'contents'),
                                new Zend_Search_Lucene_Index_Term('which', 'contents'),
                                new Zend_Search_Lucene_Index_Term('width', 'contents'),
                                new Zend_Search_Lucene_Index_Term('will', 'contents'),
                                new Zend_Search_Lucene_Index_Term('wish', 'contents'),
                                new Zend_Search_Lucene_Index_Term('wishlist', 'contents'),
                                new Zend_Search_Lucene_Index_Term('wishlists', 'contents'),
                                new Zend_Search_Lucene_Index_Term('with', 'contents'),
                                new Zend_Search_Lucene_Index_Term('without', 'contents'),
                                new Zend_Search_Lucene_Index_Term('won', 'contents'),
                                new Zend_Search_Lucene_Index_Term('work', 'contents'),
                                new Zend_Search_Lucene_Index_Term('would', 'contents'),
                                new Zend_Search_Lucene_Index_Term('write', 'contents'),
                                new Zend_Search_Lucene_Index_Term('writing', 'contents'),
                                new Zend_Search_Lucene_Index_Term('written', 'contents'),
                                new Zend_Search_Lucene_Index_Term('www', 'contents'),
                                new Zend_Search_Lucene_Index_Term('xml', 'contents'),
                                new Zend_Search_Lucene_Index_Term('xmlrpc', 'contents'),
                                new Zend_Search_Lucene_Index_Term('you', 'contents'),
                                new Zend_Search_Lucene_Index_Term('your', 'contents'),
                                new Zend_Search_Lucene_Index_Term('1178009946', 'modified'),
                                new Zend_Search_Lucene_Index_Term('about', 'path'),
                                new Zend_Search_Lucene_Index_Term('authors', 'path'),
                                new Zend_Search_Lucene_Index_Term('bugs', 'path'),
                                new Zend_Search_Lucene_Index_Term('contributing', 'path'),
                                new Zend_Search_Lucene_Index_Term('copyright', 'path'),
                                new Zend_Search_Lucene_Index_Term('core', 'path'),
                                new Zend_Search_Lucene_Index_Term('documentation', 'path'),
                                new Zend_Search_Lucene_Index_Term('html', 'path'),
                                new Zend_Search_Lucene_Index_Term('indexsource', 'path'),
                                new Zend_Search_Lucene_Index_Term('newpackage', 'path'),
                                new Zend_Search_Lucene_Index_Term('patches', 'path'),
                                new Zend_Search_Lucene_Index_Term('pear', 'path'),
                                new Zend_Search_Lucene_Index_Term('wishlist', 'path')
                               ));

    }
}

