/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public class Id
extends SystemFunction {
    private boolean isSingletonId = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Id id = (Id)super.simplify(visitor);
        if (this.argument.length == 1) {
            id.addContextDocumentArgument(1, "id");
        }
        return id;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
        this.isSingletonId = !Cardinality.allowsMany(this.argument[0].getCardinality());
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        AxisExpression allElements = new AxisExpression(4, NodeKindTest.ELEMENT);
        allElements.setContainer(this.getContainer());
        target = target.createArc(allElements);
        return target;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo arg1 = (NodeInfo)this.argument[1].evaluateItem(context);
        if ((arg1 = arg1.getRoot()).getNodeKind() != 9) {
            this.dynamicError("In the id() function, the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg1;
        if (this.isSingletonId) {
            AtomicValue arg = (AtomicValue)this.argument[0].evaluateItem(context);
            if (arg == null) {
                return EmptyIterator.getInstance();
            }
            String idrefs = arg.getStringValue();
            return Id.getIdSingle(doc, idrefs);
        }
        SequenceIterator idrefs = this.argument[0].iterate(context);
        return Id.getIdMultiple(doc, idrefs);
    }

    public static SequenceIterator getIdSingle(DocumentInfo doc, String idrefs) throws XPathException {
        boolean white = false;
        for (int i = idrefs.length() - 1; i >= 0; --i) {
            char c = idrefs.charAt(i);
            if (c > ' ' || c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
            white = true;
            break;
        }
        if (white) {
            StringTokenIterator tokens = new StringTokenIterator(idrefs);
            IdMappingFunction map = new IdMappingFunction();
            map.document = doc;
            MappingIterator result = new MappingIterator(tokens, map);
            return new DocumentOrderIterator(result, LocalOrderComparer.getInstance());
        }
        return SingletonIterator.makeIterator(doc.selectID(idrefs));
    }

    public static SequenceIterator getIdMultiple(DocumentInfo doc, SequenceIterator idrefs) throws XPathException {
        IdMappingFunction map = new IdMappingFunction();
        map.document = doc;
        MappingIterator result = new MappingIterator(idrefs, map);
        return new DocumentOrderIterator(result, LocalOrderComparer.getInstance());
    }

    private static class IdMappingFunction
    implements MappingFunction {
        public DocumentInfo document;

        private IdMappingFunction() {
        }

        public SequenceIterator map(Item item) throws XPathException {
            String idrefs = Whitespace.trim(item.getStringValueCS());
            boolean white = false;
            for (int i = idrefs.length() - 1; i >= 0; --i) {
                char c = idrefs.charAt(i);
                if (c > ' ' || c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
                white = true;
                break;
            }
            if (white) {
                StringTokenIterator tokens = new StringTokenIterator(idrefs);
                IdMappingFunction submap = new IdMappingFunction();
                submap.document = this.document;
                return new MappingIterator(tokens, submap);
            }
            return SingletonIterator.makeIterator(this.document.selectID(idrefs));
        }
    }
}

