from spyceModule import spyceModule

__doc__ = '''This module takes care of presenting the portal.
Spyce lambdas are easier to use to perform the output.'''

class myPortal(spyceModule):
  def start(self):
    self.show = self._api.getModule('spylambda')(spysigPortal, spycodePortal)
    self.showView = self._api.getModule('spylambda')(spysigItem, spycodeItem)

spysigPortal = 'selection'
spycodePortal = '''
  <html><body>
    <table align=center valign=center border=1 width=100% bgcolor="#aaaaaa"><tr>
      <td width=30% >
        [[ for view in selection: {]]
          [[myPortal.showView(view['heading'], view['data'])]]
          <p>
        [[ } ]]
      </td>
      <td align=center valign=center width=50% ><b>main panel</b></td>
      <td align=center valign=center width=20% ><b>other stuff</b></td>
    </tr><table>
  </body></html>
'''

spysigItem = 'heading, data'
spycodeItem = '''
  <table cellspacing=0 border=0 bgcolor="#ffdddd" width=100% >
    <tr><td bgcolor="#bbddff" colspan=[[=max(map(len, data))]]>
      <b>[[=heading]]<b>
    </td></tr>
    [[ for row in data: { ]]
      <tr> 
        [[ for i in row: { ]]
          <td>[[=i]]</td> 
        [[ } ]]
      </tr>
    [[ } ]]
  </table>
'''
