/** @file RNAplot_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef RNAPLOT_CMDL_H
#define RNAPLOT_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNAPLOT_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNAPLOT_CMDLINE_PARSER_PACKAGE "RNAplot"
#endif

#ifndef RNAPLOT_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNAPLOT_CMDLINE_PARSER_PACKAGE_NAME "RNAplot"
#endif

#ifndef RNAPLOT_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNAPLOT_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct RNAplot_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int jobs_arg;	/**< @brief Split batch input into jobs and start processing in parallel using multiple threads. (default='0').  */
  char * jobs_orig;	/**< @brief Split batch input into jobs and start processing in parallel using multiple threads. original value given at command line.  */
  const char *jobs_help; /**< @brief Split batch input into jobs and start processing in parallel using multiple threads. help description.  */
  char ** infile_arg;	/**< @brief Read a file instead of reading from stdin..  */
  char ** infile_orig;	/**< @brief Read a file instead of reading from stdin. original value given at command line.  */
  unsigned int infile_min; /**< @brief Read a file instead of reading from stdin.'s minimum occurreces */
  unsigned int infile_max; /**< @brief Read a file instead of reading from stdin.'s maximum occurreces */
  const char *infile_help; /**< @brief Read a file instead of reading from stdin. help description.  */
  int msa_flag;	/**< @brief Input is multiple sequence alignment in Stockholm 1.0 format. (default=off).  */
  const char *msa_help; /**< @brief Input is multiple sequence alignment in Stockholm 1.0 format. help description.  */
  int mis_flag;	/**< @brief Output \"most informative sequence\" instead of simple consensus (default=off).  */
  const char *mis_help; /**< @brief Output \"most informative sequence\" instead of simple consensus help description.  */
  int covar_flag;	/**< @brief Annotate covariance of base pairs in consensus structure. (default=off).  */
  const char *covar_help; /**< @brief Annotate covariance of base pairs in consensus structure. help description.  */
  int aln_flag;	/**< @brief Produce a colored and structure annotated alignment in PostScript format in the file \"aln.ps\" in the current directory. (default=off).  */
  const char *aln_help; /**< @brief Produce a colored and structure annotated alignment in PostScript format in the file \"aln.ps\" in the current directory. help description.  */
  int aln_EPS_cols_arg;	/**< @brief Number of columns in colored EPS alignment output. (default='60').  */
  char * aln_EPS_cols_orig;	/**< @brief Number of columns in colored EPS alignment output. original value given at command line.  */
  const char *aln_EPS_cols_help; /**< @brief Number of columns in colored EPS alignment output. help description.  */
  int layout_type_arg;	/**< @brief Choose the plotting layout algorithm. (default='1').  */
  char * layout_type_orig;	/**< @brief Choose the plotting layout algorithm. original value given at command line.  */
  const char *layout_type_help; /**< @brief Choose the plotting layout algorithm. help description.  */
  int noOptimization_flag;	/**< @brief Disable the drawing space optimization of RNApuzzler. (default=off).  */
  const char *noOptimization_help; /**< @brief Disable the drawing space optimization of RNApuzzler. help description.  */
  int ignoreExteriorIntersections_flag;	/**< @brief Ignore intersections with the exterior loop within the RNA-tree. (default=off).  */
  const char *ignoreExteriorIntersections_help; /**< @brief Ignore intersections with the exterior loop within the RNA-tree. help description.  */
  int ignoreAncestorIntersections_flag;	/**< @brief Ignore ancestor intersections within the RNA-tree. (default=off).  */
  const char *ignoreAncestorIntersections_help; /**< @brief Ignore ancestor intersections within the RNA-tree. help description.  */
  int ignoreSiblingIntersections_flag;	/**< @brief Ignore sibling intersections within the RNA-tree (default=off).  */
  const char *ignoreSiblingIntersections_help; /**< @brief Ignore sibling intersections within the RNA-tree help description.  */
  int allowFlipping_flag;	/**< @brief Allow flipping of exterior loop branches to resolve exterior branch intersections. (default=off).  */
  const char *allowFlipping_help; /**< @brief Allow flipping of exterior loop branches to resolve exterior branch intersections. help description.  */
  char * output_format_arg;	/**< @brief Specify output format. (default='ps').  */
  char * output_format_orig;	/**< @brief Specify output format. original value given at command line.  */
  const char *output_format_help; /**< @brief Specify output format. help description.  */
  char * pre_arg;	/**< @brief Add annotation macros to postscript file, and add the postscript code in \"string\" just before the code to draw the structure. This is an easy way to add annotation..  */
  char * pre_orig;	/**< @brief Add annotation macros to postscript file, and add the postscript code in \"string\" just before the code to draw the structure. This is an easy way to add annotation. original value given at command line.  */
  const char *pre_help; /**< @brief Add annotation macros to postscript file, and add the postscript code in \"string\" just before the code to draw the structure. This is an easy way to add annotation. help description.  */
  char * post_arg;	/**< @brief Same as --pre but in contrast to adding the annotation macros. E.g to mark position 15 with circle use --post \"15 cmark\"..  */
  char * post_orig;	/**< @brief Same as --pre but in contrast to adding the annotation macros. E.g to mark position 15 with circle use --post \"15 cmark\". original value given at command line.  */
  const char *post_help; /**< @brief Same as --pre but in contrast to adding the annotation macros. E.g to mark position 15 with circle use --post \"15 cmark\". help description.  */
  int auto_id_flag;	/**< @brief Automatically generate an ID for each sequence. (default=off).  */
  const char *auto_id_help; /**< @brief Automatically generate an ID for each sequence. help description.  */
  char * id_prefix_arg;	/**< @brief Prefix for automatically generated IDs (as used in output file names). (default='sequence').  */
  char * id_prefix_orig;	/**< @brief Prefix for automatically generated IDs (as used in output file names). original value given at command line.  */
  const char *id_prefix_help; /**< @brief Prefix for automatically generated IDs (as used in output file names). help description.  */
  char * id_delim_arg;	/**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names). (default='_').  */
  char * id_delim_orig;	/**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names). original value given at command line.  */
  const char *id_delim_help; /**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names). help description.  */
  int id_digits_arg;	/**< @brief Specify the number of digits of the counter in automatically generated alignment IDs. (default='4').  */
  char * id_digits_orig;	/**< @brief Specify the number of digits of the counter in automatically generated alignment IDs. original value given at command line.  */
  const char *id_digits_help; /**< @brief Specify the number of digits of the counter in automatically generated alignment IDs. help description.  */
  long id_start_arg;	/**< @brief Specify the first number in automatically generated alignment IDs. (default='1').  */
  char * id_start_orig;	/**< @brief Specify the first number in automatically generated alignment IDs. original value given at command line.  */
  const char *id_start_help; /**< @brief Specify the first number in automatically generated alignment IDs. help description.  */
  char * filename_delim_arg;	/**< @brief Change the delimiting character that is used for sanitized filenames
 (default='ID-delimiter').  */
  char * filename_delim_orig;	/**< @brief Change the delimiting character that is used for sanitized filenames
 original value given at command line.  */
  const char *filename_delim_help; /**< @brief Change the delimiting character that is used for sanitized filenames
 help description.  */
  int filename_full_flag;	/**< @brief Use full FASTA header to create filenames. (default=off).  */
  const char *filename_full_help; /**< @brief Use full FASTA header to create filenames. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int jobs_given ;	/**< @brief Whether jobs was given.  */
  unsigned int infile_given ;	/**< @brief Whether infile was given.  */
  unsigned int msa_given ;	/**< @brief Whether msa was given.  */
  unsigned int mis_given ;	/**< @brief Whether mis was given.  */
  unsigned int covar_given ;	/**< @brief Whether covar was given.  */
  unsigned int aln_given ;	/**< @brief Whether aln was given.  */
  unsigned int aln_EPS_cols_given ;	/**< @brief Whether aln-EPS-cols was given.  */
  unsigned int layout_type_given ;	/**< @brief Whether layout-type was given.  */
  unsigned int noOptimization_given ;	/**< @brief Whether noOptimization was given.  */
  unsigned int ignoreExteriorIntersections_given ;	/**< @brief Whether ignoreExteriorIntersections was given.  */
  unsigned int ignoreAncestorIntersections_given ;	/**< @brief Whether ignoreAncestorIntersections was given.  */
  unsigned int ignoreSiblingIntersections_given ;	/**< @brief Whether ignoreSiblingIntersections was given.  */
  unsigned int allowFlipping_given ;	/**< @brief Whether allowFlipping was given.  */
  unsigned int output_format_given ;	/**< @brief Whether output-format was given.  */
  unsigned int pre_given ;	/**< @brief Whether pre was given.  */
  unsigned int post_given ;	/**< @brief Whether post was given.  */
  unsigned int auto_id_given ;	/**< @brief Whether auto-id was given.  */
  unsigned int id_prefix_given ;	/**< @brief Whether id-prefix was given.  */
  unsigned int id_delim_given ;	/**< @brief Whether id-delim was given.  */
  unsigned int id_digits_given ;	/**< @brief Whether id-digits was given.  */
  unsigned int id_start_given ;	/**< @brief Whether id-start was given.  */
  unsigned int filename_delim_given ;	/**< @brief Whether filename-delim was given.  */
  unsigned int filename_full_given ;	/**< @brief Whether filename-full was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAplot_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAplot_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAplot_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAplot_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAplot_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAplot_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAplot_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *RNAplot_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *RNAplot_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAplot_cmdline_parser (int argc, char **argv,
  struct RNAplot_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAplot_cmdline_parser_ext() instead
 */
int RNAplot_cmdline_parser2 (int argc, char **argv,
  struct RNAplot_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAplot_cmdline_parser_ext (int argc, char **argv,
  struct RNAplot_args_info *args_info,
  struct RNAplot_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAplot_cmdline_parser_dump(FILE *outfile,
  struct RNAplot_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAplot_cmdline_parser_file_save(const char *filename,
  struct RNAplot_args_info *args_info);

/**
 * Print the help
 */
void RNAplot_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void RNAplot_cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void RNAplot_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void RNAplot_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAplot_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAplot_cmdline_parser_params_init(struct RNAplot_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAplot_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAplot_cmdline_parser_params structure
 */
struct RNAplot_cmdline_parser_params *RNAplot_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAplot_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAplot_cmdline_parser_init (struct RNAplot_args_info *args_info);
/**
 * Deallocates the string fields of the RNAplot_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAplot_cmdline_parser_free (struct RNAplot_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAplot_cmdline_parser_required (struct RNAplot_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNAPLOT_CMDL_H */
