/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /usr/bin/gengetopt -i RNAup.ggo --file-name=RNAup_cmdl --include-getopt --default-optional --func-name=RNAup_cmdline_parser --arg-struct-name=RNAup_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAup_cmdl.h"

const char *RNAup_args_info_purpose = "Calculate the thermodynamics of RNA-RNA interactions";

const char *RNAup_args_info_usage = "Usage: RNAup [OPTION]...";

const char *RNAup_args_info_versiontext = "";

const char *RNAup_args_info_description = "RNAup calculates the thermodynamics of RNA-RNA interactions, by decomposing the\nbinding into two stages. (1) First the probability that a potential binding\nsites remains unpaired (equivalent to the free energy needed to open the site)\nis computed. (2) Then this accessibility is combined with the interaction\nenergy to obtain the total binding energy. All calculations are done by\ncomputing partition functions over all possible conformations.\n";

const char *RNAup_args_info_detailed_help[] = {
  "  -h, --help                  Print help and exit",
  "      --detailed-help         Print help, including all details and hidden\n                                options, and exit",
  "      --full-help             Print help, including hidden options, and exit",
  "  -V, --version               Print version and exit",
  "\nGeneral Options:",
  "  Below are command line options which alter the general behavior of this\n  program\n",
  "  -C, --constraint            Calculate structures subject to constraints.\n                                  (default=off)",
  "  The program reads first the sequence(s), then a string containing constraints\n  on the structure encoded with the symbols:\n   . (no constraint for this base)\n\n   x (the base is unpaired)\n   < (base i is paired with a base j>i) (solely used for calculation of\n  unpaired regions)\n   > (base i is paired with a base j<i) (solely used for calculation of\n  unpaired regions)\n   ( ) (base i pairs base j)\n   | (the corresponding base has to be paired intermolecularily (works only in\n  interaction mode)\n\n",
  "  -o, --no_output_file        Do not produce an output file\n\n                                  (default=off)",
  "      --no_header             Do not produce a header with the command line\n                                parameters used in the outputfile\n\n                                  (default=off)",
  "      --noconv                Do not automatically substitude nucleotide \"T\"\n                                with \"U\"\n\n                                  (default=off)",
  "\nCalculations of opening energies:",
  "  -u, --ulength=length        specifies the length of the unstructured region\n                                in the output.\n                                  (default=`4')",
  "  The probability of being unpaired is plotted on the right border of the\n  unpaired region. You can specify up to 20 different length values: use \"-\"\n  to specify a range of continuous values (e.g. -u 4-8) or specify a list of\n  comma separated values (e.g. -u 4,8,15).\n\n",
  "  -c, --contributions=SHIME   Specify the contributions listed in the output\n                                  (default=`S')",
  "  By default only the full probability of being unpaired is plotted. The -c\n  option allows one to get the different contributions (c) to the probability\n  of being unpaired: The full probability of being unpaired (\"S\" is the sum\n  of the probability of being unpaired in the exterior loop (\"E\"), within a\n  hairpin loop (\"H\"), within an interior loop (\"I\") and within a multiloop\n  (\"M\"). Any combination of these letters may be given.\n\n",
  "\nCalculations of RNA-RNA interactions:",
  "  -w, --window=INT            Determine the maximal length of the region of\n                                interaction\n\n                                  (default=`25')",
  "  -b, --include_both          Include the probability of unpaired regions in\n                                both (b) RNAs. By default\n                                only the probability of being unpaired in the\n                                longer RNA (target) is used.\n\n                                  (default=off)",
  "  -5, --extend5=INT           Extend the region of interaction in the target to\n                                some residues on the 5' side\n",
  "  The underlying assumption is that it is favorable for an interaction if not\n  only the direct region of contact is unpaired but also a few residues 5'\n\n",
  "  -3, --extend3=INT           Extend the region of interaction in the target to\n                                some residues on the 3' side\n",
  "  The underlying assumption is that it is favorable for an interaction if not\n  only the direct region of contact is unpaired but also a few residues 3'\n\n",
  "      --interaction_pairwise  Activate pairwise interaction mode\n                                  (default=off)",
  "  The first sequence interacts with the 2nd, the third with the 4th etc. If\n  activated, two interacting sequences may be given in a single line separated\n  by \"&\" or each sequence may be given on an extra line.\n\n",
  "      --interaction_first     Activate interaction mode using first sequence\n                                only\n                                  (default=off)",
  "  The interaction of each sequence with the first one is calculated (e.g.\n  interaction of one mRNA with many small RNAs). Each sequence has to be given\n  on an extra line\n\n",
  "\nModel Details:",
  "  -S, --pfScale=DOUBLE        In the calculation of the pf use scale*mfe as an\n                                estimate for the ensemble free energy (used to\n                                avoid overflows). The default is 1.07, useful\n                                values are 1.0 to 1.2. Occasionally needed for\n                                long sequences.\n                                You can also recompile the program to use\n                                double precision (see the README file).\n\n",
  "  -T, --temp=DOUBLE           Rescale energy parameters to a temperature of\n                                temp C. Default is 37C.\n\n",
  "  -4, --noTetra               Do not include special tabulated stabilizing\n                                energies for tri-, tetra- and hexaloop\n                                hairpins. Mostly for testing.\n\n                                  (default=off)",
  "  -d, --dangles=INT           How to treat \"dangling end\" energies for bases\n                                adjacent to helices in free ends and\n                                multi-loops\n                                  (default=`2')",
  "  \n  With -d2 dangling energies will be added for the bases adjacent to a helix on\n  both sides in any case.\n   The option -d0 ignores dangling ends altogether (mostly for debugging).\n\n",
  "      --noLP                  Produce structures without lonely pairs (helices\n                                of length 1).\n                                  (default=off)",
  "  For partition function folding this only disallows pairs that can only occur\n  isolated. Other pairs may still occasionally occur as helices of length 1.\n\n",
  "      --noGU                  Do not allow GU pairs\n\n                                  (default=off)",
  "      --noClosingGU           Do not allow GU pairs at the end of helices\n\n                                  (default=off)",
  "  -P, --paramFile=paramfile   Read energy parameters from paramfile, instead of\n                                using the default parameter set.\n",
  "  Different sets of energy parameters for RNA and DNA should accompany your\n  distribution.\n  See the RNAlib documentation for details on the file format. When passing the\n  placeholder file name \"DNA\", DNA parameters are loaded without the need to\n  actually specify any input file.\n\n",
  "      --nsp=STRING            Allow other pairs in addition to the usual\n                                AU,GC,and GU pairs.\n",
  "  Its argument is a comma separated list of additionally allowed pairs. If the\n  first character is a \"-\" then AB will imply that AB and BA are allowed\n  pairs.\n  e.g. RNAfold -nsp -GA  will allow GA and AG pairs. Nonstandard pairs are\n  given 0 stacking energy.\n\n",
  "  -e, --energyModel=INT       Rarely used option to fold sequences from the\n                                artificial ABCD... alphabet, where A pairs B,\n                                C-D etc.  Use the energy parameters for GC (-e\n                                1) or AU (-e 2) pairs.\n\n",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n\n",
    0
};
static void
init_full_help_array(void)
{
  RNAup_args_info_full_help[0] = RNAup_args_info_detailed_help[0];
  RNAup_args_info_full_help[1] = RNAup_args_info_detailed_help[1];
  RNAup_args_info_full_help[2] = RNAup_args_info_detailed_help[2];
  RNAup_args_info_full_help[3] = RNAup_args_info_detailed_help[3];
  RNAup_args_info_full_help[4] = RNAup_args_info_detailed_help[4];
  RNAup_args_info_full_help[5] = RNAup_args_info_detailed_help[5];
  RNAup_args_info_full_help[6] = RNAup_args_info_detailed_help[6];
  RNAup_args_info_full_help[7] = RNAup_args_info_detailed_help[8];
  RNAup_args_info_full_help[8] = RNAup_args_info_detailed_help[9];
  RNAup_args_info_full_help[9] = RNAup_args_info_detailed_help[10];
  RNAup_args_info_full_help[10] = RNAup_args_info_detailed_help[11];
  RNAup_args_info_full_help[11] = RNAup_args_info_detailed_help[12];
  RNAup_args_info_full_help[12] = RNAup_args_info_detailed_help[14];
  RNAup_args_info_full_help[13] = RNAup_args_info_detailed_help[16];
  RNAup_args_info_full_help[14] = RNAup_args_info_detailed_help[17];
  RNAup_args_info_full_help[15] = RNAup_args_info_detailed_help[18];
  RNAup_args_info_full_help[16] = RNAup_args_info_detailed_help[19];
  RNAup_args_info_full_help[17] = RNAup_args_info_detailed_help[21];
  RNAup_args_info_full_help[18] = RNAup_args_info_detailed_help[23];
  RNAup_args_info_full_help[19] = RNAup_args_info_detailed_help[25];
  RNAup_args_info_full_help[20] = RNAup_args_info_detailed_help[27];
  RNAup_args_info_full_help[21] = RNAup_args_info_detailed_help[28];
  RNAup_args_info_full_help[22] = RNAup_args_info_detailed_help[29];
  RNAup_args_info_full_help[23] = RNAup_args_info_detailed_help[30];
  RNAup_args_info_full_help[24] = RNAup_args_info_detailed_help[31];
  RNAup_args_info_full_help[25] = RNAup_args_info_detailed_help[33];
  RNAup_args_info_full_help[26] = RNAup_args_info_detailed_help[35];
  RNAup_args_info_full_help[27] = RNAup_args_info_detailed_help[36];
  RNAup_args_info_full_help[28] = RNAup_args_info_detailed_help[37];
  RNAup_args_info_full_help[29] = RNAup_args_info_detailed_help[39];
  RNAup_args_info_full_help[30] = RNAup_args_info_detailed_help[41];
  RNAup_args_info_full_help[31] = RNAup_args_info_detailed_help[42];
  RNAup_args_info_full_help[32] = 0; 
  
}

const char *RNAup_args_info_full_help[33];

static void
init_help_array(void)
{
  RNAup_args_info_help[0] = RNAup_args_info_detailed_help[0];
  RNAup_args_info_help[1] = RNAup_args_info_detailed_help[1];
  RNAup_args_info_help[2] = RNAup_args_info_detailed_help[2];
  RNAup_args_info_help[3] = RNAup_args_info_detailed_help[3];
  RNAup_args_info_help[4] = RNAup_args_info_detailed_help[4];
  RNAup_args_info_help[5] = RNAup_args_info_detailed_help[5];
  RNAup_args_info_help[6] = RNAup_args_info_detailed_help[6];
  RNAup_args_info_help[7] = RNAup_args_info_detailed_help[8];
  RNAup_args_info_help[8] = RNAup_args_info_detailed_help[9];
  RNAup_args_info_help[9] = RNAup_args_info_detailed_help[10];
  RNAup_args_info_help[10] = RNAup_args_info_detailed_help[11];
  RNAup_args_info_help[11] = RNAup_args_info_detailed_help[12];
  RNAup_args_info_help[12] = RNAup_args_info_detailed_help[14];
  RNAup_args_info_help[13] = RNAup_args_info_detailed_help[16];
  RNAup_args_info_help[14] = RNAup_args_info_detailed_help[17];
  RNAup_args_info_help[15] = RNAup_args_info_detailed_help[18];
  RNAup_args_info_help[16] = RNAup_args_info_detailed_help[19];
  RNAup_args_info_help[17] = RNAup_args_info_detailed_help[21];
  RNAup_args_info_help[18] = RNAup_args_info_detailed_help[23];
  RNAup_args_info_help[19] = RNAup_args_info_detailed_help[25];
  RNAup_args_info_help[20] = RNAup_args_info_detailed_help[27];
  RNAup_args_info_help[21] = RNAup_args_info_detailed_help[29];
  RNAup_args_info_help[22] = RNAup_args_info_detailed_help[30];
  RNAup_args_info_help[23] = RNAup_args_info_detailed_help[31];
  RNAup_args_info_help[24] = RNAup_args_info_detailed_help[33];
  RNAup_args_info_help[25] = RNAup_args_info_detailed_help[35];
  RNAup_args_info_help[26] = RNAup_args_info_detailed_help[36];
  RNAup_args_info_help[27] = RNAup_args_info_detailed_help[37];
  RNAup_args_info_help[28] = RNAup_args_info_detailed_help[42];
  RNAup_args_info_help[29] = 0; 
  
}

const char *RNAup_args_info_help[30];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_DOUBLE
} RNAup_cmdline_parser_arg_type;

static
void clear_given (struct RNAup_args_info *args_info);
static
void clear_args (struct RNAup_args_info *args_info);

static int
RNAup_cmdline_parser_internal (int argc, char **argv, struct RNAup_args_info *args_info,
                        struct RNAup_cmdline_parser_params *params, const char *additional_error);

static int
RNAup_cmdline_parser_required2 (struct RNAup_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAup_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->constraint_given = 0 ;
  args_info->no_output_file_given = 0 ;
  args_info->no_header_given = 0 ;
  args_info->noconv_given = 0 ;
  args_info->ulength_given = 0 ;
  args_info->contributions_given = 0 ;
  args_info->window_given = 0 ;
  args_info->include_both_given = 0 ;
  args_info->extend5_given = 0 ;
  args_info->extend3_given = 0 ;
  args_info->interaction_pairwise_given = 0 ;
  args_info->interaction_first_given = 0 ;
  args_info->pfScale_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->noTetra_given = 0 ;
  args_info->dangles_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->noGU_given = 0 ;
  args_info->noClosingGU_given = 0 ;
  args_info->paramFile_given = 0 ;
  args_info->nsp_given = 0 ;
  args_info->energyModel_given = 0 ;
}

static
void clear_args (struct RNAup_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->constraint_flag = 0;
  args_info->no_output_file_flag = 0;
  args_info->no_header_flag = 0;
  args_info->noconv_flag = 0;
  args_info->ulength_arg = NULL;
  args_info->ulength_orig = NULL;
  args_info->contributions_arg = gengetopt_strdup ("S");
  args_info->contributions_orig = NULL;
  args_info->window_arg = 25;
  args_info->window_orig = NULL;
  args_info->include_both_flag = 0;
  args_info->extend5_orig = NULL;
  args_info->extend3_orig = NULL;
  args_info->interaction_pairwise_flag = 0;
  args_info->interaction_first_flag = 0;
  args_info->pfScale_orig = NULL;
  args_info->temp_orig = NULL;
  args_info->noTetra_flag = 0;
  args_info->dangles_arg = 2;
  args_info->dangles_orig = NULL;
  args_info->noLP_flag = 0;
  args_info->noGU_flag = 0;
  args_info->noClosingGU_flag = 0;
  args_info->paramFile_arg = NULL;
  args_info->paramFile_orig = NULL;
  args_info->nsp_arg = NULL;
  args_info->nsp_orig = NULL;
  args_info->energyModel_orig = NULL;
  
}

static
void init_args_info(struct RNAup_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAup_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAup_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAup_args_info_detailed_help[2] ;
  args_info->version_help = RNAup_args_info_detailed_help[3] ;
  args_info->constraint_help = RNAup_args_info_detailed_help[6] ;
  args_info->no_output_file_help = RNAup_args_info_detailed_help[8] ;
  args_info->no_header_help = RNAup_args_info_detailed_help[9] ;
  args_info->noconv_help = RNAup_args_info_detailed_help[10] ;
  args_info->ulength_help = RNAup_args_info_detailed_help[12] ;
  args_info->ulength_min = 0;
  args_info->ulength_max = 0;
  args_info->contributions_help = RNAup_args_info_detailed_help[14] ;
  args_info->window_help = RNAup_args_info_detailed_help[17] ;
  args_info->include_both_help = RNAup_args_info_detailed_help[18] ;
  args_info->extend5_help = RNAup_args_info_detailed_help[19] ;
  args_info->extend3_help = RNAup_args_info_detailed_help[21] ;
  args_info->interaction_pairwise_help = RNAup_args_info_detailed_help[23] ;
  args_info->interaction_first_help = RNAup_args_info_detailed_help[25] ;
  args_info->pfScale_help = RNAup_args_info_detailed_help[28] ;
  args_info->temp_help = RNAup_args_info_detailed_help[29] ;
  args_info->noTetra_help = RNAup_args_info_detailed_help[30] ;
  args_info->dangles_help = RNAup_args_info_detailed_help[31] ;
  args_info->noLP_help = RNAup_args_info_detailed_help[33] ;
  args_info->noGU_help = RNAup_args_info_detailed_help[35] ;
  args_info->noClosingGU_help = RNAup_args_info_detailed_help[36] ;
  args_info->paramFile_help = RNAup_args_info_detailed_help[37] ;
  args_info->nsp_help = RNAup_args_info_detailed_help[39] ;
  args_info->energyModel_help = RNAup_args_info_detailed_help[41] ;
  
}

void
RNAup_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNAUP_CMDLINE_PARSER_PACKAGE_NAME) ? RNAUP_CMDLINE_PARSER_PACKAGE_NAME : RNAUP_CMDLINE_PARSER_PACKAGE),
     RNAUP_CMDLINE_PARSER_VERSION);

  if (strlen(RNAup_args_info_versiontext) > 0)
    printf("\n%s\n", RNAup_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(RNAup_args_info_purpose);
	size_t len_usage = strlen(RNAup_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", RNAup_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", RNAup_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(RNAup_args_info_description) > 0) {
		printf("%s\n\n", RNAup_args_info_description);
	}
}

void
RNAup_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAup_args_info_help[i])
    printf("%s\n", RNAup_args_info_help[i++]);
}

void
RNAup_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAup_args_info_full_help[i])
    printf("%s\n", RNAup_args_info_full_help[i++]);
}

void
RNAup_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAup_args_info_detailed_help[i])
    printf("%s\n", RNAup_args_info_detailed_help[i++]);
}

void
RNAup_cmdline_parser_init (struct RNAup_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
RNAup_cmdline_parser_params_init(struct RNAup_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAup_cmdline_parser_params *
RNAup_cmdline_parser_params_create(void)
{
  struct RNAup_cmdline_parser_params *params = 
    (struct RNAup_cmdline_parser_params *)malloc(sizeof(struct RNAup_cmdline_parser_params));
  RNAup_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    double double_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
RNAup_cmdline_parser_release (struct RNAup_args_info *args_info)
{

  free_multiple_string_field (args_info->ulength_given, &(args_info->ulength_arg), &(args_info->ulength_orig));
  free_string_field (&(args_info->contributions_arg));
  free_string_field (&(args_info->contributions_orig));
  free_string_field (&(args_info->window_orig));
  free_string_field (&(args_info->extend5_orig));
  free_string_field (&(args_info->extend3_orig));
  free_string_field (&(args_info->pfScale_orig));
  free_string_field (&(args_info->temp_orig));
  free_string_field (&(args_info->dangles_orig));
  free_string_field (&(args_info->paramFile_arg));
  free_string_field (&(args_info->paramFile_orig));
  free_string_field (&(args_info->nsp_arg));
  free_string_field (&(args_info->nsp_orig));
  free_string_field (&(args_info->energyModel_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
RNAup_cmdline_parser_dump(FILE *outfile, struct RNAup_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNAUP_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->constraint_given)
    write_into_file(outfile, "constraint", 0, 0 );
  if (args_info->no_output_file_given)
    write_into_file(outfile, "no_output_file", 0, 0 );
  if (args_info->no_header_given)
    write_into_file(outfile, "no_header", 0, 0 );
  if (args_info->noconv_given)
    write_into_file(outfile, "noconv", 0, 0 );
  write_multiple_into_file(outfile, args_info->ulength_given, "ulength", args_info->ulength_orig, 0);
  if (args_info->contributions_given)
    write_into_file(outfile, "contributions", args_info->contributions_orig, 0);
  if (args_info->window_given)
    write_into_file(outfile, "window", args_info->window_orig, 0);
  if (args_info->include_both_given)
    write_into_file(outfile, "include_both", 0, 0 );
  if (args_info->extend5_given)
    write_into_file(outfile, "extend5", args_info->extend5_orig, 0);
  if (args_info->extend3_given)
    write_into_file(outfile, "extend3", args_info->extend3_orig, 0);
  if (args_info->interaction_pairwise_given)
    write_into_file(outfile, "interaction_pairwise", 0, 0 );
  if (args_info->interaction_first_given)
    write_into_file(outfile, "interaction_first", 0, 0 );
  if (args_info->pfScale_given)
    write_into_file(outfile, "pfScale", args_info->pfScale_orig, 0);
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  if (args_info->noTetra_given)
    write_into_file(outfile, "noTetra", 0, 0 );
  if (args_info->dangles_given)
    write_into_file(outfile, "dangles", args_info->dangles_orig, 0);
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->noGU_given)
    write_into_file(outfile, "noGU", 0, 0 );
  if (args_info->noClosingGU_given)
    write_into_file(outfile, "noClosingGU", 0, 0 );
  if (args_info->paramFile_given)
    write_into_file(outfile, "paramFile", args_info->paramFile_orig, 0);
  if (args_info->nsp_given)
    write_into_file(outfile, "nsp", args_info->nsp_orig, 0);
  if (args_info->energyModel_given)
    write_into_file(outfile, "energyModel", args_info->energyModel_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAup_cmdline_parser_file_save(const char *filename, struct RNAup_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNAUP_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAup_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAup_cmdline_parser_free (struct RNAup_args_info *args_info)
{
  RNAup_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
RNAup_cmdline_parser (int argc, char **argv, struct RNAup_args_info *args_info)
{
  return RNAup_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAup_cmdline_parser_ext (int argc, char **argv, struct RNAup_args_info *args_info,
                   struct RNAup_cmdline_parser_params *params)
{
  int result;
  result = RNAup_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAup_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAup_cmdline_parser2 (int argc, char **argv, struct RNAup_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAup_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAup_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAup_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAup_cmdline_parser_required (struct RNAup_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAup_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAup_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAup_cmdline_parser_required2 (struct RNAup_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->ulength_given, args_info->ulength_min, args_info->ulength_max, "'--ulength' ('-u')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAup_cmdline_parser_params.check_ambiguity
 * @param override @see RNAup_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAup_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               RNAup_cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               RNAup_cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_DOUBLE:
      *((double **)field) = (double *)realloc (*((double **)field), (field_given + prev_given) * sizeof (double)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_DOUBLE:
          (*((double **)field))[i + field_given] = tmp->arg.double_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_DOUBLE:
        if (! *((double **)field)) {
          *((double **)field) = (double *)malloc (sizeof (double));
          (*((double **)field))[0] = default_value->double_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
RNAup_cmdline_parser_internal (
  int argc, char **argv, struct RNAup_args_info *args_info,
                        struct RNAup_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  union generic_value multiple_default_value;

  struct generic_list * ulength_list = NULL;
  int error_occurred = 0;
  struct RNAup_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    RNAup_cmdline_parser_init (args_info);

  RNAup_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "constraint",	0, NULL, 'C' },
        { "no_output_file",	0, NULL, 'o' },
        { "no_header",	0, NULL, 0 },
        { "noconv",	0, NULL, 0 },
        { "ulength",	1, NULL, 'u' },
        { "contributions",	1, NULL, 'c' },
        { "window",	1, NULL, 'w' },
        { "include_both",	0, NULL, 'b' },
        { "extend5",	1, NULL, '5' },
        { "extend3",	1, NULL, '3' },
        { "interaction_pairwise",	0, NULL, 0 },
        { "interaction_first",	0, NULL, 0 },
        { "pfScale",	1, NULL, 'S' },
        { "temp",	1, NULL, 'T' },
        { "noTetra",	0, NULL, '4' },
        { "dangles",	1, NULL, 'd' },
        { "noLP",	0, NULL, 0 },
        { "noGU",	0, NULL, 0 },
        { "noClosingGU",	0, NULL, 0 },
        { "paramFile",	1, NULL, 'P' },
        { "nsp",	1, NULL, 0 },
        { "energyModel",	1, NULL, 'e' },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVCou:c:w:b5:3:S:T:4d:P:e:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAup_cmdline_parser_print_help ();
          RNAup_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAup_cmdline_parser_print_version ();
          RNAup_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'C':	/* Calculate structures subject to constraints.
.  */
        
        
          if (update_arg((void *)&(args_info->constraint_flag), 0, &(args_info->constraint_given),
              &(local_args_info.constraint_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "constraint", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Do not produce an output file
        
.  */
        
        
          if (update_arg((void *)&(args_info->no_output_file_flag), 0, &(args_info->no_output_file_given),
              &(local_args_info.no_output_file_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "no_output_file", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* specifies the length of the unstructured region in the output.
.  */
        
          if (update_multiple_arg_temp(&ulength_list, 
              &(local_args_info.ulength_given), optarg, 0, "4", ARG_STRING,
              "ulength", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Specify the contributions listed in the output
.  */
        
        
          if (update_arg( (void *)&(args_info->contributions_arg), 
               &(args_info->contributions_orig), &(args_info->contributions_given),
              &(local_args_info.contributions_given), optarg, 0, "S", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "contributions", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* Determine the maximal length of the region of interaction
        
.  */
        
        
          if (update_arg( (void *)&(args_info->window_arg), 
               &(args_info->window_orig), &(args_info->window_given),
              &(local_args_info.window_given), optarg, 0, "25", ARG_INT,
              check_ambiguity, override, 0, 0,
              "window", 'w',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Include the probability of unpaired regions in both (b) RNAs. By default
        only the probability of being unpaired in the longer RNA (target) is used.
        
.  */
        
        
          if (update_arg((void *)&(args_info->include_both_flag), 0, &(args_info->include_both_given),
              &(local_args_info.include_both_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "include_both", 'b',
              additional_error))
            goto failure;
        
          break;
        case '5':	/* Extend the region of interaction in the target to some residues on the 5' side
.  */
        
        
          if (update_arg( (void *)&(args_info->extend5_arg), 
               &(args_info->extend5_orig), &(args_info->extend5_given),
              &(local_args_info.extend5_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "extend5", '5',
              additional_error))
            goto failure;
        
          break;
        case '3':	/* Extend the region of interaction in the target to some residues on the 3' side
.  */
        
        
          if (update_arg( (void *)&(args_info->extend3_arg), 
               &(args_info->extend3_orig), &(args_info->extend3_given),
              &(local_args_info.extend3_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "extend3", '3',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows). The default is 1.07, useful values are 1.0 to 1.2. Occasionally needed for long sequences.
        You can also recompile the program to use double precision (see the README file).
        
.  */
        
        
          if (update_arg( (void *)&(args_info->pfScale_arg), 
               &(args_info->pfScale_orig), &(args_info->pfScale_given),
              &(local_args_info.pfScale_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "pfScale", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Rescale energy parameters to a temperature of temp C. Default is 37C.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case '4':	/* Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins. Mostly for testing.
        
.  */
        
        
          if (update_arg((void *)&(args_info->noTetra_flag), 0, &(args_info->noTetra_given),
              &(local_args_info.noTetra_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "noTetra", '4',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
.  */
        
        
          if (update_arg( (void *)&(args_info->dangles_arg), 
               &(args_info->dangles_orig), &(args_info->dangles_given),
              &(local_args_info.dangles_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangles", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Read energy parameters from paramfile, instead of using the default parameter set.
.  */
        
        
          if (update_arg( (void *)&(args_info->paramFile_arg), 
               &(args_info->paramFile_orig), &(args_info->paramFile_given),
              &(local_args_info.paramFile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "paramFile", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Rarely used option to fold sequences from the artificial ABCD... alphabet, where A pairs B, C-D etc.  Use the energy parameters for GC (-e 1) or AU (-e 2) pairs.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->energyModel_arg), 
               &(args_info->energyModel_orig), &(args_info->energyModel_given),
              &(local_args_info.energyModel_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "energyModel", 'e',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAup_cmdline_parser_print_detailed_help ();
            RNAup_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAup_cmdline_parser_print_full_help ();
            RNAup_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Do not produce a header with the command line parameters used in the outputfile
          
.  */
          if (strcmp (long_options[option_index].name, "no_header") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->no_header_flag), 0, &(args_info->no_header_given),
                &(local_args_info.no_header_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "no_header", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not automatically substitude nucleotide \"T\" with \"U\"
          
.  */
          else if (strcmp (long_options[option_index].name, "noconv") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noconv_flag), 0, &(args_info->noconv_given),
                &(local_args_info.noconv_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noconv", '-',
                additional_error))
              goto failure;
          
          }
          /* Activate pairwise interaction mode
.  */
          else if (strcmp (long_options[option_index].name, "interaction_pairwise") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->interaction_pairwise_flag), 0, &(args_info->interaction_pairwise_given),
                &(local_args_info.interaction_pairwise_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "interaction_pairwise", '-',
                additional_error))
              goto failure;
          
          }
          /* Activate interaction mode using first sequence only
.  */
          else if (strcmp (long_options[option_index].name, "interaction_first") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->interaction_first_flag), 0, &(args_info->interaction_first_given),
                &(local_args_info.interaction_first_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "interaction_first", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce structures without lonely pairs (helices of length 1).
.  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs
          
.  */
          else if (strcmp (long_options[option_index].name, "noGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noGU_flag), 0, &(args_info->noGU_given),
                &(local_args_info.noGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs at the end of helices
          
.  */
          else if (strcmp (long_options[option_index].name, "noClosingGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noClosingGU_flag), 0, &(args_info->noClosingGU_given),
                &(local_args_info.noClosingGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noClosingGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
          else if (strcmp (long_options[option_index].name, "nsp") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nsp_arg), 
                 &(args_info->nsp_orig), &(args_info->nsp_given),
                &(local_args_info.nsp_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "nsp", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNAUP_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  multiple_default_value.default_string_arg = "4";
  update_multiple_arg((void *)&(args_info->ulength_arg),
    &(args_info->ulength_orig), args_info->ulength_given,
    local_args_info.ulength_given, &multiple_default_value,
    ARG_STRING, ulength_list);

  args_info->ulength_given += local_args_info.ulength_given;
  local_args_info.ulength_given = 0;
  
  if (check_required)
    {
      error_occurred += RNAup_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAup_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (ulength_list, 1 );
  
  RNAup_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
