/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt -i RNAlocmin.ggo --file-name=RNAlocmin_cmdline --include-getopt --default-optional --unamed-opts

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAlocmin_cmdline.h"

const char *gengetopt_args_info_purpose = "Calculate local minima from structures via gradient walks. Example usage: \n    RNAsubopt -p 10000 < \"sequence.txt\" > \"suboptp.txt\"\n    RNAlocmin -s \"sequence.txt\" [OPTIONS] < \"suboptp.txt\"";

const char *gengetopt_args_info_usage = "Usage: RNAlocmin [OPTIONS]... [FILES]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_detailed_help[] = {
  "  -h, --help                 Print help and exit",
  "      --detailed-help        Print help, including all details and hidden\n                               options, and exit",
  "      --full-help            Print help, including hidden options, and exit",
  "  -V, --version              Print version and exit",
  "\nGeneral options:",
  "  -s, --seq=STRING           Sequence file in FASTA format. If the sequence is\n                               the first line of the input file, this is not\n                               needed  (default=`seq.txt')",
  "  -p, --previous=STRING      Previously found LM (output from RNAlocmin or\n                               barriers), if specified does not need --seq\n                               option",
  "  -m, --move=STRING          Move set:\n                               I ==> insertion & deletion of base pairs\n                               S ==> I&D& switch of base pairs  (possible\n                               values=\"I\", \"S\" default=`I')",
  "  -n, --min-num=INT          Maximal number of local minima returned\n                               (0 == unlimited)  (default=`100000')",
  "      --find-num=INT         Maximal number of local minima found\n                               (default = unlimited - crawl through whole input\n                               file)",
  "  -v, --verbose-lvl=INT      Level of verbosity (0 = nothing, 4 = full)\n                               WARNING: higher verbose levels increase the\n                               computation time  (default=`0')",
  "      --depth=INT            Depth of findpath search (higher value increases\n                               running time linearly)  (default=`10')",
  "      --minh=DOUBLE          Print only minima with energy barrier greater than\n                               this  (default=`0.0')",
  "      --minh-lite            When flooding with --minh option, search for only\n                               saddle (do not search for a LM that is lower).\n                               Increases efficiency a tiny bit, but when turned\n                               on, the results may omit some non-shallow\n                               minima, especially with higher --minh value.\n                               (default=off)",
  "  -w, --walk=STRING          Walking method used\n                               D ==> gradient descent\n                               F ==> use first found lower energy structure\n                               R ==> use random lower energy structure (does\n                               not work with --noLP and -m S options)\n                               (possible values=\"D\", \"F\", \"R\"\n                               default=`D')",
  "      --noLP                 Work only with canonical RNA structures (w/o\n                               isolated base pairs, cannot be combined with\n                               ranodm walk (-w R option) and shift move set (-m\n                               S))  (default=off)",
  "  -e, --useEOS               Use energy_of_structure_pt calculation instead of\n                               energy_of_move (slower, it should not affect\n                               results)  (default=off)",
  "  -P, --paramFile=STRING     Read energy parameters from paramfile, instead of\n                               using the default parameter set",
  "  -d, --dangles=INT          How to treat \"dangling end\" energies for bases\n                               adjacent to helices in free ends and multi-loops\n                                 (default=`2')",
  "  \n  With -d1 only unpaired bases can participate in at most one dangling end,\n  this is the default for mfe folding but unsupported for the partition\n  function folding.\n\n  With -d2 this check is ignored, dangling energies will be added for the bases\n  adjacent to a helix on both sides in any case; this is the default for\n  partition function folding (-p).\n  The option -d0 ignores dangling ends altogether (mostly for debugging).\n  With -d3 mfe folding will allow coaxial stacking of adjacent helices in\n  multi-loops. At the moment the implementation will not allow coaxial stacking\n  of the two interior pairs in a loop of degree 3 and works only for mfe\n  folding.\n\n  Note that by default (as well as with -d1 and -d3) pf and mfe folding treat\n  dangling ends differently. Use -d2 in addition to -p to ensure that both\n  algorithms use the same energy model.\n\n",
  "      --fix-barriers=STRING  Fix barrier file for interior loops (just\n                               recompute if all LM in barrier output are LM),\n                               if specified, does not need neither --previous\n                               nor --seq option",
  "  -k, --pseudoknots          Allow for pseudoknots according to \"gfold\" model\n                               - H, K, L, and M types (genus one) of\n                               pseudoknots are allowed (increases computation\n                               time greatly), cannot be combined with shift\n                               move set (-m S)  (default=off)",
  "      --just-read            Do not expect input from stdin, just do\n                               postprocessing.  (default=off)",
  "  -N, --neighborhood         Use the Neighborhood routines to perform gradient\n                               descend. Cannot be combined with shift move set\n                               (-m S) and pseudoknots (-k). Test option.\n                               (default=off)",
  "      --degeneracy-off       Do not deal with degeneracy, select the\n                               lexicographically first from the same energy\n                               neighbors.  (default=off)",
  "      --just-output          Do not store the minima and optimize, just compute\n                               directly minima and output them. Output file can\n                               contain duplicates.  (default=off)",
  "\nBarrier tree:",
  "  -b, --bartree              Generate an approximate barrier tree.\n                               (default=off)",
  "      --barr-name=STRING     Name of barrier tree output file, switches on -b\n                               flag.  (default=`treeRNAloc.ps')",
  "\nKinetics (rates for treekin program):",
  "      --barrier-file=STRING  File for saddle heights between LM (simulates the\n                               output format of barriers program)",
  "  -r, --rates                Create rates for treekin  (default=off)",
  "  -f, --rates-file=STRING    File where to write rates, switches on -r flag\n                               (default=`rates.out')",
  "  -T, --temp=DOUBLE          Temperature in Celsius (only for rates)\n                               (default=`37.0')",
  "\nFlooding parameters (flooding occurs only with -r, -b, or --minh option):",
  "      --floodPortion=DOUBLE  Fraction of minima to flood (floods first minima\n                               with low number of inwalking sample structures)\n                               (0.0 -> no flood; 1.0 -> try to flood all)\n                               Usable only with -r or -b options.\n                               (default=`0.95')",
  "      --floodMax=INT         Flood cap - how many structures to flood in one\n                               basin  (default=`1000')",
  "\nMiscelaneous:",
  "      --numIntervals=INT     Number of intervals for Jing's visualisation\n                               (default=`0')",
  "      --eRange=FLOAT         Report only LM, which energy is in range <MFE (or\n                               lowest found LM), MFE+eRange> in kcal/mol.",
  "      --allegiance=STRING    Filename where to output the allegiance of\n                               structures. Works properly only with RNAsubopt\n                               -e list.",
    0
};
static void
init_full_help_array(void)
{
  gengetopt_args_info_full_help[0] = gengetopt_args_info_detailed_help[0];
  gengetopt_args_info_full_help[1] = gengetopt_args_info_detailed_help[1];
  gengetopt_args_info_full_help[2] = gengetopt_args_info_detailed_help[2];
  gengetopt_args_info_full_help[3] = gengetopt_args_info_detailed_help[3];
  gengetopt_args_info_full_help[4] = gengetopt_args_info_detailed_help[4];
  gengetopt_args_info_full_help[5] = gengetopt_args_info_detailed_help[5];
  gengetopt_args_info_full_help[6] = gengetopt_args_info_detailed_help[6];
  gengetopt_args_info_full_help[7] = gengetopt_args_info_detailed_help[7];
  gengetopt_args_info_full_help[8] = gengetopt_args_info_detailed_help[8];
  gengetopt_args_info_full_help[9] = gengetopt_args_info_detailed_help[9];
  gengetopt_args_info_full_help[10] = gengetopt_args_info_detailed_help[10];
  gengetopt_args_info_full_help[11] = gengetopt_args_info_detailed_help[11];
  gengetopt_args_info_full_help[12] = gengetopt_args_info_detailed_help[12];
  gengetopt_args_info_full_help[13] = gengetopt_args_info_detailed_help[13];
  gengetopt_args_info_full_help[14] = gengetopt_args_info_detailed_help[14];
  gengetopt_args_info_full_help[15] = gengetopt_args_info_detailed_help[15];
  gengetopt_args_info_full_help[16] = gengetopt_args_info_detailed_help[16];
  gengetopt_args_info_full_help[17] = gengetopt_args_info_detailed_help[17];
  gengetopt_args_info_full_help[18] = gengetopt_args_info_detailed_help[18];
  gengetopt_args_info_full_help[19] = gengetopt_args_info_detailed_help[20];
  gengetopt_args_info_full_help[20] = gengetopt_args_info_detailed_help[21];
  gengetopt_args_info_full_help[21] = gengetopt_args_info_detailed_help[22];
  gengetopt_args_info_full_help[22] = gengetopt_args_info_detailed_help[23];
  gengetopt_args_info_full_help[23] = gengetopt_args_info_detailed_help[24];
  gengetopt_args_info_full_help[24] = gengetopt_args_info_detailed_help[25];
  gengetopt_args_info_full_help[25] = gengetopt_args_info_detailed_help[26];
  gengetopt_args_info_full_help[26] = gengetopt_args_info_detailed_help[27];
  gengetopt_args_info_full_help[27] = gengetopt_args_info_detailed_help[28];
  gengetopt_args_info_full_help[28] = gengetopt_args_info_detailed_help[29];
  gengetopt_args_info_full_help[29] = gengetopt_args_info_detailed_help[30];
  gengetopt_args_info_full_help[30] = gengetopt_args_info_detailed_help[31];
  gengetopt_args_info_full_help[31] = gengetopt_args_info_detailed_help[32];
  gengetopt_args_info_full_help[32] = gengetopt_args_info_detailed_help[33];
  gengetopt_args_info_full_help[33] = gengetopt_args_info_detailed_help[34];
  gengetopt_args_info_full_help[34] = gengetopt_args_info_detailed_help[35];
  gengetopt_args_info_full_help[35] = gengetopt_args_info_detailed_help[36];
  gengetopt_args_info_full_help[36] = gengetopt_args_info_detailed_help[37];
  gengetopt_args_info_full_help[37] = gengetopt_args_info_detailed_help[38];
  gengetopt_args_info_full_help[38] = gengetopt_args_info_detailed_help[39];
  gengetopt_args_info_full_help[39] = gengetopt_args_info_detailed_help[40];
  gengetopt_args_info_full_help[40] = 0; 
  
}

const char *gengetopt_args_info_full_help[41];

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_detailed_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_detailed_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_detailed_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_detailed_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_detailed_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_detailed_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_detailed_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_detailed_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_detailed_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_detailed_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_detailed_help[10];
  gengetopt_args_info_help[11] = gengetopt_args_info_detailed_help[11];
  gengetopt_args_info_help[12] = gengetopt_args_info_detailed_help[12];
  gengetopt_args_info_help[13] = gengetopt_args_info_detailed_help[14];
  gengetopt_args_info_help[14] = gengetopt_args_info_detailed_help[15];
  gengetopt_args_info_help[15] = gengetopt_args_info_detailed_help[17];
  gengetopt_args_info_help[16] = gengetopt_args_info_detailed_help[18];
  gengetopt_args_info_help[17] = gengetopt_args_info_detailed_help[21];
  gengetopt_args_info_help[18] = gengetopt_args_info_detailed_help[22];
  gengetopt_args_info_help[19] = gengetopt_args_info_detailed_help[23];
  gengetopt_args_info_help[20] = gengetopt_args_info_detailed_help[24];
  gengetopt_args_info_help[21] = gengetopt_args_info_detailed_help[25];
  gengetopt_args_info_help[22] = gengetopt_args_info_detailed_help[26];
  gengetopt_args_info_help[23] = gengetopt_args_info_detailed_help[27];
  gengetopt_args_info_help[24] = gengetopt_args_info_detailed_help[28];
  gengetopt_args_info_help[25] = gengetopt_args_info_detailed_help[29];
  gengetopt_args_info_help[26] = gengetopt_args_info_detailed_help[30];
  gengetopt_args_info_help[27] = gengetopt_args_info_detailed_help[31];
  gengetopt_args_info_help[28] = gengetopt_args_info_detailed_help[32];
  gengetopt_args_info_help[29] = gengetopt_args_info_detailed_help[33];
  gengetopt_args_info_help[30] = gengetopt_args_info_detailed_help[34];
  gengetopt_args_info_help[31] = gengetopt_args_info_detailed_help[35];
  gengetopt_args_info_help[32] = gengetopt_args_info_detailed_help[36];
  gengetopt_args_info_help[33] = gengetopt_args_info_detailed_help[37];
  gengetopt_args_info_help[34] = gengetopt_args_info_detailed_help[39];
  gengetopt_args_info_help[35] = 0; 
  
}

const char *gengetopt_args_info_help[36];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
  , ARG_DOUBLE
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


const char *cmdline_parser_move_values[] = {"I", "S", 0}; /*< Possible values for move. */
const char *cmdline_parser_walk_values[] = {"D", "F", "R", 0}; /*< Possible values for walk. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->seq_given = 0 ;
  args_info->previous_given = 0 ;
  args_info->move_given = 0 ;
  args_info->min_num_given = 0 ;
  args_info->find_num_given = 0 ;
  args_info->verbose_lvl_given = 0 ;
  args_info->depth_given = 0 ;
  args_info->minh_given = 0 ;
  args_info->minh_lite_given = 0 ;
  args_info->walk_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->useEOS_given = 0 ;
  args_info->paramFile_given = 0 ;
  args_info->dangles_given = 0 ;
  args_info->fix_barriers_given = 0 ;
  args_info->pseudoknots_given = 0 ;
  args_info->just_read_given = 0 ;
  args_info->neighborhood_given = 0 ;
  args_info->degeneracy_off_given = 0 ;
  args_info->just_output_given = 0 ;
  args_info->bartree_given = 0 ;
  args_info->barr_name_given = 0 ;
  args_info->barrier_file_given = 0 ;
  args_info->rates_given = 0 ;
  args_info->rates_file_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->floodPortion_given = 0 ;
  args_info->floodMax_given = 0 ;
  args_info->numIntervals_given = 0 ;
  args_info->eRange_given = 0 ;
  args_info->allegiance_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->seq_arg = gengetopt_strdup ("seq.txt");
  args_info->seq_orig = NULL;
  args_info->previous_arg = NULL;
  args_info->previous_orig = NULL;
  args_info->move_arg = gengetopt_strdup ("I");
  args_info->move_orig = NULL;
  args_info->min_num_arg = 100000;
  args_info->min_num_orig = NULL;
  args_info->find_num_orig = NULL;
  args_info->verbose_lvl_arg = 0;
  args_info->verbose_lvl_orig = NULL;
  args_info->depth_arg = 10;
  args_info->depth_orig = NULL;
  args_info->minh_arg = 0.0;
  args_info->minh_orig = NULL;
  args_info->minh_lite_flag = 0;
  args_info->walk_arg = gengetopt_strdup ("D");
  args_info->walk_orig = NULL;
  args_info->noLP_flag = 0;
  args_info->useEOS_flag = 0;
  args_info->paramFile_arg = NULL;
  args_info->paramFile_orig = NULL;
  args_info->dangles_arg = 2;
  args_info->dangles_orig = NULL;
  args_info->fix_barriers_arg = NULL;
  args_info->fix_barriers_orig = NULL;
  args_info->pseudoknots_flag = 0;
  args_info->just_read_flag = 0;
  args_info->neighborhood_flag = 0;
  args_info->degeneracy_off_flag = 0;
  args_info->just_output_flag = 0;
  args_info->bartree_flag = 0;
  args_info->barr_name_arg = gengetopt_strdup ("treeRNAloc.ps");
  args_info->barr_name_orig = NULL;
  args_info->barrier_file_arg = NULL;
  args_info->barrier_file_orig = NULL;
  args_info->rates_flag = 0;
  args_info->rates_file_arg = gengetopt_strdup ("rates.out");
  args_info->rates_file_orig = NULL;
  args_info->temp_arg = 37.0;
  args_info->temp_orig = NULL;
  args_info->floodPortion_arg = 0.95;
  args_info->floodPortion_orig = NULL;
  args_info->floodMax_arg = 1000;
  args_info->floodMax_orig = NULL;
  args_info->numIntervals_arg = 0;
  args_info->numIntervals_orig = NULL;
  args_info->eRange_orig = NULL;
  args_info->allegiance_arg = NULL;
  args_info->allegiance_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = gengetopt_args_info_detailed_help[0] ;
  args_info->detailed_help_help = gengetopt_args_info_detailed_help[1] ;
  args_info->full_help_help = gengetopt_args_info_detailed_help[2] ;
  args_info->version_help = gengetopt_args_info_detailed_help[3] ;
  args_info->seq_help = gengetopt_args_info_detailed_help[5] ;
  args_info->previous_help = gengetopt_args_info_detailed_help[6] ;
  args_info->move_help = gengetopt_args_info_detailed_help[7] ;
  args_info->min_num_help = gengetopt_args_info_detailed_help[8] ;
  args_info->find_num_help = gengetopt_args_info_detailed_help[9] ;
  args_info->verbose_lvl_help = gengetopt_args_info_detailed_help[10] ;
  args_info->depth_help = gengetopt_args_info_detailed_help[11] ;
  args_info->minh_help = gengetopt_args_info_detailed_help[12] ;
  args_info->minh_lite_help = gengetopt_args_info_detailed_help[13] ;
  args_info->walk_help = gengetopt_args_info_detailed_help[14] ;
  args_info->noLP_help = gengetopt_args_info_detailed_help[15] ;
  args_info->useEOS_help = gengetopt_args_info_detailed_help[16] ;
  args_info->paramFile_help = gengetopt_args_info_detailed_help[17] ;
  args_info->dangles_help = gengetopt_args_info_detailed_help[18] ;
  args_info->fix_barriers_help = gengetopt_args_info_detailed_help[20] ;
  args_info->pseudoknots_help = gengetopt_args_info_detailed_help[21] ;
  args_info->just_read_help = gengetopt_args_info_detailed_help[22] ;
  args_info->neighborhood_help = gengetopt_args_info_detailed_help[23] ;
  args_info->degeneracy_off_help = gengetopt_args_info_detailed_help[24] ;
  args_info->just_output_help = gengetopt_args_info_detailed_help[25] ;
  args_info->bartree_help = gengetopt_args_info_detailed_help[27] ;
  args_info->barr_name_help = gengetopt_args_info_detailed_help[28] ;
  args_info->barrier_file_help = gengetopt_args_info_detailed_help[30] ;
  args_info->rates_help = gengetopt_args_info_detailed_help[31] ;
  args_info->rates_file_help = gengetopt_args_info_detailed_help[32] ;
  args_info->temp_help = gengetopt_args_info_detailed_help[33] ;
  args_info->floodPortion_help = gengetopt_args_info_detailed_help[35] ;
  args_info->floodMax_help = gengetopt_args_info_detailed_help[36] ;
  args_info->numIntervals_help = gengetopt_args_info_detailed_help[38] ;
  args_info->eRange_help = gengetopt_args_info_detailed_help[39] ;
  args_info->allegiance_help = gengetopt_args_info_detailed_help[40] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_detailed_help[i])
    printf("%s\n", gengetopt_args_info_detailed_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->seq_arg));
  free_string_field (&(args_info->seq_orig));
  free_string_field (&(args_info->previous_arg));
  free_string_field (&(args_info->previous_orig));
  free_string_field (&(args_info->move_arg));
  free_string_field (&(args_info->move_orig));
  free_string_field (&(args_info->min_num_orig));
  free_string_field (&(args_info->find_num_orig));
  free_string_field (&(args_info->verbose_lvl_orig));
  free_string_field (&(args_info->depth_orig));
  free_string_field (&(args_info->minh_orig));
  free_string_field (&(args_info->walk_arg));
  free_string_field (&(args_info->walk_orig));
  free_string_field (&(args_info->paramFile_arg));
  free_string_field (&(args_info->paramFile_orig));
  free_string_field (&(args_info->dangles_orig));
  free_string_field (&(args_info->fix_barriers_arg));
  free_string_field (&(args_info->fix_barriers_orig));
  free_string_field (&(args_info->barr_name_arg));
  free_string_field (&(args_info->barr_name_orig));
  free_string_field (&(args_info->barrier_file_arg));
  free_string_field (&(args_info->barrier_file_orig));
  free_string_field (&(args_info->rates_file_arg));
  free_string_field (&(args_info->rates_file_orig));
  free_string_field (&(args_info->temp_orig));
  free_string_field (&(args_info->floodPortion_orig));
  free_string_field (&(args_info->floodMax_orig));
  free_string_field (&(args_info->numIntervals_orig));
  free_string_field (&(args_info->eRange_orig));
  free_string_field (&(args_info->allegiance_arg));
  free_string_field (&(args_info->allegiance_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->seq_given)
    write_into_file(outfile, "seq", args_info->seq_orig, 0);
  if (args_info->previous_given)
    write_into_file(outfile, "previous", args_info->previous_orig, 0);
  if (args_info->move_given)
    write_into_file(outfile, "move", args_info->move_orig, cmdline_parser_move_values);
  if (args_info->min_num_given)
    write_into_file(outfile, "min-num", args_info->min_num_orig, 0);
  if (args_info->find_num_given)
    write_into_file(outfile, "find-num", args_info->find_num_orig, 0);
  if (args_info->verbose_lvl_given)
    write_into_file(outfile, "verbose-lvl", args_info->verbose_lvl_orig, 0);
  if (args_info->depth_given)
    write_into_file(outfile, "depth", args_info->depth_orig, 0);
  if (args_info->minh_given)
    write_into_file(outfile, "minh", args_info->minh_orig, 0);
  if (args_info->minh_lite_given)
    write_into_file(outfile, "minh-lite", 0, 0 );
  if (args_info->walk_given)
    write_into_file(outfile, "walk", args_info->walk_orig, cmdline_parser_walk_values);
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->useEOS_given)
    write_into_file(outfile, "useEOS", 0, 0 );
  if (args_info->paramFile_given)
    write_into_file(outfile, "paramFile", args_info->paramFile_orig, 0);
  if (args_info->dangles_given)
    write_into_file(outfile, "dangles", args_info->dangles_orig, 0);
  if (args_info->fix_barriers_given)
    write_into_file(outfile, "fix-barriers", args_info->fix_barriers_orig, 0);
  if (args_info->pseudoknots_given)
    write_into_file(outfile, "pseudoknots", 0, 0 );
  if (args_info->just_read_given)
    write_into_file(outfile, "just-read", 0, 0 );
  if (args_info->neighborhood_given)
    write_into_file(outfile, "neighborhood", 0, 0 );
  if (args_info->degeneracy_off_given)
    write_into_file(outfile, "degeneracy-off", 0, 0 );
  if (args_info->just_output_given)
    write_into_file(outfile, "just-output", 0, 0 );
  if (args_info->bartree_given)
    write_into_file(outfile, "bartree", 0, 0 );
  if (args_info->barr_name_given)
    write_into_file(outfile, "barr-name", args_info->barr_name_orig, 0);
  if (args_info->barrier_file_given)
    write_into_file(outfile, "barrier-file", args_info->barrier_file_orig, 0);
  if (args_info->rates_given)
    write_into_file(outfile, "rates", 0, 0 );
  if (args_info->rates_file_given)
    write_into_file(outfile, "rates-file", args_info->rates_file_orig, 0);
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  if (args_info->floodPortion_given)
    write_into_file(outfile, "floodPortion", args_info->floodPortion_orig, 0);
  if (args_info->floodMax_given)
    write_into_file(outfile, "floodMax", args_info->floodMax_orig, 0);
  if (args_info->numIntervals_given)
    write_into_file(outfile, "numIntervals", args_info->numIntervals_orig, 0);
  if (args_info->eRange_given)
    write_into_file(outfile, "eRange", args_info->eRange_orig, 0);
  if (args_info->allegiance_given)
    write_into_file(outfile, "allegiance", args_info->allegiance_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "seq",	1, NULL, 's' },
        { "previous",	1, NULL, 'p' },
        { "move",	1, NULL, 'm' },
        { "min-num",	1, NULL, 'n' },
        { "find-num",	1, NULL, 0 },
        { "verbose-lvl",	1, NULL, 'v' },
        { "depth",	1, NULL, 0 },
        { "minh",	1, NULL, 0 },
        { "minh-lite",	0, NULL, 0 },
        { "walk",	1, NULL, 'w' },
        { "noLP",	0, NULL, 0 },
        { "useEOS",	0, NULL, 'e' },
        { "paramFile",	1, NULL, 'P' },
        { "dangles",	1, NULL, 'd' },
        { "fix-barriers",	1, NULL, 0 },
        { "pseudoknots",	0, NULL, 'k' },
        { "just-read",	0, NULL, 0 },
        { "neighborhood",	0, NULL, 'N' },
        { "degeneracy-off",	0, NULL, 0 },
        { "just-output",	0, NULL, 0 },
        { "bartree",	0, NULL, 'b' },
        { "barr-name",	1, NULL, 0 },
        { "barrier-file",	1, NULL, 0 },
        { "rates",	0, NULL, 'r' },
        { "rates-file",	1, NULL, 'f' },
        { "temp",	1, NULL, 'T' },
        { "floodPortion",	1, NULL, 0 },
        { "floodMax",	1, NULL, 0 },
        { "numIntervals",	1, NULL, 0 },
        { "eRange",	1, NULL, 0 },
        { "allegiance",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVs:p:m:n:v:w:eP:d:kNbrf:T:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 's':	/* Sequence file in FASTA format. If the sequence is the first line of the input file, this is not needed.  */
        
        
          if (update_arg( (void *)&(args_info->seq_arg), 
               &(args_info->seq_orig), &(args_info->seq_given),
              &(local_args_info.seq_given), optarg, 0, "seq.txt", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "seq", 's',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Previously found LM (output from RNAlocmin or barriers), if specified does not need --seq option.  */
        
        
          if (update_arg( (void *)&(args_info->previous_arg), 
               &(args_info->previous_orig), &(args_info->previous_given),
              &(local_args_info.previous_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "previous", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Move set:
        I ==> insertion & deletion of base pairs
        S ==> I&D& switch of base pairs.  */
        
        
          if (update_arg( (void *)&(args_info->move_arg), 
               &(args_info->move_orig), &(args_info->move_given),
              &(local_args_info.move_given), optarg, cmdline_parser_move_values, "I", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "move", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Maximal number of local minima returned
        (0 == unlimited).  */
        
        
          if (update_arg( (void *)&(args_info->min_num_arg), 
               &(args_info->min_num_orig), &(args_info->min_num_given),
              &(local_args_info.min_num_given), optarg, 0, "100000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "min-num", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Level of verbosity (0 = nothing, 4 = full)
        WARNING: higher verbose levels increase the computation time.  */
        
        
          if (update_arg( (void *)&(args_info->verbose_lvl_arg), 
               &(args_info->verbose_lvl_orig), &(args_info->verbose_lvl_given),
              &(local_args_info.verbose_lvl_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "verbose-lvl", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* Walking method used
        D ==> gradient descent
        F ==> use first found lower energy structure
        R ==> use random lower energy structure (does not work with --noLP and -m S options).  */
        
        
          if (update_arg( (void *)&(args_info->walk_arg), 
               &(args_info->walk_orig), &(args_info->walk_given),
              &(local_args_info.walk_given), optarg, cmdline_parser_walk_values, "D", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "walk", 'w',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Use energy_of_structure_pt calculation instead of energy_of_move (slower, it should not affect results).  */
        
        
          if (update_arg((void *)&(args_info->useEOS_flag), 0, &(args_info->useEOS_given),
              &(local_args_info.useEOS_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "useEOS", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Read energy parameters from paramfile, instead of using the default parameter set.  */
        
        
          if (update_arg( (void *)&(args_info->paramFile_arg), 
               &(args_info->paramFile_orig), &(args_info->paramFile_given),
              &(local_args_info.paramFile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "paramFile", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
.  */
        
        
          if (update_arg( (void *)&(args_info->dangles_arg), 
               &(args_info->dangles_orig), &(args_info->dangles_given),
              &(local_args_info.dangles_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangles", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* Allow for pseudoknots according to \"gfold\" model - H, K, L, and M types (genus one) of pseudoknots are allowed (increases computation time greatly), cannot be combined with shift move set (-m S).  */
        
        
          if (update_arg((void *)&(args_info->pseudoknots_flag), 0, &(args_info->pseudoknots_given),
              &(local_args_info.pseudoknots_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "pseudoknots", 'k',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Use the Neighborhood routines to perform gradient descend. Cannot be combined with shift move set (-m S) and pseudoknots (-k). Test option..  */
        
        
          if (update_arg((void *)&(args_info->neighborhood_flag), 0, &(args_info->neighborhood_given),
              &(local_args_info.neighborhood_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "neighborhood", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Generate an approximate barrier tree..  */
        
        
          if (update_arg((void *)&(args_info->bartree_flag), 0, &(args_info->bartree_given),
              &(local_args_info.bartree_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "bartree", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Create rates for treekin.  */
        
        
          if (update_arg((void *)&(args_info->rates_flag), 0, &(args_info->rates_given),
              &(local_args_info.rates_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "rates", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* File where to write rates, switches on -r flag.  */
        
        
          if (update_arg( (void *)&(args_info->rates_file_arg), 
               &(args_info->rates_file_orig), &(args_info->rates_file_given),
              &(local_args_info.rates_file_given), optarg, 0, "rates.out", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "rates-file", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Temperature in Celsius (only for rates).  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, "37.0", ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            cmdline_parser_print_detailed_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Maximal number of local minima found
          (default = unlimited - crawl through whole input file).  */
          if (strcmp (long_options[option_index].name, "find-num") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->find_num_arg), 
                 &(args_info->find_num_orig), &(args_info->find_num_given),
                &(local_args_info.find_num_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "find-num", '-',
                additional_error))
              goto failure;
          
          }
          /* Depth of findpath search (higher value increases running time linearly).  */
          else if (strcmp (long_options[option_index].name, "depth") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->depth_arg), 
                 &(args_info->depth_orig), &(args_info->depth_given),
                &(local_args_info.depth_given), optarg, 0, "10", ARG_INT,
                check_ambiguity, override, 0, 0,
                "depth", '-',
                additional_error))
              goto failure;
          
          }
          /* Print only minima with energy barrier greater than this.  */
          else if (strcmp (long_options[option_index].name, "minh") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->minh_arg), 
                 &(args_info->minh_orig), &(args_info->minh_given),
                &(local_args_info.minh_given), optarg, 0, "0.0", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "minh", '-',
                additional_error))
              goto failure;
          
          }
          /* When flooding with --minh option, search for only saddle (do not search for a LM that is lower). Increases efficiency a tiny bit, but when turned on, the results may omit some non-shallow minima, especially with higher --minh value..  */
          else if (strcmp (long_options[option_index].name, "minh-lite") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->minh_lite_flag), 0, &(args_info->minh_lite_given),
                &(local_args_info.minh_lite_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "minh-lite", '-',
                additional_error))
              goto failure;
          
          }
          /* Work only with canonical RNA structures (w/o isolated base pairs, cannot be combined with ranodm walk (-w R option) and shift move set (-m S)).  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* Fix barrier file for interior loops (just recompute if all LM in barrier output are LM), if specified, does not need neither --previous nor --seq option.  */
          else if (strcmp (long_options[option_index].name, "fix-barriers") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->fix_barriers_arg), 
                 &(args_info->fix_barriers_orig), &(args_info->fix_barriers_given),
                &(local_args_info.fix_barriers_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "fix-barriers", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not expect input from stdin, just do postprocessing..  */
          else if (strcmp (long_options[option_index].name, "just-read") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->just_read_flag), 0, &(args_info->just_read_given),
                &(local_args_info.just_read_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "just-read", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not deal with degeneracy, select the lexicographically first from the same energy neighbors..  */
          else if (strcmp (long_options[option_index].name, "degeneracy-off") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->degeneracy_off_flag), 0, &(args_info->degeneracy_off_given),
                &(local_args_info.degeneracy_off_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "degeneracy-off", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not store the minima and optimize, just compute directly minima and output them. Output file can contain duplicates..  */
          else if (strcmp (long_options[option_index].name, "just-output") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->just_output_flag), 0, &(args_info->just_output_given),
                &(local_args_info.just_output_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "just-output", '-',
                additional_error))
              goto failure;
          
          }
          /* Name of barrier tree output file, switches on -b flag..  */
          else if (strcmp (long_options[option_index].name, "barr-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->barr_name_arg), 
                 &(args_info->barr_name_orig), &(args_info->barr_name_given),
                &(local_args_info.barr_name_given), optarg, 0, "treeRNAloc.ps", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "barr-name", '-',
                additional_error))
              goto failure;
          
          }
          /* File for saddle heights between LM (simulates the output format of barriers program).  */
          else if (strcmp (long_options[option_index].name, "barrier-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->barrier_file_arg), 
                 &(args_info->barrier_file_orig), &(args_info->barrier_file_given),
                &(local_args_info.barrier_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "barrier-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Fraction of minima to flood (floods first minima with low number of inwalking sample structures)
          (0.0 -> no flood; 1.0 -> try to flood all) Usable only with -r or -b options..  */
          else if (strcmp (long_options[option_index].name, "floodPortion") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->floodPortion_arg), 
                 &(args_info->floodPortion_orig), &(args_info->floodPortion_given),
                &(local_args_info.floodPortion_given), optarg, 0, "0.95", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "floodPortion", '-',
                additional_error))
              goto failure;
          
          }
          /* Flood cap - how many structures to flood in one basin.  */
          else if (strcmp (long_options[option_index].name, "floodMax") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->floodMax_arg), 
                 &(args_info->floodMax_orig), &(args_info->floodMax_given),
                &(local_args_info.floodMax_given), optarg, 0, "1000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "floodMax", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of intervals for Jing's visualisation.  */
          else if (strcmp (long_options[option_index].name, "numIntervals") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->numIntervals_arg), 
                 &(args_info->numIntervals_orig), &(args_info->numIntervals_given),
                &(local_args_info.numIntervals_given), optarg, 0, "0", ARG_INT,
                check_ambiguity, override, 0, 0,
                "numIntervals", '-',
                additional_error))
              goto failure;
          
          }
          /* Report only LM, which energy is in range <MFE (or lowest found LM), MFE+eRange> in kcal/mol..  */
          else if (strcmp (long_options[option_index].name, "eRange") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->eRange_arg), 
                 &(args_info->eRange_orig), &(args_info->eRange_given),
                &(local_args_info.eRange_given), optarg, 0, 0, ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "eRange", '-',
                additional_error))
              goto failure;
          
          }
          /* Filename where to output the allegiance of structures. Works properly only with RNAsubopt -e list..  */
          else if (strcmp (long_options[option_index].name, "allegiance") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->allegiance_arg), 
                 &(args_info->allegiance_orig), &(args_info->allegiance_given),
                &(local_args_info.allegiance_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "allegiance", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */


      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
