#include "Labclass.h"

#include "Game.h"
#include "Entity.h"
#include "MakeAndPlay.h"

const short* labclass::loadlevel(int rx, int ry)
{
    int t;

    rx=rx-100;
    ry=ry-100;
    if(ry<5)
    {
        rx+=50-2;
        ry+=54;    //lab
    }
    else
    {
        rx+=50-2;
        ry+=50-16; //lab
    }

    t = rx + (ry * 100);
    const short* result;
    rcol = 0;
    roomname = "";
    roomname_special = false;

    switch(t)
    {
#if !defined(MAKEANDPLAY)

    case rn(50,50):
    {

        static const short contents[] = {
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,284,444,444,444,444,444,444,444,444,444,285,283,284,444,444,444,444,444,444,444,444,444,444,444,444,285,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,363,364,365,0,0,0,403,283,405,0,0,0,363,364,365,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,403,283,405,0,0,0,443,444,445,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,405,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        444,444,444,444,444,444,285,283,405,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        0,0,0,0,0,0,403,283,405,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        0,0,0,0,0,0,403,283,405,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        0,0,0,0,0,0,403,283,405,0,0,0,403,283,324,364,364,364,364,364,364,364,364,364,325,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        0,0,0,0,0,0,403,283,405,0,0,0,403,283,283,283,283,283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        0,0,0,0,0,0,403,283,405,0,0,0,443,444,444,444,444,444,444,444,444,444,444,444,285,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        364,364,365,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,403,283,324,364,364,364,364,364,364,364,364,364,364,364,365,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,403,283,283,283,283,283,283,283,283,283,283,283,283,283,405,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,443,444,444,444,444,444,444,444,444,444,444,444,444,444,445,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,324,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,325,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,403,283,283,283,283,283,283,
        };

        obj.createentity(232, 24, 10, 0, 250500);  // (savepoint)

        if(game.intimetrial)
        {
            obj.createblock(0, 0, 0, 8, 240);
        }

        rcol=1;
        roomname = "Get Ready To Bounce";
        result = contents;
        break;
    }

    case rn(50,51):
    {

        static const short contents[] = {
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,400,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,400,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,281,441,442,0,0,0,0,0,0,440,441,441,441,441,282,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,281,442,64,64,0,0,0,0,0,0,64,64,64,64,64,440,282,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,442,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        63,63,63,63,63,63,63,63,63,63,63,63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        361,361,361,361,361,361,361,361,361,361,361,361,362,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,
        280,280,280,280,280,280,280,280,280,280,280,280,321,362,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,360,322,
        280,280,280,280,280,280,280,280,280,280,280,280,280,321,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,322,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        };

        obj.createentity(112, 180, 11, 192);  // (horizontal gravity line)
        rcol = 0;

        roomname = "It's Perfectly Safe";
        result = contents;
        break;
    }

    case rn(49,51):
    {

        static const short contents[] = {
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,293,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,72,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,414,0,0,0,0,0,0,0,0,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,71,71,71,71,71,71,71,71,71,71,71,
        292,414,0,0,0,0,0,0,0,60,413,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,307,308,308,308,308,308,308,349,373,373,373,373,
        292,414,0,0,0,0,0,0,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,71,71,71,0,0,0,0,0,71,71,71,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,
        292,333,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,374,0,0,0,0,0,0,0,412,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,412,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,412,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,412,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,412,292,292,292,292,
        };

        obj.createentity(96, 124, 11, 120);  // (horizontal gravity line)
        obj.createentity(248, 48, 10, 0, 251490);  // (savepoint)
        rcol = 4;

        roomname = "Rascasse";
        result = contents;
        break;
    }

    case rn(49,52):
    {

        static const short contents[] = {
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,406,286,286,286,286,
        286,287,447,447,447,447,447,447,447,447,288,286,286,287,447,447,447,447,447,447,447,447,288,286,286,287,447,448,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,68,68,68,68,68,68,68,68,406,286,286,408,68,68,68,68,68,68,68,68,406,286,286,408,68,68,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        447,448,0,0,0,0,0,0,0,0,446,447,447,448,0,0,0,0,0,0,0,0,446,447,447,448,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,68,68,68,68,0,0,0,0,0,0,0,0,68,68,68,68,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,67,67,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,
        367,367,367,367,367,367,367,368,0,0,0,0,0,0,0,0,366,367,367,368,0,0,0,0,0,0,0,0,366,367,367,367,367,367,367,328,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,406,286,286,408,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,67,67,67,67,67,67,67,67,406,286,286,408,67,67,67,67,67,67,67,67,406,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,327,367,367,367,367,367,367,367,367,328,286,286,327,367,367,367,367,367,367,367,367,328,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        };

        obj.createentity(248, 136, 10, 1, 252490);  // (savepoint)
        obj.createentity(16, 68, 11, 64);  // (horizontal gravity line)
        obj.createentity(112, 68, 11, 64);  // (horizontal gravity line)
        obj.createentity(64, 164, 11, 64);  // (horizontal gravity line)
        obj.createentity(160, 164, 11, 64);  // (horizontal gravity line)
        rcol = 2;

        roomname = "Keep Going";
        result = contents;
        break;
    }

    case rn(48,52):
    {

        static const short contents[] = {
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,290,450,450,450,450,450,450,450,450,450,450,450,450,450,291,289,289,289,290,450,450,450,450,450,450,450,450,450,450,450,450,450,291,289,289,
        289,289,289,289,289,411,70,70,70,70,70,70,70,70,70,70,70,70,70,409,289,289,289,411,70,70,70,70,70,70,70,70,70,70,70,70,70,409,289,289,
        289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,
        289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,
        289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,
        289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,
        289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,
        289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,
        289,290,450,450,450,451,0,0,0,0,0,0,0,0,0,0,0,0,0,449,450,450,450,451,0,0,0,0,0,0,0,0,0,0,0,0,0,449,450,450,
        289,411,70,70,70,70,0,0,0,0,0,0,0,0,0,0,0,0,0,70,70,70,70,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,69,69,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,411,0,0,0,0,0,0,0,0,0,369,370,371,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,369,370,370,370,370,370,370,370,370,370,370,
        289,411,0,0,0,0,0,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,411,69,69,69,69,69,0,0,0,0,0,69,69,69,69,69,409,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,330,370,370,370,370,371,0,0,0,0,0,369,370,370,370,370,331,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,411,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,411,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,330,370,370,370,370,370,331,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        };

        obj.createentity(280, 136, 10, 1, 252480);  // (savepoint)
        obj.createentity(48, 52, 11, 104);  // (horizontal gravity line)
        obj.createentity(192, 52, 11, 104);  // (horizontal gravity line)
        obj.createentity(152, 196, 11, 40);  // (horizontal gravity line)
        rcol=3;

        roomname = "Single-slit Experiment";
        result = contents;
        break;
    }


    case rn(48,53):
    {

        static const short contents[] = {
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,296,456,456,456,456,456,456,456,456,456,456,456,456,456,456,
        295,417,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,417,74,74,74,74,74,74,74,74,74,74,74,74,74,74,
        295,417,0,0,0,0,0,0,0,0,0,455,456,456,456,456,456,456,456,456,456,456,456,456,456,457,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        295,336,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        };

        obj.createentity(32, 128, 10, 1, 253480);  // (savepoint)
        obj.createentity(187, 88, 12, 56);  // (vertical gravity line)
        obj.createentity(107, 88, 12, 56);  // (vertical gravity line)
        rcol = 5;

        roomname = "Don't Flip Out";
        result = contents;
        break;
    }

    case rn(49,53):
    {

        static const short contents[] = {
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,284,444,444,444,444,444,444,444,444,444,285,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        444,444,444,444,444,285,283,283,283,283,283,283,283,283,283,405,66,66,66,66,66,66,66,66,66,403,283,283,283,283,283,283,283,283,283,284,444,444,444,444,
        66,66,66,66,66,403,283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,283,283,283,283,283,283,283,283,405,66,66,66,66,
        0,0,0,0,0,443,444,444,444,444,444,444,444,444,444,445,0,0,0,0,0,0,0,0,0,443,444,444,444,444,444,444,444,444,444,445,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        364,364,364,364,364,365,0,0,0,0,0,0,0,0,0,363,364,364,364,364,364,364,364,364,364,365,0,0,0,0,0,0,0,0,0,363,364,364,364,364,
        283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,403,283,283,283,283,
        283,283,283,283,283,405,65,65,65,65,65,65,65,65,65,403,283,283,283,283,283,283,283,283,283,405,65,65,65,65,65,65,65,65,65,403,283,283,283,283,
        283,283,283,283,283,324,364,364,364,364,364,364,364,364,364,325,283,283,283,283,283,283,283,283,283,324,364,364,364,364,364,364,364,364,364,325,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        };

        obj.createentity(43, 88, 12, 56);  // (vertical gravity line)
        obj.createentity(123, 88, 12, 56);  // (vertical gravity line)
        obj.createentity(203, 88, 12, 56);  // (vertical gravity line)
        obj.createentity(283, 88, 12, 56);  // (vertical gravity line)

        obj.createentity(156, 128, 20, 1);  // (terminal)
        obj.createblock(5, 156-8, 128, 20, 16, 19);
        rcol = 1;

        roomname = "Shuffled Hallway";
        result = contents;
        break;
    }

    case rn(50,53):
    {

        static const short contents[] = {
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,449,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,291,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,70,70,70,70,70,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        450,450,450,450,450,450,450,450,451,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        70,70,70,70,70,70,70,70,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,449,450,450,450,450,450,450,450,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        370,370,370,370,370,370,370,370,371,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,69,69,69,69,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,330,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,371,0,0,0,0,0,0,0,0,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,69,69,69,69,69,69,69,69,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,330,370,370,370,370,370,370,370,370,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        };

        obj.createentity(96, 192, 10, 1, 253500);  // (savepoint)
        obj.createentity(163, 32, 12, 168);  // (vertical gravity line)
        rcol = 3;

        roomname = "Double-slit Experiment";
        result = contents;
        break;
    }

    case rn(51,53):
    {

        static const short contents[] = {
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,287,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,448,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,0,0,0,0,0,0,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,366,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,328,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        };

        obj.createentity(264, 104, 10, 1, 253510);  // (savepoint)
        obj.createentity(131, 120, 12, 96);  // (vertical gravity line)
        obj.createentity(187, 16, 12, 96);  // (vertical gravity line)
        obj.createentity(40, 112, 10, 0, 253511);  // (savepoint)
        rcol = 2;
        roomname = "They Call Him Flipper";
        result = contents;
        break;
    }

    case rn(52,53):
    {

        static const short contents[] = {
        453,453,453,453,453,453,294,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        72,72,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,293,453,453,453,294,292,293,453,453,453,294,292,293,453,453,453,294,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,412,414,0,0,0,0,0,0,412,414,72,72,72,412,292,414,72,72,72,412,292,414,72,72,72,412,292,292,292,292,292,292,292,292,
        373,374,0,0,0,0,412,414,0,0,0,0,0,0,452,454,0,0,0,452,453,454,0,0,0,452,453,454,0,0,0,452,453,453,453,453,453,453,294,292,
        292,414,0,0,0,0,412,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,
        292,414,0,0,0,0,412,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,
        292,414,0,0,0,0,412,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,
        292,414,0,0,0,0,412,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,71,0,0,0,412,292,
        292,414,0,0,0,0,452,454,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,307,309,0,0,0,412,292,
        292,414,0,0,0,0,72,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,72,0,0,0,412,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,
        292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,
        292,333,373,373,373,373,373,373,373,373,373,373,373,374,0,0,0,0,0,372,373,373,373,374,0,0,0,0,0,372,373,373,373,373,373,373,373,373,334,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,414,71,71,71,71,71,412,292,292,292,414,71,71,71,71,71,412,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,333,373,373,373,373,373,334,292,292,292,333,373,373,373,373,373,334,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        };

        obj.createentity(24, 184, 10, 1, 253520);  // (savepoint)
        obj.createentity(64, 164, 11, 200);  // (horizontal gravity line)
        rcol = 4;
        roomname = "Three's a Crowd";
        result = contents;
        break;
    }

    case rn(52,52):
    {

        static const short contents[] = {
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,288,286,286,286,286,286,
        68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        367,367,367,367,367,367,367,351,311,311,311,311,311,311,311,311,311,311,311,311,311,311,311,311,312,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,406,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,366,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,328,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        };

        obj.createentity(195, 24, 12, 80);  // (vertical gravity line)
        obj.createentity(195, 128, 12, 80);  // (vertical gravity line)
        obj.createentity(80, 120, 10, 0, 252520);  // (savepoint)
        obj.createentity(80, 96, 10, 1, 252521);  // (savepoint)
        rcol = 2;
        roomname = "Hitting the Apex";
        result = contents;
        break;
    }

    case rn(51,52):
    {

        static const short contents[] = {
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,280,280,280,281,441,441,441,441,441,441,441,441,441,441,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,280,280,281,442,64,64,64,64,64,64,64,64,64,64,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,281,441,441,441,441,442,51,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,281,442,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,440,282,280,281,442,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,440,344,442,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,464,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,360,361,361,361,361,361,361,361,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        280,321,362,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,360,322,280,280,280,280,280,280,280,
        280,280,321,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,322,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        };

        obj.createentity(24, 188, 11, 224);  // (horizontal gravity line)
        obj.createentity(280, 96, 10, 1, 252510);  // (savepoint)

        obj.createentity(204, 32, 20, 0);  // (terminal)
        obj.createblock(5, 204-8, 32, 20, 16, 20);
        rcol=0;

        roomname = "Square Root";
        result = contents;
        break;
    }


    case rn(51,51):
    {

        static const short contents[] = {
        292,292,293,453,453,453,453,453,453,453,453,453,453,453,453,453,453,294,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,293,454,72,72,72,72,72,72,72,72,72,72,72,72,72,72,452,294,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,452,319,454,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,467,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,387,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,372,347,374,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,333,374,71,71,71,71,71,71,71,71,71,71,71,71,71,71,372,334,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,333,373,373,373,373,373,373,373,373,373,373,373,373,373,373,334,292,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        };

        obj.createentity(24, 44, 11, 112);  // (horizontal gravity line)
        obj.createentity(176, 180, 11, 112);  // (horizontal gravity line)
        rcol = 4;
        roomname = "Thorny Exchange";
        result = contents;
        break;
    }

    case rn(51,50):
    {

        static const short contents[] = {
        283,283,283,284,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,
        283,283,284,445,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,405,53,0,0,0,0,0,363,364,364,364,364,365,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,363,364,364,
        283,283,405,53,0,0,0,0,54,403,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,443,444,444,444,444,445,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,363,365,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,324,365,65,65,65,65,65,65,65,65,65,65,65,65,65,65,363,325,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,283,324,364,364,364,364,364,364,364,364,364,364,364,364,364,364,325,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,283,
        };

        obj.createentity(32, 28, 11, 296);  // (horizontal gravity line)
        obj.createentity(32, 196, 11, 112);  // (horizontal gravity line)
        obj.createentity(128, 100, 11, 160);  // (horizontal gravity line)
        obj.createentity(88, 112, 10, 0, 250510);  // (savepoint)
        roomname = "Brought to you by the letter G";
        rcol = 1;
        result = contents;
        break;
    }

    case rn(52,50):
    {

        static const short contents[] = {
        447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,447,
        68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        367,367,367,367,367,367,367,367,368,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(-8, 28, 11, 336);  // (horizontal gravity line)
        obj.createentity(32, 72, 10, 1, 250520);  // (savepoint)
        rcol=2;

        roomname = "Free Your Mind";
        result = contents;
        break;
    }

    case rn(52,51):
    {

        static const short contents[] = {
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        280,280,280,280,280,280,280,280,321,362,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
        280,280,280,280,280,280,280,280,280,321,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        };

        obj.createentity(80, 180, 11, 248);  // (horizontal gravity line)
        rcol=0;
        roomname = "I Changed My Mind, Thelma...";
        result = contents;
        break;
    }

    case rn(53,51):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,414,59,0,0,0,0,0,0,0,0,0,0,
        71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,372,334,292,333,374,71,71,71,71,71,71,71,71,71,71,
        373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,334,292,292,292,333,373,373,373,373,373,373,373,373,373,373,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        };

        obj.createentity(-8, 180, 11, 208);  // (horizontal gravity line)
        obj.createentity(240, 180, 11, 88);  // (horizontal gravity line)
        rcol=4;

        roomname = "Indirect Jump Vector";
        result = contents;
        break;
    }

    case rn(53,50):
    {

        static const short contents[] = {
        456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,
        74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,396,73,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,375,356,377,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,417,61,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(-8, 28, 11, 336);  // (horizontal gravity line)
        rcol=5;

        roomname = "In a Single Bound";
        result = contents;
        break;
    }

    case rn(54,50):
    {

        static const short contents[] = {
        444,444,444,444,444,444,444,444,444,285,283,283,283,284,444,444,444,444,444,444,444,444,444,444,444,444,285,283,283,283,284,444,444,444,444,444,444,444,444,444,
        66,66,66,66,66,66,66,66,66,443,285,283,284,445,66,66,66,66,66,66,66,66,66,66,66,66,443,285,283,284,445,66,66,66,66,66,66,66,66,66,
        0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,443,359,445,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,66,473,66,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,65,393,65,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,363,353,365,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,53,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(-8, 28, 11, 80);  // (horizontal gravity line)
        obj.createentity(112, 28, 11, 96);  // (horizontal gravity line)
        obj.createentity(248, 28, 11, 80);  // (horizontal gravity line)
        rcol=1;

        roomname = "Barani, Barani";
        result = contents;
        break;
    }


    case rn(54,51):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,446,399,448,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,68,470,68,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,67,390,67,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,366,350,368,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,56,406,286,408,55,0,0,0,0,0,0,0,0,0,
        67,67,67,67,67,67,67,67,67,366,328,286,327,368,67,67,67,67,67,67,67,67,67,67,67,67,366,328,286,327,368,67,67,67,67,67,67,67,67,67,
        367,367,367,367,367,367,367,367,367,328,286,286,286,327,367,367,367,367,367,367,367,367,367,367,367,367,328,286,286,286,327,367,367,367,367,367,367,367,367,367,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        };

        obj.createentity(-8, 180, 11, 80);  // (horizontal gravity line)
        obj.createentity(112, 180, 11, 96);  // (horizontal gravity line)
        obj.createentity(248, 180, 11, 80);  // (horizontal gravity line)
        rcol=2;

        roomname = "Safety Dance";
        result = contents;
        break;
    }

    case rn(55,50):
    {

        static const short contents[] = {
        450,450,450,450,291,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        70,70,70,70,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,449,450,451,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,69,0,0,0,0,0,0,69,369,331,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,369,371,0,0,0,0,0,0,369,331,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,409,411,0,0,0,0,0,0,409,289,289,289,
        };

        obj.createentity(-8, 28, 11, 40);  // (horizontal gravity line)

        rcol=3;
        roomname = "Heady Heights";
        result = contents;
        break;
    }

    case rn(55,49):
    {

        static const short contents[] = {
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,296,456,456,456,456,456,456,456,456,456,456,297,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,62,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,417,0,0,0,0,0,0,0,0,0,62,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        456,457,0,0,0,0,0,0,0,0,0,62,455,456,456,456,456,456,456,456,456,456,456,456,456,297,296,456,456,456,456,456,456,456,456,456,456,456,297,295,
        0,0,0,0,375,376,377,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        0,0,0,0,415,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        0,0,0,0,415,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        0,0,0,0,415,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        376,376,376,376,337,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,455,457,61,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,336,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,377,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,296,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,457,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        295,295,295,295,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,415,295,
        };


        obj.createentity(160, 176, 10, 0, 249550);  // (savepoint)
        obj.createentity(224, 68, 11, 72);  // (horizontal gravity line)


        //obj.createentity(224, 192, 10, 0, 249550);  // (savepoint)

        if(!game.intimetrial || game.translator_exploring)
        {
            obj.createentity((12 * 8)-4, (6 * 8) + 4, 14); //Teleporter!
        }
        rcol = 5;

        roomname = "Entanglement Generator";
        result = contents;
        break;
    }


    case rn(55,51):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,402,0,0,0,0,0,0,400,280,280,280,
        63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,360,322,402,0,0,0,0,0,0,400,280,280,280,
        361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,322,280,402,0,0,0,0,0,0,400,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,400,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,400,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,400,280,280,280,
        };

        obj.createentity(-8, 180, 11, 224);  // (horizontal gravity line)

        rcol = 0;
        roomname = "Exhausted?";
        result = contents;
        break;
    }


    case rn(55,52):
    {

        static const short contents[] = {
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,293,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,294,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,414,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,333,373,373,373,373,373,373,373,373,373,373,373,373,373,373,374,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,0,0,0,0,0,0,0,0,0,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,414,59,0,0,0,0,0,0,0,60,412,292,414,0,0,0,0,0,0,412,292,292,292,
        };

        obj.createentity(32, 64, 9, 10);  // (shiny trinket)
        obj.createentity(120, 72, 10, 1, 252550);  // (savepoint)
        rcol = 4;

        roomname = "The Tantalizing Trinket";
        result = contents;
        break;
    }

    case rn(55,53):
    {

        static const short contents[] = {
        283,283,283,283,283,283,283,283,283,284,444,444,444,444,444,444,444,445,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,284,445,66,66,66,66,66,66,66,66,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,363,364,364,325,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,443,444,444,444,444,285,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,65,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,54,393,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,54,433,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,54,433,53,0,0,0,0,0,0,0,54,403,283,439,314,314,314,314,315,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,54,433,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,54,473,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,66,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,0,0,403,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,363,364,364,364,364,325,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,443,444,444,285,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,324,365,65,65,65,65,65,65,65,65,0,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,283,324,364,364,364,364,364,364,364,365,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,405,53,0,0,0,0,0,0,0,54,403,283,405,0,0,0,0,0,0,403,283,283,283,
        };

        obj.createentity(272, 144, 10, 1, 253550);  // (savepoint)
        obj.createentity(152, 116, 11, 56);  // (horizontal gravity line)
        obj.createentity(139, 16, 12, 72);  // (vertical gravity line)
        obj.createentity(139, 144, 12, 72);  // (vertical gravity line)
        rcol=1;

        roomname = "The Bernoulli Principle";
        result = contents;
        break;
    }

    case rn(55,54):
    {

        static const short contents[] = {
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,297,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,415,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,61,0,0,0,0,0,0,0,62,415,295,417,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,455,457,0,0,0,0,0,0,0,0,0,455,456,457,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,375,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,337,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,337,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        };

        obj.createentity(216, 144, 10, 1, 254550);  // (savepoint)
        obj.createentity(-8, 60, 11, 136);  // (horizontal gravity line)
        obj.createentity(-8, 172, 11, 136);  // (horizontal gravity line)
        rcol = 5;

        roomname = "Standing Wave";
        result = contents;
        break;
    }

    case rn(54,54):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,446,288,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,446,447,447,447,447,447,447,447,447,447,447,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,67,67,67,67,67,67,67,67,67,67,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,366,367,367,367,367,367,367,367,367,367,367,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,366,328,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,
        };

        obj.createentity(-8, 60, 11, 336);  // (horizontal gravity line)
        obj.createentity(-8, 172, 11, 336);  // (horizontal gravity line)
        rcol=2;

        obj.fatal_top();
        roomname = "Topsy Turvyism";
        result = contents;
        break;
    }

    case rn(53,54):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,369,370,370,370,370,371,0,0,0,0,0,0,369,370,370,370,370,370,370,370,370,371,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,449,450,450,450,450,451,0,0,0,0,0,0,449,450,450,450,450,450,291,289,289,411,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,70,70,70,70,70,0,0,0,0,0,0,70,70,70,70,70,70,449,450,450,451,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,369,370,370,371,69,69,69,69,69,69,0,0,0,0,0,0,69,69,69,69,69,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,409,289,289,330,370,370,370,370,370,371,0,0,0,0,0,0,369,370,370,370,370,371,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,449,450,450,450,450,450,450,450,450,451,0,0,0,0,0,0,449,450,450,450,450,451,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(-8, 60, 11, 120);  // (horizontal gravity line)
        obj.createentity(-8, 172, 11, 40);  // (horizontal gravity line)
        obj.createentity(264, 72, 10, 0, 254530);  // (savepoint)
        obj.createentity(40, 144, 10, 1, 254531);  // (savepoint)
        obj.createentity(160, 60, 11, 48);  // (horizontal gravity line)
        obj.createentity(288, 60, 11, 40);  // (horizontal gravity line)
        obj.createentity(112, 172, 11, 48);  // (horizontal gravity line)
        obj.createentity(208, 172, 11, 120);  // (horizontal gravity line)
        rcol=3;

        obj.fatal_top();
        roomname = "Spike Strip Deployed";
        result = contents;
        break;
    }

    case rn(52,54):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(-8, 60, 11, 336);  // (horizontal gravity line)
        obj.createentity(-8, 172, 11, 336);  // (horizontal gravity line)
        obj.createentity(72, 64, 1, 0, 8, 72, 64, 248, 168);  // Enemy, bounded
        obj.createentity(232, 64, 1, 0, 8, 72, 64, 248, 168);  // Enemy, bounded
        obj.createentity(152, 152, 1, 1, 8, 72, 64, 248, 168);  // Enemy, bounded

        obj.fatal_top();
        roomname = "Vibrating String Problem";
        rcol = 5;
        result = contents;
        break;
    }

    case rn(51,54):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,363,364,365,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,443,444,445,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,363,364,365,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,403,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,443,444,445,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(176, 60, 11, 152);  // (horizontal gravity line)
        obj.createentity(176, 172, 11, 152);  // (horizontal gravity line)
        obj.createentity(-8, 84, 11, 160);  // (horizontal gravity line)
        obj.createentity(-8, 148, 11, 160);  // (horizontal gravity line)
        obj.createentity(160-4, 120, 10, 1, 254510);  // (savepoint)
        rcol=1;

        obj.fatal_top();
        roomname = "Merge";
        result = contents;
        break;
    }

    case rn(50,54):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(-8, 84, 11, 336);  // (horizontal gravity line)
        obj.createentity(-8, 148, 11, 336);  // (horizontal gravity line)
        obj.createentity(88, 96, 1, 3, 3);  // Enemy
        obj.createentity(40, 120, 1, 3, 3);  // Enemy
        obj.createentity(136, 120, 1, 3, 3);  // Enemy
        rcol = 0;

        obj.fatal_top();

        roomname = "Kids His Age Bounce";
        result = contents;
        break;
    }

    case rn(49,54):
    {

        static const short contents[] = {
        286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,287,448,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,310,352,368,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,56,390,55,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,390,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,406,408,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,310,392,448,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,470,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,390,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,408,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,56,430,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        };

        obj.createentity(264, 84, 11, 64);  // (horizontal gravity line)
        obj.createentity(240+4, 96, 10, 0, 254490);  // (savepoint)
        obj.createentity(48, 28, 11, 192);  // (horizontal gravity line)
        obj.createentity(120, 148, 11, 208);  // (horizontal gravity line)
        rcol=2;

        roomname = "I'm Sorry";
        result = contents;
        break;
    }


    case rn(49,55):
    {

        static const short contents[] = {
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,468,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,428,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,453,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,60,427,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,60,467,59,0,0,0,0,0,0,60,467,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,0,72,0,0,0,0,0,0,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,372,373,373,373,373,373,373,373,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,
        292,292,292,292,414,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,412,292,292,292,292,292,292,292,
        292,292,292,292,333,374,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,372,334,292,292,292,292,292,292,292,
        292,292,292,292,292,333,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,334,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        };

        obj.createentity(48, 156, 11, 200);  // (horizontal gravity line)
        obj.createentity(216, 56, 10, 0, 255490);  // (savepoint)
        rcol=4;

        roomname = "Please Forgive Me!";
        result = contents;
        break;
    }

    case rn(50,55):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        364,364,364,364,364,364,364,364,364,354,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,355,364,364,
        283,283,283,283,283,283,283,283,283,405,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,443,444,444,
        444,444,444,444,444,444,444,444,444,445,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        364,364,364,364,364,364,364,364,364,365,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        283,283,283,283,283,283,283,283,283,405,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,363,364,364,
        283,283,283,283,283,283,283,283,283,324,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,364,325,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,
        };

        obj.createentity(131, 48, 12, 152);  // (vertical gravity line)
        obj.createentity(179, 48, 12, 152);  // (vertical gravity line)
        obj.createentity(227, 48, 12, 152);  // (vertical gravity line)
        obj.createentity(275, 48, 12, 152);  // (vertical gravity line)
        rcol=1;

        roomname = "Playing Foosball";
        result = contents;
        break;
    }

    case rn(51,55):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        376,376,376,376,376,357,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,317,358,376,376,376,376,
        456,456,456,456,456,457,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,455,456,456,456,456,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,416,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,416,61,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,416,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,62,416,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        376,376,376,376,376,377,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,375,376,376,376,376,
        295,295,295,295,295,336,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,337,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        };

        obj.createentity(91, 168, 12, 32);  // (vertical gravity line)
        obj.createentity(139, 80, 12, 120);  // (vertical gravity line)
        obj.createentity(235, 104, 12, 96);  // (vertical gravity line)
        obj.createentity(187, 144, 12, 56);  // (vertical gravity line)
        obj.createentity(43, 48, 12, 152);  // (vertical gravity line)
        obj.createentity(91, 48, 12, 112);  // (vertical gravity line)
        obj.createentity(139, 48, 12, 24);  // (vertical gravity line)
        obj.createentity(187, 48, 12, 88);  // (vertical gravity line)
        obj.createentity(235, 48, 12, 48);  // (vertical gravity line)
        obj.createentity(283, 48, 12, 152);  // (vertical gravity line)
        obj.createentity(8, 48, 10, 0, 255510);  // (savepoint)
        rcol=5;

        roomname = "A Difficult Chord";
        result = contents;
        break;
    }

    case rn(52,55):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        361,361,345,305,305,305,305,346,361,345,305,305,305,305,305,346,361,345,305,305,305,305,305,346,361,345,305,305,305,305,305,346,361,361,361,361,361,361,361,361,
        441,441,442,64,64,64,64,440,344,442,64,64,64,64,64,440,344,442,64,64,64,64,64,440,344,442,64,64,64,64,64,440,282,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,464,0,0,0,0,0,0,52,424,51,0,0,0,0,0,64,464,64,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,464,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,384,0,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,0,0,0,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,0,384,0,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        0,0,0,0,0,0,0,0,424,51,0,0,0,0,0,52,424,51,0,0,0,0,0,52,424,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,
        361,361,361,361,361,361,361,361,479,362,63,63,63,63,63,360,466,51,0,0,0,0,0,52,465,362,63,63,63,63,63,360,322,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,321,361,361,361,361,361,322,402,51,0,0,0,0,0,52,400,321,361,361,361,361,361,322,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,52,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        };

        obj.createentity(16, 184, 10, 1, 255520);  // (savepoint)
        obj.createentity(131, 88, 12, 96);  // (vertical gravity line)
        obj.createentity(208, 180, 11, 40);  // (horizontal gravity line)
        obj.createentity(67, 56, 12, 80);  // (vertical gravity line)
        obj.createentity(195, 56, 12, 80);  // (vertical gravity line)
        rcol = 0;

        roomname = "The Living Dead End";
        result = contents;
        break;
    }

    case rn(52,56):
    {

        static const short contents[] = {
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,411,57,0,0,0,0,0,58,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        };
        rcol=3;

        roomname = "AAAAAA";
        result = contents;
        break;
    }

    case rn(52,57):
    {

        static const short contents[] = {
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,56,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,55,0,0,0,0,0,56,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,287,447,447,447,288,286,286,286,286,286,408,55,0,0,0,0,0,56,406,286,286,286,286,286,287,447,447,447,288,286,286,286,286,286,
        286,286,286,286,286,286,408,68,68,68,406,286,286,286,286,286,408,55,0,0,0,0,0,56,406,286,286,286,286,286,408,68,68,68,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,446,288,286,286,286,286,408,55,0,0,0,0,0,56,406,286,286,286,286,287,448,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,68,406,286,286,286,286,408,55,0,0,0,0,0,56,406,286,286,286,286,408,68,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,446,447,447,447,447,448,55,0,0,0,0,0,56,446,447,447,447,447,448,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,68,68,68,68,68,68,0,0,0,0,0,0,0,68,68,68,68,68,68,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,366,367,367,367,368,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,366,367,328,286,286,286,327,367,368,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,366,367,367,328,286,286,286,286,286,286,286,327,367,367,368,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,446,447,288,286,286,286,286,286,286,286,286,286,287,447,448,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,408,0,0,0,0,0,0,68,68,446,447,288,286,286,286,286,286,287,447,448,68,68,0,0,0,0,0,0,406,286,286,286,286,286,
        286,286,286,286,286,286,327,368,0,0,0,0,0,0,0,68,68,446,447,288,286,287,447,448,68,68,0,0,0,0,0,0,0,366,328,286,286,286,286,286,
        286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,68,68,446,447,448,68,68,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,
        286,286,286,286,286,286,286,327,368,0,0,0,0,0,0,0,0,0,0,68,68,68,0,0,0,0,0,0,0,0,0,0,366,328,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,327,368,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,366,328,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,327,367,368,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,366,367,328,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,327,367,368,0,0,0,0,0,0,0,0,0,0,0,0,0,366,367,328,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,327,367,368,0,0,0,0,0,0,0,0,0,366,367,328,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,327,367,368,0,0,0,0,0,366,367,328,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,408,0,0,0,0,0,406,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
        };
        rcol = 2;

        roomname = "Diode";
        result = contents;
        break;
    }


    case rn(50,52):
    {

        static const short contents[] = {
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        281,441,441,441,441,282,281,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,282,280,280,
        402,0,0,0,0,400,402,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,440,282,280,
        402,0,0,0,0,400,402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,400,402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,440,442,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        321,361,361,361,361,361,361,361,361,362,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,0,360,361,361,361,345,306,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,0,0,0,0,0,0,0,384,0,0,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,0,0,63,0,0,0,0,0,0,0,0,0,0,424,0,0,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,0,0,384,0,0,0,0,0,0,0,0,0,0,424,0,0,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,0,0,424,0,0,0,0,0,0,0,0,0,0,424,0,0,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,0,0,424,0,0,0,0,0,0,0,0,0,0,424,0,0,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,0,0,424,0,0,0,0,0,0,0,0,0,0,424,0,0,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,402,63,63,424,63,63,63,63,63,63,63,63,63,63,424,63,63,400,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,321,361,361,479,361,361,361,361,361,361,361,361,361,361,479,361,361,322,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,402,51,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,281,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,385,306,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,400,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,360,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,322,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,402,0,0,0,0,0,400,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        };

        obj.createentity(267, 24, 12, 184);  // (vertical gravity line)
        obj.createentity(16, 24, 9,  9);  // (shiny trinket)
        obj.createentity(187, 24, 12, 64);  // (vertical gravity line)
        obj.createentity(104, 124, 11, 80);  // (horizontal gravity line)
        obj.createentity(48, 72, 10, 1, 252500);  // (savepoint)
        obj.createentity(224, 72, 10, 1, 252501);  // (savepoint)
        obj.createentity(99, 24, 12, 80);  // (vertical gravity line)
        rcol=0;

        roomname = "Young Man, It's Worth the Challenge";
        result = contents;
        break;
    }

    case rn(53,55):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        367,367,367,367,367,367,368,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,360,361,362,372,373,374,0,0,0,0,0,0,0,0,0,0,
        286,286,286,286,286,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,400,280,402,412,292,414,0,0,0,0,0,0,0,0,0,0,
        447,447,447,447,288,286,408,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,400,280,402,412,292,414,0,0,0,0,0,0,0,0,0,0,
        364,364,364,365,406,286,408,0,0,0,0,0,0,0,0,0,0,360,361,362,0,0,0,0,400,280,402,452,453,454,0,0,0,0,366,367,367,368,0,0,
        283,283,283,405,406,286,408,0,0,0,0,0,0,0,0,0,0,400,280,402,0,0,0,0,400,280,321,361,361,362,0,0,0,0,406,286,286,408,0,0,
        283,283,283,405,406,286,408,0,0,0,0,0,0,0,0,0,0,400,280,402,0,0,0,0,440,441,441,282,280,402,0,0,0,0,406,286,286,408,0,0,
        283,283,283,405,406,286,408,0,0,0,0,369,370,371,360,361,361,322,280,402,0,0,0,0,0,0,0,400,280,402,0,0,0,0,406,286,286,408,0,0,
        283,283,283,405,406,286,408,0,0,0,0,409,289,411,400,280,280,280,280,402,0,0,0,0,0,0,0,400,280,402,0,0,0,0,406,286,286,408,0,0,
        283,283,283,405,446,447,448,0,0,0,0,409,289,411,440,441,441,441,441,442,0,0,0,0,0,0,0,440,441,442,0,0,0,0,406,286,286,408,0,0,
        283,283,283,324,364,364,365,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,408,0,0,
        283,283,283,283,283,283,405,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,406,286,286,408,0,0,
        283,283,283,283,283,283,405,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,363,364,364,364,364,365,0,0,0,0,406,287,447,448,0,0,
        283,283,283,283,283,283,405,0,0,0,0,409,289,411,0,0,0,0,0,0,0,0,0,0,443,444,285,283,283,405,0,0,0,0,406,408,375,377,0,0,
        444,444,444,444,444,444,445,0,0,0,0,409,289,411,0,0,0,369,370,370,370,370,370,370,370,371,403,284,444,445,0,0,0,0,406,408,415,417,0,0,
        373,373,373,373,373,373,374,0,0,0,0,409,289,411,0,0,0,409,289,290,450,450,450,450,450,451,403,405,0,0,0,0,0,0,406,408,415,417,0,0,
        292,292,292,292,292,292,414,375,376,376,377,409,289,411,0,0,0,409,289,411,363,364,364,364,364,364,325,405,0,0,0,0,0,0,406,408,415,417,0,0,
        292,292,292,293,453,453,454,415,295,295,417,409,289,411,0,0,0,449,450,451,443,444,444,444,444,444,444,445,0,0,0,0,0,0,446,448,415,336,376,376,
        292,292,292,414,360,361,362,415,295,295,417,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,375,376,376,376,376,337,295,295,295,
        292,292,292,414,400,280,402,415,295,295,417,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,
        292,292,292,414,400,280,402,455,456,456,457,409,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,
        292,292,292,414,400,280,321,361,361,361,362,409,289,330,370,370,370,370,370,370,370,370,370,370,371,375,376,376,376,376,376,337,295,295,295,295,295,295,295,295,
        292,292,292,414,400,280,280,280,280,280,402,409,289,289,289,289,289,289,289,290,450,450,450,450,451,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        292,292,292,414,400,280,280,280,280,280,402,409,289,289,289,289,289,289,289,411,375,376,376,376,376,337,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        292,292,292,414,400,280,280,280,280,280,402,409,289,289,289,289,289,289,289,411,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        292,292,292,414,400,280,280,280,280,280,402,409,289,289,289,289,289,289,289,411,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        };

        rcol = 6;

        roomname = "Anomaly";
        result = contents;
        break;
    }

    case rn(54,55):
    {

        static const short contents[] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,417,412,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,295,295,417,412,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,296,456,457,412,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,295,295,417,372,373,334,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,296,456,457,412,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,417,372,373,334,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,296,456,457,412,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,417,372,373,334,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,296,456,457,412,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,372,373,334,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,455,457,412,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,372,373,334,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,372,373,334,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,372,373,334,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,360,361,361,361,361,362,0,0,0,0,0,366,368,412,292,292,292,292,292,292,292,292,292,292,292,292,292,292,292,
        0,0,0,0,0,0,0,0,0,0,0,400,280,280,280,280,402,0,0,0,0,0,406,408,452,453,453,453,294,292,292,292,292,292,292,292,292,292,292,292,
        370,370,370,371,366,367,367,368,363,364,365,440,282,280,280,281,442,363,364,365,366,367,328,408,369,370,370,371,452,453,294,292,292,292,292,292,292,292,292,292,
        289,289,289,411,406,286,286,408,403,283,324,365,440,282,281,442,363,325,283,405,406,286,286,408,409,289,289,330,370,371,452,453,294,292,292,292,292,292,292,292,
        289,289,289,411,446,288,286,408,443,285,283,324,365,440,442,363,325,283,284,445,406,286,287,448,409,289,289,289,289,330,370,371,452,453,294,292,292,292,292,292,
        289,289,289,330,371,446,288,327,368,443,285,283,324,364,364,325,283,284,445,366,328,287,448,369,331,289,289,289,289,289,289,330,370,371,452,453,294,292,292,292,
        289,289,289,289,330,371,406,286,327,368,443,444,285,283,283,284,444,445,366,328,286,408,369,331,289,289,289,289,289,289,289,289,289,330,370,371,452,453,294,292,
        289,289,289,289,289,411,446,288,286,327,367,368,443,444,444,445,366,367,328,286,287,448,409,289,289,289,289,289,289,289,289,289,289,289,289,330,370,371,452,453,
        289,289,289,289,289,330,371,446,447,288,286,327,367,367,367,367,328,286,287,447,448,369,331,289,289,289,289,289,289,289,289,289,289,289,289,289,289,330,370,370,
        289,289,289,289,289,289,330,370,371,406,286,286,286,286,286,286,286,286,408,369,370,331,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,406,286,286,286,286,286,286,286,286,408,409,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        };

        obj.createentity(104, 128, 9, 11);  // (shiny trinket)
        rcol = 6;

        roomname = "Purest Unobtainium";
        result = contents;
        break;
    }


    case rn(52,58):
    {

        static const short contents[] = {
        295,295,295,295,295,417,0,415,295,295,295,295,295,295,295,295,295,417,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,295,295,295,295,295,295,295,417,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,295,295,295,295,295,295,295,417,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,296,456,456,456,456,456,456,457,0,0,0,0,0,455,456,456,456,456,456,456,456,456,456,456,456,297,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,375,376,376,376,376,377,0,0,0,0,0,375,376,376,376,376,376,376,376,376,376,377,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,295,295,295,417,0,0,0,0,0,415,295,295,295,295,295,295,295,295,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,296,456,456,457,0,0,0,0,0,455,456,456,456,456,456,456,456,297,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,375,377,0,0,0,0,0,375,376,376,376,376,376,377,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,455,456,456,456,456,297,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,0,0,0,0,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,375,376,376,377,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,455,456,297,417,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,0,0,415,417,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,396,0,415,417,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,476,0,415,417,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,0,0,415,417,0,415,417,0,415,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,415,295,417,0,415,417,0,0,0,0,0,375,376,337,417,0,415,417,0,415,295,417,0,415,295,295,295,295,
        456,456,456,456,456,457,0,455,456,456,457,0,455,456,457,0,455,457,0,0,0,0,0,455,456,456,457,0,415,417,0,415,295,417,0,415,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,417,0,415,295,417,0,415,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,375,376,376,376,376,337,417,0,415,295,417,0,415,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,455,456,456,456,456,456,457,0,415,295,417,0,415,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,417,0,415,295,295,295,295,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,375,376,376,376,376,376,376,376,337,295,417,0,415,295,295,295,295,
        376,376,376,376,376,377,0,375,376,376,377,0,375,376,376,376,376,376,376,376,376,376,376,337,295,295,295,295,295,295,295,295,295,417,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,455,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,457,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,417,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,415,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,336,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,337,295,295,295,295,
        295,295,295,295,295,417,0,415,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,295,
        };

        obj.createentity(112, 184, 10, 1, 258520);  // (savepoint)
        rcol = 5;

        roomname = "I Smell Ozone";
        result = contents;
        break;
    }

    case rn(51,58):
    {

        static const short contents[] = {
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,280,
        };
        rcol=0;

        if(!game.intimetrial || game.translator_exploring)
        {
            if(game.companion==0 && !obj.flags[9] &&  !game.crewstats[5])   //also need to check if he's rescued in a previous game
            {
                obj.createentity(32, 177, 18, 16, 1, 17, 1);
                obj.createblock(1, 24*8, 0, 32, 240, 33);
            }
        }

        roomname = "Why So Blue?";

        result = contents;
        break;
    }

    case rn(50,58):
    {

        static const short contents[] = {
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,290,450,450,450,450,450,450,450,450,450,291,289,289,289,290,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,291,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,369,331,289,289,289,330,371,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,449,450,450,450,450,450,451,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,369,371,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,330,370,370,370,331,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,290,450,450,450,291,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,449,451,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,409,289,289,289,289,289,289,
        289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,449,450,450,450,450,450,450,
        289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,411,0,0,0,0,0,0,0,0,369,370,370,370,370,370,371,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,411,0,0,0,0,0,0,0,0,449,291,289,289,289,290,451,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,411,0,0,0,0,0,0,0,0,0,409,289,289,289,411,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        289,289,289,330,370,370,370,370,370,370,370,370,370,331,289,289,289,330,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,289,
        };
        rcol=3;


        obj.createentity((10 * 8)-4, (8 * 8) + 4, 14); //Teleporter!

        if(game.intimetrial)
        {
            obj.createblock(1, 280, 0, 32, 240, 82);
        }

        roomname = "Philadelphia Experiment";
        result = contents;
        break;
    }

#endif
    default:
    {
        static const short contents[1200] = {0};
        result = contents;
        break;
    }
    }

    return result;
}
