/*
main.m

Author: Makoto Kinoshita

Copyright 2004-2007 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <ExceptionHandling/NSExceptionHandler.h>

NSArray*    RSSDFeedURLs = nil;

void printStackTrace(NSException* ex)
{
     NSString *stack = [[ex userInfo] objectForKey:NSStackTraceKey];
     NSTask *ls=[[NSTask alloc] init];
     NSString *pid = [[NSNumber numberWithInt:getpid()] stringValue];
     NSMutableArray *args = [NSMutableArray arrayWithCapacity:20];

     [args addObject:@"-p"];
     [args addObject:pid];
     [args addObjectsFromArray:[stack componentsSeparatedByString:@"  "]];

     [ls setLaunchPath:@"/usr/bin/atos"];
     [ls setArguments:args];
     [ls launch];
     [ls waitUntilExit];
     
     [ls release];
}

@interface SRExceptionHandler : NSObject
{
}
@end

@implementation SRExceptionHandler

- (BOOL)exceptionHandler:(NSExceptionHandler*)exHandler 
        shouldLogException:(NSException*)exception mask:(unsigned int)mask
{
    printStackTrace(exception);
    return YES;
}

@end

int main(int argc, char *argv[])
{
#if 1
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    // Get arguments
    NSMutableArray* feedURLs;
    feedURLs = [[NSMutableArray array] retain];
    
    int i;
    for (i = 0; i < argc; i++) {
        NSString*   feedURL;
        feedURL = [NSString stringWithFormat:@"%s", argv[i]];
        if (feedURL) {
            [feedURLs addObject:feedURL];
        }
    }
    RSSDFeedURLs = feedURLs;
    
    [pool release];
    
    // Start application main
    return NSApplicationMain(argc, (const char **) argv);
#else
    SRExceptionHandler* srHandler;
    NSExceptionHandler* exHandler;
    srHandler = [[SRExceptionHandler alloc] init];
    exHandler = [NSExceptionHandler defaultExceptionHandler];
    [exHandler setExceptionHandlingMask:NSLogAndHandleEveryExceptionMask];
    [exHandler setDelegate:srHandler];
    
    int result = 0;
    @try {
        result = NSApplicationMain(argc, (const char **) argv);
    }
    @catch (NSException* ex) {
        NSLog(@"Exception: %@, %@", [ex name], [ex reason]);
        printStackTrace(ex);
    }
    
    return result;
#endif
}
