/*
SRShiiraProtocol.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRShiiraProtocol.h"

@implementation SRShiiraProtocol

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

+ (void)load
{
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    static isRegistered = NO;
    if (!isRegistered) {
        // Register itself
        [self registerClass:self];
        isRegistered = YES;
    }
    
    [pool release];
}

//--------------------------------------------------------------//
#pragma mark -- URL protocol handling --
//--------------------------------------------------------------//

+ (BOOL)canInitWithRequest:(NSURLRequest*)request
{
    // Get scheme
    NSString*   scheme;
    scheme = [[request URL] scheme];
    
    return [scheme isEqualToString:@"shiira"];
}

+ (NSURLRequest*)canonicalRequestForRequest:(NSURLRequest*)request
{
    return request;
}

- (void)startLoading
{
    // Notify finish loading after a momnet
    [NSTimer scheduledTimerWithTimeInterval:0 
            target:self selector:@selector(timerFired:) userInfo:nil repeats:NO];
}

- (void)stopLoading
{
}

- (NSURLResponse*)response
{
    // Get request
    NSURLRequest*   request;
    NSURL*          requestURL;
    request = [self request];
    if (!request) {
        return nil;
    }
    requestURL = [request URL];
    
    // Decide MIME type
    NSString*   MIMEType;
    MIMEType = @"shiira/shelf";
    
    // Create response
    NSURLResponse*  response;
    response = [[NSURLResponse alloc] initWithURL:requestURL 
            MIMEType:MIMEType expectedContentLength:0 textEncodingName:@"utf-8"];
    
    return response;
}

- (NSCachedURLResponse*)cachedResponse
{
    // Get response
    NSURLResponse*  response;
    response = [self response];
    
    // Create cached response
    NSCachedURLResponse*    cachedResponse;
    cachedResponse = [[NSCachedURLResponse alloc] initWithResponse:response data:nil];
    
    return cachedResponse;
}

- (void)timerFired:(NSTimer*)timer
{
    // Get client
    id  client;
    client = [self client];
    
    // Get response
    NSURLResponse*  response;
    response = [self response];
    
    // Notify response
    [client URLProtocol:self didReceiveResponse:response cacheStoragePolicy:NSURLCacheStorageNotAllowed];
    
    // Notify finish loading
    [client URLProtocolDidFinishLoading:self];
}

@end

