/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGDeviceActions.h
 *
 * Base device actions. Only the device actions corresponding to the device specified in the deviceHwType field is or should be present.
 */

#ifndef SWGDeviceActions_H_
#define SWGDeviceActions_H_

#include <QJsonObject>


#include "SWGSigMFFileInputActions.h"
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGDeviceActions: public SWGObject {
public:
    SWGDeviceActions();
    SWGDeviceActions(QString* json);
    virtual ~SWGDeviceActions();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGDeviceActions* fromJson(QString &jsonString) override;

    QString* getDeviceHwType();
    void setDeviceHwType(QString* device_hw_type);

    qint32 getDirection();
    void setDirection(qint32 direction);

    qint32 getOriginatorIndex();
    void setOriginatorIndex(qint32 originator_index);

    SWGSigMFFileInputActions* getSigMfFileInputActions();
    void setSigMfFileInputActions(SWGSigMFFileInputActions* sig_mf_file_input_actions);


    virtual bool isSet() override;

private:
    QString* device_hw_type;
    bool m_device_hw_type_isSet;

    qint32 direction;
    bool m_direction_isSet;

    qint32 originator_index;
    bool m_originator_index_isSet;

    SWGSigMFFileInputActions* sig_mf_file_input_actions;
    bool m_sig_mf_file_input_actions_isSet;

};

}

#endif /* SWGDeviceActions_H_ */
