///////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2015 F4EXB                                                      //
// written by Edouard Griffiths                                                  //
//                                                                               //
// This program is free software; you can redistribute it and/or modify          //
// it under the terms of the GNU General Public License as published by          //
// the Free Software Foundation as version 3 of the License, or                  //
// (at your option) any later version.                                           //
//                                                                               //
// This program is distributed in the hope that it will be useful,               //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                  //
// GNU General Public License V3 for more details.                               //
//                                                                               //
// You should have received a copy of the GNU General Public License             //
// along with this program. If not, see <http://www.gnu.org/licenses/>.          //
///////////////////////////////////////////////////////////////////////////////////

#include "../../channelrx/demodbfm/rdstmc.h"

#define TMC_EVENTS 2047+1
#define TMC_EVENT_LIST_LINES 2047+1

/* ISO 14819-2, Table 2 (paragraph 3.1.3, pages 5-57) */

/* table 2, paragraph 3.1.3, pages 5-57 of ISO 14819-2
 * 1st column: row number
 * 2nd column: text (CEN-English)
 * 3rd column: event code (to be transmitted/received)
 * 4th column: quantifier type */
static const char *tmc_events[TMC_EVENTS][4] = {
	{"0"," "," "," "},
	{"1"," "," "," "},
	{"2"," "," "," "},
	{"3"," "," "," "},
	{"4"," "," "," "},
	{"5","traffic problem","1"," "},
	{"6","stationary traffic","101"," "},
	{"7","stationary traffic for 1 km","102"," "},
	{"8","stationary traffic for 2 km","103"," "},
	{"9","stationary traffic for 3 km","129"," "},
	{"10","stationary traffic for 4 km","104"," "},
	{"11","stationary traffic for 6 km","105"," "},
	{"12","stationary traffic for 10 km","106"," "},
	{"13","danger of stationary traffic","130"," "},
	{"14","queuing traffic (with average speeds Q)","108","4"},
	{"15","queuing traffic for 1 km (with average speeds Q)","109","4"},
	{"16","queuing traffic for 2 km (with average speeds Q)","110","4"},
	{"17","queuing traffic for 3 km (with average speeds Q)","131","4"},
	{"18","queuing traffic for 4 km (with average speeds Q)","111","4"},
	{"19","queuing traffic for 6 km (with average speeds Q)","112","4"},
	{"20","queuing traffic for 10 km (with average speeds Q)","113","4"},
	{"21","danger of queuing traffic (with average speeds Q)","132","4"},
	{"22","long queues (with average speeds Q)","133","4"},
	{"23","slow traffic (with average speeds Q)","115","4"},
	{"24","slow traffic for 1 km (with average speeds Q)","116","4"},
	{"25","slow traffic for 2 km (with average speeds Q)","117","4"},
	{"26","slow traffic for 3 km (with average speeds Q)","134","4"},
	{"27","slow traffic for 4 km (with average speeds Q)","118","4"},
	{"28","slow traffic for 6 km (with average speeds Q)","119","4"},
	{"29","slow traffic for 10 km (with average speeds Q)","120","4"},
	{"30","heavy traffic (with average speeds Q)","122","4"},
	{"31","traffic heavier than normal (with average speeds Q)","142","4"},
	{"32","traffic very much heavier than normal (with average speeds Q)","143","4"},
	{"33","traffic flowing freely (with average speeds Q)","124","4"},
	{"34","traffic building up (with average speeds Q)","125","4"},
	{"35","traffic easing","135","4"},
	{"36","traffic congestion (with average speeds Q)","136","4"},
	{"37","traffic congestion, average speed of 10 km/h","70"," "},
	{"38","traffic congestion, average speed of 20 km/h","71"," "},
	{"39","traffic congestion, average speed of 30 km/h","72"," "},
	{"40","traffic congestion, average speed of 40 km/h","73"," "},
	{"41","traffic congestion, average speed of 50 km/h","74"," "},
	{"42","traffic congestion, average speed of 60 km/h","75"," "},
	{"43","traffic congestion, average speed of 70 km/h","76"," "},
	{"44","traffic lighter than normal (with average speeds Q)","137","4"},
	{"45","queuing traffic (with average speeds Q). Approach with care","138","4"},
	{"46","queuing traffic around a bend in the road","139"," "},
	{"47","queuing traffic over the crest of a hill","140"," "},
	{"48","queuing traffic (with average speeds Q). Danger of stationary traffic","2","4"},
	{"49","(Q) accident(s). Stationary traffic","215","0"},
	{"50","(Q) accident(s). Stationary traffic for 1 km","216","0"},
	{"51","(Q) accident(s). Stationary traffic for 2 km","217","0"},
	{"52","(Q) accident(s). Stationary traffic for 3 km","348","0"},
	{"53","(Q) accident(s). Stationary traffic for 4 km","218","0"},
	{"54","(Q) accident(s). Stationary traffic for 6 km","219","0"},
	{"55","(Q) accident(s). Stationary traffic for 10 km","220","0"},
	{"56","(Q) accident(s). Danger of stationary traffic","221","0"},
	{"57","(Q) accident(s). Queuing traffic","222","0"},
	{"58","(Q) accident(s). Queuing traffic for 1 km","223","0"},
	{"59","(Q) accident(s). Queuing traffic for 2 km","224","0"},
	{"60","(Q) accident(s). Queuing traffic for 3 km","349","0"},
	{"61","(Q) accident(s). Queuing traffic for 4 km","225","0"},
	{"62","(Q) accident(s). Queuing traffic for 6 km","226","0"},
	{"63","(Q) accident(s). Queuing traffic for 10 km","227","0"},
	{"64","(Q) accident(s). Danger of queuing traffic","228","0"},
	{"65","(Q) accident(s). Slow traffic","229","0"},
	{"66","(Q) accident(s). Slow traffic for 1 km","230","0"},
	{"67","(Q) accident(s). Slow traffic for 2 km","231","0"},
	{"68","(Q) accident(s). Slow traffic for 3 km","350","0"},
	{"69","(Q) accident(s). Slow traffic for 4 km","232","0"},
	{"70","(Q) accident(s). Slow traffic for 6 km","233","0"},
	{"71","(Q) accident(s). Slow traffic for 10 km","234","0"},
	{"72","(Q) accident(s). Heavy traffic","236","0"},
	{"73","(Q) accident(s). Traffic flowing freely","238","0"},
	{"74","(Q) accident(s). Traffic building up","239","0"},
	{"75","vehicles slowing to look at (Q) accident(s). Stationary traffic","250","0"},
	{"76","vehicles slowing to look at (Q) accident(s). Stationary traffic for 1 km","251","0"},
	{"77","vehicles slowing to look at (Q) accident(s). Stationary traffic for 2 km","252","0"},
	{"78","vehicles slowing to look at (Q) accident(s). Stationary traffic for 3 km","352","0"},
	{"79","vehicles slowing to look at (Q) accident(s). Stationary traffic for 4 km","253","0"},
	{"80","vehicles slowing to look at (Q) accident(s). Stationary traffic for 6 km","254","0"},
	{"81","vehicles slowing to look at (Q) accident(s). Stationary traffic for 10 km","255","0"},
	{"82","vehicles slowing to look at (Q) accident(s). Danger of stationary traffic","256","0"},
	{"83","vehicles slowing to look at (Q) accident(s). Queuing traffic","257","0"},
	{"84","vehicles slowing to look at (Q) accident(s). Queuing traffic for 1 km","258","0"},
	{"85","vehicles slowing to look at (Q) accident(s). Queuing traffic for 2 km","259","0"},
	{"86","vehicles slowing to look at (Q) accident(s). Queuing traffic for 3 km","353","0"},
	{"87","vehicles slowing to look at (Q) accident(s). Queuing traffic for 4 km","260","0"},
	{"88","vehicles slowing to look at (Q) accident(s). Queuing traffic for 6 km","261","0"},
	{"89","vehicles slowing to look at (Q) accident(s). Queuing traffic for 10 km","262","0"},
	{"90","vehicles slowing to look at (Q) accident(s). Danger of queuing traffic","263","0"},
	{"91","vehicles slowing to look at (Q) accident(s)","208","0"},
	{"92","vehicles slowing to look at (Q) accident(s). Slow traffic","264","0"},
	{"93","vehicles slowing to look at (Q) accident(s). Slow traffic for 1 km","265","0"},
	{"94","vehicles slowing to look at (Q) accident(s). Slow traffic for 2 km","266","0"},
	{"95","vehicles slowing to look at (Q) accident(s). Slow traffic for 3 km","354","0"},
	{"96","vehicles slowing to look at (Q) accident(s). Slow traffic for 4 km","267","0"},
	{"97","vehicles slowing to look at (Q) accident(s). Slow traffic for 6 km","268","0"},
	{"98","vehicles slowing to look at (Q) accident(s). Slow traffic for 10 km","269","0"},
	{"99","vehicles slowing to look at (Q) accident(s). Heavy traffic","271","0"},
	{"100","vehicles slowing to look at (Q) accident(s). Traffic building up","274","0"},
	{"101","vehicles slowing to look at (Q) accident(s). Danger","355","0"},
	{"102","(Q) shed load(s). Stationary traffic","278","0"},
	{"103","(Q) shed load(s). Stationary traffic for 1 km","279","0"},
	{"104","(Q) shed load(s). Stationary traffic for 2 km","280","0"},
	{"105","(Q) shed load(s). Stationary traffic for 3 km","356","0"},
	{"106","(Q) shed load(s). Stationary traffic for 4 km","281","0"},
	{"107","(Q) shed load(s). Stationary traffic for 6 km","282","0"},
	{"108","(Q) shed load(s). Stationary traffic for 10 km","283","0"},
	{"109","(Q) shed load(s). Danger of stationary traffic","284","0"},
	{"110","(Q) shed load(s). Queuing traffic","285","0"},
	{"111","(Q) shed load(s). Queuing traffic for 1 km","286","0"},
	{"112","(Q) shed load(s). Queuing traffic for 2 km","287","0"},
	{"113","(Q) shed load(s). Queuing traffic for 3 km","357","0"},
	{"114","(Q) shed load(s). Queuing traffic for 4 km","288","0"},
	{"115","(Q) shed load(s). Queuing traffic for 6 km","289","0"},
	{"116","(Q) shed load(s). Queuing traffic for 10 km","290","0"},
	{"117","(Q) shed load(s). Danger of queuing traffic","291","0"},
	{"118","(Q) shed load(s). Slow traffic","292","0"},
	{"119","(Q) shed load(s). Slow traffic for 1 km","293","0"},
	{"120","(Q) shed load(s). Slow traffic for 2 km","294","0"},
	{"121","(Q) shed load(s). Slow traffic for 3 km","358","0"},
	{"122","(Q) shed load(s). Slow traffic for 4 km","295","0"},
	{"123","(Q) shed load(s). Slow traffic for 6 km","296","0"},
	{"124","(Q) shed load(s). Slow traffic for 10 km","297","0"},
	{"125","(Q) shed load(s). Heavy traffic","299","0"},
	{"126","(Q) shed load(s). Traffic flowing freely","301","0"},
	{"127","(Q) shed load(s). Traffic building up","302","0"},
	{"128","(Q) overturned vehicle(s). Stationary traffic","360","0"},
	{"129","(Q) overturned vehicle(s). Danger of stationary traffic","361","0"},
	{"130","(Q) overturned vehicle(s). Queuing traffic","362","0"},
	{"131","(Q) overturned vehicle(s). Danger of queuing traffic","363","0"},
	{"132","(Q) overturned vehicle(s). Slow traffic","364","0"},
	{"133","(Q) overturned vehicle(s). Heavy traffic","366","0"},
	{"134","(Q) overturned vehicle(s). Traffic building up","368","0"},
	{"135","Stationary traffic due to (Q) earlier accident(s)","379","0"},
	{"136","Danger of stationary traffic due to (Q) earlier accident(s)","380","0"},
	{"137","Queuing traffic due to (Q) earlier accident(s)","381","0"},
	{"138","Danger of queuing traffic due to (Q) earlier accident(s)","382","0"},
	{"139","Slow traffic due to (Q) earlier accident(s)","383","0"},
	{"140","Heavy traffic due to (Q) earlier accident(s)","385","0"},
	{"141","Traffic building up due to (Q) earlier accident(s)","387","0"},
	{"142","(Q) broken down vehicle(s). Stationary traffic","313","0"},
	{"143","(Q) broken down vehicle(s). Danger of stationary traffic","314","0"},
	{"144","(Q) broken down vehicle(s). Queuing traffic","315","0"},
	{"145","(Q) broken down vehicle(s). Danger of queuing traffic","316","0"},
	{"146","(Q) broken down vehicle(s). Slow traffic","317","0"},
	{"147","(Q) broken down vehicle(s). Heavy traffic","319","0"},
	{"148","(Q) broken down vehicle(s). Traffic flowing freely","321","0"},
	{"149","(Q) broken down vehicle(s). Traffic building up","322","0"},
	{"150","closed ahead. Stationary traffic","410"," "},
	{"151","closed ahead. Stationary traffic for 1 km","411"," "},
	{"152","closed ahead. Stationary traffic for 2 km","412"," "},
	{"153","closed ahead. Stationary traffic for 3 km","495"," "},
	{"154","closed ahead. Stationary traffic for 4 km","413"," "},
	{"155","closed ahead. Stationary traffic for 6 km","414"," "},
	{"156","closed ahead. Stationary traffic for 10 km","415"," "},
	{"157","closed ahead. Danger of stationary traffic","416"," "},
	{"158","closed ahead. Queuing traffic","417"," "},
	{"159","closed ahead. Queuing traffic for 1 km","418"," "},
	{"160","closed ahead. Queuing traffic for 2 km","419"," "},
	{"161","closed ahead. Queuing traffic for 3 km","496"," "},
	{"162","closed ahead. Queuing traffic for 4 km","420"," "},
	{"163","closed ahead. Queuing traffic for 6 km","421"," "},
	{"164","closed ahead. Queuing traffic for 10 km","422"," "},
	{"165","closed ahead. Danger of queuing traffic","423"," "},
	{"166","closed ahead. Slow traffic","424"," "},
	{"167","closed ahead. Slow traffic for 1 km","425"," "},
	{"168","closed ahead. Slow traffic for 2 km","426"," "},
	{"169","closed ahead. Slow traffic for 3 km","497"," "},
	{"170","closed ahead. Slow traffic for 4 km","427"," "},
	{"171","closed ahead. Slow traffic for 6 km","428"," "},
	{"172","closed ahead. Slow traffic for 10 km","429"," "},
	{"173","closed ahead. Heavy traffic","431"," "},
	{"174","closed ahead. Traffic flowing freely","433"," "},
	{"175","closed ahead. Traffic building up","434"," "},
	{"176","blocked ahead. Stationary traffic","438"," "},
	{"177","blocked ahead. Stationary traffic for 1 km","439"," "},
	{"178","blocked ahead. Stationary traffic for 2 km","440"," "},
	{"179","blocked ahead. Stationary traffic for 3 km","498"," "},
	{"180","blocked ahead. Stationary traffic for 4 km","441"," "},
	{"181","blocked ahead. Stationary traffic for 6 km","442"," "},
	{"182","blocked ahead. Stationary traffic for 10 km","443"," "},
	{"183","blocked ahead. Danger of stationary traffic","444"," "},
	{"184","blocked ahead. Queuing traffic","445"," "},
	{"185","blocked ahead. Queuing traffic for 1 km","446"," "},
	{"186","blocked ahead. Queuing traffic for 2 km","447"," "},
	{"187","blocked ahead. Queuing traffic for 3 km","499"," "},
	{"188","blocked ahead. Queuing traffic for 4 km","448"," "},
	{"189","blocked ahead. Queuing traffic for 6 km","449"," "},
	{"190","blocked ahead. Queuing traffic for 10 km","450"," "},
	{"191","blocked ahead. Danger of queuing traffic","451"," "},
	{"192","blocked ahead. Slow traffic","452"," "},
	{"193","blocked ahead. Slow traffic for 1 km","453"," "},
	{"194","blocked ahead. Slow traffic for 2 km","454"," "},
	{"195","blocked ahead. Slow traffic for 3 km","626"," "},
	{"196","blocked ahead. Slow traffic for 4 km","455"," "},
	{"197","blocked ahead. Slow traffic for 6 km","456"," "},
	{"198","blocked ahead. Slow traffic for 10 km","457"," "},
	{"199","blocked ahead. Heavy traffic","459"," "},
	{"200","blocked ahead. Traffic flowing freely","461"," "},
	{"201","blocked ahead. Traffic building up","462"," "},
	{"202","(Q) lanes closed. Stationary traffic","521","0"},
	{"203","(Q) lanes closed. Stationary traffic for 1 km","522","0"},
	{"204","(Q) lanes closed. Stationary traffic for 2 km","523","0"},
	{"205","(Q) lanes closed. Stationary traffic for 3 km","651","0"},
	{"206","(Q) lanes closed. Stationary traffic for 4 km","524","0"},
	{"207","(Q) lanes closed. Stationary traffic for 6 km","525","0"},
	{"208","(Q) lanes closed. Stationary traffic for 10 km","526","0"},
	{"209","(Q) lanes closed. Danger of stationary traffic","527","0"},
	{"210","(Q) lanes closed. Queuing traffic","528","0"},
	{"211","(Q) lanes closed. Queuing traffic for 1 km","529","0"},
	{"212","(Q) lanes closed. Queuing traffic for 2 km","530","0"},
	{"213","(Q) lanes closed. Queuing traffic for 3 km","652","0"},
	{"214","(Q) lanes closed. Queuing traffic for 4 km","531","0"},
	{"215","(Q) lanes closed. Queuing traffic for 6 km","532","0"},
	{"216","(Q) lanes closed. Queuing traffic for 10 km","533","0"},
	{"217","(Q) lanes closed. Danger of queuing traffic","534","0"},
	{"218","(Q) lanes closed. Slow traffic","535","0"},
	{"219","(Q) lanes closed. Slow traffic for 1 km","536","0"},
	{"220","(Q) lanes closed. Slow traffic for 2 km","537","0"},
	{"221","(Q) lanes closed. Slow traffic for 3 km","653","0"},
	{"222","(Q) lanes closed. Slow traffic for 4 km","538","0"},
	{"223","(Q) lanes closed. Slow traffic for 6 km","539","0"},
	{"224","(Q) lanes closed. Slow traffic for 10 km","540","0"},
	{"225","(Q) lanes closed. Heavy traffic","542","0"},
	{"226","(Q)lanes closed. Traffic flowing freely","544","0"},
	{"227","(Q)lanes closed. Traffic building up","545","0"},
	{"228","carriageway reduced (from Q lanes) to one lane. Stationary traffic","546","0"},
	{"229","carriageway reduced (from Q lanes) to one lane. Danger of stationary traffic","547","0"},
	{"230","carriageway reduced (from Q lanes) to one lane. Queuing traffic","548","0"},
	{"231","carriageway reduced (from Q lanes) to one lane. Danger of queuing traffic","549","0"},
	{"232","carriageway reduced (from Q lanes) to one lane. Slow traffic","550","0"},
	{"233","carriageway reduced (from Q lanes) to one lane. Heavy traffic","552","0"},
	{"234","carriageway reduced (from Q lanes) to one lane. Traffic flowing freely","554","0"},
	{"235","carriageway reduced (from Q lanes) to one lane. Traffic building up","555","0"},
	{"236","carriageway reduced (from Q lanes) to two lanes. Stationary traffic","556","0"},
	{"237","carriageway reduced (from Q lanes) to two lanes. Danger of stationary traffic","557","0"},
	{"238","carriageway reduced (from Q lanes) to two lanes. Queuing traffic","558","0"},
	{"239","carriageway reduced (from Q lanes) to two lanes. Danger of queuing traffic","559","0"},
	{"240","carriageway reduced (from Q lanes) to two lanes. Slow traffic","560","0"},
	{"241","carriageway reduced (from Q lanes) to two lanes. Heavy traffic","562","0"},
	{"242","carriageway reduced (from Q lanes) to two lanes. Traffic flowing freely","564","0"},
	{"243","carriageway reduced (from Q lanes) to two lanes. Traffic building up","565","0"},
	{"244","carriageway reduced (from Q lanes) three lanes. Stationary traffic","566","0"},
	{"245","carriageway reduced (from Q lanes) three lanes. Danger of stationary traffic","567","0"},
	{"246","carriageway reduced (from Q lanes) three lanes. Queuing traffic","568","0"},
	{"247","carriageway reduced (from Q lanes) three lanes. Danger of queuing traffic","569","0"},
	{"248","carriageway reduced (from Q lanes) to three lanes. Slow traffic","570","0"},
	{"249","carriageway reduced (from Q lanes) to three lanes. Heavy traffic","572","0"},
	{"250","carriageway reduced (from Q lanes) to three lanes. Traffic flowing freely","574","0"},
	{"251","carriageway reduced (from Q lanes) to three lanes. Traffic building up","575","0"},
	{"252","contraflow. Stationary traffic","576"," "},
	{"253","contraflow. Stationary traffic for 1 km","577"," "},
	{"254","contraflow. Stationary traffic for 2 km","578"," "},
	{"255","contraflow. Stationary traffic for 3 km","654"," "},
	{"256","contraflow. Stationary traffic for 4 km","579"," "},
	{"257","contraflow. Stationary traffic for 6 km","580"," "},
	{"258","contraflow. Stationary traffic for 10 km","581"," "},
	{"259","contraflow. Danger of stationary traffic","582"," "},
	{"260","contraflow. Queuing traffic","583"," "},
	{"261","contraflow. Queuing traffic for1km","584"," "},
	{"262","contraflow. Queuing traffic for2km","585"," "},
	{"263","contraflow. Queuing traffic for3km","655"," "},
	{"264","contraflow. Queuing traffic for4km","586"," "},
	{"265","contraflow. Queuing traffic for6km","587"," "},
	{"266","contraflow. Queuing traffic for 10 km","588"," "},
	{"267","contraflow. Danger of queuing traffic","589"," "},
	{"268","contraflow. Slow traffic","590"," "},
	{"269","contraflow. Slow traffic for 1 km","591"," "},
	{"270","contraflow. Slow traffic for 2 km","592"," "},
	{"271","contraflow. Slow traffic for 3 km","656"," "},
	{"272","contraflow. Slow traffic for 4 km","593"," "},
	{"273","contraflow. Slow traffic for 6 km","594"," "},
	{"274","contraflow. Slow traffic for 10 km","595"," "},
	{"275","contraflow. Heavy traffic","597"," "},
	{"276","contraflow. Traffic flowing freely","599"," "},
	{"277","contraflow. Traffic building up","600"," "},
	{"278","narrow lanes. Stationary traffic","604"," "},
	{"279","narrow lanes. Danger of stationary traffic","605"," "},
	{"280","narrow lanes. Queuing traffic","606"," "},
	{"281","narrow lanes. Danger of queuing traffic","607"," "},
	{"282","narrow lanes. Slow traffic","608"," "},
	{"283","narrow lanes. Heavy traffic","610"," "},
	{"284","narrow lanes. Traffic flowing freely","612"," "},
	{"285","narrow lanes. Traffic building up","613"," "},
	{"286","contraflow with narrow lanes. Stationary traffic","614"," "},
	{"287","contraflow with narrow lanes. Danger of stationary traffic","615"," "},
	{"288","contraflow with narrow lanes. Queuing traffic","616"," "},
	{"289","contraflow with narrow lanes. Danger of queuing traffic","617"," "},
	{"290","contraflow with narrow lanes. Slow traffic","618"," "},
	{"291","contraflow with narrow lanes. Heavy traffic","620"," "},
	{"292","contraflow with narrow lanes. Traffic flowing freely","622"," "},
	{"293","contraflow with narrow lanes. Traffic building up","623"," "},
	{"294","(Q sets of) roadworks. Stationary traffic","710","0"},
	{"295","(Q sets of) roadworks. Stationary traffic for 1 km","711","0"},
	{"296","(Q sets of) roadworks. Stationary traffic for 2 km","712","0"},
	{"297","(Q sets of) roadworks. Stationary traffic for 3 km","812","0"},
	{"298","(Q sets of) roadworks. Stationary traffic for 4 km","713","0"},
	{"299","(Q sets of) roadworks. Stationary traffic for 6 km","714","0"},
	{"300","(Q sets of) roadworks. Stationary traffic for 10 km","715","0"},
	{"301","(Q sets of) roadworks. Danger of stationary traffic","716","0"},
	{"302","(Q sets of) roadworks. Queuing traffic","717","0"},
	{"303","(Q sets of) roadworks. Queuing traffic for 1 km","718","0"},
	{"304","(Q sets of) roadworks. Queuing traffic for 2 km","719","0"},
	{"305","(Q sets of) roadworks. Queuing traffic for 3 km","813","0"},
	{"306","(Q sets of) roadworks. Queuing traffic for 4 km","720","0"},
	{"307","(Q sets of) roadworks. Queuing traffic for 6 km","721","0"},
	{"308","(Q sets of) roadworks. Queuing traffic for 10 km","722","0"},
	{"309","(Q sets of) roadworks. Danger of queuing traffic","723","0"},
	{"310","(Q sets of) roadworks. Slow traffic","724","0"},
	{"311","(Q sets of) roadworks. Slow traffic for 1 km","725","0"},
	{"312","(Q sets of) roadworks. Slow traffic for 2 km","726","0"},
	{"313","(Q sets of) roadworks. Slow traffic for 3 km","814","0"},
	{"314","(Q sets of) roadworks. Slow traffic for 4 km","727","0"},
	{"315","(Q sets of) roadworks. Slow traffic for 6 km","728","0"},
	{"316","(Q sets of) roadworks. Slow traffic for 10 km","729","0"},
	{"317","(Q sets of) roadworks. Heavy traffic","731","0"},
	{"318","(Q sets of) roadworks. Traffic flowing freely","733","0"},
	{"319","(Q sets of) roadworks. Traffic building up","734","0"},
	{"320","(Q sections of) resurfacing work. Stationary traffic","750","0"},
	{"321","(Q sections of) resurfacing work. Stationary traffic for 1 km","751","0"},
	{"322","(Q sections of) resurfacing work. Stationary traffic for 2 km","752","0"},
	{"323","(Q sections of) resurfacing work. Stationary traffic for 3 km","818","0"},
	{"324","(Q sections of) resurfacing work. Stationary traffic for 4 km","753","0"},
	{"325","(Q sections of) resurfacing work. Stationary traffic for 6 km","754","0"},
	{"326","(Q sections of) resurfacing work. Stationary traffic for 10 km","755","0"},
	{"327","(Q sections of) resurfacing work. Danger of stationary traffic","756","0"},
	{"328","(Q sections of) resurfacing work. Queuing traffic","757","0"},
	{"329","(Q sections of) resurfacing work. Queuing traffic for 1 km","758","0"},
	{"330","(Q sections of) resurfacing work. Queuing traffic for 2 km","759","0"},
	{"331","(Q sections of) resurfacing work. Queuing traffic for 3 km","819","0"},
	{"332","(Q sections of) resurfacing work. Queuing traffic for 4 km","760","0"},
	{"333","(Q sections of) resurfacing work. Queuing traffic for 6 km","761","0"},
	{"334","(Q sections of) resurfacing work. Queuing traffic for 10 km","762","0"},
	{"335","(Q sections of) resurfacing work. Danger of queuing traffic","763","0"},
	{"336","(Q sections of) resurfacing work. traffic","764","0"},
	{"337","(Q sections of) resurfacing work. traffic for 1 km","765","0"},
	{"338","(Q sections of) resurfacing work. traffic for 2 km","766","0"},
	{"339","(Q sections of) resurfacing work. traffic for 3 km","820","0"},
	{"340","(Q sections of) resurfacing work. traffic for 4 km","767","0"},
	{"341","(Q sections of) resurfacing work. traffic for 6 km","768","0"},
	{"342","(Q sections of) resurfacing work. traffic for 10 km","769","0"},
	{"343","(Q sections of) resurfacing work. Heavy traffic","771","0"},
	{"344","(Q sections of) resurfacing work. Traffic flowing freely","773","0"},
	{"345","(Q sections of) resurfacing work. Traffic building up","774","0"},
	{"346","(Q sets of) road marking work. Stationary traffic","783","0"},
	{"347","(Q sets of) road marking work. Danger of stationary traffic","784","0"},
	{"348","(Q sets of) road marking work. Queuing traffic","785","0"},
	{"349","(Q sets of) road marking work. Danger of queuing traffic","786","0"},
	{"350","(Q sets of) road marking work. Slow traffic","787","0"},
	{"351","(Q sets of) road marking work. Heavy traffic","789","0"},
	{"352","(Q sets of) road marking work. Traffic flowing freely","791","0"},
	{"353","(Q sets of) road marking work. Traffic building up","792","0"},
	{"354","(Q sets of) slow moving maintenance vehicles. Stationary traffic","825","0"},
	{"355","(Q sets of) slow moving maintenance vehicles. Danger of stationary traffic","826","0"},
	{"356","(Q sets of) slow moving maintenance vehicles. Queuing traffic","827","0"},
	{"357","(Q sets of) slow moving maintenance vehicles. Danger of queuing traffic","828","0"},
	{"358","(Q sets of) slow moving maintenance vehicles. Slow traffic","829","0"},
	{"359","(Q sets of) slow moving maintenance vehicles. Heavy traffic","831","0"},
	{"360","(Q sets of) slow moving maintenance vehicles. Traffic flowing freely","833","0"},
	{"361","(Q sets of) slow moving maintenance vehicles. Traffic building up","834","0"},
	{"362","flooding. Stationary traffic","928"," "},
	{"363","flooding. Danger of stationary traffic","929"," "},
	{"364","flooding. Queuing traffic","930"," "},
	{"365","flooding. Danger of queuing traffic","931"," "},
	{"366","flooding. Slow traffic","932"," "},
	{"367","flooding. Heavy traffic","934"," "},
	{"368","flooding. Traffic flowing freely","936"," "},
	{"369","flooding. Traffic building up","937"," "},
	{"370","major event. Stationary traffic","1517"," "},
	{"371","major event. Danger of stationary traffic","1518"," "},
	{"372","major event. Queuing traffic","1519"," "},
	{"373","major event. Danger of queuing traffic","1520"," "},
	{"374","major event. Slow traffic","1521"," "},
	{"375","major event. Heavy traffic","1523"," "},
	{"376","major event. Traffic flowing freely","1525"," "},
	{"377","major event. Traffic building up","1526"," "},
	{"378","sports meeting. Stationary traffic","1531"," "},
	{"379","sports meeting. Danger of stationary traffic","1532"," "},
	{"380","sports meeting. Queuing traffic","1533"," "},
	{"381","sports meeting. Danger of queuing traffic","1534"," "},
	{"382","sports meeting. Slow traffic","1535"," "},
	{"383","sports meeting. Heavy traffic","1537"," "},
	{"384","sports meeting. Traffic flowing freely","1539"," "},
	{"385","sports meeting. Traffic building up","1540"," "},
	{"386","fair. Stationary traffic","1545"," "},
	{"387","fair. Danger of stationary traffic","1546"," "},
	{"388","fair. Queuing traffic","1547"," "},
	{"389","fair. Danger of queuing traffic","1548"," "},
	{"390","fair. Slow traffic","1549"," "},
	{"391","fair. Heavy traffic","1551"," "},
	{"392","fair. Traffic flowing freely","1553"," "},
	{"393","fair. Traffic building up","1554"," "},
	{"394","security alert. Stationary traffic","1571"," "},
	{"395","security alert. Danger of stationary traffic","1572"," "},
	{"396","security alert. Queuing traffic","1573"," "},
	{"397","security alert. Danger of queuing traffic","1574"," "},
	{"398","security alert. Slow traffic","1575"," "},
	{"399","security alert. Heavy traffic","1577"," "},
	{"400","evacuation. Heavy traffic","1495"," "},
	{"401","security alert. Traffic flowing freely","1586"," "},
	{"402","security alert. Traffic building up","1579"," "},
	{"403","(Q sets of) traffic lights not working. Stationary traffic","1807","0"},
	{"404","(Q sets of) traffic lights not working. Danger of stationary traffic","1808","0"},
	{"405","(Q sets of) traffic lights not working. Queuing traffic","1809","0"},
	{"406","(Q sets of) traffic lights not working. Danger of queuing traffic","1810","0"},
	{"407","(Q sets of) traffic lights not working. Slow traffic","1811","0"},
	{"408","(Q sets of) traffic lights not working. Heavy traffic","1813","0"},
	{"409","(Q sets of) traffic lights not working. Traffic flowing freely","1815","0"},
	{"410","(Q sets of) traffic lights not working. Traffic building up","1816","0"},
	{"411","level crossing failure. Stationary traffic","1820"," "},
	{"412","level crossing failure. Danger of stationary traffic","1821"," "},
	{"413","level crossing failure. Queuing traffic","1822"," "},
	{"414","level crossing failure. Danger of queuing traffic","1823"," "},
	{"415","level crossing failure. Slow traffic","1824"," "},
	{"416","level crossing failure. Heavy traffic","1826"," "},
	{"417","level crossing failure. Traffic flowing freely","1828"," "},
	{"418","level crossing failure. Traffic building up","1829"," "},
	{"419"," "," "," "},
	{"420","no problems to report","126"," "},
	{"421","traffic congestion cleared","127"," "},
	{"422","traffic has returned to normal","1584"," "},
	{"423"," "," "," "},
	{"424","message cancelled","128"," "},
	{"425"," "," "," "},
	{"426"," "," "," "},
	{"427"," "," "," "},
	{"428"," "," "," "},
	{"429"," "," "," "},
	{"430","traffic problem expected","55"," "},
	{"431","stationary traffic expected","107"," "},
	{"432","queuing traffic expected","114"," "},
	{"433","slow traffic expected","121"," "},
	{"434","heavy traffic expected","123"," "},
	{"435","traffic congestion expected","56"," "},
	{"436","(Q) accident(s). Slow traffic expected","235","0"},
	{"437","(Q) accident(s). Heavy traffic expected","237","0"},
	{"438","vehicles slowing to look at (Q) accident(s). Slow traffic expected","270","0"},
	{"439","vehicles slowing to look at (Q) accident(s). Heavy traffic expected","272","0"},
	{"440","(Q) shed load(s). Slow traffic expected","298","0"},
	{"441","(Q) shed load(s). Heavy traffic expected","300","0"},
	{"442","(Q) overturned vehicle(s). Slow traffic expected","365","0"},
	{"443","(Q) overturned vehicle(s). Heavy traffic expected","367","0"},
	{"444","(Q) broken down vehicle(s). Slow traffic expected","318","0"},
	{"445","(Q) broken down vehicle(s). Heavy traffic expected","320","0"},
	{"446","closed ahead. Slow traffic expected","430"," "},
	{"447","closed ahead. Heavy traffic expected","432"," "},
	{"448","blocked ahead. Slow traffic expected","458"," "},
	{"449","blocked ahead. Heavy traffic expected","460"," "},
	{"450","(Q) lanes closed. Slow traffic expected","541","0"},
	{"451","(Q) lanes closed. Heavy traffic expected","543","0"},
	{"452","carriageway reduced (from Q lanes) to one lane. Slow traffic expected","551","0"},
	{"453","carriageway reduced (from Q lanes) to one lane. Heavy traffic expected","553","0"},
	{"454","carriageway reduced (from Q lanes) to two lanes. Slow traffic expected","561","0"},
	{"455","carriageway reduced (from Q lanes) to two lanes. Heavy traffic expected","563","0"},
	{"456","carriageway reduced (from Q lanes) to three lanes. Slow traffic expected","571","0"},
	{"457","carriageway reduced (from Q lanes) to three lanes. Heavy traffic expected","573","0"},
	{"458","contraflow. Slow traffic expected","596"," "},
	{"459","contraflow. Heavy traffic expected","598"," "},
	{"460","narrow lanes. Slow traffic expected","609"," "},
	{"461","narrow lanes. Heavy traffic expected","611"," "},
	{"462","contraflow with narrow lanes. Slow traffic expected","619"," "},
	{"463","contraflow with narrow lanes. Heavy traffic expected","621"," "},
	{"464","(Q sets of) roadworks. Slow traffic expected","730","0"},
	{"465","(Q sets of) roadworks. Heavy traffic expected","732","0"},
	{"466","(Q sections of) resurfacing work. Slow traffic expected","770","0"},
	{"467","(Q sections of) resurfacing work. Heavy traffic expected","772","0"},
	{"468","(Q sets of) road marking work. Slow traffic expected","788","0"},
	{"469","(Q sets of) road marking work. Heavy traffic expected","790","0"},
	{"470","(Q sets of) slow moving maintenance vehicles. Slow traffic expected","830","0"},
	{"471","(Q sets of) slow moving maintenance vehicles. Heavy traffic expected","832","0"},
	{"472","flooding. Slow traffic expected","933"," "},
	{"473","flooding. Heavy traffic expected","935"," "},
	{"474","major event. Slow traffic expected","1522"," "},
	{"475","major event. Heavy traffic expected","1524"," "},
	{"476","sports meeting. Slow traffic expected","1536"," "},
	{"477","sports meeting. Heavy traffic expected","1538"," "},
	{"478","fair. Slow traffic expected","1550"," "},
	{"479","fair. Heavy traffic expected","1552"," "},
	{"480","security alert. Slow traffic expected","1576"," "},
	{"481","security alert. Heavy traffic expected","1578"," "},
	{"482","(Q sets of) traffic lights not working. Slow traffic expected","1812","0"},
	{"483","(Q sets of) traffic lights not working. Heavy traffic expected","1814","0"},
	{"484","level crossing failure. Slow traffic expected","1825"," "},
	{"485","level crossing failure. Heavy traffic expected","1827"," "},
	{"486"," "," "," "},
	{"487","normal traffic expected","57"," "},
	{"488"," "," "," "},
	{"489","message cancelled","1589"," "},
	{"490"," "," "," "},
	{"491"," "," "," "},
	{"492"," "," "," "},
	{"493"," "," "," "},
	{"494"," "," "," "},
	{"495","(Q) accident(s)","201","0"},
	{"496","(Q) serious accident(s)","202","0"},
	{"497","multi-vehicle accident (involving Q vehicles)","203","0"},
	{"498","accident involving (a/Q) heavy lorr(y/ies)","204","0"},
	{"499","accident involving (a/Q) bus(es)","335","0"},
	{"500","(Q) accident(s) involving hazardous materials","205","0"},
	{"501","(Q) fuel spillage accident(s)","206","0"},
	{"502","(Q) chemical spillage accident(s)","207","0"},
	{"503","(Q) oil spillage accident(s)","336","0"},
	{"504","(Q) overturned vehicle(s)","337","0"},
	{"505","(Q) overturned heavy lorr(y/ies)","338","0"},
	{"506","(Q) jack-knifed trailer(s)","339","0"},
	{"507","(Q) jack-knifed caravan(s)","340","0"},
	{"508","(Q) jack-knifed articulated lorr(y/ies)","341","0"},
	{"509","(Q) vehicle fire(s)","213","0"},
	{"510","(Q) vehicle(s) spun around","342","0"},
	{"511","(Q) overturned vehicle(s). Danger","378","0"},
	{"512","(Q) earlier accident(s)","343","0"},
	{"513","accident investigation work","344"," "},
	{"514","accident investigation work. Danger","391"," "},
	{"515","(Q) accident(s) in roadworks area","351","0"},
	{"516","(Q) accident(s), traffic being directed around accident area","12","0"},
	{"517","(Q) secondary accident(s)","345","0"},
	{"518","(Q) secondary accident(s). Danger","392","0"},
	{"519","(Q) accident(s) in the opposing lanes","209","0"},
	{"520"," "," "," "},
	{"521","all accidents cleared, no problems to report","141"," "},
	{"522","accident cleared","333"," "},
	{"523"," "," "," "},
	{"524","message cancelled","334"," "},
	{"525"," "," "," "},
	{"526"," "," "," "},
	{"527"," "," "," "},
	{"528"," "," "," "},
	{"529"," "," "," "},
	{"530","(Q) incident(s)","214","0"},
	{"531","(Q) broken down vehicle(s)","211","0"},
	{"532","(Q) broken down vehicle(s). Danger","393","0"},
	{"533","(Q) broken down heavy lorr(y/ies)","212","0"},
	{"534","(Q) broken down heavy lorr(y/ies). Danger","394","0"},
	{"535","(Q) broken down bus(es)","346","0"},
	{"536","over-height warning system triggered","11"," "},
	{"537","clearance work","924"," "},
	{"538","clearance work. Danger","1034"," "},
	{"539","rescue and recovery work in progress","397"," "},
	{"540","rescue and recovery work in progress. Danger","1066"," "},
	{"541"," "," "," "},
	{"542","incident cleared","396"," "},
	{"543","road cleared","395"," "},
	{"544"," "," "," "},
	{"545","message cancelled","2028"," "},
	{"546"," "," "," "},
	{"547"," "," "," "},
	{"548"," "," "," "},
	{"549"," "," "," "},
	{"550","intermittent short term closures","666"," "},
	{"551","Closed","401"," "},
	{"552","road closed due to (Q) accident(s)","240","0"},
	{"553","closed, rescue and recovery work in progress","16"," "},
	{"554","(Q) lane(s) closed","500","0"},
	{"555","(Q) right lane(s) closed","501","0"},
	{"556","(Q) centre lane(s) closed","502","0"},
	{"557","(Q) left lane(s) closed","503","0"},
	{"558","hard shoulder closed","504"," "},
	{"559","emergency lane closed","637"," "},
	{"560","(Q) overtaking lane(s) closed","41","0"},
	{"561","one lane closed","641"," "},
	{"562","two lanes closed","505"," "},
	{"563","three lanes closed","506"," "},
	{"564","carriageway reduced (from Q lanes) one lane","514","0"},
	{"565","carriageway reduced (from Q lanes) two lanes","515","0"},
	{"566","carriageway reduced (from Q lanes) three lanes","516","0"},
	{"567","contraflow. Carriageway reduced (from Q lanes) to one lane","601","0"},
	{"568","contraflow. Carriageway reduced (from Q lanes) to two lanes","602","0"},
	{"569","contraflow. Carriageway reduced (from Q lanes) to three lanes","603","0"},
	{"570","closed due to (Q sets of) roadworks","735","0"},
	{"571","(Q sets of) roadworks. Right lane closed","736","0"},
	{"572","(Q sets of) roadworks. Centre lane closed","737","0"},
	{"573","(Q sets of) roadworks. Left lane closed","738","0"},
	{"574","(Q sets of) roadworks. Hard shoulder closed","739","0"},
	{"575","(Q sets of) roadworks. Two lanes closed","740","0"},
	{"576","(Q sets of) roadworks. Three lanes closed","741","0"},
	{"577","roadworks, (Q) overtaking lane(s) closed","51","0"},
	{"578","roadworks. Carriageway reduced (from Q lanes) to one lane","743","0"},
	{"579","roadworks. Carriageway reduced (from Q lanes) to two lanes","744","0"},
	{"580","roadworks. Carriageway reduced (from Q lanes) to three lanes","745","0"},
	{"581","resurfacing work. Carriageway reduced (from Q lanes) to one lane","776","0"},
	{"582","resurfacing work. Carriageway reduced (from Q lanes) to two lanes","777","0"},
	{"583","resurfacing work. Carriageway reduced (from Q lanes) to three lanes","778","0"},
	{"584","(Q sets of) road marking work. Right lane closed","793","0"},
	{"585","(Q sets of) road marking work. Centre lane closed","794","0"},
	{"586","(Q sets of) road marking work. Left lane closed","795","0"},
	{"587","(Q sets of) road marking work. Hard shoulder closed","796","0"},
	{"588","(Q sets of) road marking work. Two lanes closed","797","0"},
	{"589","(Q sets of) road marking work. Three lanes closed","798","0"},
	{"590","(Q sets of) slow moving maintenance vehicles. Right lane closed","835","0"},
	{"591","(Q sets of) slow moving maintenance vehicles. Centre lane closed","836","0"},
	{"592","(Q sets of) slow moving maintenance vehicles. Left lane closed","837","0"},
	{"593","(Q sets of) slow moving maintenance vehicles. Two lanes closed","838","0"},
	{"594","(Q sets of) slow moving maintenance vehicles. Three lanes closed","839","0"},
	{"595","closed for bridge demolition work (at Q bridges)","799","0"},
	{"596","road closed due to landslips","947"," "},
	{"597","road closed due to burst water main","957"," "},
	{"598","closed due to serious fire","965"," "},
	{"599","subsidence. Carriageway reduced (from Q lanes) to one lane","951","0"},
	{"600","subsidence. Carriageway reduced (from Q lanes) to two lanes","952","0"},
	{"601","subsidence. Carriageway reduced (from Q lanes) to three lanes","953","0"},
	{"602","closed due to sewer collapse","956"," "},
	{"603","closed due to gas leak","961"," "},
	{"604","closed for clearance work","969"," "},
	{"605","snow on the road. Carriageway reduced (from Q lanes) to one lane","1021","0"},
	{"606","snow on the road. Carriageway reduced (from Q lanes) to two lanes","1022","0"},
	{"607","snow on the road. Carriageway reduced (from Q lanes) to three lanes","1023","0"},
	{"608","(Q) accident(s). Right lane blocked","241","0"},
	{"609","(Q) accident(s). Centre lane blocked","242","0"},
	{"610","(Q) accident(s). Left lane blocked","243","0"},
	{"611","(Q) accident(s). Hard shoulder blocked","244","0"},
	{"612","(Q) accident(s). Two lanes blocked","245","0"},
	{"613","(Q) accident(s). Three lanes blocked","246","0"},
	{"614","blocked by (Q) shed load(s)","303","0"},
	{"615","(Q) shed load(s). Right lane blocked","304","0"},
	{"616","(Q) shed load(s). Centre lane blocked","305","0"},
	{"617","(Q) shed load(s). Left lane blocked","306","0"},
	{"618","(Q) shed load(s). Hard shoulder blocked","307","0"},
	{"619","(Q) shed load(s). Two lanes blocked","308","0"},
	{"620","(Q) shed load(s). Three lanes blocked","309","0"},
	{"621","blocked by (Q) overturned vehicle(s)","369","0"},
	{"622","(Q) overturned vehicle(s). Right lane blocked","370","0"},
	{"623","(Q) overturned vehicle(s). Centre lane blocked","371","0"},
	{"624","(Q) overturned vehicle(s). Left lane blocked","372","0"},
	{"625","(Q) overturned vehicle(s). Two lanes blocked","373","0"},
	{"626","(Q) overturned vehicle(s). Three lanes blocked","374","0"},
	{"627","blocked by (Q) broken down vehicle(s).","323","0"},
	{"628","(Q) broken down vehicle(s). Right lane blocked","324","0"},
	{"629","(Q) broken down lane vehicle(s). Centre lane blocked","325","0"},
	{"630","(Q) broken down vehicle(s). Left lane blocked","326","0"},
	{"631","(Q) broken down vehicle(s). Hard shoulder blocked","327","0"},
	{"632","(Q) broken down vehicle(s). Two lanes blocked","328","0"},
	{"633","(Q) broken down vehicle(s). Three lanes blocked","329","0"},
	{"634","blocked","402"," "},
	{"635","(Q) lane(s) blocked","520","0"},
	{"636","(Q) right lane(s) blocked","507","0"},
	{"637","(Q) centre lane(s) blocked","508","0"},
	{"638","(Q) left lane(s) blocked","509","0"},
	{"639","hard shoulder blocked","510"," "},
	{"640","emergency lane blocked","642"," "},
	{"641","(Q) overtaking lane(s) blocked","42","0"},
	{"642","One lane blocked","646"," "},
	{"643","Two lanes blocked","511"," "},
	{"644","three lanes blocked","512"," "},
	{"645","blocked by (Q) obstruction(s) on the road","980","0"},
	{"646","blocked due to spillage on roadway","982"," "},
	{"647","blocked by storm damage","925"," "},
	{"648","blocked by (Q) fallen trees","926","0"},
	{"649","blocked by fallen power cables","987"," "},
	{"650","contraflow","517"," "},
	{"651","narrow lanes","518"," "},
	{"652","contraflow with narrow lanes","519"," "},
	{"653","single alternate line traffic","513"," "},
	{"654","(Q sets of) roadworks. Contraflow","746","0"},
	{"655","(Q sets of) roadworks. Single alternate line traffic","742","0"},
	{"656","(Q sections of) resurfacing work. Contraflow","779","0"},
	{"657","(Q sections of) resurfacing work. Single alternate line traffic","775","0"},
	{"658","subsidence. Contraflow in operation","954"," "},
	{"659","turning lane closed","638"," "},
	{"660","turning lane blocked","643"," "},
	{"661","crawler lane closed","639"," "},
	{"662","slow vehicle lane closed","640"," "},
	{"663","heavy vehicle lane closed","678"," "},
	{"664","crawler lane blocked","644"," "},
	{"665","slow vehicle lane blocked","645"," "},
	{"666","heavy vehicle lane blocked","679"," "},
	{"667","lane blockages cleared","657"," "},
	{"668","road cleared","631"," "},
	{"669","contraflow removed","658"," "},
	{"670","reopened","467"," "},
	{"671","open","630"," "},
	{"672","lane closures removed","624"," "},
	{"673","carriageway closed","664"," "},
	{"674","both directions closed","665"," "},
	{"675","message cancelled","625"," "},
	{"676"," "," "," "},
	{"677"," "," "," "},
	{"678"," "," "," "},
	{"679"," "," "," "},
	{"680"," "," "," "},
	{"681","parallel carriageway closed","479"," "},
	{"682","right-hand parallel carriageway closed","480"," "},
	{"683","left-hand parallel carriageway closed","481"," "},
	{"684","express lanes closed","482"," "},
	{"685","through traffic lanes closed","483"," "},
	{"686","local lanes closed","484"," "},
	{"687","parallel carriageway blocked","486"," "},
	{"688","right-hand parallel carriageway blocked","487"," "},
	{"689","left-hand parallel carriageway blocked","488"," "},
	{"690","express lanes blocked","489"," "},
	{"691","through traffic lanes blocked","490"," "},
	{"692","local lanes blocked","491"," "},
	{"693","bus lane closed","1982"," "},
	{"694","bus lane blocked","676"," "},
	{"695","bridge blocked","26"," "},
	{"696","tunnel blocked","27"," "},
	{"697"," "," "," "},
	{"698","all carriageways cleared","663"," "},
	{"699","all carriageways reopened","634"," "},
	{"700"," "," "," "},
	{"701","message cancelled","672"," "},
	{"702"," "," "," "},
	{"703"," "," "," "},
	{"704"," "," "," "},
	{"705"," "," "," "},
	{"706"," "," "," "},
	{"707","(Q th) exit slip road closed","407","0"},
	{"708","(Q) exit slip road(s) closed","474","0"},
	{"709","(Q th) exit slip road blocked","475","0"},
	{"710","exit blocked","476"," "},
	{"711","slip roads closed","408"," "},
	{"712","slip roads blocked","477"," "},
	{"713","slip road restrictions","409"," "},
	{"714","connecting carriageway closed","478"," "},
	{"715","connecting carriageway blocked","485"," "},
	{"716"," "," "," "},
	{"717","exit reopened","633"," "},
	{"718","slip roads reopened","466"," "},
	{"719"," "," "," "},
	{"720","message cancelled","673"," "},
	{"721"," "," "," "},
	{"722"," "," "," "},
	{"723"," "," "," "},
	{"724"," "," "," "},
	{"725"," "," "," "},
	{"726","(Q th) entry slip road closed","406","0"},
	{"727","(Q) entry slip road(s) closed","471","0"},
	{"728","(Q th) entry slip road blocked","472","0"},
	{"729","entry blocked","473"," "},
	{"730"," "," "," "},
	{"731","entry reopened","632"," "},
	{"732"," "," "," "},
	{"733","message cancelled","399"," "},
	{"734"," "," "," "},
	{"735"," "," "," "},
	{"736"," "," "," "},
	{"737"," "," "," "},
	{"738"," "," "," "},
	{"739","no motor vehicles","492"," "},
	{"740","restrictions","493"," "},
	{"741","no motor vehicles without catalytic converters","627"," "},
	{"742","no motor vehicles with even-numbered registration plates","628"," "},
	{"743","no motor vehicles with odd-numbered registration plates","629"," "},
	{"744","no through traffic","405"," "},
	{"745","no through traffic for heavy lorries (over Q)","404","8"},
	{"746","smog alert","1332"," "},
	{"747","no motor vehicles due to smog alert","1338"," "},
	{"748","closed ahead","469"," "},
	{"749","blocked ahead","470"," "},
	{"750","closed due to smog alert (until Q)","2000","7"},
	{"751","closed due to major event","1527"," "},
	{"752","closed due to sports meeting","1541"," "},
	{"753","closed due to fair","1555"," "},
	{"754","closed due to parade","1559"," "},
	{"755","closed due to strike","1563"," "},
	{"756","closed due to demonstration","1567"," "},
	{"757","closed due to security alert","1580"," "},
	{"758","closed due to security incident","1485"," "},
	{"759","closed due to flooding","938"," "},
	{"760","closed due to avalanches","943"," "},
	{"761","closed due to avalanche risk","993"," "},
	{"762","closed due to ice build-up","995"," "},
	{"763","closed due to rockfalls","945"," "},
	{"764","closed due to subsidence","949"," "},
	{"765","service area busy","2013"," "},
	{"766","service area overcrowded, drive to another service area","20"," "},
	{"767","service area, fuel station closed","22"," "},
	{"768","service area, restaurant closed","23"," "},
	{"769","bridge closed","24"," "},
	{"770","tunnel closed","25"," "},
	{"771","closed for heavy vehicles (over Q)","403","8"},
	{"772","closed for heavy lorries (over Q)","494","8"},
	{"773","use of hard shoulder allowed","661"," "},
	{"774","traffic regulations have been changed","1854"," "},
	{"775","road closed intermittently","28"," "},
	{"776","police directing traffic","1971"," "},
	{"777","bus lane available for all vehicles","1972"," "},
	{"778","police directing traffic via the bus-lane","1973"," "},
	{"779","heavy vehicle lane available for all vehicles","1978"," "},
	{"780","police directing traffic via the heavy vehicle lane","1979"," "},
	{"781","normal lane regulations restored","662"," "},
	{"782","allow emergency vehicles to pass","1974"," "},
	{"783","allow emergency vehicles to pass in the heavy vehicle lane","1977"," "},
	{"784","allow emergency vehicles to pass in the carpool lane","1961"," "},
	{"785","closed for high-sided vehicles due to strong winds (Q)","1212","4"},
	{"786"," "," "," "},
	{"787","lane restrictions lifted","660"," "},
	{"788","restrictions for high-sided vehicles lifted","1215"," "},
	{"789","reopened for through traffic","680"," "},
	{"790","fuel station reopened","36"," "},
	{"791","restaurant reopened","37"," "},
	{"792","motor vehicle restrictions lifted","635"," "},
	{"793","smog alert ended","40"," "},
	{"794","traffic restrictions lifted {reopened for all traffic}","636"," "},
	{"795"," "," "," "},
	{"796","message cancelled","468"," "},
	{"797"," "," "," "},
	{"798"," "," "," "},
	{"799"," "," "," "},
	{"800"," "," "," "},
	{"801"," "," "," "},
	{"802","(Q person) carpool lane in operation","647","0"},
	{"803","(Q person) carpool lane closed","648","0"},
	{"804","(Q person) carpool lane blocked","649","0"},
	{"805","bus lane available for carpools (with at least Q occupants)","671","0"},
	{"806","carpool restrictions changed (to Q persons per vehicle)","650","0"},
	{"807","carpool lane available for all vehicles","1962"," "},
	{"808","police directing traffic via the carpool lane","1963"," "},
	{"809","closed for vehicles with less than three occupants {not valid for lorries}","2006"," "},
	{"810","closed for vehicles with only one occupant {not valid for lorries}","2007"," "},
	{"811"," "," "," "},
	{"812","(Q person) carpool restrictions lifted","659","0"},
	{"813"," "," "," "},
	{"814","message cancelled","2029"," "},
	{"815"," "," "," "},
	{"816"," "," "," "},
	{"817"," "," "," "},
	{"818"," "," "," "},
	{"819"," "," "," "},
	{"820","(Q sets of) roadworks","701","0"},
	{"821","(Q sets of) major roadworks","702","0"},
	{"822","(Q sets of) long-term roadworks","802","0"},
	{"823","(Q sets of) construction work","803","0"},
	{"824","(Q sections of) resurfacing work","704","0"},
	{"825","(Q sets of) central reservation work","705","0"},
	{"826","(Q sets of) maintenance work","703","0"},
	{"827","roadwork clearance in progress","853"," "},
	{"828","bridge maintenance work (at Q bridges)","707","0"},
	{"829","bridge demolition work (at Q bridges)","805","0"},
	{"830","(Q sections of) blasting work","709","0"},
	{"831","(Q sets of) roadworks on the hard shoulder","52","0"},
	{"832","(Q sets of) roadworks in the emergency lane","53","0"},
	{"833","(Q sets of) roadworks during the day time","815","0"},
	{"834","(Q sets of) roadworks during off-peak periods","816","0"},
	{"835","(Q sets of) roadworks during the night","817","0"},
	{"836","(Q sets of) resurfacing work during the day time","821","0"},
	{"837","(Q sets of) resurfacing work during off- peak periods","822","0"},
	{"838","(Q sets of) resurfacing work during the night","823","0"},
	{"839","(Q sets of) temporary traffic lights","708","0"},
	{"840","(Q sets of) water main work","806","0"},
	{"841","(Q sets of) gas main work","807","0"},
	{"842","(Q sets of) work on buried cables","808","0"},
	{"843","(Q sets of) work on buried services","809","0"},
	{"844","new roadworks layout","810"," "},
	{"845","road layout unchanged","855"," "},
	{"846","new road layout","811"," "},
	{"847"," "," "," "},
	{"848","maintenance work cleared","854"," "},
	{"849","roadworks cleared","800"," "},
	{"850"," "," "," "},
	{"851","message cancelled","801"," "},
	{"852"," "," "," "},
	{"853"," "," "," "},
	{"854"," "," "," "},
	{"855"," "," "," "},
	{"856"," "," "," "},
	{"857","(Q) obstruction(s) on roadway {something that does block the road or part of it}","901","0"},
	{"858","(Q) obstructions on the road. Danger","902","0"},
	{"859","(Q) obstructions on the road. Passable with care","981","0"},
	{"860","(Q) object(s) on roadway {something that does not necessarily block the road or part of it} ","61","0"},
	{"861","(Q) object(s) on the road. Danger","63","0"},
	{"862","(Q) shed load(s)","210","0"},
	{"863","(Q) shed load(s). Danger","359","0"},
	{"864","spillage on the road","903"," "},
	{"865","spillage on the road. Danger","984"," "},
	{"866","storm damage","904"," "},
	{"867","storm damage. Danger","986"," "},
	{"868","storm damage expected","972"," "},
	{"869","(Q) fallen trees","905","0"},
	{"870","(Q) fallen trees. Danger","906","0"},
	{"871","fallen power cables","973"," "},
	{"872","fallen power cables. Danger","989"," "},
	{"873","flooding","907"," "},
	{"874","flooding expected","900"," "},
	{"875","flooding. Danger","908"," "},
	{"876","sewer overflow","974"," "},
	{"877","sewer overflow. Danger","990"," "},
	{"878","flash floods","909"," "},
	{"879","danger of flash floods","910"," "},
	{"880","flash floods. Danger","991"," "},
	{"881","avalanches","911"," "},
	{"882","avalanches. Danger","992"," "},
	{"883","avalanche risk","912"," "},
	{"884","avalanche risk. Danger","994"," "},
	{"885","ice build-up","975"," "},
	{"886","rockfalls","913"," "},
	{"887","rockfalls. Danger","998"," "},
	{"888","landslips","914"," "},
	{"889","landslips. Danger","999"," "},
	{"890","mud slide","976"," "},
	{"891","earthquake damage","915"," "},
	{"892","earthquake damage. Danger","1000"," "},
	{"893","subsidence","917"," "},
	{"894","subsidence. Danger","1026"," "},
	{"895","(Q) collapsed sewer(s)","918","0"},
	{"896","sewer collapse. Danger","1030"," "},
	{"897","burst water main","919"," "},
	{"898","burst water main. Danger","1031"," "},
	{"899","(Q) burst pipe(s)","62","0"},
	{"900","burst pipe. Danger","64"," "},
	{"901","gas leak","920"," "},
	{"902","gas leak. Danger","1032"," "},
	{"903","grass fire","977"," "},
	{"904","serious fire","921"," "},
	{"905","serious fire. Danger","1033"," "},
	{"906","air crash","978"," "},
	{"907","rail crash","979"," "},
	{"908","spillage on the road. Passable with care","983"," "},
	{"909","storm damage. Passable with care","985"," "},
	{"910","(Q) fallen tree(s). Passable with care","927","0"},
	{"911","fallen power cables. Passable with care","988"," "},
	{"912","flooding. Passable with care","942"," "},
	{"913","avalanches. Passable with care (above Q hundred metres)","944","0"},
	{"914","ice build-up. Passable with care (above Q hundred metres)","996","0"},
	{"915","rockfalls. Passable with care","946"," "},
	{"916","landslips. Passable with care","948"," "},
	{"917","subsidence. Passable with care","955"," "},
	{"918","subsidence. Single alternate line traffic","950"," "},
	{"919","ice build-up. Single alternate traffic","997"," "},
	{"920","spillage occurring from moving vehicle","1709"," "},
	{"921","(Q) slow moving maintenance vehicle(s)","1700","0"},
	{"922"," "," "," "},
	{"923","obstruction warning withdrawn","898"," "},
	{"924","clearance work in progress, road free again","899"," "},
	{"925","road free again","970"," "},
	{"926","road cleared","1712"," "},
	{"927","house fire","1084"," "},
	{"928"," "," "," "},
	{"929","vehicle stuck under bridge","1086"," "},
	{"930"," "," "," "},
	{"931","message cancelled","971"," "},
	{"932"," "," "," "},
	{"933"," "," "," "},
	{"934","animals on roadway","922"," "},
	{"935","sightseers obstructing access","1471"," "},
	{"936","people on roadway","1472"," "},
	{"937","children on roadway","1473"," "},
	{"938","cyclists on roadway","1474"," "},
	{"939","animals on the road. Danger","923"," "},
	{"940","people on roadway. Danger","1482"," "},
	{"941","children on roadway. Danger","1483"," "},
	{"942","cyclists on roadway. Danger","1484"," "},
	{"943","large animals on roadway","1067"," "},
	{"944","herds of animals on roadway","1068"," "},
	{"945","construction traffic merging","852"," "},
	{"946","construction traffic merging. Danger","856"," "},
	{"947","(Q sets of) road marking work","706","0"},
	{"948","(Q sets of) road marking work. Danger","824","0"},
	{"949","warning cleared","1771"," "},
	{"950","(Q) unprotected accident area(s)","857","0"},
	{"951","danger of (Q) unprotected accident area(s)","858","0"},
	{"952","(Q) unlit vehicle(s) on the road","859","0"},
	{"953","danger of (Q) unlit vehicle(s) on the road","860","0"},
	{"954","snow and ice debris","861"," "},
	{"955","danger of snow and ice debris","862"," "},
	{"956","message cancelled","2030"," "},
	{"957"," "," "," "},
	{"958","impassable (above Q hundred metres)","1035","0"},
	{"959","almost impassable (above Q hundred metres)","1036","0"},
	{"960","extremely hazardous driving conditions (above Q hundred metres)","1037","0"},
	{"961","extremely hazardous driving conditions expected (above Q hundred meters)","1073","0"},
	{"962","hazardous driving conditions (above Q hundred metres)","1001","0"},
	{"963","difficult driving conditions (above Q hundred metres)","1038","0"},
	{"964","passable with care (up to Q hundred metres)","1039","0"},
	{"965","passable (up to Q hundred metres)","1040","0"},
	{"966","impassable for heavy vehicles (over Q)","1063","8"},
	{"967","impassable (above Q hundred metres) for vehicles with trailers","1064","0"},
	{"968","surface water hazard","1041"," "},
	{"969","danger of aquaplaning","1002"," "},
	{"970","slippery road (above Q hundred metres)","1003","0"},
	{"971","mud on road","1004"," "},
	{"972","mud on road. Danger","1055"," "},
	{"973","leaves on road","1005"," "},
	{"974","loose sand on road","1042"," "},
	{"975","loose chippings","1043"," "},
	{"976","loose chippings. Danger","1056"," "},
	{"977","oil on road","1044"," "},
	{"978","oil on road. Danger","1057"," "},
	{"979","petrol on road","1045"," "},
	{"980","petrol on road. Danger","1058"," "},
	{"981","road surface in poor condition","916"," "},
	{"982","road surface in poor condition. Danger","1059"," "},
	{"983","ice (above Q hundred metres)","1006","0"},
	{"984","danger of ice (above Q hundred metres)","1007","0"},
	{"985","icy patches (above Q hundred metres)","1047","0"},
	{"986","danger of icy patches (above Q hundred metres)","1048","0"},
	{"987","black ice (above Q hundred metres)","1008","0"},
	{"988","danger of black ice (above Q hundred metres)","1050","0"},
	{"989","freezing rain (above Q hundred metres)","1009","0"},
	{"990","freezing rain expected (above Q hundred metres)","1074","0"},
	{"991","wet and icy roads (above Q hundred metres)","1010","0"},
	{"992","slush (above Q hundred metres)","1011","0"},
	{"993","snow on the road (above Q hundred metres)","1012","0"},
	{"994","packed snow (above Q hundred metres)","1013","0"},
	{"995","fresh snow (above Q hundred metres)","1014","0"},
	{"996","deep snow (above Q hundred metres)","1015","0"},
	{"997","snow drifts (above Q hundred metres)","1016","0"},
	{"998","slippery road (above Q hundred metres) due to snow","1018","0"},
	{"999","slippery road (above Q hundred metres) due to frost","1019","0"},
	{"1000","slippery due to spillage on roadway","1017"," "},
	{"1001","slippery due to loose sand on roadway","1054"," "},
	{"1002","icy patches (above Q hundred metres) on bridges","1060","0"},
	{"1003","danger of icy patches (above Q hundred metres) on bridges","1061","0"},
	{"1004","icy patches (above Q hundred metres) on bridges, in shaded areas and on slip roads","1062","0"},
	{"1005","road blocked by snow (above Q hundred metres)","1020","0"},
	{"1006","danger of road being blocked by snow (above Q hundred metres)","1075","0"},
	{"1007","conditions of road surface improved","1024"," "},
	{"1008","snow cleared","1070"," "},
	{"1009","driving conditions improved","1065"," "},
	{"1010","skid hazard reduced","1069"," "},
	{"1011","rain changing to snow","1165"," "},
	{"1012","snow changing to rain","1166"," "},
	{"1013","message cancelled","1025"," "},
	{"1014"," "," "," "},
	{"1015"," "," "," "},
	{"1016"," "," "," "},
	{"1017"," "," "," "},
	{"1018"," "," "," "},
	{"1019","current temperature (Q)","1083","6"},
	{"1020","heavy frost","1115"," "},
	{"1021","frost","1116"," "},
	{"1022","temperature falling rapidly (to Q)","1079","6"},
	{"1023","extreme heat (up to Q)","1080","6"},
	{"1024","extreme cold (of Q)","1081","6"},
	{"1025"," "," "," "},
	{"1026","less extreme temperatures","1082"," "},
	{"1027"," "," "," "},
	{"1028","message cancelled","1127"," "},
	{"1029"," "," "," "},
	{"1030"," "," "," "},
	{"1031"," "," "," "},
	{"1032"," "," "," "},
	{"1033"," "," "," "},
	{"1034","damaging hail (visibility reduced to Q)","1132","2"},
	{"1035","damaging hail (with visibility reduced to Q) expected","1174","2"},
	{"1036","hail (visibility reduced to Q)","1106","2"},
	{"1037","sleet (visibility reduced to Q)","1107","2"},
	{"1038","thunderstorms (visibility reduced to Q)","1108","2"},
	{"1039","winter storm (visibility reduced to Q)","1128","2"},
	{"1040","blizzard (visibility reduced to Q)","1130","2"},
	{"1041","blizzard (with visibility reduced to Q) expected","1173","2"},
	{"1042","heavy snowfall (Q)","1101","10"},
	{"1043","heavy snowfall (Q) expected","1170","10"},
	{"1044","heavy snowfall. Visibility reduced (to Q)","1134","2"},
	{"1045","heavy snowfall (Q). Visibility reduced to <30 m","1102","10"},
	{"1046","heavy snowfall (Q). Visibility reduced to <50 m","1103","10"},
	{"1047","snowfall (Q)","1104","10"},
	{"1048","snowfall. Visibility reduced (to Q)","1135","2"},
	{"1049","snowfall (Q). Visibility reduced to <100 m","1105","10"},
	{"1050","heavy rain (Q)","1109","10"},
	{"1051","heavy rain (Q) expected","1171","10"},
	{"1052","heavy rain. Visibility reduced (to Q)","1136","2"},
	{"1053","heavy rain (Q). Visibility reduced to <30 m","1110","10"},
	{"1054","heavy rain (Q). Visibility reduced to <50 m","1111","10"},
	{"1055","rain (Q)","1112","10"},
	{"1056","rain. Visibility reduced (to Q)","1137","2"},
	{"1057","rain (Q). Visibility reduced to <100 m","1113","10"},
	{"1058","showers (visibility reduced to Q)","1114","2"},
	{"1059","visibility reduced (to Q)","1318","2"},
	{"1060","visibility reduced to <30 m","1319"," "},
	{"1061","visibility reduced to <50 m","1320"," "},
	{"1062","visibility reduced to <100 m","1321"," "},
	{"1063","reduced visibility (to Q) expected","1175","2"},
	{"1064","white out (visibility reduced to Q)","1322","2"},
	{"1065","blowing snow (visibility reduced to Q)","1323","2"},
	{"1066","smoke hazard (visibility reduced to Q)","1309","2"},
	{"1067","spray hazard (visibility reduced to Q)","1324","2"},
	{"1068","low sun glare","1325"," "},
	{"1069","blowing dust (visibility reduced to Q)","1310","2"},
	{"1070","sandstorms (visibility reduced to Q)","1326","2"},
	{"1071","swarms of insects (visibility reduced to Q)","1340","2"},
	{"1072","dense fog (visibility reduced to Q)","1301","2"},
	{"1073","dense fog (with visibility reduced to Q) expected","1177","2"},
	{"1074","fog (visibility reduced to Q)","1304","2"},
	{"1075","patchy fog (visibility reduced to Q)","1307","2"},
	{"1076","patchy fog (with visibility reduced to Q) expected","1178","2"},
	{"1077","freezing fog (visibility reduced to Q)","1308","2"},
	{"1078","freezing fog (visibility reduced to Q). Slippery roads","1337","2"},
	{"1079","freezing fog expected (with visibility reduced to Q). Danger of slippery roads","1176","2"},
	{"1080","dense fog. Visibility reduced to <30 m","1302"," "},
	{"1081","dense fog. Visibility reduced to <50 m","1303"," "},
	{"1082","fog. Visibility reduced to <100 m","1305"," "},
	{"1083","snowfall and fog (visibility reduced to Q)","1312","2"},
	{"1084"," "," "," "},
	{"1085","fog forecast withdrawn","1346"," "},
	{"1086","fog clearing","1345"," "},
	{"1087","visibility improved","1313"," "},
	{"1088","visibility expected to improve","1179"," "},
	{"1089","weather expected to improve","1172"," "},
	{"1090","weather situation improved","1126"," "},
	{"1091","adverse weather warning withdrawn","1180"," "},
	{"1092"," "," "," "},
	{"1093","message cancelled","1314"," "},
	{"1094"," "," "," "},
	{"1095"," "," "," "},
	{"1096"," "," "," "},
	{"1097"," "," "," "},
	{"1098"," "," "," "},
	{"1099","tornadoes","1201"," "},
	{"1100","hurricane force winds (Q)","1202","4"},
	{"1101","gales (Q)","1203","4"},
	{"1102","storm force winds (Q)","1204","4"},
	{"1103","strong winds (Q)","1205","4"},
	{"1104","gusty winds (Q)","1209","4"},
	{"1105","crosswinds (Q)","1210","4"},
	{"1106","strong winds (Q) affecting high-sided vehicles","1211","4"},
	{"1107","severe smog","1190"," "},
	{"1108","severe exhaust pollution","1191"," "},
	{"1109"," "," "," "},
	{"1110","tornado warning ended","1217"," "},
	{"1111","strong winds easing","1213"," "},
	{"1112"," "," "," "},
	{"1113","message cancelled","1214"," "},
	{"1114"," "," "," "},
	{"1115"," "," "," "},
	{"1116"," "," "," "},
	{"1117"," "," "," "},
	{"1118"," "," "," "},
	{"1119","major event","1501"," "},
	{"1120","several major events","1590"," "},
	{"1121","sports event meeting","1502"," "},
	{"1122","international sports meeting","1450"," "},
	{"1123","match","1451"," "},
	{"1124","tournament","1452"," "},
	{"1125","athletics meeting","1453"," "},
	{"1126","ball game","1454"," "},
	{"1127","boxing tournament","1455"," "},
	{"1128","bull fight","1456"," "},
	{"1129","cricket match","1457"," "},
	{"1130","cycle race","1458"," "},
	{"1131","football match","1459"," "},
	{"1132","golf tournament","1460"," "},
	{"1133","marathon","1461"," "},
	{"1134","race meeting","1462"," "},
	{"1135","rugby match","1463"," "},
	{"1136","show jumping","1464"," "},
	{"1137","tennis tournament","1465"," "},
	{"1138","water sports meeting","1466"," "},
	{"1139","winter sports meeting","1467"," "},
	{"1140","show","1503"," "},
	{"1141","festival","1504"," "},
	{"1142","exhibition","1505"," "},
	{"1143","market","1507"," "},
	{"1144","fair","1506"," "},
	{"1145","funfair","1468"," "},
	{"1146","trade fair","1469"," "},
	{"1147","ceremonial event","1508"," "},
	{"1148","state occasion","1509"," "},
	{"1149","parade","1510"," "},
	{"1150","procession","1470"," "},
	{"1151","crowd","1511"," "},
	{"1152","strike","1475"," "},
	{"1153","march","1512"," "},
	{"1154","demonstration","1513"," "},
	{"1155","public disturbance","1514"," "},
	{"1156","information about major event no longer valid","1591"," "},
	{"1157","sports traffic cleared","1493"," "},
	{"1158","traffic disruption cleared","1496"," "},
	{"1159","automobile race","1592"," "},
	{"1160","baseball game","1593"," "},
	{"1161","basketball game","1594"," "},
	{"1162","boat race","1595"," "},
	{"1163","concert","1596"," "},
	{"1164","hockey game","1597"," "},
	{"1165","message cancelled","1585"," "},
	{"1166"," "," "," "},
	{"1167"," "," "," "},
	{"1168","security alert","1515"," "},
	{"1169","security incident","1476"," "},
	{"1170","police checkpoint","1477"," "},
	{"1171","bomb alert","1516"," "},
	{"1172","terrorist incident","1478"," "},
	{"1173","gunfire on roadway, danger","1479"," "},
	{"1174","civil emergency","1480"," "},
	{"1175","air raid, danger","1481"," "},
	{"1176","evacuation","1494"," "},
	{"1177"," "," "," "},
	{"1178","air raid warning cancelled","1587"," "},
	{"1179","security alert withdrawn","1492"," "},
	{"1180","civil emergency cancelled","1588"," "},
	{"1181"," "," "," "},
	{"1182","message cancelled","2033"," "},
	{"1183"," "," "," "},
	{"1184"," "," "," "},
	{"1185"," "," "," "},
	{"1186"," "," "," "},
	{"1187"," "," "," "},
	{"1188","delays (Q)","1601","5"},
	{"1189","delays (Q) expected","1607","5"},
	{"1190","delays (Q) possible","1650","5"},
	{"1191","delays up to 5 minutes","1621"," "},
	{"1192","delays up to 10 minutes","1622"," "},
	{"1193","delays up to 15 minutes","1602"," "},
	{"1194","delays up to 20 minutes","1623"," "},
	{"1195","delays up to 25 minutes","1624"," "},
	{"1196","delays up to 30 minutes","1603"," "},
	{"1197","delays up to 40 minutes","1625"," "},
	{"1198","delays up to 50 minutes","1626"," "},
	{"1199","delays up to one hour","1604"," "},
	{"1200","delays up to 90 minutes","1627"," "},
	{"1201","delays up to two hours","1605"," "},
	{"1202","delays up to three hours","1628"," "},
	{"1203","delays up to four hours","1629"," "},
	{"1204","delays up to five hours","1630"," "},
	{"1205","delays of several hours","1606"," "},
	{"1206","long delays (Q)","1608","5"},
	{"1207","very long delays (Q)","1631","5"},
	{"1208","delays of uncertain duration","1632"," "},
	{"1209","accident. Delays (Q)","247","5"},
	{"1210","accident. Delays (Q) expected","248","5"},
	{"1211","accident. Long delays (Q)","249","5"},
	{"1212","multi vehicle pile up. Delays (Q)","200","5"},
	{"1213","vehicles slowing to look at accident. Delays (Q)","275","5"},
	{"1214","vehicles slowing to look at accident. Delays (Q) expected","276","5"},
	{"1215","vehicles slowing to look at accident. Long delays (Q)","277","5"},
	{"1216","shed load. Delays (Q)","310","5"},
	{"1217","shed load. Delays (Q) expected","311","5"},
	{"1218","shed load. Long delays (Q)","312","5"},
	{"1219","overturned vehicle. Delays (Q)","375","5"},
	{"1220","overturned vehicle. Delays (Q) expected","376","5"},
	{"1221","overturned vehicle. Long delays (Q)","377","5"},
	{"1222","Delays (Q) due to earlier accident","388","5"},
	{"1223","Long delays (Q) due to earlier accident","390","5"},
	{"1224","broken down vehicle. Delays (Q)","330","5"},
	{"1225","broken down vehicle. Delays (Q) expected","331","5"},
	{"1226","broken down vehicle. Long delays (Q)","332","5"},
	{"1227","closed ahead. Delays (Q)","435","5"},
	{"1228","closed ahead. Delays (Q) expected","436","5"},
	{"1229","closed ahead. Long delays (Q)","437","5"},
	{"1230","blocked ahead. Delays (Q)","463","5"},
	{"1231","blocked ahead. Delays (Q) expected","464","5"},
	{"1232","blocked ahead. Long delays (Q)","465","5"},
	{"1233","roadworks. Delays (Q)","747","5"},
	{"1234","roadworks. Delays (Q) expected","748","5"},
	{"1235","roadworks. Long delays (Q)","749","5"},
	{"1236","resurfacing work. Delays (Q)","780","5"},
	{"1237","resurfacing work. Delays (Q) expected","781","5"},
	{"1238","resurfacing work. Long delays (Q)","782","5"},
	{"1239","water main work. Delays (Q)","840","5"},
	{"1240","water main work. Delays (Q) expected","841","5"},
	{"1241","water main work. Long delays (Q)","842","5"},
	{"1242","gas main work. Delays (Q)","843","5"},
	{"1243","gas main work. Delays (Q) expected","844","5"},
	{"1244","gas main work. Long delays (Q)","845","5"},
	{"1245","work on buried cables. Delays (Q)","846","5"},
	{"1246","work on buried cables. Delays (Q) expected","847","5"},
	{"1247","work on buried cables. Long delays (Q)","848","5"},
	{"1248","work on buried services. Delays (Q)","849","5"},
	{"1249","work on buried services. Delays (Q) expected","850","5"},
	{"1250","work on buried services. Long delays (Q)","851","5"},
	{"1251","flooding. Delays (Q)","939","5"},
	{"1252","flooding. Delays (Q) expected","940","5"},
	{"1253","flooding. Long delays (Q)","941","5"},
	{"1254","sewer collapse. Delays (Q)","1027","5"},
	{"1255","sewer collapse. Delays (Q) expected","1028","5"},
	{"1256","sewer collapse. Long delays (Q)","1029","5"},
	{"1257","burst water main. Delays (Q)","958","5"},
	{"1258","burst water main. Delays (Q) expected","959","5"},
	{"1259","burst water main. Long delays (Q)","960","5"},
	{"1260","gas leak. Delays (Q)","962","5"},
	{"1261","gas leak. Delays (Q) expected","963","5"},
	{"1262","gas leak. Long delays (Q)","964","5"},
	{"1263","serious fire. Delays (Q)","966","5"},
	{"1264","serious fire. Delays (Q) expected","967","5"},
	{"1265","serious fire. Long delays (Q)","968","5"},
	{"1266","major event. Delays (Q)","1528","5"},
	{"1267","major event. Delays (Q) expected","1529","5"},
	{"1268","major event. Long delays (Q)","1530","5"},
	{"1269","sports meeting. Delays (Q)","1542","5"},
	{"1270","sports meeting. Delays (Q) expected","1543","5"},
	{"1271","sports meeting. Long delays (Q)","1544","5"},
	{"1272","fair. Delays (Q)","1556","5"},
	{"1273","fair. Delays (Q) expected","1557","5"},
	{"1274","fair. Long delays (Q)","1558","5"},
	{"1275","parade. Delays (Q)","1560","5"},
	{"1276","parade. Delays (Q) expected","1561","5"},
	{"1277","parade. Long delays (Q)","1562","5"},
	{"1278","strike. Delays (Q)","1564","5"},
	{"1279","strike. Delays (Q) expected","1565","5"},
	{"1280","strike. Long delays (Q)","1566","5"},
	{"1281","demonstration. Delays (Q)","1568","5"},
	{"1282","demonstration. Delays (Q) expected","1569","5"},
	{"1283","demonstration. Long delays (Q)","1570","5"},
	{"1284","security alert. Delays (Q)","1581","5"},
	{"1285","security alert. Delays (Q) expected","1582","5"},
	{"1286","security alert. Long delays (Q)","1583","5"},
	{"1287","security incident. Delays (Q)","1486","5"},
	{"1288","security incident. Delays (Q) expected","1487","5"},
	{"1289","security incident. Long delays (Q)","1488","5"},
	{"1290","police checkpoint. Delays (Q)","1489","5"},
	{"1291","police checkpoint. Delays (Q) expected","1490","5"},
	{"1292","police checkpoint. Long delays (Q)","1491","5"},
	{"1293","delays (Q) for heavy vehicles","1609","5"},
	{"1294","delays (Q) for cars","91","5"},
	{"1295","delays (Q) for heavy lorr(y/ies)","1642","5"},
	{"1296","delays up to 15 minutes for heavy lorr(y/ies)","1610"," "},
	{"1297","delays up to 30 minutes for heavy lorr(y/ies)","1611"," "},
	{"1298","delays up to one hour for heavy lorr(y/ies)","1612"," "},
	{"1299","delays up to two hours for heavy lorr(y/ies)","1613"," "},
	{"1300","delays of several hours for heavy lorr(y/ies)","1614"," "},
	{"1301","delays (Q) for buses","1643","5"},
	{"1302","long delays expected","1653"," "},
	{"1303","very long delays expected","1654"," "},
	{"1304","abnormal load. Delays (Q) expected","1757","5"},
	{"1305","abnormal load. Long delays (Q)","1758","5"},
	{"1306","abnormal load. Delays (Q)","1756","5"},
	{"1307","abnormal load causing slow traffic. Delays (Q)","1740","5"},
	{"1308","convoy causing delays (Q)","1759","5"},
	{"1309","convoy. Delays (Q) expected","1760","5"},
	{"1310","convoy causing long delays (Q)","1761","5"},
	{"1311","convoy causing slow traffic. Delays (Q)","1741","5"},
	{"1312","traffic lights not working. Delays (Q)","1817","5"},
	{"1313","traffic lights not working. Delays (Q) expected","1818","5"},
	{"1314","traffic lights not working. Long delays (Q)","1819","5"},
	{"1315","traffic lights working incorrectly. Delays (Q)","1868","5"},
	{"1316","traffic lights working incorrectly. Delays (Q) expected","1869","5"},
	{"1317","traffic lights working incorrectly. Long delays (Q)","1870","5"},
	{"1318","temporary traffic lights not working. Delays (Q)","1876","5"},
	{"1319","temporary traffic lights not working. Delays (Q) expected","1877","5"},
	{"1320","temporary traffic lights not working. Long delays (Q)","1878","5"},
	{"1321","traffic signal control computer not working. Delays (Q)","1880","5"},
	{"1322","traffic signal control computer not working. Delays (Q) expected","1884","5"},
	{"1323","traffic signal control computer not working. Long delays (Q)","1885","5"},
	{"1324","level crossing failure. Delays (Q)","1830","5"},
	{"1325","level crossing failure. Delays (Q) expected","1831","5"},
	{"1326","level crossing failure. Long delays (Q)","1832","5"},
	{"1327","Snowplough. Delays (Q)","1858","5"},
	{"1328","delays cleared","1648"," "},
	{"1329","delay expected to be cleared","1663"," "},
	{"1330"," "," "," "},
	{"1331","message cancelled","1620"," "},
	{"1332"," "," "," "},
	{"1333"," "," "," "},
	{"1334"," "," "," "},
	{"1335"," "," "," "},
	{"1336"," "," "," "},
	{"1337","cancellations","1634"," "},
	{"1338","cancellations expected","1652"," "},
	{"1339","service suspended (until Q)","1615","7"},
	{"1340","delayed until further notice","1633"," "},
	{"1341","(Q) service withdrawn","1616","7"},
	{"1342","(Q) service(s) fully booked","1617","7"},
	{"1343","all services fully booked (until Q)","1655","7"},
	{"1344","park and ride service operating (until Q)","1906","7"},
	{"1345","park and ride service not operating (until Q)","1635","7"},
	{"1346","special public transport services operating (until Q)","1636","7"},
	{"1347","normal services not operating (until Q)","1637","7"},
	{"1348","rail services not operating (until Q)","1638","7"},
	{"1349","rail services irregular","1720"," "},
	{"1350","rail services irregular. Delays (Q)","1657","5"},
	{"1351","bus services irregular. Delays (Q)","1658","5"},
	{"1352","bus services not operating (until Q)","1639","7"},
	{"1353","rapid transit service not operating (until Q)","1649","7"},
	{"1354","shuttle service operating (until Q)","1640","7"},
	{"1355","free shuttle service operating (until Q)","1641","7"},
	{"1356","underground services irregular","1659"," "},
	{"1357","underground service not operating (until Q)","1651","7"},
	{"1358","service not operating, substitute service available","2021"," "},
	{"1359","public transport strike","2022"," "},
	{"1360","public transport services not operating","1721"," "},
	{"1361","ferry service not operating (until Q)","1661","7"},
	{"1362","(Q) service(s) fully booked for heavy vehicles","1618","7"},
	{"1363","(Q) service(s) fully booked for heavy lorr(y/ies)","1644","7"},
	{"1364","(Q) service(s) fully booked for buses","1645","7"},
	{"1365"," "," "," "},
	{"1366","normal public transport services resumed","1660"," "},
	{"1367","normal services resumed","1619"," "},
	{"1368"," "," "," "},
	{"1369","message cancelled","2034"," "},
	{"1370"," "," "," "},
	{"1371"," "," "," "},
	{"1372"," "," "," "},
	{"1373"," "," "," "},
	{"1374"," "," "," "},
	{"1375","park and ride trip time (Q)","1662","5"},
	{"1376","current trip time (Q)","1695","5"},
	{"1377","expected trip time (Q)","1696","5"},
	{"1378","next arrival (Q)","1656","7"},
	{"1379","next departure (Q)","1901","7"},
	{"1380","next departure (Q) for heavy vehicles","1902","7"},
	{"1381","next departure (Q) for heavy lorr(y/ies)","1646","7"},
	{"1382","next departure (Q) for buses","1647","7"},
	{"1383"," "," "," "},
	{"1384","message cancelled","2035"," "},
	{"1385"," "," "," "},
	{"1386"," "," "," "},
	{"1387"," "," "," "},
	{"1388"," "," "," "},
	{"1389"," "," "," "},
	{"1390","(Q) vehicle(s) on wrong carriageway","1701","0"},
	{"1391","(Q) reckless driver(s)","1704","0"},
	{"1392","(Q) prohibited vehicle(s) on the roadway","1705","0"},
	{"1393","(Q) emergency vehicles","1706","0"},
	{"1394","(Q) high-speed emergency vehicles","1707","0"},
	{"1395","high-speed chase (involving Q vehicles)","1708","0"},
	{"1396","objects falling from moving vehicle","1710"," "},
	{"1397","(Q sets of) slow moving maintenance vehicles","804","0"},
	{"1398","(Q) vehicle(s) carrying hazardous materials","1765","0"},
	{"1399","(Q) vehicle(s) carrying hazardous materials. Danger","1736","0"},
	{"1400","Vehicles carrying hazardous materials have to stop at next safe place!","1768"," "},
	{"1401","(Q) snowploughs","681","0"},
	{"1402","emergency vehicle warning cleared","1711"," "},
	{"1403","dangerous vehicle warning cleared","1702"," "},
	{"1404","hazardous load warning cleared","1769"," "},
	{"1405"," "," "," "},
	{"1406","message cancelled","1703"," "},
	{"1407"," "," "," "},
	{"1408"," "," "," "},
	{"1409"," "," "," "},
	{"1410"," "," "," "},
	{"1411"," "," "," "},
	{"1412","(Q) over-height vehicle(s)","347","0"},
	{"1413","(Q) over-height load(s), danger","1739","0"},
	{"1414","(Q) abnormal load(s)","1751","0"},
	{"1415","(Q) abnormal load(s), danger","1731","0"},
	{"1416","(Q) wide load(s)","1752","0"},
	{"1417","(Q) wide load(s), danger","1732","0"},
	{"1418","(Q) long load(s)","1753","0"},
	{"1419","(Q) long load(s), danger","1733","0"},
	{"1420","(Q) slow vehicle(s)","1754","0"},
	{"1421","(Q) slow vehicle(s), danger","1734","0"},
	{"1422","(Q) track-laying vehicle(s)","1764","0"},
	{"1423","(Q) track-laying vehicle(s), danger","1735","0"},
	{"1424","(Q) abnormal load(s). No overtaking","1767","0"},
	{"1425","(Q) convoy(s)","1755","0"},
	{"1426","(Q) convoy(s), danger","1737","0"},
	{"1427","(Q) military convoy(s)","1766","0"},
	{"1428","(Q) military convoy(s), danger","1738","0"},
	{"1429"," "," "," "},
	{"1430","convoy cleared","1770"," "},
	{"1431","exceptional load warning cleared","1762"," "},
	{"1432"," "," "," "},
	{"1433","message cancelled","1763"," "},
	{"1434"," "," "," "},
	{"1435"," "," "," "},
	{"1436"," "," "," "},
	{"1437"," "," "," "},
	{"1438"," "," "," "},
	{"1439","lane control signs not working","1801"," "},
	{"1440","lane control signs working incorrectly","1838"," "},
	{"1441","lane control signs operating","1839"," "},
	{"1442","variable message signs not working","1840"," "},
	{"1443","variable message signs working incorrectly","1841"," "},
	{"1444","variable message signs operating","1842"," "},
	{"1445","emergency telephones not working","1802"," "},
	{"1446","emergency telephone number not working","1803"," "},
	{"1447","emergency telephones out of order. Extra police patrols in operation","1865"," "},
	{"1448","emergency telephones out of order. In emergency, wait for police patrol","1866"," "},
	{"1449","(Q sets of) traffic lights not working","1804","0"},
	{"1450","(Q sets of) traffic lights working incorrectly","1805","0"},
	{"1451","(Q sets of) ramp control signals not working","1843","0"},
	{"1452","(Q sets of) ramp control signals working incorrectly","1844","0"},
	{"1453","(Q sets of) temporary traffic lights not working","1845","0"},
	{"1454","(Q sets of) temporary traffic lights working incorrectly","1846","0"},
	{"1455","lane control signs not working. Danger","1850"," "},
	{"1456","lane control signs working incorrectly. Danger","1864"," "},
	{"1457","(Q sets of) traffic lights not working. Danger","1867","0"},
	{"1458","(Q sets of) traffic lights working incorrectly. Danger","1875","0"},
	{"1459","(Q sets of) temporary traffic lights not working. Danger","1879","0"},
	{"1460","traffic signal control computer not working","1847"," "},
	{"1461","traffic signal timings changed","1848"," "},
	{"1462","level crossing failure","1806"," "},
	{"1463","tunnel ventilation not working","1849"," "},
	{"1464"," "," "," "},
	{"1465","electronic signs repaired","1833"," "},
	{"1466","emergency call facilities restored","1834"," "},
	{"1467","traffic signals repaired","1835"," "},
	{"1468","level crossing now working normally","1836"," "},
	{"1469","power failure","1983"," "},
	{"1470","message cancelled","1837"," "},
	{"1471"," "," "," "},
	{"1472"," "," "," "},
	{"1473"," "," "," "},
	{"1474"," "," "," "},
	{"1475"," "," "," "},
	{"1476","temporary width limit (Q)","1851","9"},
	{"1477","temporary height limit (Q)","1861","9"},
	{"1478","temporary length limit (Q)","1881","9"},
	{"1479","temporary axle load limit (Q)","1871","8"},
	{"1480","temporary gross weight limit (Q)","1872","8"},
	{"1481"," "," "," "},
	{"1482","temporary width limit lifted","1852"," "},
	{"1483","temporary height limit lifted","1862"," "},
	{"1484","temporary length limit lifted","1882"," "},
	{"1485","temporary axle weight limit lifted","1874"," "},
	{"1486","temporary gross weight limit lifted","1873"," "},
	{"1487"," "," "," "},
	{"1488","message cancelled","1857"," "},
	{"1489"," "," "," "},
	{"1490"," "," "," "},
	{"1491"," "," "," "},
	{"1492"," "," "," "},
	{"1493"," "," "," "},
	{"1494","normal parking restrictions lifted","1886"," "},
	{"1495","special parking restrictions in force","1887"," "},
	{"1496","no parking (until Q)","1927","7"},
	{"1497"," "," "," "},
	{"1498","special parking restrictions lifted","1928"," "},
	{"1499"," "," "," "},
	{"1500","message cancelled","1883"," "},
	{"1501"," "," "," "},
	{"1502"," "," "," "},
	{"1503"," "," "," "},
	{"1504"," "," "," "},
	{"1505"," "," "," "},
	{"1506","car park (Q) full","1903","3"},
	{"1507","expect car park to be full","1922"," "},
	{"1508","10% full","1888"," "},
	{"1509","20% full","1889"," "},
	{"1510","30% full","1890"," "},
	{"1511","40% full","1891"," "},
	{"1512","50% full","1892"," "},
	{"1513","60% full","1893"," "},
	{"1514","70% full","1894"," "},
	{"1515","80% full","1895"," "},
	{"1516","90% full","1896"," "},
	{"1517","full","1918"," "},
	{"1518","all car parks (Q) full","1904","3"},
	{"1519","multi story car parks full","1924"," "},
	{"1520","less than (Q) car parking spaces available","1905","1"},
	{"1521","no parking spaces available","1926"," "},
	{"1522","expect no parking spaces available","1923"," "},
	{"1523","only a few parking spaces available","1920"," "},
	{"1524","(Q) parking spaces available","1921","1"},
	{"1525","less than 10 parking spaces available","1897"," "},
	{"1526","less than 20 parking spaces available","1898"," "},
	{"1527","less than 30 parking spaces available","1899"," "},
	{"1528","less than 40 parking spaces available","1900"," "},
	{"1529","less than 50 parking spaces available","1855"," "},
	{"1530","no problems to report with park and ride services","1925"," "},
	{"1531","no park and ride information available (until Q)","1934","7"},
	{"1532"," "," "," "},
	{"1533","park and ride information service resumed","1938"," "},
	{"1534","no parking information available (until Q)","1856","7"},
	{"1535"," "," "," "},
	{"1536","message cancelled","2038"," "},
	{"1537"," "," "," "},
	{"1538"," "," "," "},
	{"1539"," "," "," "},
	{"1540"," "," "," "},
	{"1541"," "," "," "},
	{"1542","switch your car radio (to Q)","1913","12"},
	{"1543","switch your car radio (to Q)","1908","11"},
	{"1544","urgent information will be given (at Q) on normal programme broadcasts","1929","7"},
	{"1545","detailed information will be given (at Q) on normal programme broadcasts","1931","7"},
	{"1546","alarm call: important new information on this frequency follows now in normal programme","1909"," "},
	{"1547","alarm set: new information will be broadcast between these times in normal programme","1910"," "},
	{"1548"," "," "," "},
	{"1549","reference to audio programmes no longer valid","1955"," "},
	{"1550"," "," "," "},
	{"1551","message cancelled","1911"," "},
	{"1552"," "," "," "},
	{"1553"," "," "," "},
	{"1554"," "," "," "},
	{"1555"," "," "," "},
	{"1556"," "," "," "},
	{"1557","additional regional information is provided by another TMC service","1940"," "},
	{"1558","additional local information is provided by another TMC service","1941"," "},
	{"1559","additional public transport information is provided by another TMC service","1942"," "},
	{"1560","national traffic information is provided by another TMC service","1943"," "},
	{"1561","this service provides major road information","1944"," "},
	{"1562","this service provides regional travel information","1945"," "},
	{"1563","this service provides local travel information","1946"," "},
	{"1564","no detailed regional information provided by this service","1947"," "},
	{"1565","no detailed local information provided by this service","1948"," "},
	{"1566","detailed information is provided by another TMC service","1932"," "},
	{"1567","no cross-border information provided by this service","1949"," "},
	{"1568","information restricted to this area","1950"," "},
	{"1569","no new traffic information available (until Q)","1951","7"},
	{"1570","no public transport information available","1952"," "},
	{"1571","this TMC-service is being suspended (at Q)","1953","7"},
	{"1572","active TMC-service will resume (at Q)","1954","7"},
	{"1573","this TMC-service is not active (until Q)","1930","7"},
	{"1574","no information available (until Q)","1914","7"},
	{"1575","no information available (until Q) due to technical problems","1916","7"},
	{"1576"," "," "," "},
	{"1577","reference to other TMC services no longer valid","1956"," "},
	{"1578","previous announcement about this or other TMC services no longer valid","1957"," "},
	{"1579","rail Information service not available","1964"," "},
	{"1580","rail information service resumed","1965"," "},
	{"1581","rapid transit information service not available","1966"," "},
	{"1582","rapid transit information service resumed","1967"," "},
	{"1583","message cancelled","2039"," "},
	{"1584"," "," "," "},
	{"1585"," "," "," "},
	{"1586","this message is for test purposes only (number Q), please ignore","1915","0"},
	{"1587","(null event) {no event description, but location etc. given in message}","1907"," "},
	{"1588","(null message) {completely silent message, see EN ISO 14819-1, 3.5.4}","2047"," "},
	{"1589","nothing to report","2041"," "},
	{"1590","message cancelled","2040"," "}
};


/* this is like an index key:
 * 1st column: tmc event code
 * 2nd column: row in tmc_events */
static const int tmc_event_code_index[TMC_EVENT_LIST_LINES][2] = {
	{0,0},
	{1,5},
	{2,48},
	{3,0},
	{4,0},
	{5,0},
	{6,0},
	{7,0},
	{8,0},
	{9,0},
	{10,0},
	{11,536},
	{12,516},
	{13,0},
	{14,0},
	{15,0},
	{16,553},
	{17,0},
	{18,0},
	{19,0},
	{20,766},
	{21,0},
	{22,767},
	{23,768},
	{24,769},
	{25,770},
	{26,695},
	{27,696},
	{28,775},
	{29,0},
	{30,0},
	{31,0},
	{32,0},
	{33,0},
	{34,0},
	{35,0},
	{36,790},
	{37,791},
	{38,0},
	{39,0},
	{40,793},
	{41,560},
	{42,641},
	{43,0},
	{44,0},
	{45,0},
	{46,0},
	{47,0},
	{48,0},
	{49,0},
	{50,0},
	{51,577},
	{52,831},
	{53,832},
	{54,0},
	{55,430},
	{56,435},
	{57,487},
	{58,0},
	{59,0},
	{60,0},
	{61,860},
	{62,899},
	{63,861},
	{64,900},
	{65,0},
	{66,0},
	{67,0},
	{68,0},
	{69,0},
	{70,37},
	{71,38},
	{72,39},
	{73,40},
	{74,41},
	{75,42},
	{76,43},
	{77,0},
	{78,0},
	{79,0},
	{80,0},
	{81,0},
	{82,0},
	{83,0},
	{84,0},
	{85,0},
	{86,0},
	{87,0},
	{88,0},
	{89,0},
	{90,0},
	{91,1294},
	{92,0},
	{93,0},
	{94,0},
	{95,0},
	{96,0},
	{97,0},
	{98,0},
	{99,0},
	{100,0},
	{101,6},
	{102,7},
	{103,8},
	{104,10},
	{105,11},
	{106,12},
	{107,431},
	{108,14},
	{109,15},
	{110,16},
	{111,18},
	{112,19},
	{113,20},
	{114,432},
	{115,23},
	{116,24},
	{117,25},
	{118,27},
	{119,28},
	{120,29},
	{121,433},
	{122,30},
	{123,434},
	{124,33},
	{125,34},
	{126,420},
	{127,421},
	{128,424},
	{129,9},
	{130,13},
	{131,17},
	{132,21},
	{133,22},
	{134,26},
	{135,35},
	{136,36},
	{137,44},
	{138,45},
	{139,46},
	{140,47},
	{141,521},
	{142,31},
	{143,32},
	{144,0},
	{145,0},
	{146,0},
	{147,0},
	{148,0},
	{149,0},
	{150,0},
	{151,0},
	{152,0},
	{153,0},
	{154,0},
	{155,0},
	{156,0},
	{157,0},
	{158,0},
	{159,0},
	{160,0},
	{161,0},
	{162,0},
	{163,0},
	{164,0},
	{165,0},
	{166,0},
	{167,0},
	{168,0},
	{169,0},
	{170,0},
	{171,0},
	{172,0},
	{173,0},
	{174,0},
	{175,0},
	{176,0},
	{177,0},
	{178,0},
	{179,0},
	{180,0},
	{181,0},
	{182,0},
	{183,0},
	{184,0},
	{185,0},
	{186,0},
	{187,0},
	{188,0},
	{189,0},
	{190,0},
	{191,0},
	{192,0},
	{193,0},
	{194,0},
	{195,0},
	{196,0},
	{197,0},
	{198,0},
	{199,0},
	{200,1212},
	{201,495},
	{202,496},
	{203,497},
	{204,498},
	{205,500},
	{206,501},
	{207,502},
	{208,91},
	{209,519},
	{210,862},
	{211,531},
	{212,533},
	{213,509},
	{214,530},
	{215,49},
	{216,50},
	{217,51},
	{218,53},
	{219,54},
	{220,55},
	{221,56},
	{222,57},
	{223,58},
	{224,59},
	{225,61},
	{226,62},
	{227,63},
	{228,64},
	{229,65},
	{230,66},
	{231,67},
	{232,69},
	{233,70},
	{234,71},
	{235,436},
	{236,72},
	{237,437},
	{238,73},
	{239,74},
	{240,552},
	{241,608},
	{242,609},
	{243,610},
	{244,611},
	{245,612},
	{246,613},
	{247,1209},
	{248,1210},
	{249,1211},
	{250,75},
	{251,76},
	{252,77},
	{253,79},
	{254,80},
	{255,81},
	{256,82},
	{257,83},
	{258,84},
	{259,85},
	{260,87},
	{261,88},
	{262,89},
	{263,90},
	{264,92},
	{265,93},
	{266,94},
	{267,96},
	{268,97},
	{269,98},
	{270,438},
	{271,99},
	{272,439},
	{273,0},
	{274,100},
	{275,1213},
	{276,1214},
	{277,1215},
	{278,102},
	{279,103},
	{280,104},
	{281,106},
	{282,107},
	{283,108},
	{284,109},
	{285,110},
	{286,111},
	{287,112},
	{288,114},
	{289,115},
	{290,116},
	{291,117},
	{292,118},
	{293,119},
	{294,120},
	{295,122},
	{296,123},
	{297,124},
	{298,440},
	{299,125},
	{300,441},
	{301,126},
	{302,127},
	{303,614},
	{304,615},
	{305,616},
	{306,617},
	{307,618},
	{308,619},
	{309,620},
	{310,1216},
	{311,1217},
	{312,1218},
	{313,142},
	{314,143},
	{315,144},
	{316,145},
	{317,146},
	{318,444},
	{319,147},
	{320,445},
	{321,148},
	{322,149},
	{323,627},
	{324,628},
	{325,629},
	{326,630},
	{327,631},
	{328,632},
	{329,633},
	{330,1224},
	{331,1225},
	{332,1226},
	{333,522},
	{334,524},
	{335,499},
	{336,503},
	{337,504},
	{338,505},
	{339,506},
	{340,507},
	{341,508},
	{342,510},
	{343,512},
	{344,513},
	{345,517},
	{346,535},
	{347,1412},
	{348,52},
	{349,60},
	{350,68},
	{351,515},
	{352,78},
	{353,86},
	{354,95},
	{355,101},
	{356,105},
	{357,113},
	{358,121},
	{359,863},
	{360,128},
	{361,129},
	{362,130},
	{363,131},
	{364,132},
	{365,442},
	{366,133},
	{367,443},
	{368,134},
	{369,621},
	{370,622},
	{371,623},
	{372,624},
	{373,625},
	{374,626},
	{375,1219},
	{376,1220},
	{377,1221},
	{378,511},
	{379,135},
	{380,136},
	{381,137},
	{382,138},
	{383,139},
	{384,0},
	{385,140},
	{386,0},
	{387,141},
	{388,1222},
	{389,0},
	{390,1223},
	{391,514},
	{392,518},
	{393,532},
	{394,534},
	{395,543},
	{396,542},
	{397,539},
	{398,0},
	{399,733},
	{400,0},
	{401,551},
	{402,634},
	{403,771},
	{404,745},
	{405,744},
	{406,726},
	{407,707},
	{408,711},
	{409,713},
	{410,150},
	{411,151},
	{412,152},
	{413,154},
	{414,155},
	{415,156},
	{416,157},
	{417,158},
	{418,159},
	{419,160},
	{420,162},
	{421,163},
	{422,164},
	{423,165},
	{424,166},
	{425,167},
	{426,168},
	{427,170},
	{428,171},
	{429,172},
	{430,446},
	{431,173},
	{432,447},
	{433,174},
	{434,175},
	{435,1227},
	{436,1228},
	{437,1229},
	{438,176},
	{439,177},
	{440,178},
	{441,180},
	{442,181},
	{443,182},
	{444,183},
	{445,184},
	{446,185},
	{447,186},
	{448,188},
	{449,189},
	{450,190},
	{451,191},
	{452,192},
	{453,193},
	{454,194},
	{455,196},
	{456,197},
	{457,198},
	{458,448},
	{459,199},
	{460,449},
	{461,200},
	{462,201},
	{463,1230},
	{464,1231},
	{465,1232},
	{466,718},
	{467,670},
	{468,796},
	{469,748},
	{470,749},
	{471,727},
	{472,728},
	{473,729},
	{474,708},
	{475,709},
	{476,710},
	{477,712},
	{478,714},
	{479,681},
	{480,682},
	{481,683},
	{482,684},
	{483,685},
	{484,686},
	{485,715},
	{486,687},
	{487,688},
	{488,689},
	{489,690},
	{490,691},
	{491,692},
	{492,739},
	{493,740},
	{494,772},
	{495,153},
	{496,161},
	{497,169},
	{498,179},
	{499,187},
	{500,554},
	{501,555},
	{502,556},
	{503,557},
	{504,558},
	{505,562},
	{506,563},
	{507,636},
	{508,637},
	{509,638},
	{510,639},
	{511,643},
	{512,644},
	{513,653},
	{514,564},
	{515,565},
	{516,566},
	{517,650},
	{518,651},
	{519,652},
	{520,635},
	{521,202},
	{522,203},
	{523,204},
	{524,206},
	{525,207},
	{526,208},
	{527,209},
	{528,210},
	{529,211},
	{530,212},
	{531,214},
	{532,215},
	{533,216},
	{534,217},
	{535,218},
	{536,219},
	{537,220},
	{538,222},
	{539,223},
	{540,224},
	{541,450},
	{542,225},
	{543,451},
	{544,226},
	{545,227},
	{546,228},
	{547,229},
	{548,230},
	{549,231},
	{550,232},
	{551,452},
	{552,233},
	{553,453},
	{554,234},
	{555,235},
	{556,236},
	{557,237},
	{558,238},
	{559,239},
	{560,240},
	{561,454},
	{562,241},
	{563,455},
	{564,242},
	{565,243},
	{566,244},
	{567,245},
	{568,246},
	{569,247},
	{570,248},
	{571,456},
	{572,249},
	{573,457},
	{574,250},
	{575,251},
	{576,252},
	{577,253},
	{578,254},
	{579,256},
	{580,257},
	{581,258},
	{582,259},
	{583,260},
	{584,261},
	{585,262},
	{586,264},
	{587,265},
	{588,266},
	{589,267},
	{590,268},
	{591,269},
	{592,270},
	{593,272},
	{594,273},
	{595,274},
	{596,458},
	{597,275},
	{598,459},
	{599,276},
	{600,277},
	{601,567},
	{602,568},
	{603,569},
	{604,278},
	{605,279},
	{606,280},
	{607,281},
	{608,282},
	{609,460},
	{610,283},
	{611,461},
	{612,284},
	{613,285},
	{614,286},
	{615,287},
	{616,288},
	{617,289},
	{618,290},
	{619,462},
	{620,291},
	{621,463},
	{622,292},
	{623,293},
	{624,672},
	{625,675},
	{626,195},
	{627,741},
	{628,742},
	{629,743},
	{630,671},
	{631,668},
	{632,731},
	{633,717},
	{634,699},
	{635,792},
	{636,794},
	{637,559},
	{638,659},
	{639,661},
	{640,662},
	{641,561},
	{642,640},
	{643,660},
	{644,664},
	{645,665},
	{646,642},
	{647,802},
	{648,803},
	{649,804},
	{650,806},
	{651,205},
	{652,213},
	{653,221},
	{654,255},
	{655,263},
	{656,271},
	{657,667},
	{658,669},
	{659,812},
	{660,787},
	{661,773},
	{662,781},
	{663,698},
	{664,673},
	{665,674},
	{666,550},
	{667,0},
	{668,0},
	{669,0},
	{670,0},
	{671,805},
	{672,701},
	{673,720},
	{674,0},
	{675,0},
	{676,694},
	{677,0},
	{678,663},
	{679,666},
	{680,789},
	{681,1401},
	{682,0},
	{683,0},
	{684,0},
	{685,0},
	{686,0},
	{687,0},
	{688,0},
	{689,0},
	{690,0},
	{691,0},
	{692,0},
	{693,0},
	{694,0},
	{695,0},
	{696,0},
	{697,0},
	{698,0},
	{699,0},
	{700,0},
	{701,820},
	{702,821},
	{703,826},
	{704,824},
	{705,825},
	{706,947},
	{707,828},
	{708,839},
	{709,830},
	{710,294},
	{711,295},
	{712,296},
	{713,298},
	{714,299},
	{715,300},
	{716,301},
	{717,302},
	{718,303},
	{719,304},
	{720,306},
	{721,307},
	{722,308},
	{723,309},
	{724,310},
	{725,311},
	{726,312},
	{727,314},
	{728,315},
	{729,316},
	{730,464},
	{731,317},
	{732,465},
	{733,318},
	{734,319},
	{735,570},
	{736,571},
	{737,572},
	{738,573},
	{739,574},
	{740,575},
	{741,576},
	{742,655},
	{743,578},
	{744,579},
	{745,580},
	{746,654},
	{747,1233},
	{748,1234},
	{749,1235},
	{750,320},
	{751,321},
	{752,322},
	{753,324},
	{754,325},
	{755,326},
	{756,327},
	{757,328},
	{758,329},
	{759,330},
	{760,332},
	{761,333},
	{762,334},
	{763,335},
	{764,336},
	{765,337},
	{766,338},
	{767,340},
	{768,341},
	{769,342},
	{770,466},
	{771,343},
	{772,467},
	{773,344},
	{774,345},
	{775,657},
	{776,581},
	{777,582},
	{778,583},
	{779,656},
	{780,1236},
	{781,1237},
	{782,1238},
	{783,346},
	{784,347},
	{785,348},
	{786,349},
	{787,350},
	{788,468},
	{789,351},
	{790,469},
	{791,352},
	{792,353},
	{793,584},
	{794,585},
	{795,586},
	{796,587},
	{797,588},
	{798,589},
	{799,595},
	{800,849},
	{801,851},
	{802,822},
	{803,823},
	{804,1397},
	{805,829},
	{806,840},
	{807,841},
	{808,842},
	{809,843},
	{810,844},
	{811,846},
	{812,297},
	{813,305},
	{814,313},
	{815,833},
	{816,834},
	{817,835},
	{818,323},
	{819,331},
	{820,339},
	{821,836},
	{822,837},
	{823,838},
	{824,948},
	{825,354},
	{826,355},
	{827,356},
	{828,357},
	{829,358},
	{830,470},
	{831,359},
	{832,471},
	{833,360},
	{834,361},
	{835,590},
	{836,591},
	{837,592},
	{838,593},
	{839,594},
	{840,1239},
	{841,1240},
	{842,1241},
	{843,1242},
	{844,1243},
	{845,1244},
	{846,1245},
	{847,1246},
	{848,1247},
	{849,1248},
	{850,1249},
	{851,1250},
	{852,945},
	{853,827},
	{854,848},
	{855,845},
	{856,946},
	{857,950},
	{858,951},
	{859,952},
	{860,953},
	{861,954},
	{862,955},
	{863,0},
	{864,0},
	{865,0},
	{866,0},
	{867,0},
	{868,0},
	{869,0},
	{870,0},
	{871,0},
	{872,0},
	{873,0},
	{874,0},
	{875,0},
	{876,0},
	{877,0},
	{878,0},
	{879,0},
	{880,0},
	{881,0},
	{882,0},
	{883,0},
	{884,0},
	{885,0},
	{886,0},
	{887,0},
	{888,0},
	{889,0},
	{890,0},
	{891,0},
	{892,0},
	{893,0},
	{894,0},
	{895,0},
	{896,0},
	{897,0},
	{898,923},
	{899,924},
	{900,874},
	{901,857},
	{902,858},
	{903,864},
	{904,866},
	{905,869},
	{906,870},
	{907,873},
	{908,875},
	{909,878},
	{910,879},
	{911,881},
	{912,883},
	{913,886},
	{914,888},
	{915,891},
	{916,981},
	{917,893},
	{918,895},
	{919,897},
	{920,901},
	{921,904},
	{922,934},
	{923,939},
	{924,537},
	{925,647},
	{926,648},
	{927,910},
	{928,362},
	{929,363},
	{930,364},
	{931,365},
	{932,366},
	{933,472},
	{934,367},
	{935,473},
	{936,368},
	{937,369},
	{938,759},
	{939,1251},
	{940,1252},
	{941,1253},
	{942,912},
	{943,760},
	{944,913},
	{945,763},
	{946,915},
	{947,596},
	{948,916},
	{949,764},
	{950,918},
	{951,599},
	{952,600},
	{953,601},
	{954,658},
	{955,917},
	{956,602},
	{957,597},
	{958,1257},
	{959,1258},
	{960,1259},
	{961,603},
	{962,1260},
	{963,1261},
	{964,1262},
	{965,598},
	{966,1263},
	{967,1264},
	{968,1265},
	{969,604},
	{970,925},
	{971,931},
	{972,868},
	{973,871},
	{974,876},
	{975,885},
	{976,890},
	{977,903},
	{978,906},
	{979,907},
	{980,645},
	{981,859},
	{982,646},
	{983,908},
	{984,865},
	{985,909},
	{986,867},
	{987,649},
	{988,911},
	{989,872},
	{990,877},
	{991,880},
	{992,882},
	{993,761},
	{994,884},
	{995,762},
	{996,914},
	{997,919},
	{998,887},
	{999,889},
	{1000,892},
	{1001,962},
	{1002,969},
	{1003,970},
	{1004,971},
	{1005,973},
	{1006,983},
	{1007,984},
	{1008,987},
	{1009,989},
	{1010,991},
	{1011,992},
	{1012,993},
	{1013,994},
	{1014,995},
	{1015,996},
	{1016,997},
	{1017,1000},
	{1018,998},
	{1019,999},
	{1020,1005},
	{1021,605},
	{1022,606},
	{1023,607},
	{1024,1007},
	{1025,1013},
	{1026,894},
	{1027,1254},
	{1028,1255},
	{1029,1256},
	{1030,896},
	{1031,898},
	{1032,902},
	{1033,905},
	{1034,538},
	{1035,958},
	{1036,959},
	{1037,960},
	{1038,963},
	{1039,964},
	{1040,965},
	{1041,968},
	{1042,974},
	{1043,975},
	{1044,977},
	{1045,979},
	{1046,0},
	{1047,985},
	{1048,986},
	{1049,0},
	{1050,988},
	{1051,0},
	{1052,0},
	{1053,0},
	{1054,1001},
	{1055,972},
	{1056,976},
	{1057,978},
	{1058,980},
	{1059,982},
	{1060,1002},
	{1061,1003},
	{1062,1004},
	{1063,966},
	{1064,967},
	{1065,1009},
	{1066,540},
	{1067,943},
	{1068,944},
	{1069,1010},
	{1070,1008},
	{1071,0},
	{1072,0},
	{1073,961},
	{1074,990},
	{1075,1006},
	{1076,0},
	{1077,0},
	{1078,0},
	{1079,1022},
	{1080,1023},
	{1081,1024},
	{1082,1026},
	{1083,1019},
	{1084,927},
	{1085,0},
	{1086,929},
	{1087,0},
	{1088,0},
	{1089,0},
	{1090,0},
	{1091,0},
	{1092,0},
	{1093,0},
	{1094,0},
	{1095,0},
	{1096,0},
	{1097,0},
	{1098,0},
	{1099,0},
	{1100,0},
	{1101,1042},
	{1102,1045},
	{1103,1046},
	{1104,1047},
	{1105,1049},
	{1106,1036},
	{1107,1037},
	{1108,1038},
	{1109,1050},
	{1110,1053},
	{1111,1054},
	{1112,1055},
	{1113,1057},
	{1114,1058},
	{1115,1020},
	{1116,1021},
	{1117,0},
	{1118,0},
	{1119,0},
	{1120,0},
	{1121,0},
	{1122,0},
	{1123,0},
	{1124,0},
	{1125,0},
	{1126,1090},
	{1127,1028},
	{1128,1039},
	{1129,0},
	{1130,1040},
	{1131,0},
	{1132,1034},
	{1133,0},
	{1134,1044},
	{1135,1048},
	{1136,1052},
	{1137,1056},
	{1138,0},
	{1139,0},
	{1140,0},
	{1141,0},
	{1142,0},
	{1143,0},
	{1144,0},
	{1145,0},
	{1146,0},
	{1147,0},
	{1148,0},
	{1149,0},
	{1150,0},
	{1151,0},
	{1152,0},
	{1153,0},
	{1154,0},
	{1155,0},
	{1156,0},
	{1157,0},
	{1158,0},
	{1159,0},
	{1160,0},
	{1161,0},
	{1162,0},
	{1163,0},
	{1164,0},
	{1165,1011},
	{1166,1012},
	{1167,0},
	{1168,0},
	{1169,0},
	{1170,1043},
	{1171,1051},
	{1172,1089},
	{1173,1041},
	{1174,1035},
	{1175,1063},
	{1176,1079},
	{1177,1073},
	{1178,1076},
	{1179,1088},
	{1180,1091},
	{1181,0},
	{1182,0},
	{1183,0},
	{1184,0},
	{1185,0},
	{1186,0},
	{1187,0},
	{1188,0},
	{1189,0},
	{1190,1107},
	{1191,1108},
	{1192,0},
	{1193,0},
	{1194,0},
	{1195,0},
	{1196,0},
	{1197,0},
	{1198,0},
	{1199,0},
	{1200,0},
	{1201,1099},
	{1202,1100},
	{1203,1101},
	{1204,1102},
	{1205,1103},
	{1206,0},
	{1207,0},
	{1208,0},
	{1209,1104},
	{1210,1105},
	{1211,1106},
	{1212,785},
	{1213,1111},
	{1214,1113},
	{1215,788},
	{1216,0},
	{1217,1110},
	{1218,0},
	{1219,0},
	{1220,0},
	{1221,0},
	{1222,0},
	{1223,0},
	{1224,0},
	{1225,0},
	{1226,0},
	{1227,0},
	{1228,0},
	{1229,0},
	{1230,0},
	{1231,0},
	{1232,0},
	{1233,0},
	{1234,0},
	{1235,0},
	{1236,0},
	{1237,0},
	{1238,0},
	{1239,0},
	{1240,0},
	{1241,0},
	{1242,0},
	{1243,0},
	{1244,0},
	{1245,0},
	{1246,0},
	{1247,0},
	{1248,0},
	{1249,0},
	{1250,0},
	{1251,0},
	{1252,0},
	{1253,0},
	{1254,0},
	{1255,0},
	{1256,0},
	{1257,0},
	{1258,0},
	{1259,0},
	{1260,0},
	{1261,0},
	{1262,0},
	{1263,0},
	{1264,0},
	{1265,0},
	{1266,0},
	{1267,0},
	{1268,0},
	{1269,0},
	{1270,0},
	{1271,0},
	{1272,0},
	{1273,0},
	{1274,0},
	{1275,0},
	{1276,0},
	{1277,0},
	{1278,0},
	{1279,0},
	{1280,0},
	{1281,0},
	{1282,0},
	{1283,0},
	{1284,0},
	{1285,0},
	{1286,0},
	{1287,0},
	{1288,0},
	{1289,0},
	{1290,0},
	{1291,0},
	{1292,0},
	{1293,0},
	{1294,0},
	{1295,0},
	{1296,0},
	{1297,0},
	{1298,0},
	{1299,0},
	{1300,0},
	{1301,1072},
	{1302,1080},
	{1303,1081},
	{1304,1074},
	{1305,1082},
	{1306,0},
	{1307,1075},
	{1308,1077},
	{1309,1066},
	{1310,1069},
	{1311,0},
	{1312,1083},
	{1313,1087},
	{1314,1093},
	{1315,0},
	{1316,0},
	{1317,0},
	{1318,1059},
	{1319,1060},
	{1320,1061},
	{1321,1062},
	{1322,1064},
	{1323,1065},
	{1324,1067},
	{1325,1068},
	{1326,1070},
	{1327,0},
	{1328,0},
	{1329,0},
	{1330,0},
	{1331,0},
	{1332,746},
	{1333,0},
	{1334,0},
	{1335,0},
	{1336,0},
	{1337,1078},
	{1338,747},
	{1339,0},
	{1340,1071},
	{1341,0},
	{1342,0},
	{1343,0},
	{1344,0},
	{1345,1086},
	{1346,1085},
	{1347,0},
	{1348,0},
	{1349,0},
	{1350,0},
	{1351,0},
	{1352,0},
	{1353,0},
	{1354,0},
	{1355,0},
	{1356,0},
	{1357,0},
	{1358,0},
	{1359,0},
	{1360,0},
	{1361,0},
	{1362,0},
	{1363,0},
	{1364,0},
	{1365,0},
	{1366,0},
	{1367,0},
	{1368,0},
	{1369,0},
	{1370,0},
	{1371,0},
	{1372,0},
	{1373,0},
	{1374,0},
	{1375,0},
	{1376,0},
	{1377,0},
	{1378,0},
	{1379,0},
	{1380,0},
	{1381,0},
	{1382,0},
	{1383,0},
	{1384,0},
	{1385,0},
	{1386,0},
	{1387,0},
	{1388,0},
	{1389,0},
	{1390,0},
	{1391,0},
	{1392,0},
	{1393,0},
	{1394,0},
	{1395,0},
	{1396,0},
	{1397,0},
	{1398,0},
	{1399,0},
	{1400,0},
	{1401,0},
	{1402,0},
	{1403,0},
	{1404,0},
	{1405,0},
	{1406,0},
	{1407,0},
	{1408,0},
	{1409,0},
	{1410,0},
	{1411,0},
	{1412,0},
	{1413,0},
	{1414,0},
	{1415,0},
	{1416,0},
	{1417,0},
	{1418,0},
	{1419,0},
	{1420,0},
	{1421,0},
	{1422,0},
	{1423,0},
	{1424,0},
	{1425,0},
	{1426,0},
	{1427,0},
	{1428,0},
	{1429,0},
	{1430,0},
	{1431,0},
	{1432,0},
	{1433,0},
	{1434,0},
	{1435,0},
	{1436,0},
	{1437,0},
	{1438,0},
	{1439,0},
	{1440,0},
	{1441,0},
	{1442,0},
	{1443,0},
	{1444,0},
	{1445,0},
	{1446,0},
	{1447,0},
	{1448,0},
	{1449,0},
	{1450,1122},
	{1451,1123},
	{1452,1124},
	{1453,1125},
	{1454,1126},
	{1455,1127},
	{1456,1128},
	{1457,1129},
	{1458,1130},
	{1459,1131},
	{1460,1132},
	{1461,1133},
	{1462,1134},
	{1463,1135},
	{1464,1136},
	{1465,1137},
	{1466,1138},
	{1467,1139},
	{1468,1145},
	{1469,1146},
	{1470,1150},
	{1471,935},
	{1472,936},
	{1473,937},
	{1474,938},
	{1475,1152},
	{1476,1169},
	{1477,1170},
	{1478,1172},
	{1479,1173},
	{1480,1174},
	{1481,1175},
	{1482,940},
	{1483,941},
	{1484,942},
	{1485,758},
	{1486,1287},
	{1487,1288},
	{1488,1289},
	{1489,1290},
	{1490,1291},
	{1491,1292},
	{1492,1179},
	{1493,1157},
	{1494,1176},
	{1495,400},
	{1496,1158},
	{1497,0},
	{1498,0},
	{1499,0},
	{1500,0},
	{1501,1119},
	{1502,1121},
	{1503,1140},
	{1504,1141},
	{1505,1142},
	{1506,1144},
	{1507,1143},
	{1508,1147},
	{1509,1148},
	{1510,1149},
	{1511,1151},
	{1512,1153},
	{1513,1154},
	{1514,1155},
	{1515,1168},
	{1516,1171},
	{1517,370},
	{1518,371},
	{1519,372},
	{1520,373},
	{1521,374},
	{1522,474},
	{1523,375},
	{1524,475},
	{1525,376},
	{1526,377},
	{1527,751},
	{1528,1266},
	{1529,1267},
	{1530,1268},
	{1531,378},
	{1532,379},
	{1533,380},
	{1534,381},
	{1535,382},
	{1536,476},
	{1537,383},
	{1538,477},
	{1539,384},
	{1540,385},
	{1541,752},
	{1542,1269},
	{1543,1270},
	{1544,1271},
	{1545,386},
	{1546,387},
	{1547,388},
	{1548,389},
	{1549,390},
	{1550,478},
	{1551,391},
	{1552,479},
	{1553,392},
	{1554,393},
	{1555,753},
	{1556,1272},
	{1557,1273},
	{1558,1274},
	{1559,754},
	{1560,1275},
	{1561,1276},
	{1562,1277},
	{1563,755},
	{1564,1278},
	{1565,1279},
	{1566,1280},
	{1567,756},
	{1568,1281},
	{1569,1282},
	{1570,1283},
	{1571,394},
	{1572,395},
	{1573,396},
	{1574,397},
	{1575,398},
	{1576,480},
	{1577,399},
	{1578,481},
	{1579,402},
	{1580,757},
	{1581,1284},
	{1582,1285},
	{1583,1286},
	{1584,422},
	{1585,1165},
	{1586,401},
	{1587,1178},
	{1588,1180},
	{1589,489},
	{1590,1120},
	{1591,1156},
	{1592,1159},
	{1593,1160},
	{1594,1161},
	{1595,1162},
	{1596,1163},
	{1597,1164},
	{1598,0},
	{1599,0},
	{1600,0},
	{1601,1188},
	{1602,1193},
	{1603,1196},
	{1604,1199},
	{1605,1201},
	{1606,1205},
	{1607,1189},
	{1608,1206},
	{1609,1293},
	{1610,1296},
	{1611,1297},
	{1612,1298},
	{1613,1299},
	{1614,1300},
	{1615,1339},
	{1616,1341},
	{1617,1342},
	{1618,1362},
	{1619,1367},
	{1620,1331},
	{1621,1191},
	{1622,1192},
	{1623,1194},
	{1624,1195},
	{1625,1197},
	{1626,1198},
	{1627,1200},
	{1628,1202},
	{1629,1203},
	{1630,1204},
	{1631,1207},
	{1632,1208},
	{1633,1340},
	{1634,1337},
	{1635,1345},
	{1636,1346},
	{1637,1347},
	{1638,1348},
	{1639,1352},
	{1640,1354},
	{1641,1355},
	{1642,1295},
	{1643,1301},
	{1644,1363},
	{1645,1364},
	{1646,1381},
	{1647,1382},
	{1648,1328},
	{1649,1353},
	{1650,1190},
	{1651,1357},
	{1652,1338},
	{1653,1302},
	{1654,1303},
	{1655,1343},
	{1656,1378},
	{1657,1350},
	{1658,1351},
	{1659,1356},
	{1660,1366},
	{1661,1361},
	{1662,1375},
	{1663,1329},
	{1664,0},
	{1665,0},
	{1666,0},
	{1667,0},
	{1668,0},
	{1669,0},
	{1670,0},
	{1671,0},
	{1672,0},
	{1673,0},
	{1674,0},
	{1675,0},
	{1676,0},
	{1677,0},
	{1678,0},
	{1679,0},
	{1680,0},
	{1681,0},
	{1682,0},
	{1683,0},
	{1684,0},
	{1685,0},
	{1686,0},
	{1687,0},
	{1688,0},
	{1689,0},
	{1690,0},
	{1691,0},
	{1692,0},
	{1693,0},
	{1694,0},
	{1695,1376},
	{1696,1377},
	{1697,0},
	{1698,0},
	{1699,0},
	{1700,921},
	{1701,1390},
	{1702,1403},
	{1703,1406},
	{1704,1391},
	{1705,1392},
	{1706,1393},
	{1707,1394},
	{1708,1395},
	{1709,920},
	{1710,1396},
	{1711,1402},
	{1712,926},
	{1713,0},
	{1714,0},
	{1715,0},
	{1716,0},
	{1717,0},
	{1718,0},
	{1719,0},
	{1720,1349},
	{1721,1360},
	{1722,0},
	{1723,0},
	{1724,0},
	{1725,0},
	{1726,0},
	{1727,0},
	{1728,0},
	{1729,0},
	{1730,0},
	{1731,1415},
	{1732,1417},
	{1733,1419},
	{1734,1421},
	{1735,1423},
	{1736,1399},
	{1737,1426},
	{1738,1428},
	{1739,1413},
	{1740,1307},
	{1741,1311},
	{1742,0},
	{1743,0},
	{1744,0},
	{1745,0},
	{1746,0},
	{1747,0},
	{1748,0},
	{1749,0},
	{1750,0},
	{1751,1414},
	{1752,1416},
	{1753,1418},
	{1754,1420},
	{1755,1425},
	{1756,1306},
	{1757,1304},
	{1758,1305},
	{1759,1308},
	{1760,1309},
	{1761,1310},
	{1762,1431},
	{1763,1433},
	{1764,1422},
	{1765,1398},
	{1766,1427},
	{1767,1424},
	{1768,1400},
	{1769,1404},
	{1770,1430},
	{1771,949},
	{1772,0},
	{1773,0},
	{1774,0},
	{1775,0},
	{1776,0},
	{1777,0},
	{1778,0},
	{1779,0},
	{1780,0},
	{1781,0},
	{1782,0},
	{1783,0},
	{1784,0},
	{1785,0},
	{1786,0},
	{1787,0},
	{1788,0},
	{1789,0},
	{1790,0},
	{1791,0},
	{1792,0},
	{1793,0},
	{1794,0},
	{1795,0},
	{1796,0},
	{1797,0},
	{1798,0},
	{1799,0},
	{1800,0},
	{1801,1439},
	{1802,1445},
	{1803,1446},
	{1804,1449},
	{1805,1450},
	{1806,1462},
	{1807,403},
	{1808,404},
	{1809,405},
	{1810,406},
	{1811,407},
	{1812,482},
	{1813,408},
	{1814,483},
	{1815,409},
	{1816,410},
	{1817,1312},
	{1818,1313},
	{1819,1314},
	{1820,411},
	{1821,412},
	{1822,413},
	{1823,414},
	{1824,415},
	{1825,484},
	{1826,416},
	{1827,485},
	{1828,417},
	{1829,418},
	{1830,1324},
	{1831,1325},
	{1832,1326},
	{1833,1465},
	{1834,1466},
	{1835,1467},
	{1836,1468},
	{1837,1470},
	{1838,1440},
	{1839,1441},
	{1840,1442},
	{1841,1443},
	{1842,1444},
	{1843,1451},
	{1844,1452},
	{1845,1453},
	{1846,1454},
	{1847,1460},
	{1848,1461},
	{1849,1463},
	{1850,1455},
	{1851,1476},
	{1852,1482},
	{1853,0},
	{1854,774},
	{1855,1529},
	{1856,1534},
	{1857,1488},
	{1858,1327},
	{1859,0},
	{1860,0},
	{1861,1477},
	{1862,1483},
	{1863,0},
	{1864,1456},
	{1865,1447},
	{1866,1448},
	{1867,1457},
	{1868,1315},
	{1869,1316},
	{1870,1317},
	{1871,1479},
	{1872,1480},
	{1873,1486},
	{1874,1485},
	{1875,1458},
	{1876,1318},
	{1877,1319},
	{1878,1320},
	{1879,1459},
	{1880,1321},
	{1881,1478},
	{1882,1484},
	{1883,1500},
	{1884,1322},
	{1885,1323},
	{1886,1494},
	{1887,1495},
	{1888,1508},
	{1889,1509},
	{1890,1510},
	{1891,1511},
	{1892,1512},
	{1893,1513},
	{1894,1514},
	{1895,1515},
	{1896,1516},
	{1897,1525},
	{1898,1526},
	{1899,1527},
	{1900,1528},
	{1901,1379},
	{1902,1380},
	{1903,1506},
	{1904,1518},
	{1905,1520},
	{1906,1344},
	{1907,1587},
	{1908,1543},
	{1909,1546},
	{1910,1547},
	{1911,1551},
	{1912,0},
	{1913,1542},
	{1914,1574},
	{1915,1586},
	{1916,1575},
	{1917,0},
	{1918,1517},
	{1919,0},
	{1920,1523},
	{1921,1524},
	{1922,1507},
	{1923,1522},
	{1924,1519},
	{1925,1530},
	{1926,1521},
	{1927,1496},
	{1928,1498},
	{1929,1544},
	{1930,1573},
	{1931,1545},
	{1932,1566},
	{1933,0},
	{1934,1531},
	{1935,0},
	{1936,0},
	{1937,0},
	{1938,1533},
	{1939,0},
	{1940,1557},
	{1941,1558},
	{1942,1559},
	{1943,1560},
	{1944,1561},
	{1945,1562},
	{1946,1563},
	{1947,1564},
	{1948,1565},
	{1949,1567},
	{1950,1568},
	{1951,1569},
	{1952,1570},
	{1953,1571},
	{1954,1572},
	{1955,1549},
	{1956,1577},
	{1957,1578},
	{1958,0},
	{1959,0},
	{1960,0},
	{1961,784},
	{1962,807},
	{1963,808},
	{1964,1579},
	{1965,1580},
	{1966,1581},
	{1967,1582},
	{1968,0},
	{1969,0},
	{1970,0},
	{1971,776},
	{1972,777},
	{1973,778},
	{1974,782},
	{1975,0},
	{1976,0},
	{1977,783},
	{1978,779},
	{1979,780},
	{1980,0},
	{1981,0},
	{1982,693},
	{1983,1469},
	{1984,0},
	{1985,0},
	{1986,0},
	{1987,0},
	{1988,0},
	{1989,0},
	{1990,0},
	{1991,0},
	{1992,0},
	{1993,0},
	{1994,0},
	{1995,0},
	{1996,0},
	{1997,0},
	{1998,0},
	{1999,0},
	{2000,750},
	{2001,0},
	{2002,0},
	{2003,0},
	{2004,0},
	{2005,0},
	{2006,809},
	{2007,810},
	{2008,0},
	{2009,0},
	{2010,0},
	{2011,0},
	{2012,0},
	{2013,765},
	{2014,0},
	{2015,0},
	{2016,0},
	{2017,0},
	{2018,0},
	{2019,0},
	{2020,0},
	{2021,1358},
	{2022,1359},
	{2023,0},
	{2024,0},
	{2025,0},
	{2026,0},
	{2027,0},
	{2028,545},
	{2029,814},
	{2030,956},
	{2031,0},
	{2032,0},
	{2033,1182},
	{2034,1369},
	{2035,1384},
	{2036,0},
	{2037,0},
	{2038,1536},
	{2039,1583},
	{2040,1590},
	{2041,1589},
	{2042,0},
	{2043,0},
	{2044,0},
	{2045,0},
	{2046,0},
	{2047,1588}
};

/* table 1, paragraph 3.1.2, page 4 of ISO 14819-2
 * descriptions of the types of quantifiers */
static const std::string quantifier_types[13][2] = {
	{"0", "n (small number)"},
	{"1", "N (number)"},
	{"2", "less than V metres"},
	{"3", "P percent"},
	{"4", "of up to S km/h"},
	{"5", "of up to M minutes"},
	{"6", "T degrees Celsius"},
	{"7", "H time"},
	{"8", "W tonnes"},
	{"9", "L metres"},
	{"10", "of up to D millimetres"},
	{"11", "M MHz"},
	{"12", "k kHz"}
};

std::string RDSTMC::get_tmc_events(unsigned int i, unsigned int j)
{
	return tmc_events[i][j];
}

int RDSTMC::get_tmc_event_code_index(unsigned int i, unsigned int j)
{
	return tmc_event_code_index[i][j];
}


