/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGMapItem.h
 *
 * An item to draw on the map. Set image to an empty string to remove item from the map.
 */

#ifndef SWGMapItem_H_
#define SWGMapItem_H_

#include <QJsonObject>


#include "SWGMapAnimation.h"
#include "SWGMapCoordinate.h"
#include <QList>
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGMapItem: public SWGObject {
public:
    SWGMapItem();
    SWGMapItem(QString* json);
    virtual ~SWGMapItem();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGMapItem* fromJson(QString &jsonString) override;

    QString* getName();
    void setName(QString* name);

    QString* getImage();
    void setImage(QString* image);

    qint32 getImageRotation();
    void setImageRotation(qint32 image_rotation);

    QString* getText();
    void setText(QString* text);

    float getLatitude();
    void setLatitude(float latitude);

    float getLongitude();
    void setLongitude(float longitude);

    float getAltitude();
    void setAltitude(float altitude);

    qint32 getFixedPosition();
    void setFixedPosition(qint32 fixed_position);

    QString* getPositionDateTime();
    void setPositionDateTime(QString* position_date_time);

    QList<SWGMapCoordinate*>* getTrack();
    void setTrack(QList<SWGMapCoordinate*>* track);

    QList<SWGMapCoordinate*>* getPredictedTrack();
    void setPredictedTrack(QList<SWGMapCoordinate*>* predicted_track);

    QString* getModel();
    void setModel(QString* model);

    qint32 getOrientation();
    void setOrientation(qint32 orientation);

    float getHeading();
    void setHeading(float heading);

    float getPitch();
    void setPitch(float pitch);

    float getRoll();
    void setRoll(float roll);

    QString* getOrientationDateTime();
    void setOrientationDateTime(QString* orientation_date_time);

    QString* getLabel();
    void setLabel(QString* label);

    float getLabelAltitudeOffset();
    void setLabelAltitudeOffset(float label_altitude_offset);

    float getModelAltitudeOffset();
    void setModelAltitudeOffset(float model_altitude_offset);

    qint32 getAltitudeReference();
    void setAltitudeReference(qint32 altitude_reference);

    QList<SWGMapAnimation*>* getAnimations();
    void setAnimations(QList<SWGMapAnimation*>* animations);

    qint32 getType();
    void setType(qint32 type);

    float getImageTileWest();
    void setImageTileWest(float image_tile_west);

    float getImageTileSouth();
    void setImageTileSouth(float image_tile_south);

    float getImageTileEast();
    void setImageTileEast(float image_tile_east);

    float getImageTileNorth();
    void setImageTileNorth(float image_tile_north);

    float getImageZoomLevel();
    void setImageZoomLevel(float image_zoom_level);

    QList<SWGMapCoordinate*>* getCoordinates();
    void setCoordinates(QList<SWGMapCoordinate*>* coordinates);

    float getExtrudedHeight();
    void setExtrudedHeight(float extruded_height);

    QString* getAvailableUntil();
    void setAvailableUntil(QString* available_until);


    virtual bool isSet() override;

private:
    QString* name;
    bool m_name_isSet;

    QString* image;
    bool m_image_isSet;

    qint32 image_rotation;
    bool m_image_rotation_isSet;

    QString* text;
    bool m_text_isSet;

    float latitude;
    bool m_latitude_isSet;

    float longitude;
    bool m_longitude_isSet;

    float altitude;
    bool m_altitude_isSet;

    qint32 fixed_position;
    bool m_fixed_position_isSet;

    QString* position_date_time;
    bool m_position_date_time_isSet;

    QList<SWGMapCoordinate*>* track;
    bool m_track_isSet;

    QList<SWGMapCoordinate*>* predicted_track;
    bool m_predicted_track_isSet;

    QString* model;
    bool m_model_isSet;

    qint32 orientation;
    bool m_orientation_isSet;

    float heading;
    bool m_heading_isSet;

    float pitch;
    bool m_pitch_isSet;

    float roll;
    bool m_roll_isSet;

    QString* orientation_date_time;
    bool m_orientation_date_time_isSet;

    QString* label;
    bool m_label_isSet;

    float label_altitude_offset;
    bool m_label_altitude_offset_isSet;

    float model_altitude_offset;
    bool m_model_altitude_offset_isSet;

    qint32 altitude_reference;
    bool m_altitude_reference_isSet;

    QList<SWGMapAnimation*>* animations;
    bool m_animations_isSet;

    qint32 type;
    bool m_type_isSet;

    float image_tile_west;
    bool m_image_tile_west_isSet;

    float image_tile_south;
    bool m_image_tile_south_isSet;

    float image_tile_east;
    bool m_image_tile_east_isSet;

    float image_tile_north;
    bool m_image_tile_north_isSet;

    float image_zoom_level;
    bool m_image_zoom_level_isSet;

    QList<SWGMapCoordinate*>* coordinates;
    bool m_coordinates_isSet;

    float extruded_height;
    bool m_extruded_height_isSet;

    QString* available_until;
    bool m_available_until_isSet;

};

}

#endif /* SWGMapItem_H_ */
