/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSatelliteDeviceSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSatelliteDeviceSettings::SWGSatelliteDeviceSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSatelliteDeviceSettings::SWGSatelliteDeviceSettings() {
    device_set_index = 0;
    m_device_set_index_isSet = false;
    preset_group = nullptr;
    m_preset_group_isSet = false;
    preset_frequency = 0L;
    m_preset_frequency_isSet = false;
    preset_description = nullptr;
    m_preset_description_isSet = false;
    doppler = nullptr;
    m_doppler_isSet = false;
    start_on_aos = 0;
    m_start_on_aos_isSet = false;
    stop_on_los = 0;
    m_stop_on_los_isSet = false;
    start_stop_file_sinks = 0;
    m_start_stop_file_sinks_isSet = false;
    frequency = 0L;
    m_frequency_isSet = false;
    aos_command = nullptr;
    m_aos_command_isSet = false;
    los_command = nullptr;
    m_los_command_isSet = false;
}

SWGSatelliteDeviceSettings::~SWGSatelliteDeviceSettings() {
    this->cleanup();
}

void
SWGSatelliteDeviceSettings::init() {
    device_set_index = 0;
    m_device_set_index_isSet = false;
    preset_group = new QString("");
    m_preset_group_isSet = false;
    preset_frequency = 0L;
    m_preset_frequency_isSet = false;
    preset_description = new QString("");
    m_preset_description_isSet = false;
    doppler = new QList<QString*>();
    m_doppler_isSet = false;
    start_on_aos = 0;
    m_start_on_aos_isSet = false;
    stop_on_los = 0;
    m_stop_on_los_isSet = false;
    start_stop_file_sinks = 0;
    m_start_stop_file_sinks_isSet = false;
    frequency = 0L;
    m_frequency_isSet = false;
    aos_command = new QString("");
    m_aos_command_isSet = false;
    los_command = new QString("");
    m_los_command_isSet = false;
}

void
SWGSatelliteDeviceSettings::cleanup() {

    if(preset_group != nullptr) { 
        delete preset_group;
    }

    if(preset_description != nullptr) { 
        delete preset_description;
    }
    if(doppler != nullptr) { 
        auto arr = doppler;
        for(auto o: *arr) { 
            delete o;
        }
        delete doppler;
    }




    if(aos_command != nullptr) { 
        delete aos_command;
    }
    if(los_command != nullptr) { 
        delete los_command;
    }
}

SWGSatelliteDeviceSettings*
SWGSatelliteDeviceSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSatelliteDeviceSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&device_set_index, pJson["deviceSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&preset_group, pJson["presetGroup"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&preset_frequency, pJson["presetFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&preset_description, pJson["presetDescription"], "QString", "QString");
    
    
    ::SWGSDRangel::setValue(&doppler, pJson["doppler"], "QList", "QString");
    ::SWGSDRangel::setValue(&start_on_aos, pJson["startOnAOS"], "qint32", "");
    
    ::SWGSDRangel::setValue(&stop_on_los, pJson["stopOnLOS"], "qint32", "");
    
    ::SWGSDRangel::setValue(&start_stop_file_sinks, pJson["startStopFileSinks"], "qint32", "");
    
    ::SWGSDRangel::setValue(&frequency, pJson["frequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&aos_command, pJson["aosCommand"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&los_command, pJson["losCommand"], "QString", "QString");
    
}

QString
SWGSatelliteDeviceSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSatelliteDeviceSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_device_set_index_isSet){
        obj->insert("deviceSetIndex", QJsonValue(device_set_index));
    }
    if(preset_group != nullptr && *preset_group != QString("")){
        toJsonValue(QString("presetGroup"), preset_group, obj, QString("QString"));
    }
    if(m_preset_frequency_isSet){
        obj->insert("presetFrequency", QJsonValue(preset_frequency));
    }
    if(preset_description != nullptr && *preset_description != QString("")){
        toJsonValue(QString("presetDescription"), preset_description, obj, QString("QString"));
    }
    if(doppler && doppler->size() > 0){
        toJsonArray((QList<void*>*)doppler, obj, "doppler", "QString");
    }
    if(m_start_on_aos_isSet){
        obj->insert("startOnAOS", QJsonValue(start_on_aos));
    }
    if(m_stop_on_los_isSet){
        obj->insert("stopOnLOS", QJsonValue(stop_on_los));
    }
    if(m_start_stop_file_sinks_isSet){
        obj->insert("startStopFileSinks", QJsonValue(start_stop_file_sinks));
    }
    if(m_frequency_isSet){
        obj->insert("frequency", QJsonValue(frequency));
    }
    if(aos_command != nullptr && *aos_command != QString("")){
        toJsonValue(QString("aosCommand"), aos_command, obj, QString("QString"));
    }
    if(los_command != nullptr && *los_command != QString("")){
        toJsonValue(QString("losCommand"), los_command, obj, QString("QString"));
    }

    return obj;
}

qint32
SWGSatelliteDeviceSettings::getDeviceSetIndex() {
    return device_set_index;
}
void
SWGSatelliteDeviceSettings::setDeviceSetIndex(qint32 device_set_index) {
    this->device_set_index = device_set_index;
    this->m_device_set_index_isSet = true;
}

QString*
SWGSatelliteDeviceSettings::getPresetGroup() {
    return preset_group;
}
void
SWGSatelliteDeviceSettings::setPresetGroup(QString* preset_group) {
    this->preset_group = preset_group;
    this->m_preset_group_isSet = true;
}

qint64
SWGSatelliteDeviceSettings::getPresetFrequency() {
    return preset_frequency;
}
void
SWGSatelliteDeviceSettings::setPresetFrequency(qint64 preset_frequency) {
    this->preset_frequency = preset_frequency;
    this->m_preset_frequency_isSet = true;
}

QString*
SWGSatelliteDeviceSettings::getPresetDescription() {
    return preset_description;
}
void
SWGSatelliteDeviceSettings::setPresetDescription(QString* preset_description) {
    this->preset_description = preset_description;
    this->m_preset_description_isSet = true;
}

QList<QString*>*
SWGSatelliteDeviceSettings::getDoppler() {
    return doppler;
}
void
SWGSatelliteDeviceSettings::setDoppler(QList<QString*>* doppler) {
    this->doppler = doppler;
    this->m_doppler_isSet = true;
}

qint32
SWGSatelliteDeviceSettings::getStartOnAos() {
    return start_on_aos;
}
void
SWGSatelliteDeviceSettings::setStartOnAos(qint32 start_on_aos) {
    this->start_on_aos = start_on_aos;
    this->m_start_on_aos_isSet = true;
}

qint32
SWGSatelliteDeviceSettings::getStopOnLos() {
    return stop_on_los;
}
void
SWGSatelliteDeviceSettings::setStopOnLos(qint32 stop_on_los) {
    this->stop_on_los = stop_on_los;
    this->m_stop_on_los_isSet = true;
}

qint32
SWGSatelliteDeviceSettings::getStartStopFileSinks() {
    return start_stop_file_sinks;
}
void
SWGSatelliteDeviceSettings::setStartStopFileSinks(qint32 start_stop_file_sinks) {
    this->start_stop_file_sinks = start_stop_file_sinks;
    this->m_start_stop_file_sinks_isSet = true;
}

qint64
SWGSatelliteDeviceSettings::getFrequency() {
    return frequency;
}
void
SWGSatelliteDeviceSettings::setFrequency(qint64 frequency) {
    this->frequency = frequency;
    this->m_frequency_isSet = true;
}

QString*
SWGSatelliteDeviceSettings::getAosCommand() {
    return aos_command;
}
void
SWGSatelliteDeviceSettings::setAosCommand(QString* aos_command) {
    this->aos_command = aos_command;
    this->m_aos_command_isSet = true;
}

QString*
SWGSatelliteDeviceSettings::getLosCommand() {
    return los_command;
}
void
SWGSatelliteDeviceSettings::setLosCommand(QString* los_command) {
    this->los_command = los_command;
    this->m_los_command_isSet = true;
}


bool
SWGSatelliteDeviceSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_device_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(preset_group && *preset_group != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_preset_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(preset_description && *preset_description != QString("")){
            isObjectUpdated = true; break;
        }
        if(doppler && (doppler->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_start_on_aos_isSet){
            isObjectUpdated = true; break;
        }
        if(m_stop_on_los_isSet){
            isObjectUpdated = true; break;
        }
        if(m_start_stop_file_sinks_isSet){
            isObjectUpdated = true; break;
        }
        if(m_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(aos_command && *aos_command != QString("")){
            isObjectUpdated = true; break;
        }
        if(los_command && *los_command != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

