/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGRadioAstronomySettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGRadioAstronomySettings::SWGRadioAstronomySettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGRadioAstronomySettings::SWGRadioAstronomySettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    rf_bandwidth = 0;
    m_rf_bandwidth_isSet = false;
    integration = 0;
    m_integration_isSet = false;
    fft_size = 0;
    m_fft_size_isSet = false;
    fft_window = 0;
    m_fft_window_isSet = false;
    filter_freqs = nullptr;
    m_filter_freqs_isSet = false;
    star_tracker = nullptr;
    m_star_tracker_isSet = false;
    rotator = nullptr;
    m_rotator_isSet = false;
    run_mode = 0;
    m_run_mode_isSet = false;
    sweep_start_at_time = 0;
    m_sweep_start_at_time_isSet = false;
    sweep_start_date_time = nullptr;
    m_sweep_start_date_time_isSet = false;
    sweep_type = 0;
    m_sweep_type_isSet = false;
    sweep1_start = 0.0f;
    m_sweep1_start_isSet = false;
    sweep1_stop = 0.0f;
    m_sweep1_stop_isSet = false;
    sweep1_step = 0.0f;
    m_sweep1_step_isSet = false;
    sweep1_delay = 0.0f;
    m_sweep1_delay_isSet = false;
    sweep2_start = 0.0f;
    m_sweep2_start_isSet = false;
    sweep2_stop = 0.0f;
    m_sweep2_stop_isSet = false;
    sweep2_step = 0.0f;
    m_sweep2_step_isSet = false;
    sweep2_delay = 0.0f;
    m_sweep2_delay_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGRadioAstronomySettings::~SWGRadioAstronomySettings() {
    this->cleanup();
}

void
SWGRadioAstronomySettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    rf_bandwidth = 0;
    m_rf_bandwidth_isSet = false;
    integration = 0;
    m_integration_isSet = false;
    fft_size = 0;
    m_fft_size_isSet = false;
    fft_window = 0;
    m_fft_window_isSet = false;
    filter_freqs = new QString("");
    m_filter_freqs_isSet = false;
    star_tracker = new QString("");
    m_star_tracker_isSet = false;
    rotator = new QString("");
    m_rotator_isSet = false;
    run_mode = 0;
    m_run_mode_isSet = false;
    sweep_start_at_time = 0;
    m_sweep_start_at_time_isSet = false;
    sweep_start_date_time = new QString("");
    m_sweep_start_date_time_isSet = false;
    sweep_type = 0;
    m_sweep_type_isSet = false;
    sweep1_start = 0.0f;
    m_sweep1_start_isSet = false;
    sweep1_stop = 0.0f;
    m_sweep1_stop_isSet = false;
    sweep1_step = 0.0f;
    m_sweep1_step_isSet = false;
    sweep1_delay = 0.0f;
    m_sweep1_delay_isSet = false;
    sweep2_start = 0.0f;
    m_sweep2_start_isSet = false;
    sweep2_stop = 0.0f;
    m_sweep2_stop_isSet = false;
    sweep2_step = 0.0f;
    m_sweep2_step_isSet = false;
    sweep2_delay = 0.0f;
    m_sweep2_delay_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGRadioAstronomySettings::cleanup() {






    if(filter_freqs != nullptr) { 
        delete filter_freqs;
    }
    if(star_tracker != nullptr) { 
        delete star_tracker;
    }
    if(rotator != nullptr) { 
        delete rotator;
    }


    if(sweep_start_date_time != nullptr) { 
        delete sweep_start_date_time;
    }










    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGRadioAstronomySettings*
SWGRadioAstronomySettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGRadioAstronomySettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&sample_rate, pJson["sampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "qint32", "");
    
    ::SWGSDRangel::setValue(&integration, pJson["integration"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fft_size, pJson["fftSize"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fft_window, pJson["fftWindow"], "qint32", "");
    
    ::SWGSDRangel::setValue(&filter_freqs, pJson["filterFreqs"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&star_tracker, pJson["starTracker"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rotator, pJson["rotator"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&run_mode, pJson["runMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sweep_start_at_time, pJson["sweepStartAtTime"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sweep_start_date_time, pJson["sweepStartDateTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&sweep_type, pJson["sweepType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sweep1_start, pJson["sweep1Start"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep1_stop, pJson["sweep1Stop"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep1_step, pJson["sweep1Step"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep1_delay, pJson["sweep1Delay"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep2_start, pJson["sweep2Start"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep2_stop, pJson["sweep2Stop"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep2_step, pJson["sweep2Step"], "float", "");
    
    ::SWGSDRangel::setValue(&sweep2_delay, pJson["sweep2Delay"], "float", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGRadioAstronomySettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGRadioAstronomySettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_sample_rate_isSet){
        obj->insert("sampleRate", QJsonValue(sample_rate));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_integration_isSet){
        obj->insert("integration", QJsonValue(integration));
    }
    if(m_fft_size_isSet){
        obj->insert("fftSize", QJsonValue(fft_size));
    }
    if(m_fft_window_isSet){
        obj->insert("fftWindow", QJsonValue(fft_window));
    }
    if(filter_freqs != nullptr && *filter_freqs != QString("")){
        toJsonValue(QString("filterFreqs"), filter_freqs, obj, QString("QString"));
    }
    if(star_tracker != nullptr && *star_tracker != QString("")){
        toJsonValue(QString("starTracker"), star_tracker, obj, QString("QString"));
    }
    if(rotator != nullptr && *rotator != QString("")){
        toJsonValue(QString("rotator"), rotator, obj, QString("QString"));
    }
    if(m_run_mode_isSet){
        obj->insert("runMode", QJsonValue(run_mode));
    }
    if(m_sweep_start_at_time_isSet){
        obj->insert("sweepStartAtTime", QJsonValue(sweep_start_at_time));
    }
    if(sweep_start_date_time != nullptr && *sweep_start_date_time != QString("")){
        toJsonValue(QString("sweepStartDateTime"), sweep_start_date_time, obj, QString("QString"));
    }
    if(m_sweep_type_isSet){
        obj->insert("sweepType", QJsonValue(sweep_type));
    }
    if(m_sweep1_start_isSet){
        obj->insert("sweep1Start", QJsonValue(sweep1_start));
    }
    if(m_sweep1_stop_isSet){
        obj->insert("sweep1Stop", QJsonValue(sweep1_stop));
    }
    if(m_sweep1_step_isSet){
        obj->insert("sweep1Step", QJsonValue(sweep1_step));
    }
    if(m_sweep1_delay_isSet){
        obj->insert("sweep1Delay", QJsonValue(sweep1_delay));
    }
    if(m_sweep2_start_isSet){
        obj->insert("sweep2Start", QJsonValue(sweep2_start));
    }
    if(m_sweep2_stop_isSet){
        obj->insert("sweep2Stop", QJsonValue(sweep2_stop));
    }
    if(m_sweep2_step_isSet){
        obj->insert("sweep2Step", QJsonValue(sweep2_step));
    }
    if(m_sweep2_delay_isSet){
        obj->insert("sweep2Delay", QJsonValue(sweep2_delay));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGRadioAstronomySettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGRadioAstronomySettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

qint32
SWGRadioAstronomySettings::getSampleRate() {
    return sample_rate;
}
void
SWGRadioAstronomySettings::setSampleRate(qint32 sample_rate) {
    this->sample_rate = sample_rate;
    this->m_sample_rate_isSet = true;
}

qint32
SWGRadioAstronomySettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGRadioAstronomySettings::setRfBandwidth(qint32 rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

qint32
SWGRadioAstronomySettings::getIntegration() {
    return integration;
}
void
SWGRadioAstronomySettings::setIntegration(qint32 integration) {
    this->integration = integration;
    this->m_integration_isSet = true;
}

qint32
SWGRadioAstronomySettings::getFftSize() {
    return fft_size;
}
void
SWGRadioAstronomySettings::setFftSize(qint32 fft_size) {
    this->fft_size = fft_size;
    this->m_fft_size_isSet = true;
}

qint32
SWGRadioAstronomySettings::getFftWindow() {
    return fft_window;
}
void
SWGRadioAstronomySettings::setFftWindow(qint32 fft_window) {
    this->fft_window = fft_window;
    this->m_fft_window_isSet = true;
}

QString*
SWGRadioAstronomySettings::getFilterFreqs() {
    return filter_freqs;
}
void
SWGRadioAstronomySettings::setFilterFreqs(QString* filter_freqs) {
    this->filter_freqs = filter_freqs;
    this->m_filter_freqs_isSet = true;
}

QString*
SWGRadioAstronomySettings::getStarTracker() {
    return star_tracker;
}
void
SWGRadioAstronomySettings::setStarTracker(QString* star_tracker) {
    this->star_tracker = star_tracker;
    this->m_star_tracker_isSet = true;
}

QString*
SWGRadioAstronomySettings::getRotator() {
    return rotator;
}
void
SWGRadioAstronomySettings::setRotator(QString* rotator) {
    this->rotator = rotator;
    this->m_rotator_isSet = true;
}

qint32
SWGRadioAstronomySettings::getRunMode() {
    return run_mode;
}
void
SWGRadioAstronomySettings::setRunMode(qint32 run_mode) {
    this->run_mode = run_mode;
    this->m_run_mode_isSet = true;
}

qint32
SWGRadioAstronomySettings::getSweepStartAtTime() {
    return sweep_start_at_time;
}
void
SWGRadioAstronomySettings::setSweepStartAtTime(qint32 sweep_start_at_time) {
    this->sweep_start_at_time = sweep_start_at_time;
    this->m_sweep_start_at_time_isSet = true;
}

QString*
SWGRadioAstronomySettings::getSweepStartDateTime() {
    return sweep_start_date_time;
}
void
SWGRadioAstronomySettings::setSweepStartDateTime(QString* sweep_start_date_time) {
    this->sweep_start_date_time = sweep_start_date_time;
    this->m_sweep_start_date_time_isSet = true;
}

qint32
SWGRadioAstronomySettings::getSweepType() {
    return sweep_type;
}
void
SWGRadioAstronomySettings::setSweepType(qint32 sweep_type) {
    this->sweep_type = sweep_type;
    this->m_sweep_type_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep1Start() {
    return sweep1_start;
}
void
SWGRadioAstronomySettings::setSweep1Start(float sweep1_start) {
    this->sweep1_start = sweep1_start;
    this->m_sweep1_start_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep1Stop() {
    return sweep1_stop;
}
void
SWGRadioAstronomySettings::setSweep1Stop(float sweep1_stop) {
    this->sweep1_stop = sweep1_stop;
    this->m_sweep1_stop_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep1Step() {
    return sweep1_step;
}
void
SWGRadioAstronomySettings::setSweep1Step(float sweep1_step) {
    this->sweep1_step = sweep1_step;
    this->m_sweep1_step_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep1Delay() {
    return sweep1_delay;
}
void
SWGRadioAstronomySettings::setSweep1Delay(float sweep1_delay) {
    this->sweep1_delay = sweep1_delay;
    this->m_sweep1_delay_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep2Start() {
    return sweep2_start;
}
void
SWGRadioAstronomySettings::setSweep2Start(float sweep2_start) {
    this->sweep2_start = sweep2_start;
    this->m_sweep2_start_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep2Stop() {
    return sweep2_stop;
}
void
SWGRadioAstronomySettings::setSweep2Stop(float sweep2_stop) {
    this->sweep2_stop = sweep2_stop;
    this->m_sweep2_stop_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep2Step() {
    return sweep2_step;
}
void
SWGRadioAstronomySettings::setSweep2Step(float sweep2_step) {
    this->sweep2_step = sweep2_step;
    this->m_sweep2_step_isSet = true;
}

float
SWGRadioAstronomySettings::getSweep2Delay() {
    return sweep2_delay;
}
void
SWGRadioAstronomySettings::setSweep2Delay(float sweep2_delay) {
    this->sweep2_delay = sweep2_delay;
    this->m_sweep2_delay_isSet = true;
}

qint32
SWGRadioAstronomySettings::getRgbColor() {
    return rgb_color;
}
void
SWGRadioAstronomySettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGRadioAstronomySettings::getTitle() {
    return title;
}
void
SWGRadioAstronomySettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGRadioAstronomySettings::getStreamIndex() {
    return stream_index;
}
void
SWGRadioAstronomySettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGRadioAstronomySettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGRadioAstronomySettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGRadioAstronomySettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGRadioAstronomySettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGRadioAstronomySettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGRadioAstronomySettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGRadioAstronomySettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGRadioAstronomySettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGRadioAstronomySettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGRadioAstronomySettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGChannelMarker*
SWGRadioAstronomySettings::getChannelMarker() {
    return channel_marker;
}
void
SWGRadioAstronomySettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGRadioAstronomySettings::getRollupState() {
    return rollup_state;
}
void
SWGRadioAstronomySettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGRadioAstronomySettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_integration_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fft_size_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fft_window_isSet){
            isObjectUpdated = true; break;
        }
        if(filter_freqs && *filter_freqs != QString("")){
            isObjectUpdated = true; break;
        }
        if(star_tracker && *star_tracker != QString("")){
            isObjectUpdated = true; break;
        }
        if(rotator && *rotator != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_run_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep_start_at_time_isSet){
            isObjectUpdated = true; break;
        }
        if(sweep_start_date_time && *sweep_start_date_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_sweep_type_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep1_start_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep1_stop_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep1_step_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep1_delay_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep2_start_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep2_stop_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep2_step_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sweep2_delay_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

