/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMapAnimation.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMapAnimation::SWGMapAnimation(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMapAnimation::SWGMapAnimation() {
    name = nullptr;
    m_name_isSet = false;
    reverse = 0;
    m_reverse_isSet = false;
    loop = 0;
    m_loop_isSet = false;
    start_date_time = nullptr;
    m_start_date_time_isSet = false;
    start_offset = 0.0f;
    m_start_offset_isSet = false;
    multiplier = 0.0f;
    m_multiplier_isSet = false;
    duration = 0.0f;
    m_duration_isSet = false;
    stop = 0;
    m_stop_isSet = false;
}

SWGMapAnimation::~SWGMapAnimation() {
    this->cleanup();
}

void
SWGMapAnimation::init() {
    name = new QString("");
    m_name_isSet = false;
    reverse = 0;
    m_reverse_isSet = false;
    loop = 0;
    m_loop_isSet = false;
    start_date_time = new QString("");
    m_start_date_time_isSet = false;
    start_offset = 0.0f;
    m_start_offset_isSet = false;
    multiplier = 0.0f;
    m_multiplier_isSet = false;
    duration = 0.0f;
    m_duration_isSet = false;
    stop = 0;
    m_stop_isSet = false;
}

void
SWGMapAnimation::cleanup() {
    if(name != nullptr) { 
        delete name;
    }


    if(start_date_time != nullptr) { 
        delete start_date_time;
    }




}

SWGMapAnimation*
SWGMapAnimation::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMapAnimation::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&name, pJson["name"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse, pJson["reverse"], "qint32", "");
    
    ::SWGSDRangel::setValue(&loop, pJson["loop"], "qint32", "");
    
    ::SWGSDRangel::setValue(&start_date_time, pJson["startDateTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&start_offset, pJson["startOffset"], "float", "");
    
    ::SWGSDRangel::setValue(&multiplier, pJson["multiplier"], "float", "");
    
    ::SWGSDRangel::setValue(&duration, pJson["duration"], "float", "");
    
    ::SWGSDRangel::setValue(&stop, pJson["stop"], "qint32", "");
    
}

QString
SWGMapAnimation::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMapAnimation::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(name != nullptr && *name != QString("")){
        toJsonValue(QString("name"), name, obj, QString("QString"));
    }
    if(m_reverse_isSet){
        obj->insert("reverse", QJsonValue(reverse));
    }
    if(m_loop_isSet){
        obj->insert("loop", QJsonValue(loop));
    }
    if(start_date_time != nullptr && *start_date_time != QString("")){
        toJsonValue(QString("startDateTime"), start_date_time, obj, QString("QString"));
    }
    if(m_start_offset_isSet){
        obj->insert("startOffset", QJsonValue(start_offset));
    }
    if(m_multiplier_isSet){
        obj->insert("multiplier", QJsonValue(multiplier));
    }
    if(m_duration_isSet){
        obj->insert("duration", QJsonValue(duration));
    }
    if(m_stop_isSet){
        obj->insert("stop", QJsonValue(stop));
    }

    return obj;
}

QString*
SWGMapAnimation::getName() {
    return name;
}
void
SWGMapAnimation::setName(QString* name) {
    this->name = name;
    this->m_name_isSet = true;
}

qint32
SWGMapAnimation::getReverse() {
    return reverse;
}
void
SWGMapAnimation::setReverse(qint32 reverse) {
    this->reverse = reverse;
    this->m_reverse_isSet = true;
}

qint32
SWGMapAnimation::getLoop() {
    return loop;
}
void
SWGMapAnimation::setLoop(qint32 loop) {
    this->loop = loop;
    this->m_loop_isSet = true;
}

QString*
SWGMapAnimation::getStartDateTime() {
    return start_date_time;
}
void
SWGMapAnimation::setStartDateTime(QString* start_date_time) {
    this->start_date_time = start_date_time;
    this->m_start_date_time_isSet = true;
}

float
SWGMapAnimation::getStartOffset() {
    return start_offset;
}
void
SWGMapAnimation::setStartOffset(float start_offset) {
    this->start_offset = start_offset;
    this->m_start_offset_isSet = true;
}

float
SWGMapAnimation::getMultiplier() {
    return multiplier;
}
void
SWGMapAnimation::setMultiplier(float multiplier) {
    this->multiplier = multiplier;
    this->m_multiplier_isSet = true;
}

float
SWGMapAnimation::getDuration() {
    return duration;
}
void
SWGMapAnimation::setDuration(float duration) {
    this->duration = duration;
    this->m_duration_isSet = true;
}

qint32
SWGMapAnimation::getStop() {
    return stop;
}
void
SWGMapAnimation::setStop(qint32 stop) {
    this->stop = stop;
    this->m_stop_isSet = true;
}


bool
SWGMapAnimation::isSet(){
    bool isObjectUpdated = false;
    do{
        if(name && *name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_isSet){
            isObjectUpdated = true; break;
        }
        if(m_loop_isSet){
            isObjectUpdated = true; break;
        }
        if(start_date_time && *start_date_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_start_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_multiplier_isSet){
            isObjectUpdated = true; break;
        }
        if(m_duration_isSet){
            isObjectUpdated = true; break;
        }
        if(m_stop_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

